/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.util.Random;
import java.util.function.Supplier;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.ShuffleDependency$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.RoundRobinPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.execution.PartitionIdPassthrough;
import org.apache.spark.sql.execution.RecordBinaryComparator;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.execution.exchange.ExchangeCoordinator;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.MutablePair;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.sys.package$;

public final class ShuffleExchangeExec$
implements Serializable {
    public static final ShuffleExchangeExec$ MODULE$;

    static {
        new ShuffleExchangeExec$();
    }

    public ShuffleExchangeExec apply(Partitioning newPartitioning, SparkPlan child) {
        return new ShuffleExchangeExec(newPartitioning, child, (Option<ExchangeCoordinator>)Option$.MODULE$.empty());
    }

    private boolean needToCopyObjectsBeforeShuffle(Partitioner partitioner) {
        SparkConf conf = SparkEnv$.MODULE$.get().conf();
        ShuffleManager shuffleManager = SparkEnv$.MODULE$.get().shuffleManager();
        boolean sortBasedShuffleOn = shuffleManager instanceof SortShuffleManager;
        int bypassMergeThreshold = conf.getInt("spark.shuffle.sort.bypassMergeThreshold", 200);
        int numParts = partitioner.numPartitions();
        return sortBasedShuffleOn ? (numParts <= bypassMergeThreshold ? false : numParts > SortShuffleManager$.MODULE$.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) : true;
    }

    public ShuffleDependency<Object, InternalRow, InternalRow> prepareShuffleDependency(RDD<InternalRow> rdd2, Seq<Attribute> outputAttributes, Partitioning newPartitioning, Serializer serializer) {
        block9: {
            RDD rDD;
            boolean isOrderSensitive;
            Object object;
            block6: {
                Partitioning partitioning;
                block8: {
                    block7: {
                        block5: {
                            partitioning = newPartitioning;
                            if (!(partitioning instanceof RoundRobinPartitioning)) break block5;
                            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
                            int numPartitions = roundRobinPartitioning.numPartitions();
                            object = new HashPartitioner(numPartitions);
                            break block6;
                        }
                        if (!(partitioning instanceof HashPartitioning)) break block7;
                        HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
                        int n = hashPartitioning.numPartitions();
                        object = new Partitioner(n){
                            private final int n$1;

                            public int numPartitions() {
                                return this.n$1;
                            }

                            public int getPartition(Object key) {
                                return BoxesRunTime.unboxToInt((Object)key);
                            }
                            {
                                this.n$1 = n$1;
                            }
                        };
                        break block6;
                    }
                    if (!(partitioning instanceof RangePartitioning)) break block8;
                    RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
                    Seq sortingExpressions = rangePartitioning.ordering();
                    int numPartitions = rangePartitioning.numPartitions();
                    RDD rddForSampling = rdd2.mapPartitionsInternal((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Iterator<MutablePair<InternalRow, Null$>> apply(Iterator<InternalRow> iter) {
                            MutablePair mutablePair = new MutablePair();
                            return iter.map((Function1)new Serializable(this, mutablePair){
                                public static final long serialVersionUID = 0L;
                                private final MutablePair mutablePair$1;

                                public final MutablePair<InternalRow, Null$> apply(InternalRow row) {
                                    return this.mutablePair$1.update((Object)row.copy(), null);
                                }
                                {
                                    this.mutablePair$1 = mutablePair$1;
                                }
                            });
                        }
                    }, rdd2.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
                    LazilyGeneratedOrdering ordering = new LazilyGeneratedOrdering(sortingExpressions, outputAttributes);
                    object = new RangePartitioner(numPartitions, rddForSampling, true, SQLConf$.MODULE$.get().rangeExchangeSampleSizePerPartition(), (Ordering)ordering, ClassTag$.MODULE$.apply(InternalRow.class));
                    break block6;
                }
                if (!SinglePartition$.MODULE$.equals(partitioning)) break block9;
                object = new Partitioner(){

                    public int numPartitions() {
                        return 1;
                    }

                    public int getPartition(Object key) {
                        return 0;
                    }
                };
            }
            HashPartitioner part = object;
            boolean isRoundRobin = newPartitioning instanceof RoundRobinPartitioning && newPartitioning.numPartitions() > 1;
            RDD newRdd = isRoundRobin && SQLConf$.MODULE$.get().sortBeforeRepartition() ? rdd2.mapPartitionsInternal((Function1)new Serializable(outputAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq outputAttributes$1;

                public final Iterator<UnsafeRow> apply(Iterator<InternalRow> iter) {
                    Supplier<RecordComparator> recordComparatorSupplier = new Supplier<RecordComparator>(this){

                        public RecordComparator get() {
                            return new RecordBinaryComparator();
                        }
                    };
                    PrefixComparator prefixComparator = PrefixComparators.LONG;
                    boolean canUseRadixSort = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(SQLConf$.MODULE$.RADIX_SORT_ENABLED()));
                    UnsafeExternalRowSorter.PrefixComputer prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(this){
                        private final UnsafeExternalRowSorter.PrefixComputer.Prefix result;

                        private UnsafeExternalRowSorter.PrefixComputer.Prefix result() {
                            return this.result;
                        }

                        public UnsafeExternalRowSorter.PrefixComputer.Prefix computePrefix(InternalRow row) {
                            this.result().isNull = false;
                            this.result().value = row.hashCode();
                            return this.result();
                        }
                        {
                            this.result = new UnsafeExternalRowSorter.PrefixComputer.Prefix();
                        }
                    };
                    long pageSize = SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes();
                    UnsafeExternalRowSorter sorter = UnsafeExternalRowSorter.createWithRecordComparator((StructType)StructType$.MODULE$.fromAttributes(this.outputAttributes$1), (Supplier)recordComparatorSupplier, (PrefixComparator)prefixComparator, (UnsafeExternalRowSorter.PrefixComputer)prefixComputer, (long)pageSize, (boolean)canUseRadixSort);
                    return sorter.sort(iter);
                }
                {
                    this.outputAttributes$1 = outputAttributes$1;
                }
            }, rdd2.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(UnsafeRow.class)) : rdd2;
            boolean bl = isOrderSensitive = isRoundRobin && !SQLConf$.MODULE$.get().sortBeforeRepartition();
            if (this.needToCopyObjectsBeforeShuffle((Partitioner)part)) {
                Serializable x$4 = new Serializable(outputAttributes, newPartitioning, (Partitioner)part){
                    public static final long serialVersionUID = 0L;
                    private final Seq outputAttributes$1;
                    private final Partitioning newPartitioning$1;
                    public final Partitioner part$1;

                    public final Iterator<Tuple2<Object, InternalRow>> apply(int x$2, Iterator<InternalRow> iter) {
                        Function1 getPartitionKey = ShuffleExchangeExec$.MODULE$.org$apache$spark$sql$execution$exchange$ShuffleExchangeExec$$getPartitionKeyExtractor$1(this.outputAttributes$1, this.newPartitioning$1);
                        return iter.map((Function1)new Serializable(this, getPartitionKey){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.3 $outer;
                            private final Function1 getPartitionKey$1;

                            public final Tuple2<Object, InternalRow> apply(InternalRow row) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.part$1.getPartition(this.getPartitionKey$1.apply((Object)row))), (Object)row.copy());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.getPartitionKey$1 = getPartitionKey$1;
                            }
                        });
                    }
                    {
                        this.outputAttributes$1 = outputAttributes$1;
                        this.newPartitioning$1 = newPartitioning$1;
                        this.part$1 = part$1;
                    }
                };
                boolean x$5 = isOrderSensitive;
                boolean x$6 = newRdd.mapPartitionsWithIndexInternal$default$2();
                rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$4, x$6, x$5, ClassTag$.MODULE$.apply(Product2.class));
            } else {
                Serializable x$7 = new Serializable(outputAttributes, newPartitioning, (Partitioner)part){
                    public static final long serialVersionUID = 0L;
                    private final Seq outputAttributes$1;
                    private final Partitioning newPartitioning$1;
                    public final Partitioner part$1;

                    public final Iterator<MutablePair<Object, InternalRow>> apply(int x$3, Iterator<InternalRow> iter) {
                        Function1 getPartitionKey = ShuffleExchangeExec$.MODULE$.org$apache$spark$sql$execution$exchange$ShuffleExchangeExec$$getPartitionKeyExtractor$1(this.outputAttributes$1, this.newPartitioning$1);
                        MutablePair mutablePair = new MutablePair();
                        return iter.map((Function1)new Serializable(this, getPartitionKey, mutablePair){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.4 $outer;
                            private final Function1 getPartitionKey$2;
                            private final MutablePair mutablePair$2;

                            public final MutablePair<Object, InternalRow> apply(InternalRow row) {
                                return this.mutablePair$2.update((Object)BoxesRunTime.boxToInteger((int)this.$outer.part$1.getPartition(this.getPartitionKey$2.apply((Object)row))), (Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.getPartitionKey$2 = getPartitionKey$2;
                                this.mutablePair$2 = mutablePair$2;
                            }
                        });
                    }
                    {
                        this.outputAttributes$1 = outputAttributes$1;
                        this.newPartitioning$1 = newPartitioning$1;
                        this.part$1 = part$1;
                    }
                };
                boolean x$8 = isOrderSensitive;
                boolean x$9 = newRdd.mapPartitionsWithIndexInternal$default$2();
                rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$7, x$9, x$8, ClassTag$.MODULE$.apply(Product2.class));
            }
            RDD rddWithPartitionIds = rDD;
            ShuffleDependency dependency = new ShuffleDependency(rddWithPartitionIds, (Partitioner)new PartitionIdPassthrough(part.numPartitions()), serializer, (Option)ShuffleDependency$.MODULE$.$lessinit$greater$default$4(), (Option)ShuffleDependency$.MODULE$.$lessinit$greater$default$5(), ShuffleDependency$.MODULE$.$lessinit$greater$default$6(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(InternalRow.class), ClassTag$.MODULE$.apply(InternalRow.class));
            return dependency;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exchange not implemented for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newPartitioning})));
    }

    public ShuffleExchangeExec apply(Partitioning newPartitioning, SparkPlan child, Option<ExchangeCoordinator> coordinator) {
        return new ShuffleExchangeExec(newPartitioning, child, coordinator);
    }

    public Option<Tuple3<Partitioning, SparkPlan, Option<ExchangeCoordinator>>> unapply(ShuffleExchangeExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.newPartitioning(), (Object)x$0.child(), x$0.coordinator()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final Function1 org$apache$spark$sql$execution$exchange$ShuffleExchangeExec$$getPartitionKeyExtractor$1(Seq outputAttributes$1, Partitioning newPartitioning$1) {
        block5: {
            Object object;
            block3: {
                Partitioning partitioning;
                block4: {
                    block2: {
                        partitioning = newPartitioning$1;
                        if (!(partitioning instanceof RoundRobinPartitioning)) break block2;
                        RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
                        int numPartitions = roundRobinPartitioning.numPartitions();
                        IntRef position = IntRef.create((int)new Random(TaskContext$.MODULE$.get().partitionId()).nextInt(numPartitions));
                        object = new Serializable(position){
                            public static final long serialVersionUID = 0L;
                            private final IntRef position$1;

                            public final int apply(InternalRow row) {
                                ++this.position$1.elem;
                                return this.position$1.elem;
                            }
                            {
                                this.position$1 = position$1;
                            }
                        };
                        break block3;
                    }
                    if (!(partitioning instanceof HashPartitioning)) break block4;
                    HashPartitioning hashPartitioning = (HashPartitioning)partitioning;
                    Expression expression = hashPartitioning.partitionIdExpression();
                    UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), outputAttributes$1);
                    object = new Serializable(projection){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeProjection projection$1;

                        public final int apply(InternalRow row) {
                            return this.projection$1.apply(row).getInt(0);
                        }
                        {
                            this.projection$1 = projection$1;
                        }
                    };
                    break block3;
                }
                boolean bl = partitioning instanceof RangePartitioning ? true : SinglePartition$.MODULE$.equals(partitioning);
                if (!bl) break block5;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply(InternalRow x) {
                        return (InternalRow)Predef$.MODULE$.identity((Object)x);
                    }
                };
            }
            return object;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exchange not implemented for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newPartitioning$1})));
    }

    private ShuffleExchangeExec$() {
        MODULE$ = this;
    }
}

