/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.multithread.CancelEventTrigger;

public class ProgressDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6031102393562980815L;
    private static final Log log = LogFactory.getLog(ProgressDialog.class);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private Properties applicationProperties = null;
    private SkinsFactory skinsFactory = null;
    private JLabel statusMessageLabel = null;
    private JLabel detailsTextLabel = null;
    private JProgressBar progressBar = null;
    private JButton cancelButton = null;
    private CancelEventTrigger cancelEventTrigger = null;

    public ProgressDialog(Frame owner, String title, Properties applicationProperties) {
        super(owner, title, true);
        this.applicationProperties = applicationProperties;
        this.initGui();
    }

    private void initGui() {
        this.skinsFactory = SkinsFactory.getInstance(this.applicationProperties);
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        JPanel container = new JPanel(new GridBagLayout());
        this.statusMessageLabel = this.skinsFactory.createSkinnedJHtmlLabel("ProgressDialogStatusMessageLabel");
        this.statusMessageLabel.setText(" ");
        this.statusMessageLabel.setHorizontalAlignment(0);
        container.add((Component)this.statusMessageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.progressBar = this.skinsFactory.createSkinnedJProgressBar("ProgressDialogProgressBar", 0, 100);
        this.progressBar.setPreferredSize(new Dimension(550, 20));
        container.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.detailsTextLabel = this.skinsFactory.createSkinnedJHtmlLabel("ProgressDialogDetailedMessageLabel");
        this.detailsTextLabel.setText(" ");
        this.detailsTextLabel.setHorizontalAlignment(0);
        container.add((Component)this.detailsTextLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.cancelButton = this.skinsFactory.createSkinnedJButton("ProgressDialogCancelButton");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setDefaultCapable(true);
        container.add((Component)this.cancelButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 4397881858674185924L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.cancelButton.doClick();
            }
        });
        this.getContentPane().add(container);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            this.cancelButton.setText("Cancelling...");
            this.cancelButton.setEnabled(false);
            if (this.cancelEventTrigger != null) {
                new Thread(new Runnable(){

                    public void run() {
                        ProgressDialog.this.cancelEventTrigger.cancelTask(this);
                    }
                }).start();
            }
        }
    }

    public void dispose() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        super.dispose();
    }

    public void startDialog(String statusMessage, String detailsText, int minTaskValue, int maxTaskValue, CancelEventTrigger cancelEventListener, String cancelButtonText) {
        this.cancelEventTrigger = cancelEventListener;
        if (maxTaskValue > minTaskValue) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setMinimum(minTaskValue);
            this.progressBar.setMaximum(maxTaskValue);
            this.progressBar.setValue(minTaskValue);
            this.progressBar.setIndeterminate(false);
        } else {
            this.progressBar.setStringPainted(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(0);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(true);
        }
        this.statusMessageLabel.setText(statusMessage);
        if (detailsText == null) {
            this.detailsTextLabel.setText("");
        } else {
            this.detailsTextLabel.setText(detailsText);
        }
        if (this.cancelEventTrigger != null) {
            this.cancelButton.setText(cancelButtonText);
            this.cancelButton.setEnabled(true);
            this.cancelButton.setVisible(true);
        } else {
            this.cancelButton.setVisible(false);
        }
        this.setVisible(true);
    }

    public void stopDialog() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.setVisible(false);
    }

    public void updateDialog(String statusMessage, String detailsText, int progressValue) {
        this.statusMessageLabel.setText(statusMessage);
        this.detailsTextLabel.setText(detailsText);
        if (!this.progressBar.isIndeterminate()) {
            this.progressBar.setValue(progressValue);
        }
    }
}

