/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

public final class CorrelationUtilities {
    protected static boolean isExisted(ExprNodeDesc expr, List<ExprNodeDesc> columns) {
        for (ExprNodeDesc thisExpr : columns) {
            if (thisExpr == null || !thisExpr.isSame(expr)) continue;
            return true;
        }
        return false;
    }

    protected static String getColumnName(Map<String, ExprNodeDesc> opColumnExprMap, ExprNodeDesc expr) {
        for (Map.Entry<String, ExprNodeDesc> entry : opColumnExprMap.entrySet()) {
            ExprNodeDesc thisExpr = entry.getValue();
            if (thisExpr == null || !thisExpr.isSame(expr)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected static boolean hasGroupingSet(ReduceSinkOperator cRS) throws SemanticException {
        GroupByOperator cGBYm = CorrelationUtilities.getSingleParent(cRS, GroupByOperator.class);
        return cGBYm != null && ((GroupByDesc)cGBYm.getConf()).isGroupingSetsPresent();
    }

    protected static Operator<?> getSingleParent(Operator<?> operator, boolean throwException) throws SemanticException {
        List<Operator<OperatorDesc>> parents = operator.getParentOperators();
        if (parents != null && parents.size() == 1) {
            return parents.get(0);
        }
        if (throwException) {
            if (parents == null) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") does not have any parent, but we expect 1 parent.");
            }
            if (parents.size() > 1) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") has " + parents.size() + " parents, but we expect 1 parent.");
            }
        }
        return null;
    }

    protected static Operator<?> getSingleParent(Operator<?> operator) throws SemanticException {
        return CorrelationUtilities.getSingleParent(operator, false);
    }

    protected static Operator<?> getSingleChild(Operator<?> operator, boolean throwException) throws SemanticException {
        List<Operator<OperatorDesc>> children = operator.getChildOperators();
        if (children != null && children.size() == 1) {
            return children.get(0);
        }
        if (throwException) {
            if (children == null) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") does not have any parent, but we expect 1 parent.");
            }
            if (children.size() > 1) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") has " + children.size() + " parents, but we expect 1 parent.");
            }
        }
        return null;
    }

    protected static Operator<?> getSingleChild(Operator<?> operator) throws SemanticException {
        return CorrelationUtilities.getSingleChild(operator, false);
    }

    protected static <T> T getSingleChild(Operator<?> operator, Class<T> type) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleChild(operator);
        return (T)(type.isInstance(parent) ? parent : null);
    }

    protected static <T> T getSingleParent(Operator<?> operator, Class<T> type) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleParent(operator);
        return (T)(type.isInstance(parent) ? parent : null);
    }

    protected static Operator<?> getStartForGroupBy(ReduceSinkOperator cRS) throws SemanticException {
        ReduceSinkOperator parent = CorrelationUtilities.getSingleParent(cRS);
        return parent instanceof GroupByOperator ? parent : cRS;
    }

    protected static boolean[] getSortedTags(JoinOperator joinOp) {
        boolean[] result = new boolean[joinOp.getParentOperators().size()];
        for (int tag = 0; tag < result.length; ++tag) {
            result[tag] = CorrelationUtilities.isSortedTag(joinOp, tag);
        }
        return result;
    }

    protected static boolean isSortedTag(JoinOperator joinOp, int tag) {
        block5: for (JoinCondDesc cond : ((JoinDesc)joinOp.getConf()).getConds()) {
            switch (cond.getType()) {
                case 1: {
                    if (cond.getRight() != tag) continue block5;
                    return false;
                }
                case 2: {
                    if (cond.getLeft() != tag) continue block5;
                    return false;
                }
                case 3: {
                    if (cond.getLeft() != tag && cond.getRight() != tag) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    protected static int indexOf(ExprNodeDesc cexpr, ExprNodeDesc[] pexprs, Operator child, Operator[] parents, boolean[] sorted) throws SemanticException {
        for (int tag = 0; tag < parents.length; ++tag) {
            if (!sorted[tag] || !pexprs[tag].isSame(ExprNodeDescUtils.backtrack(cexpr, child, parents[tag]))) continue;
            return tag;
        }
        return -1;
    }

    protected static <T extends Operator<?>> T findPossibleParent(Operator<?> start, Class<T> target, boolean trustScript) throws SemanticException {
        Operator[] parents = CorrelationUtilities.findPossibleParents(start, target, (boolean)trustScript);
        return (T)(parents != null && parents.length == 1 ? parents[0] : null);
    }

    protected static <T extends Operator<?>> T[] findPossibleParents(Operator<?> start, Class<T> target, boolean trustScript) throws SemanticException {
        Operator<?> cursor = CorrelationUtilities.getSingleParent(start);
        while (cursor != null) {
            if (target.isAssignableFrom(cursor.getClass())) {
                Operator[] array = (Operator[])Array.newInstance(target, 1);
                array[0] = cursor;
                return array;
            }
            if (cursor instanceof JoinOperator) {
                return CorrelationUtilities.findParents((JoinOperator)((JoinOperator)cursor), target);
            }
            if (cursor instanceof ScriptOperator && !trustScript) {
                return null;
            }
            if (!(cursor instanceof SelectOperator || cursor instanceof FilterOperator || cursor instanceof ForwardOperator || cursor instanceof ScriptOperator || cursor instanceof ReduceSinkOperator)) {
                return null;
            }
            cursor = CorrelationUtilities.getSingleParent(cursor);
        }
        return null;
    }

    protected static <T extends Operator<?>> T[] findParents(JoinOperator join, Class<T> target) throws SemanticException {
        List<Operator<OperatorDesc>> parents = join.getParentOperators();
        Operator[] result = (Operator[])Array.newInstance(target, parents.size());
        for (int tag = 0; tag < result.length; ++tag) {
            Operator<OperatorDesc> cursor = parents.get(tag);
            while (cursor != null) {
                if (target.isAssignableFrom(cursor.getClass())) {
                    result[tag] = cursor;
                    break;
                }
                cursor = CorrelationUtilities.getSingleParent(cursor);
            }
            if (result[tag] != null) continue;
            throw new IllegalStateException("failed to find " + target.getSimpleName() + " from " + join + " on tag " + tag);
        }
        return result;
    }

    protected static Set<TableScanOperator> findTableScanOperators(Operator<?> startPoint) {
        if (startPoint instanceof ReduceSinkOperator) {
            assert (startPoint.getNumParent() == 1);
            startPoint = startPoint.getParentOperators().get(0);
        }
        return CorrelationUtilities.findTableScanOperators(startPoint, new LinkedHashSet<TableScanOperator>());
    }

    private static Set<TableScanOperator> findTableScanOperators(Operator<?> current, Set<TableScanOperator> found) {
        if (current instanceof TableScanOperator) {
            found.add((TableScanOperator)current);
            return found;
        }
        if (current instanceof ReduceSinkOperator || current.getNumParent() == 0) {
            return found;
        }
        for (Operator<OperatorDesc> parent : current.getParentOperators()) {
            CorrelationUtilities.findTableScanOperators(parent, found);
        }
        return found;
    }

    public static List<ReduceSinkOperator> findSiblingReduceSinkOperators(ReduceSinkOperator op) throws SemanticException {
        ArrayList<ReduceSinkOperator> siblingRSs = new ArrayList<ReduceSinkOperator>();
        Operator<?> child = CorrelationUtilities.getSingleChild(op, true);
        for (Operator<OperatorDesc> parent : child.getParentOperators()) {
            if (parent instanceof ReduceSinkOperator) {
                siblingRSs.add((ReduceSinkOperator)parent);
                continue;
            }
            throw new SemanticException("An sibling of a ReduceSinkOperatpr is not aReduceSinkOperatpr.");
        }
        return siblingRSs;
    }

    public static List<Operator<? extends OperatorDesc>> findSiblingOperators(Operator<? extends OperatorDesc> op) throws SemanticException {
        Operator<?> child = CorrelationUtilities.getSingleChild(op, true);
        return child.getParentOperators();
    }

    protected static SelectOperator replaceReduceSinkWithSelectOperator(ReduceSinkOperator childRS, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        RowSchema inputRS = childRS.getSchema();
        SelectDesc select = new SelectDesc(((ReduceSinkDesc)childRS.getConf()).getValueCols(), ((ReduceSinkDesc)childRS.getConf()).getOutputValueColumnNames());
        Operator<?> parent = CorrelationUtilities.getSingleParent(childRS);
        parent.getChildOperators().clear();
        SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(inputRS.getSignature()), parent);
        sel.setColumnExprMap(childRS.getColumnExprMap());
        sel.setChildOperators(childRS.getChildOperators());
        for (Operator<OperatorDesc> ch : childRS.getChildOperators()) {
            ch.replaceParent(childRS, sel);
        }
        CorrelationUtilities.removeChildSelIfApplicable(CorrelationUtilities.getSingleChild(childRS), sel, context, procCtx);
        childRS.setChildOperators(null);
        childRS.setParentOperators(null);
        procCtx.addRemovedOperator(childRS);
        return sel;
    }

    private static void removeChildSelIfApplicable(Operator<?> child, SelectOperator sel, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        if (!(child instanceof SelectOperator)) {
            return;
        }
        if (child.getColumnExprMap() != null) {
            return;
        }
        SelectOperator selOp = (SelectOperator)child;
        for (ExprNodeDesc desc : ((SelectDesc)selOp.getConf()).getColList()) {
            if (!(desc instanceof ExprNodeColumnDesc)) {
                return;
            }
            ExprNodeColumnDesc col = (ExprNodeColumnDesc)desc;
            if (col.getColumn().startsWith(Utilities.ReduceField.VALUE.toString() + ".") && col.getTabAlias() == null && !col.getIsPartitionColOrVirtualCol()) continue;
            return;
        }
        CorrelationUtilities.removeOperator(child, CorrelationUtilities.getSingleChild(child), sel, context);
        procCtx.addRemovedOperator(child);
    }

    protected static void removeReduceSinkForGroupBy(ReduceSinkOperator cRS, GroupByOperator cGBYr, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleParent(cRS);
        if (parent instanceof GroupByOperator) {
            GroupByOperator cGBYm = (GroupByOperator)parent;
            ((GroupByDesc)cGBYr.getConf()).setKeys(ExprNodeDescUtils.backtrack(ExprNodeDescUtils.backtrack(((GroupByDesc)cGBYr.getConf()).getKeys(), cGBYr, cRS), cRS, cGBYm));
            ((GroupByDesc)cGBYr.getConf()).setAggregators(((GroupByDesc)cGBYm.getConf()).getAggregators());
            for (AggregationDesc aggr : ((GroupByDesc)cGBYm.getConf()).getAggregators()) {
                aggr.setMode(GenericUDAFEvaluator.Mode.COMPLETE);
            }
            cGBYr.setColumnExprMap(cGBYm.getColumnExprMap());
            cGBYr.setSchema(cGBYm.getSchema());
        } else {
            ((GroupByDesc)cGBYr.getConf()).setKeys(ExprNodeDescUtils.backtrack(((GroupByDesc)cGBYr.getConf()).getKeys(), cGBYr, cRS));
            for (AggregationDesc aggr : ((GroupByDesc)cGBYr.getConf()).getAggregators()) {
                aggr.setParameters(ExprNodeDescUtils.backtrack(aggr.getParameters(), cGBYr, cRS));
            }
            Map<String, ExprNodeDesc> oldMap = cGBYr.getColumnExprMap();
            RowSchema oldRS = cGBYr.getSchema();
            HashMap<String, ExprNodeDesc> newMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<ColumnInfo> newRS = new ArrayList<ColumnInfo>();
            ArrayList<String> outputCols = ((GroupByDesc)cGBYr.getConf()).getOutputColumnNames();
            for (int i = 0; i < outputCols.size(); ++i) {
                String colName = (String)outputCols.get(i);
                ColumnInfo colInfo = oldRS.getColumnInfo(colName);
                newRS.add(colInfo);
                ExprNodeDesc colExpr = ExprNodeDescUtils.backtrack(oldMap.get(colName), cGBYr, cRS);
                if (colExpr == null) continue;
                newMap.put(colInfo.getInternalName(), colExpr);
            }
            cGBYr.setColumnExprMap(newMap);
            cGBYr.setSchema(new RowSchema(newRS));
        }
        ((GroupByDesc)cGBYr.getConf()).setMode(GroupByDesc.Mode.COMPLETE);
        CorrelationUtilities.removeOperator(cRS, cGBYr, parent, context);
        procCtx.addRemovedOperator(cRS);
        if (parent instanceof GroupByOperator) {
            CorrelationUtilities.removeOperator(parent, cGBYr, CorrelationUtilities.getSingleParent(parent), context);
            procCtx.addRemovedOperator(cGBYr);
        }
    }

    protected static void isNullOperator(Operator<?> operator) throws SemanticException {
        if (operator == null) {
            throw new SemanticException("Operator is null.");
        }
    }

    protected static void insertOperatorBetween(Operator<?> newOperator, Operator<?> parent, Operator<?> child) throws SemanticException {
        CorrelationUtilities.isNullOperator(newOperator);
        CorrelationUtilities.isNullOperator(parent);
        CorrelationUtilities.isNullOperator(child);
        if (parent != CorrelationUtilities.getSingleParent(child)) {
            throw new SemanticException("Operator " + parent.getName() + " (ID: " + parent.getIdentifier() + ") is not the only parent of Operator " + child.getName() + " (ID: " + child.getIdentifier() + ")");
        }
        if (child != CorrelationUtilities.getSingleChild(parent)) {
            throw new SemanticException("Operator " + child.getName() + " (ID: " + child.getIdentifier() + ") is not the only child of Operator " + parent.getName() + " (ID: " + parent.getIdentifier() + ")");
        }
        newOperator.setParentOperators(Utilities.makeList(parent));
        newOperator.setChildOperators(Utilities.makeList(child));
        child.setParentOperators(Utilities.makeList(newOperator));
        parent.setChildOperators(Utilities.makeList(newOperator));
    }

    public static void removeOperator(Operator<?> target, ParseContext context) {
        assert (target.getNumParent() == 1 && target.getNumChild() == 1);
        CorrelationUtilities.removeOperator(target, target.getChildOperators().get(0), target.getParentOperators().get(0), context);
    }

    protected static void removeOperator(Operator<?> target, Operator<?> child, Operator<?> parent, ParseContext context) {
        for (Operator<OperatorDesc> aparent : target.getParentOperators()) {
            aparent.replaceChild(target, child);
        }
        for (Operator<OperatorDesc> achild : target.getChildOperators()) {
            achild.replaceParent(target, parent);
        }
        target.setChildOperators(null);
        target.setParentOperators(null);
    }
}

