/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSerde;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class VectorizedColumnarSerDe
extends ColumnarSerDe
implements VectorizedSerde {
    private final BytesRefArrayWritable[] byteRefArray = new BytesRefArrayWritable[1024];
    private final ObjectWritable ow = new ObjectWritable();
    private final ByteStream.Output serializeVectorStream = new ByteStream.Output();

    @Override
    public Writable serializeVector(VectorizedRowBatch vrg, ObjectInspector objInspector) throws SerDeException {
        try {
            if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new UnsupportedOperationException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
            }
            VectorizedRowBatch batch = vrg;
            StructObjectInspector soi = (StructObjectInspector)objInspector;
            List<? extends StructField> fields = soi.getAllStructFieldRefs();
            this.serializeVectorStream.reset();
            int count = 0;
            int rowIndex = 0;
            for (int i = 0; i < batch.size; ++i) {
                rowIndex = batch.selectedInUse ? batch.selected[i] : i;
                BytesRefArrayWritable byteRow = this.byteRefArray[i];
                int numCols = fields.size();
                if (byteRow == null) {
                    this.byteRefArray[i] = byteRow = new BytesRefArrayWritable(numCols);
                }
                byteRow.resetValid(numCols);
                for (int p = 0; p < batch.projectionSize; ++p) {
                    int k = batch.projectedColumns[p];
                    ObjectInspector foi = fields.get(k).getFieldObjectInspector();
                    ColumnVector currentColVector = batch.cols[k];
                    block1 : switch (foi.getCategory()) {
                        case PRIMITIVE: {
                            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
                            if (!currentColVector.noNulls && (currentColVector.isRepeating || currentColVector.isNull[rowIndex])) {
                                this.serializeVectorStream.write(new byte[0], 0, 0);
                                break;
                            }
                            if (currentColVector.isRepeating) {
                                rowIndex = 0;
                            }
                            switch (poi.getPrimitiveCategory()) {
                                case BOOLEAN: {
                                    boolean b;
                                    LongColumnVector lcv = (LongColumnVector)batch.cols[k];
                                    boolean bl = b = lcv.vector[rowIndex] == 1L;
                                    if (b) {
                                        this.serializeVectorStream.write(LazyUtils.trueBytes, 0, LazyUtils.trueBytes.length);
                                        break block1;
                                    }
                                    this.serializeVectorStream.write(LazyUtils.trueBytes, 0, LazyUtils.trueBytes.length);
                                    break block1;
                                }
                                case BYTE: 
                                case SHORT: 
                                case INT: 
                                case LONG: {
                                    LongColumnVector lcv = (LongColumnVector)batch.cols[k];
                                    LazyLong.writeUTF8(this.serializeVectorStream, lcv.vector[rowIndex]);
                                    break block1;
                                }
                                case FLOAT: 
                                case DOUBLE: {
                                    DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[k];
                                    ByteBuffer b = Text.encode((String)String.valueOf(dcv.vector[rowIndex]));
                                    this.serializeVectorStream.write(b.array(), 0, b.limit());
                                    break block1;
                                }
                                case BINARY: {
                                    BytesColumnVector bcv = (BytesColumnVector)batch.cols[k];
                                    byte[] bytes = bcv.vector[rowIndex];
                                    this.serializeVectorStream.write(bytes, 0, bytes.length);
                                    break block1;
                                }
                                case STRING: 
                                case CHAR: 
                                case VARCHAR: {
                                    BytesColumnVector bcv = (BytesColumnVector)batch.cols[k];
                                    LazyUtils.writeEscaped(this.serializeVectorStream, bcv.vector[rowIndex], bcv.start[rowIndex], bcv.length[rowIndex], this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar(), this.serdeParams.getNeedsEscape());
                                    break block1;
                                }
                                case TIMESTAMP: {
                                    LongColumnVector tcv = (LongColumnVector)batch.cols[k];
                                    long timeInNanoSec = tcv.vector[rowIndex];
                                    Timestamp t = new Timestamp(0L);
                                    TimestampUtils.assignTimeInNanoSec(timeInNanoSec, t);
                                    TimestampWritable tw = new TimestampWritable();
                                    tw.set(t);
                                    LazyTimestamp.writeUTF8(this.serializeVectorStream, tw);
                                    break block1;
                                }
                                case DATE: {
                                    LongColumnVector dacv = (LongColumnVector)batch.cols[k];
                                    DateWritable daw = new DateWritable((int)dacv.vector[rowIndex]);
                                    LazyDate.writeUTF8(this.serializeVectorStream, daw);
                                    break block1;
                                }
                            }
                            throw new UnsupportedOperationException("Vectorizaton is not supported for datatype:" + (Object)((Object)poi.getPrimitiveCategory()));
                        }
                        case LIST: 
                        case MAP: 
                        case STRUCT: 
                        case UNION: {
                            throw new UnsupportedOperationException("Vectorizaton is not supported for datatype:" + (Object)((Object)foi.getCategory()));
                        }
                        default: {
                            throw new SerDeException("Unknown ObjectInspector category!");
                        }
                    }
                    byteRow.get(k).set(this.serializeVectorStream.getData(), count, this.serializeVectorStream.getLength() - count);
                    count = this.serializeVectorStream.getLength();
                }
            }
            this.ow.set((Object)this.byteRefArray);
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
        return this.ow;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesRefArrayWritable.class;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        return super.deserialize(blob);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deserializeVector(Object rowBlob, int rowsInBlob, VectorizedRowBatch reuseBatch) throws SerDeException {
        BytesRefArrayWritable[] refArray = (BytesRefArrayWritable[])rowBlob;
        DataOutputBuffer buffer = new DataOutputBuffer();
        for (int i = 0; i < rowsInBlob; ++i) {
            Object row = this.deserialize(refArray[i]);
            try {
                VectorizedBatchUtil.addRowToBatch(row, (StructObjectInspector)this.cachedObjectInspector, i, reuseBatch, buffer);
                continue;
            }
            catch (HiveException e) {
                throw new SerDeException(e);
            }
        }
    }
}

