/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedLongHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedMultiKeyHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedMultiKeyHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedStringHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedStringHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedStringHashSet;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;

public class VectorMapJoinOptimizedCreateHashTable {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOptimizedCreateHashTable.class.getName());

    public static VectorMapJoinOptimizedHashTable createHashTable(MapJoinDesc desc, MapJoinTableContainer mapJoinTableContainer) {
        MapJoinKey refKey = mapJoinTableContainer.getAnyKey();
        MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter = mapJoinTableContainer.createGetter(refKey);
        boolean isOuterJoin = !desc.isNoOuterJoin();
        VectorMapJoinDesc vectorDesc = desc.getVectorDesc();
        VectorMapJoinDesc.HashTableKind hashTableKind = vectorDesc.hashTableKind();
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = vectorDesc.hashTableKeyType();
        boolean minMaxEnabled = vectorDesc.minMaxEnabled();
        VectorMapJoinOptimizedHashTable hashTable = null;
        block0 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinOptimizedLongHashMap(minMaxEnabled, isOuterJoin, hashTableKeyType, mapJoinTableContainer, hashMapRowGetter);
                        break;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinOptimizedLongHashMultiSet(minMaxEnabled, isOuterJoin, hashTableKeyType, mapJoinTableContainer, hashMapRowGetter);
                        break;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinOptimizedLongHashSet(minMaxEnabled, isOuterJoin, hashTableKeyType, mapJoinTableContainer, hashMapRowGetter);
                    }
                }
                break;
            }
            case STRING: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinOptimizedStringHashMap(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                        break;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinOptimizedStringHashMultiSet(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                        break;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinOptimizedStringHashSet(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                    }
                }
                break;
            }
            case MULTI_KEY: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinOptimizedMultiKeyHashMap(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                        break block0;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinOptimizedMultiKeyHashMultiSet(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                        break block0;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinOptimizedMultiKeyHashSet(isOuterJoin, mapJoinTableContainer, hashMapRowGetter);
                    }
                }
            }
        }
        return hashTable;
    }
}

