/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.VectorFields;
import org.spark_project.dmg.pmml.VectorInstance;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.jpmml.schema.Added;
import org.spark_project.jpmml.schema.Optional;
import org.spark_project.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "vectorFields", "vectorInstances"})
@XmlRootElement(name="VectorDictionary", namespace="http://www.dmg.org/PMML-4_2")
public class VectorDictionary
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="numberOfVectors")
    private Integer numberOfVectors;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="VectorFields", namespace="http://www.dmg.org/PMML-4_2", required=true)
    @Added(value=Version.PMML_3_1)
    private VectorFields vectorFields;
    @XmlElement(name="VectorInstance", namespace="http://www.dmg.org/PMML-4_2")
    @Optional(value=Version.PMML_3_1)
    private List<VectorInstance> vectorInstances;

    public VectorDictionary() {
    }

    public VectorDictionary(VectorFields vectorFields) {
        this.vectorFields = vectorFields;
    }

    public Integer getNumberOfVectors() {
        return this.numberOfVectors;
    }

    public VectorDictionary setNumberOfVectors(Integer numberOfVectors) {
        this.numberOfVectors = numberOfVectors;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public VectorFields getVectorFields() {
        return this.vectorFields;
    }

    public VectorDictionary setVectorFields(VectorFields vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    public List<VectorInstance> getVectorInstances() {
        if (this.vectorInstances == null) {
            this.vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public VectorDictionary addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasVectorInstances() {
        return this.vectorInstances != null && this.vectorInstances.size() > 0;
    }

    public VectorDictionary addVectorInstances(VectorInstance ... vectorInstances) {
        this.getVectorInstances().addAll(Arrays.asList(vectorInstances));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getVectorFields());
            }
            if (status == VisitorAction.CONTINUE && this.hasVectorInstances()) {
                status = PMMLObject.traverse(visitor, this.getVectorInstances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

