/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;

public final class DecisionTree$
implements Serializable,
Logging {
    public static final DecisionTree$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DecisionTree$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Strategy strategy) {
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, Strategy$.MODULE$.$lessinit$greater$default$4(), Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClasses) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClasses, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClasses, int maxBins, Enumeration.Value quantileCalculationStrategy, Map<Object, Object> categoricalFeaturesInfo) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClasses, maxBins, quantileCalculationStrategy, categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel trainClassifier(RDD<LabeledPoint> input, int numClasses, Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Classification(), impurityType, maxDepth, numClasses, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainClassifier(JavaRDD<LabeledPoint> input, int numClasses, java.util.Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClasses, (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), impurity, maxDepth, maxBins);
    }

    public DecisionTreeModel trainRegressor(RDD<LabeledPoint> input, Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainRegressor(JavaRDD<LabeledPoint> input, java.util.Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.$conforms()), impurity, maxDepth, maxBins);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTree$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

