/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rMb!B\u0001\u0003\u0001\u0011a!\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002\u0004\t\u0005)q\u000e\u001d;j[*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019\u0012\u0004\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0005\u0002\u000f5%\u00111d\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t;\u0001\u0011)\u0019!C\u0001?\u0005aa-\u001b;J]R,'oY3qi\u000e\u0001Q#\u0001\u0011\u0011\u00059\t\u0013B\u0001\u0012\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u000eM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0002QA\u0011a\"K\u0005\u0003U=\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0014\u0002\u001f\u0015d\u0017m\u001d;jG:+G\u000fU1sC6D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0011K2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taH\u0001\u0014gR\fg\u000eZ1sI&TXMR3biV\u0014Xm\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005A\u0005!2\u000f^1oI\u0006\u0014H-\u001b>f\r\u0016\fG/\u001e:fg\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taH\u0001\u0011gR\fg\u000eZ1sI&TX\rT1cK2D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0012gR\fg\u000eZ1sI&TX\rT1cK2\u0004\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011A\u001e\u0002\u0015M|GN^3s)f\u0004X-F\u0001=!\titJ\u0004\u0002?\u007f5\t!a\u0002\u0004A\u0005!\u0005A!Q\u0001\u0015/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:\u0011\u0005y\u0012eAB\u0001\u0003\u0011\u0003!1iE\u0002C\u001beAQ!\u0012\"\u0005\u0002\u0019\u000ba\u0001P5oSRtD#A!\t\u000f!\u0013%\u0019!C\u0001\u0013\u0006\u0001R*\u0011-`\u001dVkuLR#B)V\u0013ViU\u000b\u0002\u0015B\u0011abS\u0005\u0003\u0019>\u00111!\u00138u\u0011\u0019q%\t)A\u0005\u0015\u0006\tR*\u0011-`\u001dVkuLR#B)V\u0013Vi\u0015\u0011\u0007\u000fA\u0013\u0005\u0013aI\u0011#\n11k\u001c7wKJ\u001c\"aT\u0007*\r=\u001b\u0016\u0011DA\u001f\r\u0015!&\t#!V\u0005\u0011\tU\u000f^8\u0014\u000bMka\u000bW\r\u0011\u0005]{U\"\u0001\"\u0011\u00059I\u0016B\u0001.\u0010\u0005\u001d\u0001&o\u001c3vGRDQ!R*\u0005\u0002q#\u0012!\u0018\t\u0003/NCqaX*\u0002\u0002\u0013\u0005\u0003-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005Y\u0006twMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'AB*ue&tw\rC\u0004k'\u0006\u0005I\u0011A%\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u000f1\u001c\u0016\u0011!C\u0001[\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u00018r!\tqq.\u0003\u0002q\u001f\t\u0019\u0011I\\=\t\u000fI\\\u0017\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\t\u000fQ\u001c\u0016\u0011!C!k\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001w!\r9(P\\\u0007\u0002q*\u0011\u0011pD\u0001\u000bG>dG.Z2uS>t\u0017BA>y\u0005!IE/\u001a:bi>\u0014\bbB?T\u0003\u0003%\tA`\u0001\tG\u0006tW)];bYR\u0011\u0001e \u0005\ber\f\t\u00111\u0001o\u0011%\t\u0019aUA\u0001\n\u0003\n)!\u0001\u0005iCND7i\u001c3f)\u0005Q\u0005\"CA\u0005'\u0006\u0005I\u0011IA\u0006\u0003!!xn\u0015;sS:<G#A1\t\u0013\u0005=1+!A\u0005\n\u0005E\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0005\u0011\u0007\t\f)\"C\u0002\u0002\u0018\r\u0014aa\u00142kK\u000e$haBA\u000e\u0005\"\u0005\u0015Q\u0004\u0002\t\u0007\"|G.Z:lsN1\u0011\u0011D\u0007W1fAq!RA\r\t\u0003\t\t\u0003\u0006\u0002\u0002$A\u0019q+!\u0007\t\u0011}\u000bI\"!A\u0005B\u0001D\u0001B[A\r\u0003\u0003%\t!\u0013\u0005\nY\u0006e\u0011\u0011!C\u0001\u0003W!2A\\A\u0017\u0011!\u0011\u0018\u0011FA\u0001\u0002\u0004Q\u0005\u0002\u0003;\u0002\u001a\u0005\u0005I\u0011I;\t\u0013u\fI\"!A\u0005\u0002\u0005MBc\u0001\u0011\u00026!A!/!\r\u0002\u0002\u0003\u0007a\u000e\u0003\u0006\u0002\u0004\u0005e\u0011\u0011!C!\u0003\u000bA!\"!\u0003\u0002\u001a\u0005\u0005I\u0011IA\u0006\u0011)\ty!!\u0007\u0002\u0002\u0013%\u0011\u0011\u0003\u0004\b\u0003\u007f\u0011\u0005\u0012QA!\u0005-\tV/Y:j\u001d\u0016<Ho\u001c8\u0014\r\u0005uRB\u0016-\u001a\u0011\u001d)\u0015Q\bC\u0001\u0003\u000b\"\"!a\u0012\u0011\u0007]\u000bi\u0004\u0003\u0005`\u0003{\t\t\u0011\"\u0011a\u0011!Q\u0017QHA\u0001\n\u0003I\u0005\"\u00037\u0002>\u0005\u0005I\u0011AA()\rq\u0017\u0011\u000b\u0005\te\u00065\u0013\u0011!a\u0001\u0015\"AA/!\u0010\u0002\u0002\u0013\u0005S\u000fC\u0005~\u0003{\t\t\u0011\"\u0001\u0002XQ\u0019\u0001%!\u0017\t\u0011I\f)&!AA\u00029D!\"a\u0001\u0002>\u0005\u0005I\u0011IA\u0003\u0011)\tI!!\u0010\u0002\u0002\u0013\u0005\u00131\u0002\u0005\u000b\u0003\u001f\ti$!A\u0005\n\u0005EqABA2\u0005\"\u0005U,\u0001\u0003BkR|waBA4\u0005\"\u0005\u00151E\u0001\t\u0007\"|G.Z:ls\u001e9\u00111\u000e\"\t\u0002\u0006\u001d\u0013aC)vCNLg*Z<u_:D\u0011\"a\u001cC\u0005\u0004%\t!!\u001d\u0002!M,\b\u000f]8si\u0016$7k\u001c7wKJ\u001cXCAA:!\u0015q\u0011QOA=\u0013\r\t9h\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\n\u0006\u0003wB\u0016D\u0016\u0004\u0007\u0003{\u0012\u0005!!\u001f\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\u0011\u0005\u0005%\t)A\u0005\u0003g\n\u0011c];qa>\u0014H/\u001a3T_24XM]:!\r\u0019\t)I\u0011\u0003\u0002\b\nQ\u0011iZ4sK\u001e\fGo\u001c:\u0014\t\u0005\rU\"\u0007\u0005\b\u000b\u0006\rE\u0011AAF)\t\ti\tE\u0002X\u0003\u0007C\u0011\"!%\u0002\u0004\u0002\u0007I\u0011A\u0010\u0002\u0017%t\u0017\u000e^5bY&TX\r\u001a\u0005\u000b\u0003+\u000b\u0019\t1A\u0005\u0002\u0005]\u0015aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\t\u0005e\u0015q\u0014\t\u0004\u001d\u0005m\u0015bAAO\u001f\t!QK\\5u\u0011!\u0011\u00181SA\u0001\u0002\u0004\u0001\u0003\u0002CAR\u0003\u0007\u0003\u000b\u0015\u0002\u0011\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0017\u0005\u001d\u00161\u0011a\u0001\u0002\u0004%\t!S\u0001\u0002W\"a\u00111VAB\u0001\u0004\u0005\r\u0011\"\u0001\u0002.\u0006)1n\u0018\u0013fcR!\u0011\u0011TAX\u0011!\u0011\u0018\u0011VA\u0001\u0002\u0004Q\u0005\u0002CAZ\u0003\u0007\u0003\u000b\u0015\u0002&\u0002\u0005-\u0004\u0003\u0002DA\\\u0003\u0007\u0003\r\u00111A\u0005\u0002\u0005e\u0016!B2pk:$XCAA^!\rq\u0011QX\u0005\u0004\u0003\u007f{!\u0001\u0002'p]\u001eDA\"a1\u0002\u0004\u0002\u0007\t\u0019!C\u0001\u0003\u000b\f\u0011bY8v]R|F%Z9\u0015\t\u0005e\u0015q\u0019\u0005\ne\u0006\u0005\u0017\u0011!a\u0001\u0003wC\u0011\"a3\u0002\u0004\u0002\u0006K!a/\u0002\r\r|WO\u001c;!\u0011-\ty-a!A\u0002\u0003\u0007I\u0011A%\u0002\tQ\u0014\u0018n\u0013\u0005\r\u0003'\f\u0019\t1AA\u0002\u0013\u0005\u0011Q[\u0001\tiJL7j\u0018\u0013fcR!\u0011\u0011TAl\u0011!\u0011\u0018\u0011[A\u0001\u0002\u0004Q\u0005\u0002CAn\u0003\u0007\u0003\u000b\u0015\u0002&\u0002\u000bQ\u0014\u0018n\u0013\u0011\t\u0017\u0005}\u00171\u0011a\u0001\u0002\u0004%\taJ\u0001\u0005oN+X\u000e\u0003\u0007\u0002d\u0006\r\u0005\u0019!a\u0001\n\u0003\t)/\u0001\u0005x'Vlw\fJ3r)\u0011\tI*a:\t\u0011I\f\t/!AA\u0002!B\u0001\"a;\u0002\u0004\u0002\u0006K\u0001K\u0001\u0006oN+X\u000e\t\u0005\f\u0003_\f\u0019\t1AA\u0002\u0013%q%A\u0003xoN+X\u000e\u0003\u0007\u0002t\u0006\r\u0005\u0019!a\u0001\n\u0013\t)0A\u0005xoN+Xn\u0018\u0013fcR!\u0011\u0011TA|\u0011!\u0011\u0018\u0011_A\u0001\u0002\u0004A\u0003\u0002CA~\u0003\u0007\u0003\u000b\u0015\u0002\u0015\u0002\r]<8+^7!\u0011-\ty0a!A\u0002\u0003\u0007I\u0011B\u0014\u0002\t\t\u001cV/\u001c\u0005\r\u0005\u0007\t\u0019\t1AA\u0002\u0013%!QA\u0001\tEN+Xn\u0018\u0013fcR!\u0011\u0011\u0014B\u0004\u0011!\u0011(\u0011AA\u0001\u0002\u0004A\u0003\u0002\u0003B\u0006\u0003\u0007\u0003\u000b\u0015\u0002\u0015\u0002\u000b\t\u001cV/\u001c\u0011\t\u0017\t=\u00111\u0011a\u0001\u0002\u0004%IaJ\u0001\u0006E\n\u001cV/\u001c\u0005\r\u0005'\t\u0019\t1AA\u0002\u0013%!QC\u0001\nE\n\u001cV/\\0%KF$B!!'\u0003\u0018!A!O!\u0005\u0002\u0002\u0003\u0007\u0001\u0006\u0003\u0005\u0003\u001c\u0005\r\u0005\u0015)\u0003)\u0003\u0019\u0011'mU;nA!a!qDAB\u0001\u0004\u0005\r\u0011\"\u0003\u0003\"\u0005!\u0011mU;n+\t\u0011\u0019\u0003\u0005\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011I\u0003B\u0001\u0007Y&t\u0017\r\\4\n\t\t5\"q\u0005\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0007\u00032\u0005\r\u0005\u0019!a\u0001\n\u0013\u0011\u0019$\u0001\u0005b'Vlw\fJ3r)\u0011\tIJ!\u000e\t\u0013I\u0014y#!AA\u0002\t\r\u0002\"\u0003B\u001d\u0003\u0007\u0003\u000b\u0015\u0002B\u0012\u0003\u0015\t7+^7!\u00111\u0011i$a!A\u0002\u0003\u0007I\u0011\u0002B\u0011\u0003\u0015\t'mU;n\u00111\u0011\t%a!A\u0002\u0003\u0007I\u0011\u0002B\"\u0003%\t'mU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\n\u0015\u0003\"\u0003:\u0003@\u0005\u0005\t\u0019\u0001B\u0012\u0011%\u0011I%a!!B\u0013\u0011\u0019#\u0001\u0004bEN+X\u000e\t\u0005\r\u0005\u001b\n\u0019\t1AA\u0002\u0013%!\u0011E\u0001\u0006C\u0006\u001cV/\u001c\u0005\r\u0005#\n\u0019\t1AA\u0002\u0013%!1K\u0001\nC\u0006\u001cV/\\0%KF$B!!'\u0003V!I!Oa\u0014\u0002\u0002\u0003\u0007!1\u0005\u0005\n\u00053\n\u0019\t)Q\u0005\u0005G\ta!Y1Tk6\u0004\u0003\u0002\u0003B/\u0003\u0007#IAa\u0018\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u00033\u0013\t\u0007C\u0004\u0002(\nm\u0003\u0019\u0001&\t\u0011\t\u0015\u00141\u0011C\u0001\u0005O\n1!\u00193e)\u0011\u0011IGa\u001b\u000e\u0005\u0005\r\u0005\u0002\u0003B7\u0005G\u0002\rAa\u001c\u0002\u0011%t7\u000f^1oG\u0016\u0004BA!\u001d\u0003x5\u0011!1\u000f\u0006\u0004\u0005k\"\u0011a\u00024fCR,(/Z\u0005\u0005\u0005s\u0012\u0019H\u0001\u0005J]N$\u0018M\\2f\u0011!\u0011i(a!\u0005\u0002\t}\u0014!B7fe\u001e,G\u0003\u0002B5\u0005\u0003C\u0001Ba!\u0003|\u0001\u0007\u0011QR\u0001\u0006_RDWM\u001d\u0005\t\u0005\u000f\u000b\u0019\t\"\u0001\u0003\n\u0006Aa/\u00197jI\u0006$X\r\u0006\u0002\u0002\u001a\"A!QRAB\t\u0003\u0011\t#\u0001\u0003b\u0005\u0006\u0014\bb\u0002BI\u0003\u0007#\taJ\u0001\u0005E\n\u000b'\u000fC\u0004\u0003\u0016\u0006\rE\u0011A\u0014\u0002\u000b\t\u0014')\u0019:\t\u000f\te\u00151\u0011C\u0001O\u0005!!m\u0015;e\u0011!\u0011i*a!\u0005\u0002\t\u0005\u0012!B1c\u0005\u0006\u0014\b\u0002\u0003BQ\u0003\u0007#\tA!\t\u0002\u000b\u0005\f')\u0019:\t\u0011\t\u0015\u00161\u0011C\u0001\u0005C\tA!Y*uI\"A!\u0011VAB\t\u0003\u0011\t#\u0001\u0003b-\u0006\u0014\b\"\u0003BW\u0005F\u0005I\u0011\u0001BX\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0017\u0016\u0004y\tM6F\u0001B[!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}v\"\u0001\u0006b]:|G/\u0019;j_:LAAa1\u0003:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u001d')%A\u0005\u0002\t%\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003L*\u001a!Ja-\t\u0013\t=')%A\u0005\u0002\tE\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003T*\u001a\u0001Fa-\t\u0013\u0005=!)!A\u0005\n\u0005E\u0001\"\u0003Bm\u0001\t\u0005\t\u0015!\u0003=\u0003-\u0019x\u000e\u001c<feRK\b/\u001a\u0011\t\u0013\tu\u0007A!b\u0001\n\u0003I\u0015aB7bq&#XM\u001d\u0005\n\u0005C\u0004!\u0011!Q\u0001\n)\u000b\u0001\"\\1y\u0013R,'\u000f\t\u0005\n\u0005K\u0004!Q1A\u0005\u0002\u001d\n1\u0001^8m\u0011%\u0011I\u000f\u0001B\u0001B\u0003%\u0001&\u0001\u0003u_2\u0004\u0003BB#\u0001\t\u0003\u0011i\u000f\u0006\n\u0003p\nE(1\u001fB{\u0005o\u0014IPa?\u0003~\n}\bC\u0001 \u0001\u0011\u0019i\"1\u001ea\u0001A!1aEa;A\u0002!BaA\fBv\u0001\u0004A\u0003B\u0002\u001a\u0003l\u0002\u0007\u0001\u0005\u0003\u00047\u0005W\u0004\r\u0001\t\u0005\tu\t-\b\u0013!a\u0001y!I!Q\u001cBv!\u0003\u0005\rA\u0013\u0005\n\u0005K\u0014Y\u000f%AA\u0002!Bqaa\u0001\u0001\t\u0003\u0019)!A\u0002gSR$Baa\u0002\u0004\u000eA\u0019ah!\u0003\n\u0007\r-!AA\rXK&<\u0007\u000e^3e\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm]'pI\u0016d\u0007\u0002CB\b\u0007\u0003\u0001\ra!\u0005\u0002\u0013%t7\u000f^1oG\u0016\u001c\bCBB\n\u00073\u0011y'\u0004\u0002\u0004\u0016)\u00191q\u0003\u0004\u0002\u0007I$G-\u0003\u0003\u0004\u001c\rU!a\u0001*E\t\"91q\u0004\u0001\u0005\n\r\u0005\u0012AB4fi\u0006#\u0018\t\u0006\u0004\u0003$\r\r2q\u0005\u0005\t\u0005C\u001bi\u00021\u0001\u0004&A!a\"!\u001e)\u0011!\u0011ii!\bA\u0002\r\u0015\u0002bBB\u0016\u0001\u0011%1QF\u0001\u0007O\u0016$\u0018\t\u001e\"\u0015\r\t\r2qFB\u0019\u0011!\u0011ij!\u000bA\u0002\r\u0015\u0002b\u0002BI\u0007S\u0001\r\u0001\u000b")
public class WeightedLeastSquares
implements Logging,
Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances) {
        block24: {
            block25: {
                x$7 = new Aggregator();
                x$8 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Aggregator apply(Aggregator x$1, Instance x$2) {
                        return x$1.add(x$2);
                    }
                };
                x$9 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Aggregator apply(Aggregator x$3, Aggregator x$4) {
                        return x$3.merge(x$4);
                    }
                };
                x$10 = instances.treeAggregate$default$4((Object)x$7);
                summary = (Aggregator)instances.treeAggregate((Object)x$7, (Function2)x$8, (Function2)x$9, x$10, ClassTag$.MODULE$.apply(Aggregator.class));
                summary.validate();
                this.logInfo((Function0<String>)new Serializable(this, summary){
                    public static final long serialVersionUID = 0L;
                    private final Aggregator summary$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.summary$1.count())}));
                    }
                    {
                        this.summary$1 = summary$1;
                    }
                });
                k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
                numFeatures = summary.k();
                triK = summary.triK();
                wSum = summary.wSum();
                rawBStd = summary.bStd();
                rawBBar = summary.bBar();
                v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
                if (rawBStd == (double)false) {
                    if (this.fitIntercept() || rawBBar == 0.0) {
                        if (rawBBar == 0.0) {
                            this.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean and standard deviation of the label are zero, so the coefficients "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and the intercept will all be zero; as a result, training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                                }
                            });
                        } else {
                            this.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                                }
                            });
                        }
                        coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double()));
                        intercept = rawBBar;
                        diagInvAtWA = new DenseVector(new double[]{0.0});
                        return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                    }
                    Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The standard deviation of the label is zero. Model cannot be regularized with standardization=true";
                        }
                    });
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero. Consider setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fitIntercept=true."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                    });
                }
                bBar = summary.bBar() / bStd;
                bbBar = summary.bbBar() / (bStd * bStd);
                aStd = summary.aStd();
                aStdValues = aStd.values();
                _aBar = summary.aBar();
                _aBarValues = _aBar.values();
                for (i = 0; i < numFeatures; ++i) {
                    if (aStdValues[i] == 0.0) {
                        _aBarValues[i] = 0.0;
                        continue;
                    }
                    var32_24 = i;
                    _aBarValues[var32_24] = _aBarValues[var32_24] / aStdValues[i];
                }
                aBar = _aBar;
                aBarValues = aBar.values();
                _abBar = summary.abBar();
                _abBarValues = _abBar.values();
                for (i = 0; i < numFeatures; ++i) {
                    if (aStdValues[i] == 0.0) {
                        _abBarValues[i] = 0.0;
                        continue;
                    }
                    var38_30 = i;
                    _abBarValues[var38_30] = _abBarValues[var38_30] / (aStdValues[i] * bStd);
                }
                abBar = _abBar;
                abBarValues = abBar.values();
                _aaBar = summary.aaBar();
                _aaBarValues = _aaBar.values();
                p = 0;
                for (j = 0; j < numFeatures; ++j) {
                    aStdJ = aStdValues[j];
                    for (i = 0; i <= j; ++i) {
                        aStdI = aStdValues[i];
                        if (aStdJ == 0.0 || aStdI == 0.0) {
                            _aaBarValues[p] = 0.0;
                        } else {
                            var50_40 = p;
                            _aaBarValues[var50_40] = _aaBarValues[var50_40] / (aStdI * aStdJ);
                        }
                        ++p;
                    }
                }
                aaBar = _aaBar;
                aaBarValues = aaBar.values();
                effectiveRegParam = this.regParam() / bStd;
                effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
                effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
                i = 0;
                j = 2;
                while (i < triK) {
                    lambda = effectiveL2RegParam;
                    if (!this.standardizeFeatures()) {
                        std = aStdValues[j - 2];
                        lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                    }
                    if (!this.standardizeLabel()) {
                        lambda *= bStd;
                    }
                    var64_48 = i;
                    aaBarValues[var64_48] = aaBarValues[var64_48] + lambda;
                    i += j;
                    ++j;
                }
                aa = this.getAtA(aaBarValues, aBarValues);
                ab = this.getAtB(abBarValues, bBar);
                v1 = this.solverType();
                var68_53 = WeightedLeastSquares$Auto$.MODULE$;
                if (v1 != null ? v1.equals(var68_53) == false : var68_53 != null) break block25;
                if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
            }
            v2 = this.solverType();
            var69_54 = WeightedLeastSquares$QuasiNewton$.MODULE$;
            if (!(v2 != null ? v2.equals(var69_54) == false : var69_54 != null)) lbl-1000:
            // 2 sources

            {
                effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)new Serializable(this, numFeatures, aStdValues, effectiveL1RegParam){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WeightedLeastSquares $outer;
                    private final int numFeatures$1;
                    private final double[] aStdValues$1;
                    private final double effectiveL1RegParam$1;

                    public final double apply(int index2) {
                        return this.apply$mcDI$sp(index2);
                    }

                    public double apply$mcDI$sp(int index2) {
                        return this.$outer.fitIntercept() && index2 == this.numFeatures$1 ? 0.0 : (this.$outer.standardizeFeatures() ? this.effectiveL1RegParam$1 : (this.aStdValues$1[index2] != 0.0 ? this.effectiveL1RegParam$1 / this.aStdValues$1[index2] : 0.0));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numFeatures$1 = numFeatures$1;
                        this.aStdValues$1 = aStdValues$1;
                        this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
                    }
                }) : None$.MODULE$;
                v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
            } else {
                v3 /* !! */  = new CholeskySolver();
            }
            var72_57 = solver = v3 /* !! */ ;
            if (var72_57 instanceof CholeskySolver) {
                var73_58 = var72_57;
                v4 = var73_58.solve(bBar, bbBar, ab, aa, aBar);
            }
            if (var72_57 instanceof QuasiNewtonSolver) {
                var82_59 = (QuasiNewtonSolver)var72_57;
                var74_60 = var82_59.solve(bBar, bbBar, ab, aa, aBar);
            } else {
                throw new MatchError((Object)var72_57);
                catch (Throwable var75_61) {
                    var76_62 = var75_61;
                    if (!(var76_62 instanceof SingularMatrixException)) break block24;
                    v5 = this.solverType();
                    var77_63 = WeightedLeastSquares$Auto$.MODULE$;
                    if (v5 != null ? v5.equals(var77_63) == false : var77_63 != null) break block24;
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
                        }
                    });
                    _aa = this.getAtA(aaBarValues, aBarValues);
                    _ab = this.getAtB(abBarValues, bBar);
                    newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                    v4 = var78_67 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                }
                var74_60 = v4;
            }
            solution = var74_60;
            v6 = var84_69 = this.fitIntercept() != false ? new Tuple2(Predef$.MODULE$.doubleArrayOps(solution.coefficients()).slice(0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(solution.coefficients()).last()) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
            if (var84_69 != null) {
                coefficientArray = (double[])var84_69._1();
                intercept = var84_69._2$mcD$sp();
                var83_73 = var88_72 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
                coefficientArray = (double[])var83_73._1();
                intercept = var83_73._2$mcD$sp();
                len = coefficientArray.length;
                for (q = 0; q < len; ++q) {
                    var94_78 = q;
                    coefficientArray[var94_78] = coefficientArray[var94_78] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
                }
                diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)new Serializable(this, k, wSum, aStdValues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WeightedLeastSquares $outer;
                    public final int k$1;
                    public final double wSum$1;
                    public final double[] aStdValues$1;

                    public final DenseVector apply(double[] inv) {
                        return new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.k$1).map((Function1)new Serializable(this, inv){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10 $outer;
                            private final double[] inv$1;

                            public final double apply(int i) {
                                return this.apply$mcDI$sp(i);
                            }

                            public double apply$mcDI$sp(int i) {
                                double multiplier = i == this.$outer.k$1 && this.$outer.org$apache$spark$ml$optim$WeightedLeastSquares$$anonfun$$$outer().fitIntercept() ? 1.0 : this.$outer.aStdValues$1[i - 1] * this.$outer.aStdValues$1[i - 1];
                                return this.inv$1[i + (i - 1) * i / 2 - 1] / (this.$outer.wSum$1 * multiplier);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.inv$1 = inv$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                    }

                    public /* synthetic */ WeightedLeastSquares org$apache$spark$ml$optim$WeightedLeastSquares$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                        this.wSum$1 = wSum$1;
                        this.aStdValues$1 = aStdValues$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DenseVector apply() {
                        return new DenseVector(new double[]{0.0});
                    }
                });
                return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply() {
                        return new double[]{0.0};
                    }
                }));
            }
            throw new MatchError((Object)var84_69);
        }
        throw var75_61;
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])abBar.clone());
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regParam cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.regParam())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (regParam == 0.0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "regParam is zero, which might cause numerical instability and overfitting.";
                }
            });
        }
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elasticNetParam must be in [0, 1]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.elasticNetParam())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(maxIter >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIter must be a positive integer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.maxIter())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(tol >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tol must be >= 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.tol())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static interface Solver {
    }

    public static class Aggregator
    implements Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0)new Serializable(this, k){
                public static final long serialVersionUID = 0L;
                private final int k$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"In order to take the normal equation approach efficiently, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we set the max number of features to ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()), BoxesRunTime.boxToInteger((int)this.k$2)}))).toString();
                }
                {
                    this.k$2 = k$2;
                }
            });
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 != null) {
                Tuple3 tuple3;
                double l = instance2.label();
                double w2 = instance2.weight();
                Vector f = instance2.features();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w2), (Object)f);
                double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double w3 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                Vector f2 = (Vector)tuple32._3();
                int ak = f2.size();
                if (!this.initialized()) {
                    this.init(ak);
                }
                Predef$.MODULE$.assert(ak == this.k(), (Function0)new Serializable(this, ak){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final int ak$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch. Expect vectors of size ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.ak$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ak$1 = ak$1;
                    }
                });
                this.count_$eq(this.count() + 1L);
                this.wSum_$eq(this.wSum() + w3);
                this.wwSum_$eq(this.wwSum() + w3 * w3);
                this.bSum_$eq(this.bSum() + w3 * l2);
                this.bbSum_$eq(this.bbSum() + w3 * l2 * l2);
                BLAS$.MODULE$.axpy(w3, f2, (Vector)this.aSum());
                BLAS$.MODULE$.axpy(w3 * l2, f2, (Vector)this.abSum());
                BLAS$.MODULE$.spr(w3, f2, this.aaSum());
                return this;
            }
            throw new MatchError((Object)instance2);
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (other.initialized()) {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0)new Serializable(this, other){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final Aggregator other$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension mismatch: this.k = ", " but other.k = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.other$1.k())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.other$1 = other$1;
                    }
                });
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            } else {
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Training dataset is empty.";
                }
            });
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sum of weights cannot be zero.";
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance2 = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance2);
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance2 = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance2[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance2);
        }
    }
}

