/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.io.DataInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.CredentialUpdater$;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c!B\u0001\u0003\u0001!q!!E\"sK\u0012,g\u000e^5bYV\u0003H-\u0019;fe*\u00111\u0001B\u0001\tg\u0016\u001cWO]5us*\u0011QAB\u0001\u0005s\u0006\u0014hN\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0013M\u0004\u0018M]6D_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n!\u0002[1e_>\u00048i\u001c8g!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003d_:4'BA\u0015\u000b\u0003\u0019A\u0017\rZ8pa&\u00111F\n\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0011c\u0019:fI\u0016tG/[1m\u001b\u0006t\u0017mZ3s!\ty\u0003'D\u0001\u0003\u0013\t\t$A\u0001\u0011Z\u0003Js\u0005*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014\b\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00036m]B\u0004CA\u0018\u0001\u0011\u0015a\"\u00071\u0001\u001f\u0011\u0015\u0019#\u00071\u0001%\u0011\u0015i#\u00071\u0001/\u0011\u001dQ\u0004\u00011A\u0005\nm\n\u0011\u0004\\1ti\u000e\u0013X\rZ3oi&\fGn\u001d$jY\u0016\u001cVO\u001a4jqV\tA\b\u0005\u0002\u0011{%\u0011a(\u0005\u0002\u0004\u0013:$\bb\u0002!\u0001\u0001\u0004%I!Q\u0001\u001eY\u0006\u001cHo\u0011:fI\u0016tG/[1mg\u001aKG.Z*vM\u001aL\u0007p\u0018\u0013fcR\u0011!)\u0012\t\u0003!\rK!\u0001R\t\u0003\tUs\u0017\u000e\u001e\u0005\b\r~\n\t\u00111\u0001=\u0003\rAH%\r\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001f\u000251\f7\u000f^\"sK\u0012,g\u000e^5bYN4\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0011)\u0005\u001dS\u0005C\u0001\tL\u0013\ta\u0015C\u0001\u0005w_2\fG/\u001b7f\u0011\u001dq\u0005A1A\u0005\n=\u000bqb\u0019:fI\u0016tG/[1mg\u001aKG.Z\u000b\u0002!B\u0011\u0011\u000b\u0016\b\u0003!IK!aU\t\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'FAa\u0001\u0017\u0001!\u0002\u0013\u0001\u0016\u0001E2sK\u0012,g\u000e^5bYN4\u0015\u000e\\3!\u0011\u001dQ\u0006A1A\u0005\nm\u000bqB\u001a:fg\"D\u0015\rZ8pa\u000e{gNZ\u000b\u0002I!1Q\f\u0001Q\u0001\n\u0011\n\u0001C\u001a:fg\"D\u0015\rZ8pa\u000e{gN\u001a\u0011\t\u000f}\u0003!\u0019!C\u0005A\u0006\t2M]3eK:$\u0018.\u00197Va\u0012\fG/\u001a:\u0016\u0003\u0005\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002gO\u0006!Q\u000f^5m\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[2\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004m\u0001\u0001\u0006I!Y\u0001\u0013GJ,G-\u001a8uS\u0006dW\u000b\u001d3bi\u0016\u0014\b\u0005C\u0004o\u0001\t\u0007I\u0011B8\u00023\r\u0014X\rZ3oi&\fG.\u00169eCR,'OU;o]\u0006\u0014G.Z\u000b\u0002aJ\u0019\u0011/^>\u0007\tI\u001c\b\u0001\u001d\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\u0007i\u0002\u0001\u000b\u0011\u00029\u00025\r\u0014X\rZ3oi&\fG.\u00169eCR,'OU;o]\u0006\u0014G.\u001a\u0011\u0011\u0005YLX\"A<\u000b\u0005a<\u0017\u0001\u00027b]\u001eL!A_<\u0003\r=\u0013'.Z2u!\t1H0\u0003\u0002~o\nA!+\u001e8oC\ndW\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0006gR\f'\u000f\u001e\u000b\u0002\u0005\"9\u0011Q\u0001\u0001\u0005\n\u0005\u0005\u0011aG;qI\u0006$Xm\u0011:fI\u0016tG/[1mg&3'+Z9vSJ,G\rC\u0004\u0002\n\u0001!I!a\u0003\u00025\u001d,Go\u0011:fI\u0016tG/[1mg\u001a\u0013x.\u001c%E\rN3\u0015\u000e\\3\u0015\r\u00055\u0011qCA\u0014!\u0011\ty!a\u0005\u000e\u0005\u0005E!BA\u0002)\u0013\u0011\t)\"!\u0005\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\t\u00033\t9\u00011\u0001\u0002\u001c\u0005A!/Z7pi\u001645\u000f\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003K\u0001\u0003MNLA!!\n\u0002 \tQa)\u001b7f'f\u001cH/Z7\t\u0011\u0005%\u0012q\u0001a\u0001\u0003W\t\u0011\u0002^8lK:\u0004\u0016\r\u001e5\u0011\t\u0005u\u0011QF\u0005\u0005\u0003_\tyB\u0001\u0003QCRD\u0007bBA\u001a\u0001\u0011%\u0011QG\u0001 O\u0016$H+[7f\u001f\u001atU\r\u001f;Va\u0012\fG/\u001a$s_64\u0015\u000e\\3OC6,G\u0003BA\u001c\u0003{\u00012\u0001EA\u001d\u0013\r\tY$\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0002@\u0005E\u0002\u0019AA\u0016\u0003=\u0019'/\u001a3f]RL\u0017\r\\:QCRD\u0007bBA\"\u0001\u0011\u0005\u0011\u0011A\u0001\u0005gR|\u0007\u000f")
public class CredentialUpdater
implements Logging {
    private final SparkConf sparkConf;
    private volatile int org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix;
    private final String credentialsFile;
    private final Configuration freshHadoopConf;
    private final ScheduledExecutorService credentialUpdater;
    private final Runnable credentialUpdaterRunnable;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public int org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix = x$1;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    private Configuration freshHadoopConf() {
        return this.freshHadoopConf;
    }

    private ScheduledExecutorService credentialUpdater() {
        return this.credentialUpdater;
    }

    private Runnable credentialUpdaterRunnable() {
        return this.credentialUpdaterRunnable;
    }

    public void start() {
        long startTime = BoxesRunTime.unboxToLong((Object)this.sparkConf.get(package$.MODULE$.CREDENTIALS_UPDATE_TIME()));
        long remainingTime = startTime - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), 1L, TimeUnit.MINUTES);
        } else {
            this.logInfo((Function0<String>)new Serializable(this, remainingTime){
                public static final long serialVersionUID = 0L;
                private final long remainingTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling credentials refresh from HDFS in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.remainingTime$1)}));
                }
                {
                    this.remainingTime$1 = remainingTime$1;
                }
            });
            this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public void org$apache$spark$deploy$yarn$security$CredentialUpdater$$updateCredentialsIfRequired() {
        long l;
        try {
            Path credentialsFilePath = new Path(this.credentialsFile());
            FileSystem remoteFs = FileSystem.get((Configuration)this.freshHadoopConf());
            l = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])SparkHadoopUtil$.MODULE$.get().listFilesSorted(remoteFs, credentialsFilePath.getParent(), credentialsFilePath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().map((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CredentialUpdater $outer;
                private final FileSystem remoteFs$1;

                public final long apply(FileStatus credentialsStatus) {
                    long l;
                    int suffix = SparkHadoopUtil$.MODULE$.get().getSuffixForCredentialsPath(credentialsStatus.getPath());
                    if (suffix > this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix()) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, credentialsStatus){
                            public static final long serialVersionUID = 0L;
                            private final FileStatus credentialsStatus$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Reading new credentials from ").append((Object)this.credentialsStatus$1.getPath()).toString();
                            }
                            {
                                this.credentialsStatus$1 = credentialsStatus$1;
                            }
                        });
                        Credentials newCredentials = this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$getCredentialsFromHDFSFile(this.remoteFs$1, credentialsStatus.getPath());
                        this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix_$eq(suffix);
                        UserGroupInformation.getCurrentUser().addCredentials(newCredentials);
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Credentials updated from credentials file.";
                            }
                        });
                        long remainingTime = this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$getTimeOfNextUpdateFromFileName(credentialsStatus.getPath()) - System.currentTimeMillis();
                        l = remainingTime <= 0L ? TimeUnit.MINUTES.toMillis(1L) : remainingTime;
                    } else {
                        l = TimeUnit.HOURS.toMillis(1L);
                    }
                    return l;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteFs$1 = remoteFs$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return TimeUnit.MINUTES.toMillis(1L);
                }
            }));
        }
        catch (Throwable throwable) {
            long l2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while trying to update credentials, will try again in 1 hour";
                }
            }, e);
            l = l2 = TimeUnit.HOURS.toMillis(1L);
        }
        long timeToNextUpdate = l;
        this.logInfo((Function0<String>)new Serializable(this, timeToNextUpdate){
            public static final long serialVersionUID = 0L;
            private final long timeToNextUpdate$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling credentials refresh from HDFS in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeToNextUpdate$1)}));
            }
            {
                this.timeToNextUpdate$1 = timeToNextUpdate$1;
            }
        });
        this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), timeToNextUpdate, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public Credentials org$apache$spark$deploy$yarn$security$CredentialUpdater$$getCredentialsFromHDFSFile(FileSystem remoteFs, Path tokenPath) {
        Credentials credentials;
        FSDataInputStream stream = remoteFs.open(tokenPath);
        try {
            Credentials newCredentials = new Credentials();
            newCredentials.readTokenStorageStream((DataInputStream)stream);
            credentials = newCredentials;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return credentials;
    }

    public long org$apache$spark$deploy$yarn$security$CredentialUpdater$$getTimeOfNextUpdateFromFileName(Path credentialsPath) {
        String name = credentialsPath.getName();
        int index = name.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM());
        String slice = name.substring(0, index);
        int last2index = slice.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM());
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(last2index + 1, index))).toLong();
    }

    public void stop() {
        this.credentialUpdater().shutdown();
    }

    public CredentialUpdater(SparkConf sparkConf, Configuration hadoopConf, YARNHadoopDelegationTokenManager credentialManager) {
        this.sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix = 0;
        this.credentialsFile = (String)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_PATH());
        this.freshHadoopConf = SparkHadoopUtil$.MODULE$.get().getConfBypassingFSCache(hadoopConf, new Path(this.credentialsFile()).toUri().getScheme());
        this.credentialUpdater = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Credential Refresh Thread"));
        this.credentialUpdaterRunnable = new Runnable(this){
            private final /* synthetic */ CredentialUpdater $outer;

            public void run() {
                Utils$.MODULE$.logUncaughtExceptions((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$anon$$$outer().org$apache$spark$deploy$yarn$security$CredentialUpdater$$updateCredentialsIfRequired();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CredentialUpdater org$apache$spark$deploy$yarn$security$CredentialUpdater$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

