/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.util.Util;

public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return new ViewTableMacro(CalciteSchema.from(schema), viewSql, schemaPath);
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView(context, relOptTable.getRowType(), this.viewSql);
    }

    private RelNode expandView(RelOptTable.ToRelContext preparingStmt, RelDataType rowType, String queryString) {
        try {
            RelNode rel = preparingStmt.expandView(rowType, queryString, this.schemaPath);
            rel = RelOptUtil.createCastRel(rel, rowType, true);
            return rel;
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while parsing view definition:  " + queryString);
        }
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    static class ViewTableMacro
    implements TableMacro {
        protected final String viewSql;
        protected final CalciteSchema schema;
        protected final List<String> schemaPath;

        ViewTableMacro(CalciteSchema schema, String viewSql, List<String> schemaPath) {
            this.viewSql = viewSql;
            this.schema = schema;
            this.schemaPath = schemaPath == null ? null : ImmutableList.copyOf(schemaPath);
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public TranslatableTable apply(List<Object> arguments) {
            CalcitePrepare.ParseResult parsed = Schemas.parse(MaterializedViewTable.MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
            return new ViewTable(typeFactory.getJavaClass(parsed.rowType), RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1);
        }
    }
}

