/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;

public class LoptJoinTree {
    private final BinaryTree factorTree;
    private final RelNode joinTree;
    private final boolean removableSelfJoin;

    public LoptJoinTree(RelNode joinTree, int factorId) {
        this.joinTree = joinTree;
        this.factorTree = new Leaf(factorId, this);
        this.removableSelfJoin = false;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree factorTree, boolean removableSelfJoin) {
        this.joinTree = joinTree;
        this.factorTree = factorTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree) {
        this(joinTree, leftFactorTree, rightFactorTree, false);
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree, boolean removableSelfJoin) {
        this.factorTree = new Node(leftFactorTree, rightFactorTree, this);
        this.joinTree = joinTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public RelNode getJoinTree() {
        return this.joinTree;
    }

    public LoptJoinTree getLeft() {
        Node node = (Node)this.factorTree;
        return new LoptJoinTree(((Join)this.joinTree).getLeft(), node.getLeft(), node.getLeft().getParent().isRemovableSelfJoin());
    }

    public LoptJoinTree getRight() {
        Node node = (Node)this.factorTree;
        return new LoptJoinTree(((Join)this.joinTree).getRight(), node.getRight(), node.getRight().getParent().isRemovableSelfJoin());
    }

    public BinaryTree getFactorTree() {
        return this.factorTree;
    }

    public List<Integer> getTreeOrder() {
        ArrayList treeOrder = Lists.newArrayList();
        this.getTreeOrder(treeOrder);
        return treeOrder;
    }

    public void getTreeOrder(List<Integer> treeOrder) {
        this.factorTree.getTreeOrder(treeOrder);
    }

    public boolean isRemovableSelfJoin() {
        return this.removableSelfJoin;
    }

    protected static class Node
    extends BinaryTree {
        private BinaryTree left;
        private BinaryTree right;

        public Node(BinaryTree left, BinaryTree right, LoptJoinTree parent) {
            super(parent);
            this.left = (BinaryTree)Preconditions.checkNotNull((Object)left);
            this.right = (BinaryTree)Preconditions.checkNotNull((Object)right);
        }

        public BinaryTree getLeft() {
            return this.left;
        }

        public BinaryTree getRight() {
            return this.right;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            this.left.getTreeOrder(treeOrder);
            this.right.getTreeOrder(treeOrder);
        }
    }

    protected static class Leaf
    extends BinaryTree {
        private final int id;

        public Leaf(int rootId, LoptJoinTree parent) {
            super(parent);
            this.id = rootId;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            treeOrder.add(this.id);
        }
    }

    protected static abstract class BinaryTree {
        private final LoptJoinTree parent;

        protected BinaryTree(LoptJoinTree parent) {
            this.parent = (LoptJoinTree)Preconditions.checkNotNull((Object)parent);
        }

        public LoptJoinTree getParent() {
            return this.parent;
        }

        public abstract void getTreeOrder(List<Integer> var1);
    }
}

