/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;

public abstract class SingleRel
extends AbstractRelNode {
    private RelNode input;

    protected SingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, traits);
        this.input = input;
    }

    public RelNode getInput() {
        return this.input;
    }

    @Override
    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.input);
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getRowCount(this.input);
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        visitor.visit(this.input, 0, this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).input("input", this.getInput());
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode rel) {
        assert (ordinalInParent == 0);
        this.input = rel;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.input.getRowType();
    }
}

