/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.KVIndex;
import org.spark_project.guava.base.Preconditions;

@Private
public class KVTypeInfo {
    private final Class<?> type;
    private final Map<String, KVIndex> indices;
    private final Map<String, Accessor> accessors;

    public KVTypeInfo(Class<?> type) throws Exception {
        KVIndex idx;
        this.type = type;
        this.accessors = new HashMap<String, Accessor>();
        this.indices = new HashMap<String, KVIndex>();
        for (Field field : type.getDeclaredFields()) {
            idx = field.getAnnotation(KVIndex.class);
            if (idx == null) continue;
            this.checkIndex(idx, this.indices);
            field.setAccessible(true);
            this.indices.put(idx.value(), idx);
            field.setAccessible(true);
            this.accessors.put(idx.value(), new FieldAccessor(field));
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            idx = ((Method)accessibleObject).getAnnotation(KVIndex.class);
            if (idx == null) continue;
            this.checkIndex(idx, this.indices);
            Preconditions.checkArgument((((Method)accessibleObject).getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Annotated method %s::%s should not have any parameters.", (Object[])new Object[]{type.getName(), ((Method)accessibleObject).getName()});
            ((Method)accessibleObject).setAccessible(true);
            this.indices.put(idx.value(), idx);
            ((Method)accessibleObject).setAccessible(true);
            this.accessors.put(idx.value(), new MethodAccessor((Method)accessibleObject));
        }
        Preconditions.checkArgument((boolean)this.indices.containsKey("__main__"), (String)"No natural index defined for type %s.", (Object[])new Object[]{type.getName()});
        Preconditions.checkArgument((boolean)this.indices.get("__main__").parent().isEmpty(), (String)"Natural index of %s cannot have a parent.", (Object[])new Object[]{type.getName()});
        for (KVIndex idx2 : this.indices.values()) {
            if (idx2.parent().isEmpty()) continue;
            KVIndex parent = this.indices.get(idx2.parent());
            Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"Cannot find parent %s of index %s.", (Object[])new Object[]{idx2.parent(), idx2.value()});
            Preconditions.checkArgument((boolean)parent.parent().isEmpty(), (String)"Parent index %s of index %s cannot be itself a child index.", (Object[])new Object[]{idx2.parent(), idx2.value()});
        }
    }

    private void checkIndex(KVIndex idx, Map<String, KVIndex> indices) {
        Preconditions.checkArgument((idx.value() != null && !idx.value().isEmpty() ? 1 : 0) != 0, (String)"No name provided for index in type %s.", (Object[])new Object[]{this.type.getName()});
        Preconditions.checkArgument((!idx.value().startsWith("_") || idx.value().equals("__main__") ? 1 : 0) != 0, (String)"Index name %s (in type %s) is not allowed.", (Object[])new Object[]{idx.value(), this.type.getName()});
        Preconditions.checkArgument((idx.parent().isEmpty() || !idx.parent().equals(idx.value()) ? 1 : 0) != 0, (String)"Index %s cannot be parent of itself.", (Object[])new Object[]{idx.value()});
        Preconditions.checkArgument((!indices.containsKey(idx.value()) ? 1 : 0) != 0, (String)"Duplicate index %s for type %s.", (Object[])new Object[]{idx.value(), this.type.getName()});
    }

    public Class<?> type() {
        return this.type;
    }

    public Object getIndexValue(String indexName, Object instance) throws Exception {
        return this.getAccessor(indexName).get(instance);
    }

    public Stream<KVIndex> indices() {
        return this.indices.values().stream();
    }

    Accessor getAccessor(String indexName) {
        Accessor a = this.accessors.get(indexName);
        Preconditions.checkArgument((a != null ? 1 : 0) != 0, (String)"No index %s.", (Object[])new Object[]{indexName});
        return a;
    }

    Accessor getParentAccessor(String indexName) {
        KVIndex index = this.indices.get(indexName);
        return index.parent().isEmpty() ? null : this.getAccessor(index.parent());
    }

    private class MethodAccessor
    implements Accessor {
        private final Method method;

        MethodAccessor(Method method) {
            this.method = method;
        }

        @Override
        public Object get(Object instance) throws Exception {
            return this.method.invoke(instance, new Object[0]);
        }
    }

    private class FieldAccessor
    implements Accessor {
        private final Field field;

        FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object instance) throws Exception {
            return this.field.get(instance);
        }
    }

    static interface Accessor {
        public Object get(Object var1) throws Exception;
    }
}

