/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.api.python.DechunkedInputStream$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0001\u0002\u0001\r1\u0011A\u0003R3dQVt7.\u001a3J]B,Ho\u0015;sK\u0006l'BA\u0002\u0005\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001iQ\u0003\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005\u0011\u0011n\u001c\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rBA\u0006J]B,Ho\u0015;sK\u0006l\u0007C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000e\u0018\u0005\u001daunZ4j]\u001eD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!D\u0001\boJ\f\u0007\u000f]3e\u0007\u0001AQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDCA\u0011$!\t\u0011\u0003!D\u0001\u0003\u0011\u0015ab\u00041\u0001\u000e\u0011\u001d)\u0003A1A\u0005\n\u0019\n1\u0001Z5o+\u00059\u0003C\u0001\b)\u0013\tIsBA\bECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0019Y\u0003\u0001)A\u0005O\u0005!A-\u001b8!\u0011\u001di\u0003\u00011A\u0005\n9\n\u0001C]3nC&t\u0017N\\4J]\u000eCWO\\6\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00138u\u0011\u001d1\u0004\u00011A\u0005\n]\nAC]3nC&t\u0017N\\4J]\u000eCWO\\6`I\u0015\fHC\u0001\u001d<!\t\u0001\u0014(\u0003\u0002;c\t!QK\\5u\u0011\u001daT'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019q\u0004\u0001)Q\u0005_\u0005\t\"/Z7bS:LgnZ%o\u0007\",hn\u001b\u0011\t\u000b\u0001\u0003A\u0011I!\u0002\tI,\u0017\r\u001a\u000b\u0002_!)\u0001\t\u0001C!\u0007R!q\u0006\u0012'O\u0011\u0015)%\t1\u0001G\u0003\u0011!Wm\u001d;\u0011\u0007A:\u0015*\u0003\u0002Ic\t)\u0011I\u001d:bsB\u0011\u0001GS\u0005\u0003\u0017F\u0012AAQ=uK\")QJ\u0011a\u0001_\u0005\u0019qN\u001a4\t\u000b=\u0013\u0005\u0019A\u0018\u0002\u00071,g\u000eC\u0003R\u0001\u0011\u0005#+A\u0003dY>\u001cX\rF\u00019\u000f\u0019!&\u0001#\u0001\u0007+\u0006!B)Z2ik:\\W\rZ%oaV$8\u000b\u001e:fC6\u0004\"A\t,\u0007\r\u0005\u0011\u0001\u0012\u0001\u0004X'\t1\u0006\f\u0005\u000213&\u0011!,\r\u0002\u0007\u0003:L(+\u001a4\t\u000b}1F\u0011\u0001/\u0015\u0003UCQA\u0018,\u0005\u0002}\u000ba\u0003Z3dQVt7.\u00118e\u0007>\u0004\u0018\u0010V8PkR\u0004X\u000f\u001e\u000b\u0004q\u0001\u0014\u0007\"B1^\u0001\u0004i\u0011aB2ik:\\W\r\u001a\u0005\u0006Gv\u0003\r\u0001Z\u0001\u0004_V$\bC\u0001\bf\u0013\t1wB\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e")
public class DechunkedInputStream
extends InputStream
implements Logging {
    private final InputStream wrapped;
    private final DataInputStream din;
    private int remainingInChunk;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void dechunkAndCopyToOutput(InputStream inputStream, OutputStream outputStream) {
        DechunkedInputStream$.MODULE$.dechunkAndCopyToOutput(inputStream, outputStream);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    private DataInputStream din() {
        return this.din;
    }

    private int remainingInChunk() {
        return this.remainingInChunk;
    }

    private void remainingInChunk_$eq(int x$1) {
        this.remainingInChunk = x$1;
    }

    @Override
    public int read() {
        byte[] into = new byte[1];
        int n = this.read(into, 0, 1);
        return n == -1 ? -1 : into[0] & 0xFF;
    }

    @Override
    public int read(byte[] dest, int off, int len) {
        int destSpace;
        int read2;
        if (this.remainingInChunk() == -1) {
            return -1;
        }
        int destPos = off;
        for (destSpace = len; destSpace > 0 && this.remainingInChunk() != -1; destSpace -= read2) {
            int toCopy = package$.MODULE$.min(this.remainingInChunk(), destSpace);
            read2 = this.din().read(dest, destPos, toCopy);
            destPos += read2;
            this.remainingInChunk_$eq(this.remainingInChunk() - read2);
            if (this.remainingInChunk() != 0) continue;
            this.remainingInChunk_$eq(this.din().readInt());
        }
        Predef$.MODULE$.assert(destSpace == 0 || this.remainingInChunk() == -1);
        return destPos - off;
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    public DechunkedInputStream(InputStream wrapped) {
        this.wrapped = wrapped;
        Logging$class.$init$(this);
        this.din = new DataInputStream(wrapped);
        this.remainingInChunk = this.din().readInt();
    }
}

