/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodFactory;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1$;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1$$anonfun$handleDisconnectedExecutors$1$;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\rMd!B\u0001\u0003\u0001!q!!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\rY\u0007h\u001d\u0006\u0003\u000b\u0019\tqa\u00197vgR,'O\u0003\u0002\b\u0011\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Ei\u0011\u0001B\u0005\u0003%\u0011\u0011QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0005\t\u000f\u0001\u0011\t\u0011)A\u0005+\r\u0001\u0001C\u0001\f\u0018\u001b\u00051\u0011B\u0001\r\u0007\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\n5\u0001\u0011\t\u0011)A\u00057\u0005\naA\u001d9d\u000b:4\bC\u0001\u000f \u001b\u0005i\"B\u0001\u0010\t\u0003\r\u0011\boY\u0005\u0003Au\u0011aA\u00159d\u000b:4\u0018B\u0001\u000e\u0012\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013AE3yK\u000e,Ho\u001c:Q_\u00124\u0015m\u0019;pef\u0004\"!\n\u0014\u000e\u0003\tI!a\n\u0002\u0003%\u0015CXmY;u_J\u0004v\u000e\u001a$bGR|'/\u001f\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003WQj\u0011\u0001\f\u0006\u0003[9\naa\u00197jK:$(BA\u00181\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003cI\nqAZ1ce&\u001c\u0007HC\u00014\u0003\tIw.\u0003\u00026Y\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005\t\u0012\r\u001c7pG\u0006$xN]#yK\u000e,Ho\u001c:\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014AC2p]\u000e,(O]3oi*\u0011QHP\u0001\u0005kRLGNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005S$\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"A1\t\u0001B\u0001B\u0003%A)A\fsKF,Xm\u001d;Fq\u0016\u001cW\u000f^8sgN+'O^5dKB\u0011\u0011(R\u0005\u0003\rj\u0012q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f)[E*\u0014(P!B\u0011Q\u0005\u0001\u0005\u0006\u000f\u001d\u0003\r!\u0006\u0005\u00065\u001d\u0003\ra\u0007\u0005\u0006G\u001d\u0003\r\u0001\n\u0005\u0006S\u001d\u0003\rA\u000b\u0005\u0006o\u001d\u0003\r\u0001\u000f\u0005\u0006\u0007\u001e\u0003\r\u0001\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0003M)\u0005,R\"V)>\u0013v,\u0013#`\u0007>+f\nV#S+\u0005!\u0006CA+Y\u001b\u00051&BA,;\u0003\u0019\tGo\\7jG&\u0011\u0011L\u0016\u0002\u000b\u0003R|W.[2M_:<\u0007BB.\u0001A\u0003%A+\u0001\u000bF1\u0016\u001bU\u000bV(S?&#ulQ(V\u001dR+%\u000b\t\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0003i\u0011VK\u0014(J\u001d\u001e{V\tW#D+R{%k\u0018)P\tN{FjT\"L+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012?\u0003\u0011a\u0017M\\4\n\u0005\u0011\f'AB(cU\u0016\u001cG\u000f\u0003\u0004g\u0001\u0001\u0006IaX\u0001\u001c%Vse*\u0013(H?\u0016CViQ+U\u001fJ{\u0006k\u0014#T?2{5i\u0013\u0011\t\u000f!\u0004!\u0019!C\u0005S\u00061\"/\u001e8oS:<W\t_3dkR|'o\u001d+p!>$7/F\u0001k!\u0011Y'\u000f\u001e?\u000e\u00031T!!\u001c8\u0002\u000f5,H/\u00192mK*\u0011q\u000e]\u0001\u000bG>dG.Z2uS>t'\"A9\u0002\u000bM\u001c\u0017\r\\1\n\u0005Md'a\u0002%bg\"l\u0015\r\u001d\t\u0003kft!A^<\u000e\u0003AL!\u0001\u001f9\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003qB\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005)Qn\u001c3fY*\u0019\u00111\u0001\u0018\u0002\u0007\u0005\u0004\u0018.C\u0002\u0002\by\u00141\u0001U8e\u0011\u001d\tY\u0001\u0001Q\u0001\n)\fqC];o]&tw-\u0012=fGV$xN]:U_B{Gm\u001d\u0011)\u0011\u0005%\u0011qBA\u0011\u0003G\u0001B!!\u0005\u0002\u001e5\u0011\u00111\u0003\u0006\u0004w\u0005U!\u0002BA\f\u00033\t!\"\u00198o_R\fG/[8o\u0015\t\tY\"A\u0003kCZ\f\u00070\u0003\u0003\u0002 \u0005M!!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005i\u0006\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0003E)\u00070Z2vi>\u0014\bk\u001c3t\u0005fL\u0005k]\u000b\u0003\u0003W\u0001R!OA\u0017irL1!a\f;\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002,\u0005\u0011R\r_3dkR|'\u000fU8eg\nK\u0018\nU:!\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI$\u0001\rq_\u0012\u001cx+\u001b;i\u0017:|wO\\#ySR\u0014V-Y:p]N,\"!a\u000f\u0011\re\ni\u0003^A\u001f!\r1\u0012qH\u0005\u0004\u0003\u00032!AD#yK\u000e,Ho\u001c:Fq&$X\r\u001a\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002<\u0005I\u0002o\u001c3t/&$\bn\u00138po:,\u00050\u001b;SK\u0006\u001cxN\\:!\u0011%\tI\u0005\u0001b\u0001\n\u0013\tI#\u0001\u0016eSN\u001cwN\u001c8fGR,G\rU8eg\nKX\t_3dkR|'/\u00133QK:$\u0017N\\4SK6|g/\u00197\t\u0011\u00055\u0003\u0001)A\u0005\u0003W\t1\u0006Z5tG>tg.Z2uK\u0012\u0004v\u000eZ:Cs\u0016CXmY;u_JLE\rU3oI&twMU3n_Z\fG\u000e\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'\n1c[;cKJtW\r^3t\u001d\u0006lWm\u001d9bG\u0016,\u0012\u0001\u001e\u0005\b\u0003/\u0002\u0001\u0015!\u0003u\u0003QYWOY3s]\u0016$Xm\u001d(b[\u0016\u001c\b/Y2fA!I\u00111\f\u0001C\u0002\u0013%\u00111K\u0001\u0018WV\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0004v\u000e\u001a(b[\u0016Dq!a\u0018\u0001A\u0003%A/\u0001\rlk\n,'O\\3uKN$%/\u001b<feB{GMT1nK\u0002B\u0011\"a\u0019\u0001\u0005\u0004%Y!!\u001a\u0002-I,\u0017/^3ti\u0016CXmY;u_J\u001cuN\u001c;fqR,\"!a\u001a\u0011\t\u0005%\u0014QN\u0007\u0003\u0003WR!a\u000f9\n\t\u0005=\u00141\u000e\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CA:\u0001\u0001\u0006I!a\u001a\u0002/I,\u0017/^3ti\u0016CXmY;u_J\u001cuN\u001c;fqR\u0004\u0003\"CA<\u0001\t\u0007I\u0011BA=\u0003%!'/\u001b<feB{G-F\u0001}\u0011\u001d\ti\b\u0001Q\u0001\nq\f!\u0002\u001a:jm\u0016\u0014\bk\u001c3!\u0011%\t\t\t\u0001b\u0001\n#\n\u0019)\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|WCAAC!\r1\u0018qQ\u0005\u0004\u0003\u0013\u0003(A\u0002#pk\ndW\r\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAC\u0003Mi\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8!\u0011%\t\t\n\u0001b\u0001\n\u0013\t\u0019*A\u000bfq\u0016\u001cW\u000f^8s/\u0006$8\r\u001b*fg>,(oY3\u0016\u0005\u0005U\u0005#B+\u0002\u0018\u0006m\u0015bAAM-\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u001e\u0006\u0005VBAAP\u0015\t\u0019d(\u0003\u0003\u0002$\u0006}%!C\"m_N,\u0017M\u00197f\u0011!\t9\u000b\u0001Q\u0001\n\u0005U\u0015AF3yK\u000e,Ho\u001c:XCR\u001c\u0007NU3t_V\u00148-\u001a\u0011\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0016A\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0016\u0005\u0005=\u0006cA+\u00022&\u0019\u00111\u0017,\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t9\f\u0001Q\u0001\n\u0005=\u0016a\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:!\u0011%\tY\f\u0001b\u0001\n\u0013\t\u0019&A\u0005ee&4XM]+sY\"9\u0011q\u0018\u0001!\u0002\u0013!\u0018A\u00033sSZ,'/\u0016:mA!I\u00111\u0019\u0001C\u0002\u0013%\u0011QY\u0001\u0011S:LG/[1m\u000bb,7-\u001e;peN,\"!a2\u0011\u0007Y\fI-C\u0002\u0002LB\u00141!\u00138u\u0011!\ty\r\u0001Q\u0001\n\u0005\u001d\u0017!E5oSRL\u0017\r\\#yK\u000e,Ho\u001c:tA!I\u00111\u001b\u0001C\u0002\u0013%\u0011Q[\u0001\u0016a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8J]R,'O^1m+\t\t9\u000eE\u0002w\u00033L1!a7q\u0005\u0011auN\\4\t\u0011\u0005}\u0007\u0001)A\u0005\u0003/\fa\u0003]8e\u00032dwnY1uS>t\u0017J\u001c;feZ\fG\u000e\t\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003\u000b\f\u0011\u0003]8e\u00032dwnY1uS>t7+\u001b>f\u0011!\t9\u000f\u0001Q\u0001\n\u0005\u001d\u0017A\u00059pI\u0006cGn\\2bi&|gnU5{K\u0002B\u0011\"a;\u0001\u0005\u0004%I!!2\u0002E\u0015DXmY;u_Jdun\u001d;SK\u0006\u001cxN\\\"iK\u000e\\W*\u0019=BiR,W\u000e\u001d;t\u0011!\ty\u000f\u0001Q\u0001\n\u0005\u001d\u0017aI3yK\u000e,Ho\u001c:M_N$(+Z1t_:\u001c\u0005.Z2l\u001b\u0006D\u0018\t\u001e;f[B$8\u000f\t\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003k\f\u0011#\u00197m_\u000e\fGo\u001c:Sk:t\u0017M\u00197f+\t\t9PE\u0003\u0002z~\u0013\tAB\u0004\u0002|\u0006u\b!a>\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\u0011\u0005}\b\u0001)A\u0005\u0003o\f!#\u00197m_\u000e\fGo\u001c:Sk:t\u0017M\u00197fAA\u0019\u0001Ma\u0001\n\u0007\t\u0015\u0011M\u0001\u0005Sk:t\u0017M\u00197f\u0011!\u0011I!!?\u0005\u0002\t-\u0011a\u00075b]\u0012dW\rR5tG>tg.Z2uK\u0012,\u00050Z2vi>\u00148\u000f\u0006\u0002\u0003\u000eA\u0019aOa\u0004\n\u0007\tE\u0001O\u0001\u0003V]&$\b\u0002\u0003B\u000b\u0003s$\tAa\u0006\u0002[I,Wn\u001c<f\u000bb,7-\u001e;pe>\u0013\u0018J\\2sK6,g\u000e\u001e'pgN\u0014V-Y:p]\u000eCWmY6D_VtG\u000f\u0006\u0003\u0003\u000e\te\u0001b\u0002B\u000e\u0005'\u0001\r\u0001^\u0001\u000bKb,7-\u001e;pe&#\u0007\u0002\u0003B\u0010\u0003s$\tA!\t\u0002U\u0011,G.\u001a;f\u000bb,7-\u001e;pe\u001a\u0013x.\\\"mkN$XM]!oI\u0012\u000bG/Y*ueV\u001cG/\u001e:fgR!!Q\u0002B\u0012\u0011\u001d\u0011YB!\bA\u0002QD\u0001Ba\n\u0002z\u0012\u0005!\u0011F\u0001!I\u0016dW\r^3Fq\u0016\u001cW\u000f^8s\rJ|W\u000eR1uCN#(/^2ukJ,7\u000f\u0006\u0003\u0003,\tE\u0002\u0003\u0002<\u0003.qL1Aa\fq\u0005\u0019y\u0005\u000f^5p]\"9!1\u0004B\u0013\u0001\u0004!\bb\u0002B\u001b\u0001\u0011\u0005#qG\u0001\u001egV4g-[2jK:$(+Z:pkJ\u001cWm\u001d*fO&\u001cH/\u001a:fIR\u0011!\u0011\b\t\u0004m\nm\u0012b\u0001B\u001fa\n9!i\\8mK\u0006t\u0007b\u0002B!\u0001\u0011\u0005#1B\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0005\u000b\u0002A\u0011\tB\u0006\u0003\u0011\u0019Ho\u001c9\t\u000f\t%\u0003\u0001\"\u0003\u0003L\u0005Yr-\u001a;O_\u0012,7oV5uQ2{7-\u00197UCN\\7i\\;oiN$\"A!\u0014\u0011\rU\u0014y\u0005^Ad\u0013\r\u0011\tf\u001f\u0002\u0004\u001b\u0006\u0004\bb\u0002B+\u0001\u0011\u0005#qK\u0001\u0018I>\u0014V-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$BA!\u0017\u0003`A1\u0011\u0011\u000eB.\u0005sIAA!\u0018\u0002l\t1a)\u001e;ve\u0016D\u0001B!\u0019\u0003T\u0001\u0007\u0011qY\u0001\u000fe\u0016\fX/Z:uK\u0012$v\u000e^1m\u0011\u001d\u0011)\u0007\u0001C!\u0005O\nq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u00053\u0012I\u0007\u0003\u0005\u0003l\t\r\u0004\u0019\u0001B7\u0003-)\u00070Z2vi>\u0014\u0018\nZ:\u0011\u000b\t=$q\u0010;\u000f\t\tE$1\u0010\b\u0005\u0005g\u0012I(\u0004\u0002\u0003v)\u0019!q\u000f\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0018b\u0001B?a\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BA\u0005\u0007\u00131aU3r\u0015\r\u0011i\b\u001d\u0005\b\u0005\u000f\u0003A\u0011\u0002B\u0006\u0003a!W\r\\3uK\u0016CXmY;u_J\u0004v\u000eZ:P]N#x\u000e\u001d\u0004\u0007\u0005\u0017\u0003AA!$\u0003'\u0015CXmY;u_J\u0004v\u000eZ:XCR\u001c\u0007.\u001a:\u0014\u000b\t%uLa$\u0011\t-\u0012\t\n`\u0005\u0004\u0005'c#aB,bi\u000eDWM\u001d\u0005\b\u0011\n%E\u0011\u0001BL)\t\u0011I\n\u0005\u0003\u0003\u001c\n%U\"\u0001\u0001\t\u0015\t}%\u0011\u0012b\u0001\n\u0013\t)-A\u0013E\u000b\u001a\u000bU\u000b\u0014+`\u0007>sE+Q%O\u000bJ{f)Q%M+J+u,\u0012-J)~\u001bF+\u0011+V'\"I!1\u0015BEA\u0003%\u0011qY\u0001'\t\u00163\u0015)\u0016'U?\u000e{e\nV!J\u001d\u0016\u0013vLR!J\u0019V\u0013ViX#Y\u0013R{6\u000bV!U+N\u0003\u0003\u0002\u0003BT\u0005\u0013#\tE!+\u0002\u001b\u00154XM\u001c;SK\u000e,\u0017N^3e)\u0019\u0011iAa+\u0003N\"A!Q\u0016BS\u0001\u0004\u0011y+\u0001\u0004bGRLwN\u001c\t\u0005\u0005c\u00139M\u0004\u0003\u00034\n\rg\u0002\u0002B[\u0005\u0003tAAa.\u0003@:!!\u0011\u0018B_\u001d\u0011\u0011\u0019Ha/\n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014BA\u0017/\u0013\r\u0011)\rL\u0001\b/\u0006$8\r[3s\u0013\u0011\u0011IMa3\u0003\r\u0005\u001bG/[8o\u0015\r\u0011)\r\f\u0005\b\u0005\u001f\u0014)\u000b1\u0001}\u0003\r\u0001x\u000e\u001a\u0005\t\u0005'\u0014I\t\"\u0011\u0003V\u00069qN\\\"m_N,G\u0003\u0002B\u0007\u0005/D\u0001B!7\u0003R\u0002\u0007!1\\\u0001\u0006G\u0006,8/\u001a\t\u0004W\tu\u0017b\u0001BpY\tI2*\u001e2fe:,G/Z:DY&,g\u000e^#yG\u0016\u0004H/[8o\u0011!\u0011\u0019O!#\u0005\n\t\u0015\u0018!F4fi\u0016CXmY;u_J,\u00050\u001b;Ti\u0006$Xo\u001d\u000b\u0005\u0003\u000f\u00149\u000fC\u0004\u0003P\n\u0005\b\u0019\u0001?\t\u0011\t\r(\u0011\u0012C\u0005\u0005W$B!a2\u0003n\"A!q\u001eBu\u0001\u0004\u0011\t0A\bd_:$\u0018-\u001b8feN#\u0018\r^;t!\ri(1_\u0005\u0004\u0005kt(aD\"p]R\f\u0017N\\3s'R\fG/^:\t\u0011\te(\u0011\u0012C\u0005\u0005w\fA#[:Q_\u0012\fEN]3bIf\u0014V\r\\3bg\u0016$G\u0003\u0002B\u001d\u0005{DqAa4\u0003x\u0002\u0007A\u0010\u0003\u0005\u0004\u0002\t%E\u0011BB\u0002\u0003e)\u00070Z2vi>\u0014X\t_5u%\u0016\f7o\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005u2Q\u0001\u0005\b\u0005\u001f\u0014y\u00101\u0001}\u0011!\u0019IA!#\u0005\n\r-\u0011AG3yK\u000e,Ho\u001c:Fq&$(+Z1t_:|e\u000eR3mKR,G\u0003BA\u001f\u0007\u001bAqAa4\u0004\b\u0001\u0007A\u0010\u0003\u0005\u0004\u0012\t%E\u0011BB\n\u000359W\r^#yK\u000e,Ho\u001c:JIR\u0019Ao!\u0006\t\u000f\t=7q\u0002a\u0001y\"91\u0011\u0004\u0001\u0005B\rm\u0011\u0001F2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0003\u0004\u001e\r\r\u0002\u0003\u0002BN\u0007?I1a!\t\u0012\u00059!%/\u001b<fe\u0016sG\r]8j]RD\u0001b!\n\u0004\u0018\u0001\u00071qE\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0002B8\u0005\u007f\u001aI\u0003E\u0003w\u0007W!H/C\u0002\u0004.A\u0014a\u0001V;qY\u0016\u0014dABB\u0019\u0001\u0011\u0019\u0019D\u0001\rLk\n,'O\\3uKN$%/\u001b<fe\u0016sG\r]8j]R\u001cBaa\f\u0004\u001e!Y!da\f\u0003\u0002\u0003\u0006IaGB\u001c\u0013\rQ2q\u0004\u0005\f\u0007w\u0019yC!A!\u0002\u0013\u00199#A\bta\u0006\u00148\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u001dA5q\u0006C\u0001\u0007\u007f!ba!\u0011\u0004D\r\u0015\u0003\u0003\u0002BN\u0007_AaAGB\u001f\u0001\u0004Y\u0002\u0002CB\u001e\u0007{\u0001\raa\n\t\u0011\r%3q\u0006C!\u0007\u0017\nab\u001c8ESN\u001cwN\u001c8fGR,G\r\u0006\u0003\u0003\u000e\r5\u0003\u0002CB(\u0007\u000f\u0002\ra!\u0015\u0002\u0015I\u00048-\u00113ee\u0016\u001c8\u000fE\u0002\u001d\u0007'J1a!\u0016\u001e\u0005)\u0011\u0006oY!eIJ,7o]\u0004\b\u00073\u0012\u0001\u0012BB.\u0003\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\r)3Q\f\u0004\u0007\u0003\tAIaa\u0018\u0014\t\ru3\u0011\r\t\u0004m\u000e\r\u0014bAB3a\n1\u0011I\\=SK\u001aDq\u0001SB/\t\u0003\u0019I\u0007\u0006\u0002\u0004\\!Q1QNB/\u0005\u0004%I!!2\u0002#Us5JT(X\u001d~+\u0005,\u0013+`\u0007>#U\tC\u0005\u0004r\ru\u0003\u0015!\u0003\u0002H\u0006\u0011RKT&O\u001f^su,\u0012-J)~\u001bu\nR#!\u0001")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final ExecutorPodFactory org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodFactory;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    private final ScheduledExecutorService allocatorExecutor;
    private final AtomicLong org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$EXECUTOR_ID_COUNTER;
    private final Object org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK;
    @GuardedBy(value="RUNNING_EXECUTOR_PODS_LOCK")
    private final HashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods;
    private final ConcurrentHashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs;
    private final ConcurrentHashMap<String, ExecutorExited> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons;
    private final ConcurrentHashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval;
    private final String kubernetesNamespace;
    private final String kubernetesDriverPodName;
    private final ExecutionContextExecutorService requestExecutorContext;
    private final Pod org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverPod;
    private final double minRegisteredRatio;
    private final AtomicReference<Closeable> executorWatchResource;
    private final AtomicInteger org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$totalExpectedExecutors;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverUrl;
    private final int initialExecutors;
    private final long podAllocationInterval;
    private final int org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podAllocationSize;
    private final int org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorLostReasonCheckMaxAttempts;
    private final Runnable allocatorRunnable;

    public AtomicLong org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$EXECUTOR_ID_COUNTER() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$EXECUTOR_ID_COUNTER;
    }

    public Object org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK;
    }

    public HashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods;
    }

    public ConcurrentHashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs;
    }

    public ConcurrentHashMap<String, ExecutorExited> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons;
    }

    public ConcurrentHashMap<String, Pod> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval;
    }

    private String kubernetesNamespace() {
        return this.kubernetesNamespace;
    }

    private String kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private ExecutionContextExecutorService requestExecutorContext() {
        return this.requestExecutorContext;
    }

    public Pod org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverPod() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverPod;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private AtomicReference<Closeable> executorWatchResource() {
        return this.executorWatchResource;
    }

    public AtomicInteger org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$totalExpectedExecutors() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$totalExpectedExecutors;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverUrl() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverUrl;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private long podAllocationInterval() {
        return this.podAllocationInterval;
    }

    public int org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podAllocationSize() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podAllocationSize;
    }

    public int org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorLostReasonCheckMaxAttempts() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorLostReasonCheckMaxAttempts;
    }

    private Runnable allocatorRunnable() {
        return this.allocatorRunnable;
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public void start() {
        super.start();
        this.executorWatchResource().set((Closeable)((Watchable)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).watch((Object)new ExecutorPodsWatcher()));
        this.allocatorExecutor.scheduleWithFixedDelay(this.allocatorRunnable(), 0L, this.podAllocationInterval(), TimeUnit.MILLISECONDS);
        if (!Utils$.MODULE$.isDynamicAllocationEnabled(this.conf())) {
            this.doRequestTotalExecutors(this.initialExecutors());
        }
    }

    public void stop() {
        this.allocatorExecutor.shutdown();
        this.allocatorExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        super.stop();
        try {
            Closeable resource = this.executorWatchResource().getAndSet(null);
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable throwable) {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to close the executor pod watcher";
                }
            }, throwable);
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$deleteExecutorPodsOnStop();
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs().clear();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Closing kubernetes client";
                    }
                });
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$getNodesWithLocalTaskCounts() {
        scala.collection.mutable.Map nodeToLocalTaskCount;
        KubernetesClusterSchedulerBackend kubernetesClusterSchedulerBackend = this;
        synchronized (kubernetesClusterSchedulerBackend) {
            scala.collection.mutable.Map map = ((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.hostToLocalTaskCount());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : kubernetesClusterSchedulerBackend
            nodeToLocalTaskCount = map;
        }
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs().values()).asScala()).foreach((Function1)new Serializable(this, nodeToLocalTaskCount){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map nodeToLocalTaskCount$1;

            public final boolean apply(Pod pod) {
                return this.nodeToLocalTaskCount$1.remove((Object)pod.getSpec().getNodeName()).nonEmpty() || this.nodeToLocalTaskCount$1.remove((Object)pod.getStatus().getHostIP()).nonEmpty() || this.nodeToLocalTaskCount$1.remove((Object)InetAddress.getByName(pod.getStatus().getHostIP()).getCanonicalHostName()).nonEmpty();
            }
            {
                this.nodeToLocalTaskCount$1 = nodeToLocalTaskCount$1;
            }
        });
        return nodeToLocalTaskCount.toMap(Predef$.MODULE$.$conforms());
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.apply((Function0)new Serializable(this, requestedTotal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final int requestedTotal$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$totalExpectedExecutors().set(this.requestedTotal$1);
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestedTotal$1 = requestedTotal$1;
            }
        }, (ExecutionContext)this.requestExecutorContext());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.apply((Function0)new Serializable(this, executorIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean apply$mcZ$sp() {
                Object object;
                Object object2 = this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK();
                synchronized (object2) {
                    object = this.executorIds$1.flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$doKillExecutors$1 $outer;

                        public final Iterable<Pod> apply(String executorId) {
                            Option option;
                            block4: {
                                Iterable iterable;
                                block3: {
                                    block2: {
                                        option = this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().remove((Object)executorId);
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        Pod pod = (Pod)some.x();
                                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval().put(executorId, pod);
                                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)pod));
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anonfun$$$outer().logWarning((Function0)new Serializable(this, executorId){
                                        public static final long serialVersionUID = 0L;
                                        private final String executorId$4;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to remove pod for unknown executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4}));
                                        }
                                        {
                                            this.executorId$4 = executorId$4;
                                        }
                                    });
                                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                }
                                return iterable;
                            }
                            throw new MatchError((Object)option);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                Seq podsToDelete = (Seq)object;
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().delete((Object[])podsToDelete.toArray(ClassTag$.MODULE$.apply(Pod.class)));
                return true;
            }

            public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }
        }, (ExecutionContext)this.requestExecutorContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$deleteExecutorPodsOnStop() {
        Seq executorPodsToDelete;
        Object object = this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK();
        synchronized (object) {
            Seq runningExecutorPodsCopy = (Seq)Seq$.MODULE$.apply(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().values().toSeq());
            this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().clear();
            Seq seq = runningExecutorPodsCopy;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : object
            executorPodsToDelete = seq;
        }
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().delete((Object[])executorPodsToDelete.toArray(ClassTag$.MODULE$.apply(Pod.class)));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new KubernetesDriverEndpoint(this, super.rpcEnv(), properties);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv, ExecutorPodFactory executorPodFactory, KubernetesClient kubernetesClient, ScheduledExecutorService allocatorExecutor, ExecutorService requestExecutorsService) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodFactory = executorPodFactory;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.allocatorExecutor = allocatorExecutor;
        super(scheduler, rpcEnv);
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK = new Object();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods = new HashMap();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs = new ConcurrentHashMap();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons = new ConcurrentHashMap();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval = new ConcurrentHashMap();
        this.kubernetesNamespace = (String)this.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (String)((Option)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("Must specify the driver pod name");
            }
        });
        this.requestExecutorContext = ExecutionContext$.MODULE$.fromExecutorService(requestExecutorsService);
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverPod = (Pod)((Gettable)((Nameable)kubernetesClient.pods().inNamespace(this.kubernetesNamespace())).withName(this.kubernetesDriverPodName())).get();
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.executorWatchResource = new AtomicReference();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$totalExpectedExecutors = new AtomicInteger(0);
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$driverUrl = RpcEndpointAddress$.MODULE$.apply(this.conf().get("spark.driver.host"), this.conf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.podAllocationInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podAllocationSize = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorLostReasonCheckMaxAttempts = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS()));
        this.allocatorRunnable = new Runnable(this){
            private final HashMap<String, Object> executorReasonCheckAttemptCounts;
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;

            private HashMap<String, Object> executorReasonCheckAttemptCounts() {
                return this.executorReasonCheckAttemptCounts;
            }

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[MONITOR]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public void handleDisconnectedExecutors() {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(Tuple2<String, Pod> x0$2) {
                        Tuple2<String, Pod> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String executorId = (String)tuple2._1();
                            Pod executorPod = (Pod)tuple2._2();
                            Option knownExitReason = Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons().remove(executorPod.getMetadata().getName()));
                            BoxedUnit boxedUnit = (BoxedUnit)knownExitReason.fold((Function0)new Serializable(this, executorId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1$$anonfun$handleDisconnectedExecutors$1 $outer;
                                private final String executorId$3;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().removeExecutorOrIncrementLossReasonCheckCount(this.executorId$3);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executorId$3 = executorId$3;
                                }
                            }, (Function1)new Serializable(this, executorId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1$$anonfun$handleDisconnectedExecutors$1 $outer;
                                public final String executorId$3;

                                public final void apply(ExecutorExited executorExited) {
                                    this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().logWarning((Function0)new Serializable(this, executorExited){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anon$1$$anonfun$handleDisconnectedExecutors$1$$anonfun$apply$5 $outer;
                                        private final ExecutorExited executorExited$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing executor ", " with loss reason "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.executorId$3}))).append((Object)this.executorExited$1.message()).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.executorExited$1 = executorExited$1;
                                        }
                                    });
                                    this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().removeExecutor(this.executorId$3, (ExecutorLossReason)executorExited);
                                    if (executorExited.exitCausedByApp()) {
                                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anon$1$$anonfun$handleDisconnectedExecutors$1$$anonfun$apply$5 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor ", " exited because of the application."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.executorId$3}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().deleteExecutorFromDataStructures(this.executorId$3);
                                    } else {
                                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anon$1$$anonfun$handleDisconnectedExecutors$1$$anonfun$apply$5 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor ", " failed because of a framework error."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.executorId$3}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer().deleteExecutorFromClusterAndDataStructures(this.executorId$3);
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executorId$3 = executorId$3;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anon$1 org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public void removeExecutorOrIncrementLossReasonCheckCount(String executorId) {
                int reasonCheckCount = BoxesRunTime.unboxToInt((Object)this.executorReasonCheckAttemptCounts().getOrElse((Object)executorId, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
                if (reasonCheckCount >= this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorLostReasonCheckMaxAttempts()) {
                    this.$outer.removeExecutor(executorId, (ExecutorLossReason)new SlaveLost("Executor lost for unknown reasons.", SlaveLost$.MODULE$.apply$default$2()));
                    this.deleteExecutorFromClusterAndDataStructures(executorId);
                } else {
                    this.executorReasonCheckAttemptCounts().put((Object)executorId, (Object)BoxesRunTime.boxToInteger((int)(reasonCheckCount + 1)));
                }
            }

            public void deleteExecutorFromClusterAndDataStructures(String executorId) {
                this.deleteExecutorFromDataStructures(executorId).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final Boolean apply(Pod pod) {
                        return (Boolean)this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().delete((Object[])new Pod[]{pod});
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public Option<Pod> deleteExecutorFromDataStructures(String executorId) {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval().remove(executorId);
                this.executorReasonCheckAttemptCounts().$minus$eq((Object)executorId);
                this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons().remove(executorId);
                Object object = this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK();
                synchronized (object) {
                    Option option = this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().remove((Object)executorId).orElse((Function0)new Serializable(this, executorId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;
                        public final String executorId$1;

                        public final None$ apply() {
                            this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer().logWarning((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1$$anonfun$deleteExecutorFromDataStructures$1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to remove pod for unknown executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.executorId$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            return None$.MODULE$;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executorId$1 = executorId$1;
                        }
                    });
                    return option;
                }
            }

            public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorReasonCheckAttemptCounts = new HashMap();
            }
        };
    }

    public class ExecutorPodsWatcher
    implements Watcher<Pod> {
        private final int DEFAULT_CONTAINER_FAILURE_EXIT_STATUS;

        private int DEFAULT_CONTAINER_FAILURE_EXIT_STATUS() {
            return this.DEFAULT_CONTAINER_FAILURE_EXIT_STATUS;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void eventReceived(Watcher.Action action, Pod pod) {
            block9: {
                ExecutorExited executorExited;
                String executorId;
                block8: {
                    String podName;
                    block7: {
                        boolean bl;
                        podName = pod.getMetadata().getName();
                        String podIP = pod.getStatus().getPodIP();
                        Watcher.Action action2 = action;
                        if (Watcher.Action.MODIFIED.equals(action2)) {
                            String string = pod.getStatus().getPhase();
                            String string2 = "Running";
                            if (!(string != null ? !string.equals(string2) : string2 != null) && pod.getMetadata().getDeletionTimestamp() == null) {
                                String clusterNodeName = pod.getSpec().getNodeName();
                                this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logInfo((Function0)new Serializable(this, podName, podIP, clusterNodeName){
                                    public static final long serialVersionUID = 0L;
                                    private final String podName$1;
                                    private final String podIP$1;
                                    private final String clusterNodeName$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor pod ", " ready, launched at ", " as IP ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.podName$1, this.clusterNodeName$1, this.podIP$1}));
                                    }
                                    {
                                        this.podName$1 = podName$1;
                                        this.podIP$1 = podIP$1;
                                        this.clusterNodeName$1 = clusterNodeName$1;
                                    }
                                });
                                this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs().put(podIP, pod);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        if (!(bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2))) {
                            this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logDebug((Function0)new Serializable(this, action, podName){
                                public static final long serialVersionUID = 0L;
                                private final Watcher.Action action$1;
                                private final String podName$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received event of executor pod ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.podName$1}))).append((Object)this.action$1).toString();
                                }
                                {
                                    this.action$1 = action$1;
                                    this.podName$1 = podName$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        executorId = this.getExecutorId(pod);
                        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logDebug((Function0)new Serializable(this, action, podName, podIP){
                            public static final long serialVersionUID = 0L;
                            private final Watcher.Action action$1;
                            private final String podName$1;
                            private final String podIP$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor pod ", " at IP ", " was at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.podName$1, this.podIP$1, this.action$1}));
                            }
                            {
                                this.action$1 = action$1;
                                this.podName$1 = podName$1;
                                this.podIP$1 = podIP$1;
                            }
                        });
                        Object object = podIP == null ? BoxedUnit.UNIT : this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorPodsByIPs().remove(podIP);
                        Watcher.Action action3 = action;
                        Watcher.Action action4 = Watcher.Action.ERROR;
                        if (action3 != null ? !action3.equals(action4) : action4 != null) break block7;
                        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logWarning((Function0)new Serializable(this, pod, podName){
                            public static final long serialVersionUID = 0L;
                            private final Pod pod$1;
                            private final String podName$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received error event of executor pod ", ". Reason: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.podName$1}))).append((Object)this.pod$1.getStatus().getReason()).toString();
                            }
                            {
                                this.pod$1 = pod$1;
                                this.podName$1 = podName$1;
                            }
                        });
                        executorExited = this.executorExitReasonOnError(pod);
                        break block8;
                    }
                    Watcher.Action action5 = action;
                    Watcher.Action action6 = Watcher.Action.DELETED;
                    if (action5 != null ? !action5.equals(action6) : action6 != null) break block9;
                    this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logWarning((Function0)new Serializable(this, pod, podName){
                        public static final long serialVersionUID = 0L;
                        private final Pod pod$1;
                        private final String podName$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received delete event of executor pod ", ". Reason: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.podName$1}))).append((Object)this.pod$1.getStatus().getReason()).toString();
                        }
                        {
                            this.pod$1 = pod$1;
                            this.podName$1 = podName$1;
                        }
                    });
                    executorExited = this.executorExitReasonOnDelete(pod);
                }
                ExecutorExited executorExitReason = executorExited;
                this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podsWithKnownExitReasons().put(pod.getMetadata().getName(), executorExitReason);
                if (!this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval().containsKey(executorId)) {
                    this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor with id ", " was not marked as disconnected, but the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executorId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"watch received an event of type ", " for this executor. The executor may "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action}))).append((Object)"have failed to start in the first place and never registered with the driver.").toString());
                }
                this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval().put(executorId, pod);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown action that should only be DELETED or ERROR: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action})));
        }

        public void onClose(KubernetesClientException cause) {
            this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().logDebug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Executor pod watch closed.";
                }
            }, (Throwable)cause);
        }

        private int getExecutorExitStatus(Pod pod) {
            List containerStatuses = pod.getStatus().getContainerStatuses();
            return containerStatuses.isEmpty() ? this.DEFAULT_CONTAINER_FAILURE_EXIT_STATUS() : this.getExecutorExitStatus((ContainerStatus)containerStatuses.get(0));
        }

        private int getExecutorExitStatus(ContainerStatus containerStatus) {
            return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)containerStatus.getState()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ContainerState containerState) {
                    return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)containerState.getTerminated()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(ContainerStateTerminated containerStateTerminated) {
                            return containerStateTerminated.getExitCode();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return KubernetesClusterSchedulerBackend$.MODULE$.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$UNKNOWN_EXIT_CODE();
                        }
                    }));
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return KubernetesClusterSchedulerBackend$.MODULE$.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$UNKNOWN_EXIT_CODE();
                }
            }));
        }

        private boolean isPodAlreadyReleased(Pod pod) {
            String executorId = (String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL());
            Object object = this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK();
            synchronized (object) {
                Boolean bl = BoxesRunTime.boxToBoolean((!this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().contains((Object)executorId) ? 1 : 0) != 0);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
        }

        private ExecutorExited executorExitReasonOnError(Pod pod) {
            ExecutorExited executorExited;
            int containerExitStatus = this.getExecutorExitStatus(pod);
            if (this.isPodAlreadyReleased(pod)) {
                executorExited = new ExecutorExited(containerExitStatus, false, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container in pod ", " exited from explicit termination "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pod.getMetadata().getName()}))).append((Object)"request.").toString());
            } else {
                String containerExitReason = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pod ", "'s executor container "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pod.getMetadata().getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exited with exit status code ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)containerExitStatus)}))).toString();
                executorExited = new ExecutorExited(containerExitStatus, true, containerExitReason);
            }
            return executorExited;
        }

        private ExecutorExited executorExitReasonOnDelete(Pod pod) {
            String exitMessage = this.isPodAlreadyReleased(pod) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container in pod ", " exited from explicit termination request."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pod.getMetadata().getName()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pod ", " deleted or lost."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pod.getMetadata().getName()}));
            return new ExecutorExited(this.getExecutorExitStatus(pod), false, exitMessage);
        }

        /*
         * WARNING - void declaration
         */
        private String getExecutorId(Pod pod) {
            void var2_2;
            String executorId = (String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL());
            Predef$.MODULE$.require(executorId != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected pod metadata; expected all executor pods ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to have label ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()}))).toString();
                }
            });
            return var2_2;
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$ExecutorPodsWatcher$$$outer() {
            return KubernetesClusterSchedulerBackend.this;
        }

        public ExecutorPodsWatcher() {
            if (KubernetesClusterSchedulerBackend.this == null) {
                throw null;
            }
            this.DEFAULT_CONTAINER_FAILURE_EXIT_STATUS = -1;
        }
    }

    public class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(String executorId) {
                    if (!this.$outer.disableExecutor(executorId)) return;
                    Object object = this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$RUNNING_EXECUTOR_PODS_LOCK();
                    synchronized (object) {
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$runningExecutorsToPods().get((Object)executorId).foreach((Function1)new Serializable(this, executorId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ KubernetesDriverEndpoint$$anonfun$onDisconnected$1 $outer;
                            private final String executorId$5;

                            public final Pod apply(Pod pod) {
                                return this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$disconnectedPodsByExecutorIdPendingRemoval().put(this.executorId$5, pod);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.executorId$5 = executorId$5;
                            }
                        });
                        return;
                    }
                }

                public /* synthetic */ KubernetesDriverEndpoint org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }
}

