/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.util.Collection;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import org.apache.spark.internal.config.ConfigEntry;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0001\u0015A\u0011ADQ1tS\u000e$%/\u001b<fe\u000e{gNZ5hkJ\fG/[8o'R,\u0007O\u0003\u0002\u0004\t\u0005)1\u000f^3qg*\u0011QAB\u0001\u0007gV\u0014W.\u001b;\u000b\u0005\u001dA\u0011aA69g*\u0011\u0011BC\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c2\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001$G\u0007\u0002\u0005%\u0011!D\u0001\u0002\u0018\tJLg/\u001a:D_:4\u0017nZ;sCRLwN\\*uKBD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0010WV\u0014WM\u001d8fi\u0016\u001c\u0018\t\u001d9JI\u000e\u0001\u0001CA\u0010#\u001d\t\u0011\u0002%\u0003\u0002\"'\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\t3\u0003\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u001f\u0003I\u0011Xm]8ve\u000e,g*Y7f!J,g-\u001b=\t\u0011!\u0002!\u0011!Q\u0001\n%\nA\u0002\u001a:jm\u0016\u0014H*\u00192fYN\u0004Ba\b\u0016\u001f=%\u00111\u0006\n\u0002\u0004\u001b\u0006\u0004\b\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001f%l\u0017mZ3Qk2d\u0007k\u001c7jGfD\u0001b\f\u0001\u0003\u0002\u0003\u0006IAH\u0001\bCB\u0004h*Y7f\u0011!\t\u0004A!A!\u0002\u0013q\u0012!C7bS:\u001cE.Y:t\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014aB1qa\u0006\u0013xm\u001d\t\u0004%Ur\u0012B\u0001\u001c\u0014\u0005\u0015\t%O]1z\u0011!A\u0004A!A!\u0002\u0013I\u0014!C:qCJ\\7i\u001c8g!\tQ4(D\u0001\u000b\u0013\ta$BA\u0005Ta\u0006\u00148nQ8oM\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"\u0012\u0002Q!C\u0007\u0012+ei\u0012%\u0011\u0005a\u0001\u0001\"\u0002\u000f>\u0001\u0004q\u0002\"\u0002\u0014>\u0001\u0004q\u0002\"\u0002\u0015>\u0001\u0004I\u0003\"B\u0017>\u0001\u0004q\u0002\"B\u0018>\u0001\u0004q\u0002\"B\u0019>\u0001\u0004q\u0002\"B\u001a>\u0001\u0004!\u0004\"\u0002\u001d>\u0001\u0004I\u0004b\u0002&\u0001\u0005\u0004%IaS\u0001\u000eIJLg/\u001a:Q_\u0012t\u0015-\\3\u0016\u0003yAa!\u0014\u0001!\u0002\u0013q\u0012A\u00043sSZ,'\u000fU8e\u001d\u0006lW\r\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003Q!'/\u001b<fe\u0016CHO]1DY\u0006\u001c8\u000f]1uQV\t\u0011\u000bE\u0002\u0013%zI!aU\n\u0003\r=\u0003H/[8o\u0011\u0019)\u0006\u0001)A\u0005#\u0006)BM]5wKJ,\u0005\u0010\u001e:b\u00072\f7o\u001d9bi\"\u0004\u0003bB,\u0001\u0005\u0004%IaS\u0001\u0015IJLg/\u001a:D_:$\u0018-\u001b8fe&k\u0017mZ3\t\re\u0003\u0001\u0015!\u0003\u001f\u0003U!'/\u001b<fe\u000e{g\u000e^1j]\u0016\u0014\u0018*\\1hK\u0002Bqa\u0017\u0001C\u0002\u0013%1*\u0001\bee&4XM]\"qk\u000e{'/Z:\t\ru\u0003\u0001\u0015!\u0003\u001f\u0003=!'/\u001b<fe\u000e\u0003XoQ8sKN\u0004\u0003bB0\u0001\u0005\u0004%I\u0001U\u0001\u0011IJLg/\u001a:MS6LGoQ8sKNDa!\u0019\u0001!\u0002\u0013\t\u0016!\u00053sSZ,'\u000fT5nSR\u001cuN]3tA!91\r\u0001b\u0001\n\u0013!\u0017a\u00043sSZ,'/T3n_JLX*\u001b\"\u0016\u0003\u0015\u0004\"A\u00054\n\u0005\u001d\u001c\"\u0001\u0002'p]\u001eDa!\u001b\u0001!\u0002\u0013)\u0017\u0001\u00053sSZ,'/T3n_JLX*\u001b\"!\u0011\u001dY\u0007A1A\u0005\n-\u000b!\u0003\u001a:jm\u0016\u0014X*Z7pef\u001cFO]5oO\"1Q\u000e\u0001Q\u0001\ny\t1\u0003\u001a:jm\u0016\u0014X*Z7pef\u001cFO]5oO\u0002Bqa\u001c\u0001C\u0002\u0013%A-A\tnK6|'/_(wKJDW-\u00193NS\nCa!\u001d\u0001!\u0002\u0013)\u0017AE7f[>\u0014\u0018p\u0014<fe\",\u0017\rZ'j\u0005\u0002Bqa\u001d\u0001C\u0002\u0013%A-A\u000eee&4XM]'f[>\u0014\u0018pV5uQ>3XM\u001d5fC\u0012l\u0015N\u0011\u0005\u0007k\u0002\u0001\u000b\u0011B3\u00029\u0011\u0014\u0018N^3s\u001b\u0016lwN]=XSRDwJ^3sQ\u0016\fG-T5CA!)q\u000f\u0001C!q\u0006y1m\u001c8gS\u001e,(/\u001a#sSZ,'\u000f\u0006\u0002z{B\u0011!p_\u0007\u0002\t%\u0011A\u0010\u0002\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001c\u0006/Z2\t\u000by4\b\u0019A=\u0002\u0015\u0011\u0014\u0018N^3s'B,7\r")
public class BasicDriverConfigurationStep
implements DriverConfigurationStep {
    private final String kubernetesAppId;
    public final String org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$resourceNamePrefix;
    private final scala.collection.immutable.Map<String, String> driverLabels;
    private final String imagePullPolicy;
    private final String appName;
    private final String mainClass;
    private final String[] appArgs;
    private final SparkConf sparkConf;
    private final String driverPodName;
    private final Option<String> driverExtraClasspath;
    private final String driverContainerImage;
    private final String driverCpuCores;
    private final Option<String> driverLimitCores;
    private final long org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB;
    private final String driverMemoryString;
    private final long memoryOverheadMiB;
    private final long driverMemoryWithOverheadMiB;

    private String driverPodName() {
        return this.driverPodName;
    }

    private Option<String> driverExtraClasspath() {
        return this.driverExtraClasspath;
    }

    private String driverContainerImage() {
        return this.driverContainerImage;
    }

    private String driverCpuCores() {
        return this.driverCpuCores;
    }

    private Option<String> driverLimitCores() {
        return this.driverLimitCores;
    }

    public long org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB() {
        return this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB;
    }

    private String driverMemoryString() {
        return this.driverMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long driverMemoryWithOverheadMiB() {
        return this.driverMemoryWithOverheadMiB;
    }

    @Override
    public KubernetesDriverSpec configureDriver(KubernetesDriverSpec driverSpec) {
        Option driverExtraClasspathEnv = this.driverExtraClasspath().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(String classPath) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(classPath)).build();
            }
        });
        scala.collection.immutable.Map<String, String> driverCustomAnnotations = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(this.sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX());
        Predef$.MODULE$.require(!driverCustomAnnotations.contains((Object)Constants$.MODULE$.SPARK_APP_NAME_ANNOTATION()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Annotation with key ", " is not allowed as it is reserved for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SPARK_APP_NAME_ANNOTATION()}))).append((Object)" Spark bookkeeping operations.").toString();
            }
        });
        Seq driverCustomEnvs = (Seq)Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAllWithPrefix(Config$.MODULE$.KUBERNETES_DRIVER_ENV_KEY())).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(Tuple2<String, String> env) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build();
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map driverAnnotations = driverCustomAnnotations.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_ANNOTATION()), (Object)this.appName)})));
        scala.collection.immutable.Map<String, String> nodeSelector = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(this.sparkConf, Config$.MODULE$.KUBERNETES_NODE_SELECTOR_PREFIX());
        Quantity driverCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.driverCpuCores())).build();
        Quantity driverMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Mi"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB())})))).build();
        Quantity driverMemoryLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Mi"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.driverMemoryWithOverheadMiB())})))).build();
        Option maybeCpuLimitQuantity = this.driverLimitCores().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Quantity> apply(String limitCores) {
                return new Tuple2((Object)"cpu", (Object)((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build());
            }
        });
        Container driverContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(driverSpec.driverContainer()).withName(Constants$.MODULE$.DRIVER_CONTAINER_NAME())).withImage(this.driverContainerImage())).withImagePullPolicy(this.imagePullPolicy)).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverCustomEnvs).asJava())).addToEnv((EnvVar[])Option$.MODULE$.option2Iterable(driverExtraClasspathEnv).toSeq().toArray(ClassTag$.MODULE$.apply(EnvVar.class)))).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_MEMORY()).withValue(this.driverMemoryString())).endEnv()).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_MAIN_CLASS()).withValue(this.mainClass)).endEnv()).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_ARGS()).withValue(Predef$.MODULE$.refArrayOps((Object[])this.appArgs).mkString(" "))).endEnv()).addNewEnv().withName(Constants$.MODULE$.ENV_DRIVER_BIND_ADDRESS()).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).withNewResources().addToRequests("cpu", driverCpuQuantity).addToRequests("memory", driverMemoryQuantity).addToLimits("memory", driverMemoryLimitQuantity).addToLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Option$.MODULE$.option2Iterable(maybeCpuLimitQuantity).toMap(Predef$.MODULE$.$conforms())).asJava())).endResources()).addToArgs(new String[]{"driver"})).build();
        Pod baseDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(driverSpec.driverPod()).editOrNewMetadata().withName(this.driverPodName()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.driverLabels).asJava()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)driverAnnotations).asJava())).endMetadata()).withNewSpec().withRestartPolicy("Never").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(nodeSelector).asJava())).endSpec()).build();
        SparkConf resolvedSparkConf = driverSpec.driverSparkConf().clone().setIfMissing(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set("spark.app.id", this.kubernetesAppId).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$resourceNamePrefix);
        Pod x$1 = baseDriverPod;
        SparkConf x$2 = resolvedSparkConf;
        Container x$3 = driverContainer;
        Seq<HasMetadata> x$4 = driverSpec.copy$default$3();
        return driverSpec.copy(x$1, x$3, x$4, x$2);
    }

    public BasicDriverConfigurationStep(String kubernetesAppId, String resourceNamePrefix, scala.collection.immutable.Map<String, String> driverLabels, String imagePullPolicy, String appName, String mainClass, String[] appArgs, SparkConf sparkConf) {
        this.kubernetesAppId = kubernetesAppId;
        this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$resourceNamePrefix = resourceNamePrefix;
        this.driverLabels = driverLabels;
        this.imagePullPolicy = imagePullPolicy;
        this.appName = appName;
        this.mainClass = mainClass;
        this.appArgs = appArgs;
        this.sparkConf = sparkConf;
        this.driverPodName = (String)((Option)sparkConf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicDriverConfigurationStep $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$resourceNamePrefix}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.driverExtraClasspath = (Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CLASS_PATH());
        this.driverContainerImage = (String)((Option)sparkConf.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("Must specify the driver container image");
            }
        });
        this.driverCpuCores = (String)sparkConf.getOption("spark.driver.cores").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "1";
            }
        });
        this.driverLimitCores = (Option)sparkConf.get(Config$.MODULE$.KUBERNETES_DRIVER_LIMIT_CORES());
        this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB = BoxesRunTime.unboxToLong((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY()));
        this.driverMemoryString = sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY_OVERHEAD())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicDriverConfigurationStep $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return package$.MODULE$.max((long)((int)(Constants$.MODULE$.MEMORY_OVERHEAD_FACTOR() * (double)this.$outer.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.driverMemoryWithOverheadMiB = this.org$apache$spark$deploy$k8s$submit$steps$BasicDriverConfigurationStep$$driverMemoryMiB() + this.memoryOverheadMiB();
    }
}

