/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class PageRank$
implements Logging {
    public static final PageRank$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PageRank$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public <VD, ED> Graph<Object, Object> run(Graph<VD, ED> graph, int numIter, double resetProb, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        return this.runWithOptions(graph, numIter, resetProb, this.runWithOptions$default$4(), evidence$1, evidence$2);
    }

    public <VD, ED> double run$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runWithOptions(Graph<VD, ED> graph, int numIter, double resetProb, Option<Object> srcId, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        Predef$.MODULE$.require(numIter > 0, (Function0)new Serializable(numIter){
            public static final long serialVersionUID = 0L;
            private final int numIter$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of iterations must be greater than 0,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIter$2)}))).toString();
            }
            {
                this.numIter$2 = numIter$2;
            }
        });
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0)new Serializable(resetProb){
            public static final long serialVersionUID = 0L;
            private final double resetProb$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Random reset probability must belong"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to [0, 1], but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.resetProb$3)}))).toString();
            }
            {
                this.resetProb$3 = resetProb$3;
            }
        });
        boolean personalized = srcId.isDefined();
        long src = BoxesRunTime.unboxToLong((Object)srcId.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        VertexRDD<Object> x$7 = Graph$.MODULE$.graphToGraphOps(graph, evidence$3, evidence$4).outDegrees();
        Serializable x$8 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(long vid, VD vdata, Option<Object> deg) {
                return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
        };
        ClassTag x$9 = ClassTag$.MODULE$.Int();
        ClassTag x$10 = ClassTag$.MODULE$.Int();
        graph.outerJoinVertices$default$5(x$7, x$8);
        Object x$11 = null;
        Graph qual$1 = graph.outerJoinVertices(x$7, x$8, x$9, x$10, null).mapTriplets(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<Object, ED> e) {
                return 1.0 / (double)BoxesRunTime.unboxToInt((Object)e.srcAttr());
            }
        }, TripletFields.Src, ClassTag$.MODULE$.Double());
        Serializable x$12 = new Serializable(personalized, src){
            public static final long serialVersionUID = 0L;
            private final boolean personalized$1;
            private final long src$1;

            public final double apply(long id, int attr) {
                return this.apply$mcDJI$sp(id, attr);
            }

            public double apply$mcDJI$sp(long id, int attr) {
                return id != this.src$1 && this.personalized$1 ? 0.0 : 1.0;
            }
            {
                this.personalized$1 = personalized$1;
                this.src$1 = src$1;
            }
        };
        ClassTag x$13 = ClassTag$.MODULE$.Double();
        qual$1.mapVertices$default$3(x$12);
        Object x$14 = null;
        Graph<Object, Object> rankGraph = qual$1.mapVertices(x$12, x$13, null);
        IntRef iteration = IntRef.create((int)0);
        Graph<Object, Object> prevRankGraph = null;
        while (iteration.elem < numIter) {
            rankGraph.cache();
            VertexRDD rankUpdates = rankGraph.aggregateMessages(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<Object, Object, Object> ctx) {
                    ctx.sendToDst(BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)ctx.srcAttr()) * BoxesRunTime.unboxToDouble((Object)ctx.attr()))));
                }
            }, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$1, double x$2) {
                    return this.apply$mcDDD$sp(x$1, x$2);
                }

                public double apply$mcDDD$sp(double x$1, double x$2) {
                    return x$1 + x$2;
                }
            }, TripletFields.Src, ClassTag$.MODULE$.Double());
            prevRankGraph = rankGraph;
            Object rPrb = personalized ? new Serializable(resetProb){
                public static final long serialVersionUID = 0L;
                private final double resetProb$3;

                public final double apply(long src, long id) {
                    return this.apply$mcDJJ$sp(src, id);
                }

                public double apply$mcDJJ$sp(long src, long id) {
                    return this.resetProb$3 * PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$delta$1(src, id);
                }
                {
                    this.resetProb$3 = resetProb$3;
                }
            } : new Serializable(resetProb){
                public static final long serialVersionUID = 0L;
                private final double resetProb$3;

                public final double apply(long src, long id) {
                    return this.apply$mcDJJ$sp(src, id);
                }

                public double apply$mcDJJ$sp(long src, long id) {
                    return this.resetProb$3;
                }
                {
                    this.resetProb$3 = resetProb$3;
                }
            };
            rankGraph = rankGraph.outerJoinVertices(rankUpdates, new Serializable(resetProb, src, (Function2)rPrb){
                public static final long serialVersionUID = 0L;
                private final double resetProb$3;
                private final long src$1;
                private final Function2 rPrb$1;

                public final double apply(long id, double oldRank, Option<Object> msgSumOpt) {
                    return this.rPrb$1.apply$mcDJJ$sp(this.src$1, id) + (1.0 - this.resetProb$3) * BoxesRunTime.unboxToDouble((Object)msgSumOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }));
                }
                {
                    this.resetProb$3 = resetProb$3;
                    this.src$1 = src$1;
                    this.rPrb$1 = rPrb$1;
                }
            }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            rankGraph.edges().foreachPartition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Edge<Object>> x) {
                }
            });
            this.logInfo((Function0<String>)new Serializable(iteration){
                public static final long serialVersionUID = 0L;
                private final IntRef iteration$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PageRank finished iteration ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                }
                {
                    this.iteration$1 = iteration$1;
                }
            });
            prevRankGraph.vertices().unpersist(false);
            prevRankGraph.edges().unpersist(false);
            ++iteration.elem;
        }
        return this.normalizeRankSum(rankGraph, personalized);
    }

    public <VD, ED> double runWithOptions$default$3() {
        return 0.15;
    }

    public <VD, ED> Option<Object> runWithOptions$default$4() {
        return None$.MODULE$;
    }

    public <VD, ED> Graph<org.apache.spark.ml.linalg.Vector, Object> runParallelPersonalizedPageRank(Graph<VD, ED> graph, int numIter, double resetProb, long[] sources, ClassTag<VD> evidence$5, ClassTag<ED> evidence$6) {
        Predef$.MODULE$.require(numIter > 0, (Function0)new Serializable(numIter){
            public static final long serialVersionUID = 0L;
            private final int numIter$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of iterations must be greater than 0,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIter$1)}))).toString();
            }
            {
                this.numIter$1 = numIter$1;
            }
        });
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0)new Serializable(resetProb){
            public static final long serialVersionUID = 0L;
            private final double resetProb$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Random reset probability must belong"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to [0, 1], but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.resetProb$2)}))).toString();
            }
            {
                this.resetProb$2 = resetProb$2;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.longArrayOps(sources).nonEmpty(), (Function0)new Serializable(sources){
            public static final long serialVersionUID = 0L;
            private final long[] sources$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The list of sources must be non-empty,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.longArrayOps(this.sources$1).mkString("[", ",", "]")}))).toString();
            }
            {
                this.sources$1 = sources$1;
            }
        });
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(sources).max((Ordering)Ordering.Long$.MODULE$)) <= (long)Integer.MAX_VALUE, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This implementation currently only works for source vertex ids at most ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)}));
            }
        });
        Vector zero = Vectors$.MODULE$.sparse(Predef$.MODULE$.longArrayOps(sources).size(), (Seq)Nil$.MODULE$).asBreeze();
        Map sourcesInitMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps(sources).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(sources){
            public static final long serialVersionUID = 0L;
            private final long[] sources$1;

            public final Tuple2<Object, Vector<Object>> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long vid = tuple2._1$mcJ$sp();
                    int i = tuple2._2$mcI$sp();
                    Vector v = Vectors$.MODULE$.sparse(Predef$.MODULE$.longArrayOps(this.sources$1).size(), new int[]{i}, new double[]{1.0}).asBreeze();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)vid), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sources$1 = sources$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        SparkContext sc = graph.vertices().sparkContext();
        Broadcast sourcesInitMapBC = sc.broadcast((Object)sourcesInitMap, ClassTag$.MODULE$.apply(Map.class));
        VertexRDD<Object> x$15 = Graph$.MODULE$.graphToGraphOps(graph, evidence$5, evidence$6).outDegrees();
        Serializable x$16 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(long vid, VD vdata, Option<Object> deg) {
                return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
        };
        ClassTag x$17 = ClassTag$.MODULE$.Int();
        ClassTag x$18 = ClassTag$.MODULE$.Int();
        graph.outerJoinVertices$default$5(x$15, x$16);
        Object x$19 = null;
        Graph qual$2 = graph.outerJoinVertices(x$15, x$16, x$17, x$18, null).mapTriplets(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<Object, ED> e) {
                return 1.0 / (double)BoxesRunTime.unboxToInt((Object)e.srcAttr());
            }
        }, TripletFields.Src, ClassTag$.MODULE$.Double());
        Serializable x$20 = new Serializable(zero, sourcesInitMapBC){
            public static final long serialVersionUID = 0L;
            private final Vector zero$1;
            private final Broadcast sourcesInitMapBC$1;

            public final Vector<Object> apply(long vid, int attr) {
                return ((MapLike)this.sourcesInitMapBC$1.value()).contains((Object)BoxesRunTime.boxToLong((long)vid)) ? (Vector)((MapLike)this.sourcesInitMapBC$1.value()).apply((Object)BoxesRunTime.boxToLong((long)vid)) : this.zero$1;
            }
            {
                this.zero$1 = zero$1;
                this.sourcesInitMapBC$1 = sourcesInitMapBC$1;
            }
        };
        ClassTag x$21 = ClassTag$.MODULE$.apply(Vector.class);
        qual$2.mapVertices$default$3(x$20);
        Object x$22 = null;
        Graph rankGraph = qual$2.mapVertices(x$20, x$21, null);
        IntRef i = IntRef.create((int)0);
        while (i.elem < numIter) {
            Graph prevRankGraph = rankGraph;
            VertexRDD rankUpdates = rankGraph.aggregateMessages(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<Vector<Object>, Object, Vector<Object>> ctx) {
                    ctx.sendToDst((Vector<Object>)((ImmutableNumericOps)ctx.srcAttr()).$times$colon$times(ctx.attr(), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulScalar()));
                }
            }, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector<Object> apply(Vector<Object> a, Vector<Object> b) {
                    return (Vector)a.$plus$colon$plus(b, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
                }
            }, TripletFields.Src, ClassTag$.MODULE$.apply(Vector.class));
            rankGraph = rankGraph.outerJoinVertices(rankUpdates, new Serializable(resetProb, zero, sourcesInitMapBC){
                public static final long serialVersionUID = 0L;
                private final double resetProb$2;
                public final Vector zero$1;
                private final Broadcast sourcesInitMapBC$1;

                public final Vector<Object> apply(long vid, Vector<Object> oldRank, Option<Vector<Object>> msgSumOpt) {
                    Vector popActivations = (Vector)((ImmutableNumericOps)msgSumOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.runParallelPersonalizedPageRank.5 $outer;

                        public final Vector<Object> apply() {
                            return this.$outer.zero$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).$times$colon$times((Object)BoxesRunTime.boxToDouble((double)(1.0 - this.resetProb$2)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulScalar());
                    Vector resetActivations = ((MapLike)this.sourcesInitMapBC$1.value()).contains((Object)BoxesRunTime.boxToLong((long)vid)) ? (Vector)((ImmutableNumericOps)((MapLike)this.sourcesInitMapBC$1.value()).apply((Object)BoxesRunTime.boxToLong((long)vid))).$times$colon$times((Object)BoxesRunTime.boxToDouble((double)this.resetProb$2), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulScalar()) : this.zero$1;
                    return (Vector)popActivations.$plus$colon$plus((Object)resetActivations, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
                }
                {
                    this.resetProb$2 = resetProb$2;
                    this.zero$1 = zero$1;
                    this.sourcesInitMapBC$1 = sourcesInitMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(Vector.class), ClassTag$.MODULE$.apply(Vector.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            rankGraph.edges().foreachPartition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Edge<Object>> x) {
                }
            });
            prevRankGraph.vertices().unpersist(false);
            prevRankGraph.edges().unpersist(false);
            this.logInfo((Function0<String>)new Serializable(i){
                public static final long serialVersionUID = 0L;
                private final IntRef i$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parallel Personalized PageRank finished iteration ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1.elem)}));
                }
                {
                    this.i$1 = i$1;
                }
            });
            ++i.elem;
        }
        Vector rankSums = (Vector)RDD$.MODULE$.rddToPairRDDFunctions(rankGraph.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)zero, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector<Object> apply(Vector<Object> x$3, Vector<Object> x$4) {
                return (Vector)x$3.$plus$colon$plus(x$4, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
            }
        });
        Graph qual$3 = rankGraph;
        Serializable x$23 = new Serializable(rankSums){
            public static final long serialVersionUID = 0L;
            private final Vector rankSums$1;

            public final org.apache.spark.ml.linalg.Vector apply(long vid, Vector<Object> attr) {
                return Vectors$.MODULE$.fromBreeze((Vector)attr.$div$colon$div((Object)this.rankSums$1, (UFunc.UImpl2)Vector$.MODULE$.v_v_Op_Double_OpDiv()));
            }
            {
                this.rankSums$1 = rankSums$1;
            }
        };
        ClassTag x$24 = ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class);
        qual$3.mapVertices$default$3(x$23);
        Object x$25 = null;
        return qual$3.mapVertices(x$23, x$24, null);
    }

    public <VD, ED> double runParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runUntilConvergence(Graph<VD, ED> graph, double tol, double resetProb, ClassTag<VD> evidence$7, ClassTag<ED> evidence$8) {
        return this.runUntilConvergenceWithOptions(graph, tol, resetProb, this.runUntilConvergenceWithOptions$default$4(), evidence$7, evidence$8);
    }

    public <VD, ED> double runUntilConvergence$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runUntilConvergenceWithOptions(Graph<VD, ED> graph, double tol, double resetProb, Option<Object> srcId, ClassTag<VD> evidence$9, ClassTag<ED> evidence$10) {
        Predef$.MODULE$.require(tol >= 0.0, (Function0)new Serializable(tol){
            public static final long serialVersionUID = 0L;
            private final double tol$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tolerance must be no less than 0, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.tol$1)}));
            }
            {
                this.tol$1 = tol$1;
            }
        });
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0)new Serializable(resetProb){
            public static final long serialVersionUID = 0L;
            private final double resetProb$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Random reset probability must belong"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to [0, 1], but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.resetProb$1)}))).toString();
            }
            {
                this.resetProb$1 = resetProb$1;
            }
        });
        boolean personalized = srcId.isDefined();
        long src = BoxesRunTime.unboxToLong((Object)srcId.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        VertexRDD<Object> x$26 = Graph$.MODULE$.graphToGraphOps(graph, evidence$9, evidence$10).outDegrees();
        Serializable x$27 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(long vid, VD vdata, Option<Object> deg) {
                return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
        };
        ClassTag x$28 = ClassTag$.MODULE$.Int();
        ClassTag x$29 = ClassTag$.MODULE$.Int();
        graph.outerJoinVertices$default$5(x$26, x$27);
        Object x$30 = null;
        Graph qual$4 = graph.outerJoinVertices(x$26, x$27, x$28, x$29, null).mapTriplets(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<Object, ED> e) {
                return 1.0 / (double)BoxesRunTime.unboxToInt((Object)e.srcAttr());
            }
        }, ClassTag$.MODULE$.Double());
        Serializable x$31 = new Serializable(src){
            public static final long serialVersionUID = 0L;
            private final long src$2;

            public final Tuple2<Object, Object> apply(long id, int attr) {
                return id == this.src$2 ? new Tuple2.mcDD.sp(0.0, Double.NEGATIVE_INFINITY) : new Tuple2.mcDD.sp(0.0, 0.0);
            }
            {
                this.src$2 = src$2;
            }
        };
        ClassTag x$32 = ClassTag$.MODULE$.apply(Tuple2.class);
        qual$4.mapVertices$default$3(x$31);
        Object x$33 = null;
        Graph pagerankGraph = qual$4.mapVertices(x$31, x$32, null).cache();
        double initialMessage = personalized ? 0.0 : resetProb / (1.0 - resetProb);
        Object vp = personalized ? new Serializable(resetProb){
            public static final long serialVersionUID = 0L;
            private final double resetProb$1;

            public final Tuple2<Object, Object> apply(long id, Tuple2<Object, Object> attr, double msgSum) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$personalizedVertexProgram$1(id, attr, msgSum, this.resetProb$1);
            }
            {
                this.resetProb$1 = resetProb$1;
            }
        } : new Serializable(resetProb){
            public static final long serialVersionUID = 0L;
            private final double resetProb$1;

            public final Tuple2<Object, Object> apply(long id, Tuple2<Object, Object> attr, double msgSum) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$vertexProgram$1(id, attr, msgSum, this.resetProb$1);
            }
            {
                this.resetProb$1 = resetProb$1;
            }
        };
        Graph x$34 = pagerankGraph;
        double x$35 = initialMessage;
        EdgeDirection x$36 = EdgeDirection$.MODULE$.Out();
        int x$37 = Pregel$.MODULE$.apply$default$3();
        Object x$38 = vp;
        Serializable x$39 = new Serializable(tol){
            public static final long serialVersionUID = 0L;
            private final double tol$1;

            public final Iterator<Tuple2<Object, Object>> apply(EdgeTriplet<Tuple2<Object, Object>, Object> edge) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$sendMessage$1(edge, this.tol$1);
            }
            {
                this.tol$1 = tol$1;
            }
        };
        Serializable x$40 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double a, double b) {
                return this.apply$mcDDD$sp(a, b);
            }

            public double apply$mcDDD$sp(double a, double b) {
                return PageRank$.MODULE$.org$apache$spark$graphx$lib$PageRank$$messageCombiner$1(a, b);
            }
        };
        Graph qual$5 = Pregel$.MODULE$.apply(x$34, BoxesRunTime.boxToDouble((double)x$35), x$37, x$36, x$38, x$39, x$40, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
        Serializable x$41 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(long vid, Tuple2<Object, Object> attr) {
                return attr._1$mcD$sp();
            }
        };
        ClassTag x$42 = ClassTag$.MODULE$.Double();
        qual$5.mapVertices$default$3(x$41);
        Object x$43 = null;
        Graph<Object, Object> rankGraph = qual$5.mapVertices(x$41, x$42, null);
        return this.normalizeRankSum(rankGraph, personalized);
    }

    public <VD, ED> double runUntilConvergenceWithOptions$default$3() {
        return 0.15;
    }

    public <VD, ED> Option<Object> runUntilConvergenceWithOptions$default$4() {
        return None$.MODULE$;
    }

    private Graph<Object, Object> normalizeRankSum(Graph<Object, Object> rankGraph, boolean personalized) {
        Graph<Object, Object> graph;
        double rankSum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rankGraph.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
        if (personalized) {
            graph = rankGraph.mapVertices(new Serializable(rankSum){
                public static final long serialVersionUID = 0L;
                private final double rankSum$1;

                public final double apply(long id, double rank) {
                    return this.apply$mcDJD$sp(id, rank);
                }

                public double apply$mcDJD$sp(long id, double rank) {
                    return rank / this.rankSum$1;
                }
                {
                    this.rankSum$1 = rankSum$1;
                }
            }, ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        } else {
            long numVertices = Graph$.MODULE$.graphToGraphOps(rankGraph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).numVertices();
            double correctionFactor = (double)numVertices / rankSum;
            graph = rankGraph.mapVertices(new Serializable(correctionFactor){
                public static final long serialVersionUID = 0L;
                private final double correctionFactor$1;

                public final double apply(long id, double rank) {
                    return this.apply$mcDJD$sp(id, rank);
                }

                public double apply$mcDJD$sp(long id, double rank) {
                    return rank * this.correctionFactor$1;
                }
                {
                    this.correctionFactor$1 = correctionFactor$1;
                }
            }, ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        }
        return graph;
    }

    public final double org$apache$spark$graphx$lib$PageRank$$delta$1(long u, long v) {
        return u == v ? 1.0 : 0.0;
    }

    public final Tuple2 org$apache$spark$graphx$lib$PageRank$$vertexProgram$1(long id, Tuple2 attr, double msgSum, double resetProb$1) {
        Tuple2 tuple2 = attr;
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double oldPR = tuple2._1$mcD$sp();
            double lastDelta = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(oldPR, lastDelta);
            double oldPR2 = sp3._1$mcD$sp();
            double lastDelta2 = sp3._2$mcD$sp();
            double newPR = oldPR2 + (1.0 - resetProb$1) * msgSum;
            return new Tuple2.mcDD.sp(newPR, newPR - oldPR2);
        }
        throw new MatchError((Object)tuple2);
    }

    public final Tuple2 org$apache$spark$graphx$lib$PageRank$$personalizedVertexProgram$1(long id, Tuple2 attr, double msgSum, double resetProb$1) {
        Tuple2 tuple2 = attr;
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double oldPR = tuple2._1$mcD$sp();
            double lastDelta = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(oldPR, lastDelta);
            double oldPR2 = sp3._1$mcD$sp();
            double lastDelta2 = sp3._2$mcD$sp();
            double newPR = lastDelta2 == Double.NEGATIVE_INFINITY ? 1.0 : oldPR2 + (1.0 - resetProb$1) * msgSum;
            return new Tuple2.mcDD.sp(newPR, newPR - oldPR2);
        }
        throw new MatchError((Object)tuple2);
    }

    public final Iterator org$apache$spark$graphx$lib$PageRank$$sendMessage$1(EdgeTriplet edge, double tol$1) {
        return ((Tuple2)edge.srcAttr())._2$mcD$sp() > tol$1 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(edge.dstId(), ((Tuple2)edge.srcAttr())._2$mcD$sp() * edge.attr$mcD$sp())})) : package$.MODULE$.Iterator().empty();
    }

    public final double org$apache$spark$graphx$lib$PageRank$$messageCombiner$1(double a, double b) {
        return a + b;
    }

    private PageRank$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

