/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.ql.exec.vector;

import org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class UnionColumnVector
extends ColumnVector {
    public int[] tags;
    public ColumnVector[] fields;

    public UnionColumnVector() {
        this(1024, new ColumnVector[0]);
    }

    public UnionColumnVector(int len, ColumnVector ... fields) {
        super(len);
        this.tags = new int[len];
        this.fields = fields;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].flatten(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            UnionColumnVector input = (UnionColumnVector)inputVector;
            this.tags[outElementNum] = input.tags[inputElementNum];
            this.fields[this.tags[outElementNum]].setElement(outElementNum, inputElementNum, input.fields[this.tags[outElementNum]]);
        } else {
            this.noNulls = false;
            this.isNull[outElementNum] = true;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append("{\"tag\": ");
            buffer.append(this.tags[row]);
            buffer.append(", \"value\": ");
            this.fields[this.tags[row]].stringifyValue(buffer, row);
            buffer.append('}');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (this.tags.length < size) {
            if (preserveData) {
                int[] oldTags = this.tags;
                this.tags = new int[size];
                System.arraycopy(oldTags, 0, this.tags, 0, oldTags.length);
            } else {
                this.tags = new int[size];
            }
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].ensureSize(size, preserveData);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].reset();
        }
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].init();
        }
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].unFlatten();
        }
    }

    @Override
    public void setRepeating(boolean isRepeating) {
        super.setRepeating(isRepeating);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setRepeating(isRepeating);
        }
    }
}

