/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class InMemoryFileIndex$
implements Logging {
    public static final InMemoryFileIndex$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new InMemoryFileIndex$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<Path, Seq<FileStatus>>> org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$bulkListLeafFiles(Seq<Path> paths, Configuration hadoopConf, PathFilter filter, SparkSession sparkSession) {
        Tuple2[] tuple2Array;
        if (paths.size() <= sparkSession.sessionState().conf().parallelPartitionDiscoveryThreshold()) {
            return (Seq)paths.map((Function1)new Serializable(hadoopConf, filter, sparkSession){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;
                private final PathFilter filter$1;
                private final SparkSession sparkSession$1;

                public final Tuple2<Path, Seq<FileStatus>> apply(Path path) {
                    return new Tuple2((Object)path, InMemoryFileIndex$.MODULE$.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$listLeafFiles(path, this.hadoopConf$1, this.filter$1, (Option<SparkSession>)new Some((Object)this.sparkSession$1)));
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                    this.filter$1 = filter$1;
                    this.sparkSession$1 = sparkSession$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            private final Seq paths$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories in parallel under: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.paths$1.mkString(", ")}));
            }
            {
                this.paths$1 = paths$1;
            }
        });
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SparkContext sparkContext = sparkSession.sparkContext();
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$3) {
                return x$3.toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        int parallelPartitionDiscoveryParallelism = sparkSession.sessionState().conf().parallelPartitionDiscoveryParallelism();
        int numParallelism = Math.min(paths.size(), parallelPartitionDiscoveryParallelism);
        String previousJobDescription = sparkContext.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                default: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories for ", " paths:<br/>", ", ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), paths.apply(0)}));
                    break;
                }
                case 1: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories for 1 path:<br/>", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths.apply(0)}));
                    break;
                }
                case 0: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories 0 paths"})).s((Seq)Nil$.MODULE$);
                }
            }
            String description = string;
            sparkContext.setJobDescription(description);
            RDD qual$1 = sparkContext.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Serializable x$9 = new Serializable(filter, serializableConfiguration){
                public static final long serialVersionUID = 0L;
                public final PathFilter filter$1;
                private final SerializableConfiguration serializableConfiguration$1;

                public final Iterator<Tuple2<Path, Seq<FileStatus>>> apply(Iterator<String> pathStrings) {
                    Configuration hadoopConf = this.serializableConfiguration$1.value();
                    return ((IterableLike)pathStrings.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x$4) {
                            return new Path(x$4);
                        }
                    }).toSeq().map((Function1)new Serializable(this, hadoopConf){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final Configuration hadoopConf$3;

                        public final Tuple2<Path, Seq<FileStatus>> apply(Path path) {
                            return new Tuple2((Object)path, InMemoryFileIndex$.MODULE$.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$listLeafFiles(path, this.hadoopConf$3, this.$outer.filter$1, (Option<SparkSession>)None$.MODULE$));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.hadoopConf$3 = hadoopConf$3;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.filter$1 = filter$1;
                    this.serializableConfiguration$1 = serializableConfiguration$1;
                }
            };
            boolean x$10 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions((Function1)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<InMemoryFileIndex.SerializableFileStatus>> apply(Tuple2<Path, Seq<FileStatus>> x0$2) {
                    Tuple2<Path, Seq<FileStatus>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Path path = (Path)tuple2._1();
                        Seq statuses = (Seq)tuple2._2();
                        Seq serializableStatuses = (Seq)statuses.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final InMemoryFileIndex.SerializableFileStatus apply(FileStatus status) {
                                InMemoryFileIndex.SerializableBlockLocation[] serializableBlockLocationArray;
                                FileStatus fileStatus = status;
                                if (fileStatus instanceof LocatedFileStatus) {
                                    LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                                    serializableBlockLocationArray = (InMemoryFileIndex.SerializableBlockLocation[])Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final InMemoryFileIndex.SerializableBlockLocation apply(BlockLocation loc) {
                                            return new InMemoryFileIndex.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InMemoryFileIndex.SerializableBlockLocation.class)));
                                } else {
                                    serializableBlockLocationArray = (InMemoryFileIndex.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InMemoryFileIndex.SerializableBlockLocation.class));
                                }
                                InMemoryFileIndex.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                                return new InMemoryFileIndex.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Tuple2 tuple22 = new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        catch (Throwable throwable) {
            void var10_10;
            void var5_5;
            var5_5.setJobDescription((String)var10_10);
            throw throwable;
        }
        sparkContext.setJobDescription(previousJobDescription);
        Tuple2[] statusMap = tuple2Array;
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])statusMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, Seq<LocatedFileStatus>> apply(Tuple2<String, Seq<InMemoryFileIndex.SerializableFileStatus>> x0$3) {
                Tuple2<String, Seq<InMemoryFileIndex.SerializableFileStatus>> tuple2 = x0$3;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    Seq serializableStatuses = (Seq)tuple2._2();
                    Seq statuses = (Seq)serializableStatuses.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final LocatedFileStatus apply(InMemoryFileIndex.SerializableFileStatus f) {
                            BlockLocation[] blockLocations = (BlockLocation[])Predef$.MODULE$.refArrayOps((Object[])f.blockLocations()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final BlockLocation apply(InMemoryFileIndex.SerializableBlockLocation loc) {
                                    return new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                            return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Tuple2 tuple22 = new Tuple2((Object)new Path(path), (Object)statuses);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<FileStatus> org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkSession> sessionOpt) {
        FileStatus[] fileStatusArray;
        this.logTrace((Function0<String>)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        FileSystem fs = path.getFileSystem(hadoopConf);
        try {
            fileStatusArray = fs.listStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logWarning((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The directory ", " was not found. Was it deleted very recently?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            });
            fileStatusArray = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
        }
        FileStatus[] statuses = fileStatusArray;
        FileStatus[] filteredStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])statuses).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus status) {
                return InMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName());
            }
        });
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])filteredStatuses).partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$5) {
                return x$5.isDirectory();
            }
        });
        if (tuple2 != null) {
            Seq seq;
            Tuple2 tuple22;
            FileStatus[] dirs = (FileStatus[])tuple2._1();
            FileStatus[] topLevelFiles = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)dirs, (Object)topLevelFiles);
            FileStatus[] dirs2 = (FileStatus[])tuple23._1();
            FileStatus[] topLevelFiles2 = (FileStatus[])tuple23._2();
            Option<SparkSession> option = sessionOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession session = (SparkSession)some.x();
                seq = (Seq)this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$bulkListLeafFiles((Seq<Path>)((Seq)Predef$.MODULE$.refArrayOps((Object[])dirs2).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$7) {
                        return x$7.getPath();
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), hadoopConf, filter, session).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<FileStatus> apply(Tuple2<Path, Seq<FileStatus>> x$8) {
                        return (Seq)x$8._2();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])dirs2).flatMap((Function1)new Serializable(hadoopConf, filter, sessionOpt){
                    public static final long serialVersionUID = 0L;
                    private final Configuration hadoopConf$2;
                    private final PathFilter filter$2;
                    private final Option sessionOpt$1;

                    public final Seq<FileStatus> apply(FileStatus dir) {
                        return InMemoryFileIndex$.MODULE$.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$listLeafFiles(dir.getPath(), this.hadoopConf$2, this.filter$2, (Option<SparkSession>)this.sessionOpt$1);
                    }
                    {
                        this.hadoopConf$2 = hadoopConf$2;
                        this.filter$2 = filter$2;
                        this.sessionOpt$1 = sessionOpt$1;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            Seq nestedFiles = seq;
            FileStatus[] allFiles2 = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])topLevelFiles2).$plus$plus((GenTraversableOnce)nestedFiles, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            FileStatus[] allLeafStatuses = filter == null ? allFiles2 : (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])allFiles2).filter((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                private final PathFilter filter$2;

                public final boolean apply(FileStatus f) {
                    return this.filter$2.accept(f.getPath());
                }
                {
                    this.filter$2 = filter$2;
                }
            });
            ArrayBuffer missingFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            FileStatus[] filteredLeafStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    return InMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName());
                }
            });
            LocatedFileStatus[] resolvedLeafStatuses = (LocatedFileStatus[])Predef$.MODULE$.refArrayOps((Object[])filteredLeafStatuses).flatMap((Function1)new Serializable(fs, missingFiles){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$1;
                private final ArrayBuffer missingFiles$1;

                public final Iterable<LocatedFileStatus> apply(FileStatus x0$4) {
                    Iterable iterable;
                    FileStatus fileStatus = x0$4;
                    if (fileStatus instanceof LocatedFileStatus) {
                        LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)locatedFileStatus));
                    } else {
                        Iterable iterable2;
                        try {
                            BlockLocation[] locations = this.fs$1.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
                            LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                            if (fileStatus.isSymlink()) {
                                lfs.setSymlink(fileStatus.getSymlink());
                            }
                            iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)lfs));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.missingFiles$1.$plus$eq((Object)fileStatus.getPath().toString());
                            iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        iterable = iterable2;
                    }
                    return iterable;
                }
                {
                    this.fs$1 = fs$1;
                    this.missingFiles$1 = missingFiles$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LocatedFileStatus.class)));
            if (missingFiles.nonEmpty()) {
                this.logWarning((Function0<String>)new Serializable(missingFiles){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer missingFiles$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the following files were missing during file scan:\\n  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.missingFiles$1.mkString("\n  ")}));
                    }
                    {
                        this.missingFiles$1 = missingFiles$1;
                    }
                });
            }
            return Predef$.MODULE$.wrapRefArray((Object[])resolvedLeafStatuses);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean shouldFilterOut(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.startsWith(".") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    public FileStatusCache $lessinit$greater$default$5() {
        return NoopCache$.MODULE$;
    }

    private InMemoryFileIndex$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

