/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.hive.client.package$hive$;
import org.apache.spark.sql.hive.client.package$hive$v12$;
import org.apache.spark.sql.hive.client.package$hive$v13$;
import org.apache.spark.sql.hive.client.package$hive$v14$;
import org.apache.spark.sql.hive.client.package$hive$v1_0$;
import org.apache.spark.sql.hive.client.package$hive$v1_1$;
import org.apache.spark.sql.hive.client.package$hive$v1_2$;
import org.apache.spark.sql.hive.client.package$hive$v2_0$;
import org.apache.spark.sql.hive.client.package$hive$v2_1$;
import org.apache.spark.sql.hive.execution.HiveFileFormat;
import org.apache.spark.sql.hive.execution.HiveOptions$;
import org.apache.spark.sql.hive.execution.SaveAsHiveFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public abstract class SaveAsHiveFile$class {
    public static scala.collection.immutable.Set saveAsHiveFile(SaveAsHiveFile $this, SparkSession sparkSession, SparkPlan plan, Configuration hadoopConf, HiveShim.ShimFileSinkDesc fileSinkConf, String outputLocation, Map customPartitionLocations, Seq partitionAttributes) {
        String string = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getOutputFileFormatClassName().toLowerCase(Locale.ROOT);
        boolean bl = string.endsWith("orcoutputformat") ? false : new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("hive.exec.compress.output", "false"))).toBoolean();
        boolean isCompressed = bl;
        if (isCompressed) {
            hadoopConf.set("mapreduce.output.fileoutputformat.compress", "true");
            fileSinkConf.setCompressed(true);
            fileSinkConf.setCompressCodec(hadoopConf.get("mapreduce.output.fileoutputformat.compress.codec"));
            fileSinkConf.setCompressType(hadoopConf.get("mapreduce.output.fileoutputformat.compress.type"));
        } else {
            HiveOptions$.MODULE$.getHiveWriteCompression(HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo(), sparkSession.sessionState().conf()).foreach((Function1)new Serializable($this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String compression = (String)tuple2._1();
                        String codec = (String)tuple2._2();
                        this.hadoopConf$1.set(compression, codec);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(sparkSession.sessionState().conf().fileCommitProtocolClass(), UUID.randomUUID().toString(), outputLocation, FileCommitProtocol$.MODULE$.instantiate$default$4());
        return FileFormatWriter$.MODULE$.write(sparkSession, plan, (FileFormat)new HiveFileFormat(fileSinkConf), committer, new FileFormatWriter.OutputSpec(outputLocation, customPartitionLocations, $this.outputColumns()), hadoopConf, partitionAttributes, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{$this.basicWriteJobStatsTracker(hadoopConf)})), Predef$.MODULE$.Map().empty());
    }

    public static Map saveAsHiveFile$default$6(SaveAsHiveFile $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static Seq saveAsHiveFile$default$7(SaveAsHiveFile $this) {
        return Nil$.MODULE$;
    }

    public static Path getExternalTmpPath(SaveAsHiveFile $this, SparkSession sparkSession, Configuration hadoopConf, Path path) {
        package.HiveVersion hiveVersion;
        block4: {
            Path path2;
            block3: {
                String stagingDir;
                scala.collection.immutable.Set hiveVersionsUsingNewExternalTempPath;
                block2: {
                    scala.collection.immutable.Set hiveVersionsUsingOldExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v12$.MODULE$, package$hive$v13$.MODULE$, package$hive$v14$.MODULE$, package$hive$v1_0$.MODULE$}));
                    hiveVersionsUsingNewExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v1_1$.MODULE$, package$hive$v1_2$.MODULE$, package$hive$v2_0$.MODULE$, package$hive$v2_1$.MODULE$}));
                    Set set = hiveVersionsUsingNewExternalTempPath.$plus$plus((GenTraversableOnce)hiveVersionsUsingOldExternalTempPath);
                    scala.collection.immutable.Set<Product> set2 = package$hive$.MODULE$.allSupportedHiveVersions();
                    Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
                    ExternalCatalog externalCatalog = sparkSession.sharedState().externalCatalog();
                    hiveVersion = ((HiveExternalCatalog)externalCatalog).client().version();
                    stagingDir = hadoopConf.get("hive.exec.stagingdir", ".hive-staging");
                    String scratchDir = hadoopConf.get("hive.exec.scratchdir", "/tmp/hive");
                    if (!hiveVersionsUsingOldExternalTempPath.contains((Object)hiveVersion)) break block2;
                    path2 = SaveAsHiveFile$class.oldVersionExternalTempPath($this, path, hadoopConf, scratchDir);
                    break block3;
                }
                if (!hiveVersionsUsingNewExternalTempPath.contains((Object)hiveVersion)) break block4;
                path2 = SaveAsHiveFile$class.newVersionExternalTempPath($this, path, hadoopConf, stagingDir);
            }
            return path2;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Unsupported hive version: ").append((Object)hiveVersion.fullVersion()).toString());
    }

    public static void deleteExternalTmpPath(SaveAsHiveFile $this, Configuration hadoopConf) {
        try {
            $this.createdTempDir().foreach((Function1)new Serializable($this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$2;

                public final Object apply(Path path) {
                    FileSystem fs = path.getFileSystem(this.hadoopConf$2);
                    return fs.delete(path, true) ? BoxesRunTime.boxToBoolean((boolean)fs.cancelDeleteOnExit(path)) : BoxedUnit.UNIT;
                }
                {
                    this.hadoopConf$2 = hadoopConf$2;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            String stagingDir = hadoopConf.get("hive.exec.stagingdir", ".hive-staging");
            ((Logging)$this).logWarning((Function0)new Serializable($this, e, stagingDir){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;
                private final String stagingDir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete staging directory: ", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stagingDir$1}))).append((Object)this.e$1).toString();
                }
                {
                    this.e$1 = e$1;
                    this.stagingDir$1 = stagingDir$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Path oldVersionExternalTempPath(SaveAsHiveFile $this, Path path, Configuration hadoopConf, String scratchDir) {
        void var6_6;
        block3: {
            URI extURI = path.toUri();
            Path scratchPath = new Path(scratchDir, SaveAsHiveFile$class.executionId($this));
            Path dirPath = new Path(extURI.getScheme(), extURI.getAuthority(), new StringBuilder().append((Object)scratchPath.toUri().getPath()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString());
            try {
                FileSystem fs = dirPath.getFileSystem(hadoopConf);
                dirPath = new Path(fs.makeQualified(dirPath).toString());
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dirPath, (boolean)true, (Configuration)hadoopConf)) break block3;
                $this.createdTempDir_$eq((Option<Path>)new Some((Object)dirPath));
                fs.deleteOnExit(dirPath);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory: ").append((Object)var6_6.toString()).toString(), iOException);
            }
            return dirPath;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory: ").append((Object)var6_6.toString()).toString());
    }

    private static Path newVersionExternalTempPath(SaveAsHiveFile $this, Path path, Configuration hadoopConf, String stagingDir) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        return !(string != null ? !string.equals(string2) : string2 != null) ? SaveAsHiveFile$class.getExtTmpPathRelTo($this, path.getParent(), hadoopConf, stagingDir) : new Path(SaveAsHiveFile$class.getExternalScratchDir($this, extURI, hadoopConf, stagingDir), "-ext-10000");
    }

    private static Path getExtTmpPathRelTo(SaveAsHiveFile $this, Path path, Configuration hadoopConf, String stagingDir) {
        return new Path(SaveAsHiveFile$class.getStagingDir($this, path, hadoopConf, stagingDir), "-ext-10000");
    }

    private static Path getExternalScratchDir(SaveAsHiveFile $this, URI extURI, Configuration hadoopConf, String stagingDir) {
        return SaveAsHiveFile$class.getStagingDir($this, new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), hadoopConf, stagingDir);
    }

    /*
     * WARNING - void declaration
     */
    private static Path getStagingDir(SaveAsHiveFile $this, Path inputPath, Configuration hadoopConf, String stagingDir) {
        void var8_8;
        block4: {
            URI inputPathUri = inputPath.toUri();
            String inputPathName = inputPathUri.getPath();
            FileSystem fs = inputPath.getFileSystem(hadoopConf);
            ObjectRef stagingPathName = ObjectRef.create((Object)(inputPathName.indexOf(stagingDir) == -1 ? new Path(inputPathName, stagingDir).toString() : inputPathName.substring(0, inputPathName.indexOf(stagingDir) + stagingDir.length())));
            if (FileUtils.isSubDir((Path)new Path((String)stagingPathName.elem), (Path)inputPath, (FileSystem)fs) && !new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)stagingPathName.elem)).stripPrefix(inputPathName))).stripPrefix(File.separator).startsWith(".")) {
                ((Logging)$this).logDebug((Function0)new Serializable($this, stagingPathName){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stagingPathName$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The staging dir '", "' should be a child directory starts "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.stagingPathName$1.elem}))).append((Object)"with '.' to avoid being deleted if we set hive.exec.stagingdir under the table ").append((Object)"directory.").toString();
                    }
                    {
                        this.stagingPathName$1 = stagingPathName$1;
                    }
                });
                stagingPathName.elem = new Path(inputPathName, ".hive-staging").toString();
            }
            Path dir = fs.makeQualified(new Path(new StringBuilder().append((Object)((String)stagingPathName.elem)).append((Object)"_").append((Object)SaveAsHiveFile$class.executionId($this)).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString()));
            ((Logging)$this).logDebug((Function0)new Serializable($this, inputPath, dir){
                public static final long serialVersionUID = 0L;
                private final Path inputPath$1;
                private final Path dir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created staging dir = ").append((Object)this.dir$1).append((Object)" for path = ").append((Object)this.inputPath$1).toString();
                }
                {
                    this.inputPath$1 = inputPath$1;
                    this.dir$1 = dir$1;
                }
            });
            try {
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dir, (boolean)true, (Configuration)hadoopConf)) break block4;
                $this.createdTempDir_$eq((Option<Path>)new Some((Object)dir));
                fs.deleteOnExit(dir);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory '").append((Object)var8_8.toString()).append((Object)"': ").append((Object)iOException.getMessage()).toString(), iOException);
            }
            return dir;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory  '").append((Object)var8_8.toString()).append((Object)"'").toString());
    }

    private static String executionId(SaveAsHiveFile $this) {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS", Locale.US);
        return new StringBuilder().append((Object)"hive_").append((Object)format.format(new Date())).append((Object)"_").append((Object)BoxesRunTime.boxToLong((long)Math.abs(rand.nextLong()))).toString();
    }

    public static void $init$(SaveAsHiveFile $this) {
        $this.createdTempDir_$eq((Option<Path>)None$.MODULE$);
    }
}

