/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.ql.exec.vector;

import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.MultiValuedColumnVector;

public class ListColumnVector
extends MultiValuedColumnVector {
    public ColumnVector child;

    public ListColumnVector() {
        this(1024, null);
    }

    public ListColumnVector(int len, ColumnVector child) {
        super(len);
        this.child = child;
    }

    @Override
    protected void childFlatten(boolean useSelected, int[] selected, int size) {
        this.child.flatten(useSelected, selected, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        ListColumnVector input = (ListColumnVector)inputVector;
        if (input.isRepeating) {
            inputElementNum = 0;
        }
        if (!input.noNulls && input.isNull[inputElementNum]) {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        } else {
            this.isNull[outElementNum] = false;
            int offset = this.childCount;
            int length = (int)input.lengths[inputElementNum];
            int inputOffset = (int)input.offsets[inputElementNum];
            this.offsets[outElementNum] = offset;
            this.childCount += length;
            this.lengths[outElementNum] = length;
            this.child.ensureSize(this.childCount, true);
            for (int i = 0; i < length; ++i) {
                this.child.setElement(i + offset, inputOffset + i, input.child);
            }
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('[');
            boolean isFirst = true;
            for (long i = this.offsets[row]; i < this.offsets[row] + this.lengths[row]; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                this.child.stringifyValue(buffer, (int)i);
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void init() {
        super.init();
        this.child.init();
    }

    @Override
    public void reset() {
        super.reset();
        this.child.reset();
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        if (!this.isRepeating || this.noNulls || !this.isNull[0]) {
            this.child.unFlatten();
        }
    }
}

