/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroProxy;
import net.razorvine.pyro.PyroURI;
import net.razorvine.serpent.IClassSerializer;

public class PyroProxySerpent
implements IClassSerializer {
    public static Object FromSerpentDict(Map<Object, Object> dict) throws IOException {
        int i;
        Object[] state = (Object[])dict.get("state");
        PyroURI uri = new PyroURI((String)state[0]);
        PyroProxy proxy = new PyroProxy(uri);
        Object methods = state[2];
        Object attrs = state[3];
        Object oneways = state[1];
        if (methods instanceof Object[]) {
            Object[] methods_array = (Object[])methods;
            proxy.pyroMethods = new HashSet<String>();
            for (i = 0; i < methods_array.length; ++i) {
                proxy.pyroMethods.add((String)methods_array[i]);
            }
        } else if (methods != null) {
            HashSet methods_set;
            proxy.pyroMethods = methods_set = (HashSet)methods;
        }
        if (attrs instanceof Object[]) {
            Object[] attrs_array = (Object[])attrs;
            proxy.pyroAttrs = new HashSet<String>();
            for (i = 0; i < attrs_array.length; ++i) {
                proxy.pyroAttrs.add((String)attrs_array[i]);
            }
        } else if (attrs != null) {
            HashSet attrs_set;
            proxy.pyroAttrs = attrs_set = (HashSet)attrs;
        }
        if (oneways instanceof Object[]) {
            Object[] oneways_array = (Object[])oneways;
            proxy.pyroOneway = new HashSet<String>();
            for (i = 0; i < oneways_array.length; ++i) {
                proxy.pyroOneway.add((String)oneways_array[i]);
            }
        } else if (oneways != null) {
            HashSet oneways_set;
            proxy.pyroOneway = oneways_set = (HashSet)oneways;
        }
        if (state[5] != null) {
            String encodedHmac = (String)state[5];
            if (encodedHmac.startsWith("b64:")) {
                proxy.pyroHmacKey = DatatypeConverter.parseBase64Binary((String)encodedHmac.substring(4));
            } else {
                throw new PyroException("hmac encoding error");
            }
        }
        proxy.pyroHandshake = state[6];
        return proxy;
    }

    public Map<String, Object> convert(Object obj) {
        PyroProxy proxy = (PyroProxy)obj;
        HashMap<String, Object> dict = new HashMap<String, Object>();
        String uri = String.format("PYRO:%s@%s:%d", proxy.objectid, proxy.hostname, proxy.port);
        String encodedHmac = proxy.pyroHmacKey != null ? "b64:" + DatatypeConverter.printBase64Binary((byte[])proxy.pyroHmacKey) : null;
        dict.put("state", new Object[]{uri, proxy.pyroOneway, proxy.pyroMethods, proxy.pyroAttrs, 0.0, encodedHmac, proxy.pyroHandshake, 0});
        dict.put("__class__", "Pyro4.core.Proxy");
        return dict;
    }
}

