/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    private static final long serialVersionUID = 7093033866379803297L;
    private double r;
    private double i;

    public ComplexNumber(double rr, double ii) {
        this.r = rr;
        this.i = ii;
    }

    public ComplexNumber(Double rr, Double ii) {
        this.r = rr;
        this.i = ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.r);
        if (this.i >= 0.0) {
            sb.append('+');
        }
        return sb.append(this.i).append('i').toString();
    }

    public double getReal() {
        return this.r;
    }

    public double getImaginary() {
        return this.i;
    }

    public double magnitude() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public ComplexNumber add(ComplexNumber other) {
        return ComplexNumber.add(this, other);
    }

    public static ComplexNumber add(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r + c2.r, c1.i + c2.i);
    }

    public ComplexNumber subtract(ComplexNumber other) {
        return ComplexNumber.subtract(this, other);
    }

    public static ComplexNumber subtract(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r - c2.r, c1.i - c2.i);
    }

    public ComplexNumber multiply(ComplexNumber other) {
        return ComplexNumber.multiply(this, other);
    }

    public static ComplexNumber multiply(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r * c2.r - c1.i * c2.i, c1.r * c2.i + c1.i * c2.r);
    }

    public static ComplexNumber divide(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber((c1.r * c2.r + c1.i * c2.i) / (c2.r * c2.r + c2.i * c2.i), (c1.i * c2.r - c1.r * c2.i) / (c2.r * c2.r + c2.i * c2.i));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber other = (ComplexNumber)o;
        return this.r == other.r && this.i == other.i;
    }

    public int hashCode() {
        return new Double(this.r).hashCode() ^ new Double(this.i).hashCode();
    }
}

