/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkSubmitOptionParser;

class SparkSubmitCommandBuilder
extends AbstractCommandBuilder {
    static final String PYSPARK_SHELL = "pyspark-shell-main";
    static final String PYSPARK_SHELL_RESOURCE = "pyspark-shell";
    static final String SPARKR_SHELL = "sparkr-shell-main";
    static final String SPARKR_SHELL_RESOURCE = "sparkr-shell";
    static final String RUN_EXAMPLE = "run-example";
    static final String EXAMPLE_CLASS_PREFIX = "org.apache.spark.examples.";
    private static final Map<String, String> specialClasses = new HashMap<String, String>();
    final List<String> sparkArgs;
    private final boolean isAppResourceReq;
    private final boolean isExample;
    private boolean allowsMixedArguments;

    SparkSubmitCommandBuilder() {
        this.sparkArgs = new ArrayList<String>();
        this.isAppResourceReq = true;
        this.isExample = false;
    }

    SparkSubmitCommandBuilder(List<String> args) {
        this.allowsMixedArguments = false;
        this.sparkArgs = new ArrayList<String>();
        boolean isExample = false;
        List<String> submitArgs = args;
        if (args.size() > 0) {
            switch (args.get(0)) {
                case "pyspark-shell-main": {
                    this.allowsMixedArguments = true;
                    this.appResource = PYSPARK_SHELL;
                    submitArgs = args.subList(1, args.size());
                    break;
                }
                case "sparkr-shell-main": {
                    this.allowsMixedArguments = true;
                    this.appResource = SPARKR_SHELL;
                    submitArgs = args.subList(1, args.size());
                    break;
                }
                case "run-example": {
                    isExample = true;
                    submitArgs = args.subList(1, args.size());
                }
            }
            this.isExample = isExample;
            OptionParser parser = new OptionParser();
            parser.parse(submitArgs);
            this.isAppResourceReq = parser.isAppResourceReq;
        } else {
            this.isExample = isExample;
            this.isAppResourceReq = false;
        }
    }

    @Override
    public List<String> buildCommand(Map<String, String> env) throws IOException, IllegalArgumentException {
        if (PYSPARK_SHELL.equals(this.appResource) && this.isAppResourceReq) {
            return this.buildPySparkShellCommand(env);
        }
        if (SPARKR_SHELL.equals(this.appResource) && this.isAppResourceReq) {
            return this.buildSparkRCommand(env);
        }
        return this.buildSparkSubmitCommand(env);
    }

    List<String> buildSparkSubmitArgs() {
        ArrayList<String> args = new ArrayList<String>();
        SparkSubmitOptionParser parser = new SparkSubmitOptionParser();
        if (!this.allowsMixedArguments && this.isAppResourceReq) {
            CommandBuilderUtils.checkArgument(this.appResource != null, "Missing application resource.", new Object[0]);
        }
        if (this.verbose) {
            parser.getClass();
            args.add("--verbose");
        }
        if (this.master != null) {
            parser.getClass();
            args.add("--master");
            args.add(this.master);
        }
        if (this.deployMode != null) {
            parser.getClass();
            args.add("--deploy-mode");
            args.add(this.deployMode);
        }
        if (this.appName != null) {
            parser.getClass();
            args.add("--name");
            args.add(this.appName);
        }
        for (Map.Entry e : this.conf.entrySet()) {
            parser.getClass();
            args.add("--conf");
            args.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        if (this.propertiesFile != null) {
            parser.getClass();
            args.add("--properties-file");
            args.add(this.propertiesFile);
        }
        if (this.isExample) {
            this.jars.addAll(this.findExamplesJars());
        }
        if (!this.jars.isEmpty()) {
            parser.getClass();
            args.add("--jars");
            args.add(CommandBuilderUtils.join(",", this.jars));
        }
        if (!this.files.isEmpty()) {
            parser.getClass();
            args.add("--files");
            args.add(CommandBuilderUtils.join(",", this.files));
        }
        if (!this.pyFiles.isEmpty()) {
            parser.getClass();
            args.add("--py-files");
            args.add(CommandBuilderUtils.join(",", this.pyFiles));
        }
        if (this.isAppResourceReq) {
            CommandBuilderUtils.checkArgument(!this.isExample || this.mainClass != null, "Missing example class name.", new Object[0]);
        }
        if (this.mainClass != null) {
            parser.getClass();
            args.add("--class");
            args.add(this.mainClass);
        }
        args.addAll(this.sparkArgs);
        if (this.appResource != null) {
            args.add(this.appResource);
        }
        args.addAll(this.appArgs);
        return args;
    }

    private List<String> buildSparkSubmitCommand(Map<String, String> env) throws IOException, IllegalArgumentException {
        Map<String, String> config = this.getEffectiveConfig();
        boolean isClientMode = this.isClientMode(config);
        String extraClassPath = isClientMode ? config.get("spark.driver.extraClassPath") : null;
        List<String> cmd = this.buildJavaCommand(extraClassPath);
        if (this.isThriftServer(this.mainClass)) {
            this.addOptionString(cmd, System.getenv("SPARK_DAEMON_JAVA_OPTS"));
        }
        this.addOptionString(cmd, System.getenv("SPARK_SUBMIT_OPTS"));
        String driverExtraJavaOptions = config.get("spark.driver.extraJavaOptions");
        if (!CommandBuilderUtils.isEmpty(driverExtraJavaOptions) && driverExtraJavaOptions.contains("Xmx")) {
            String msg = String.format("Not allowed to specify max heap(Xmx) memory settings through java options (was %s). Use the corresponding --driver-memory or spark.driver.memory configuration instead.", driverExtraJavaOptions);
            throw new IllegalArgumentException(msg);
        }
        if (isClientMode) {
            String tsMemory = this.isThriftServer(this.mainClass) ? System.getenv("SPARK_DAEMON_MEMORY") : null;
            String memory = CommandBuilderUtils.firstNonEmpty(tsMemory, config.get("spark.driver.memory"), System.getenv("SPARK_DRIVER_MEMORY"), System.getenv("SPARK_MEM"), "1g");
            cmd.add("-Xmx" + memory);
            this.addOptionString(cmd, driverExtraJavaOptions);
            CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), config.get("spark.driver.extraLibraryPath"));
        }
        cmd.add("org.apache.spark.deploy.SparkSubmit");
        cmd.addAll(this.buildSparkSubmitArgs());
        return cmd;
    }

    private List<String> buildPySparkShellCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && ((String)this.appArgs.get(0)).endsWith(".py")) {
            System.err.println("Running python applications through 'pyspark' is not supported as of Spark 2.0.\nUse ./bin/spark-submit <python file>");
            System.exit(-1);
        }
        CommandBuilderUtils.checkArgument(this.appArgs.isEmpty(), "pyspark does not support any application options.", new Object[0]);
        this.appResource = PYSPARK_SHELL_RESOURCE;
        this.constructEnvVarArgs(env, "PYSPARK_SUBMIT_ARGS");
        ArrayList<String> pyargs = new ArrayList<String>();
        pyargs.add(CommandBuilderUtils.firstNonEmpty((String)this.conf.get("spark.pyspark.driver.python"), (String)this.conf.get("spark.pyspark.python"), System.getenv("PYSPARK_DRIVER_PYTHON"), System.getenv("PYSPARK_PYTHON"), "python"));
        String pyOpts = System.getenv("PYSPARK_DRIVER_PYTHON_OPTS");
        if (this.conf.containsKey("spark.pyspark.python")) {
            env.put("PYSPARK_PYTHON", (String)this.conf.get("spark.pyspark.python"));
        }
        if (!CommandBuilderUtils.isEmpty(pyOpts)) {
            pyargs.addAll(CommandBuilderUtils.parseOptionString(pyOpts));
        }
        return pyargs;
    }

    private List<String> buildSparkRCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && ((String)this.appArgs.get(0)).endsWith(".R")) {
            System.err.println("Running R applications through 'sparkR' is not supported as of Spark 2.0.\nUse ./bin/spark-submit <R file>");
            System.exit(-1);
        }
        this.appResource = SPARKR_SHELL_RESOURCE;
        this.constructEnvVarArgs(env, "SPARKR_SUBMIT_ARGS");
        String sparkHome = System.getenv("SPARK_HOME");
        env.put("R_PROFILE_USER", CommandBuilderUtils.join(File.separator, sparkHome, "R", "lib", "SparkR", "profile", "shell.R"));
        ArrayList<String> args = new ArrayList<String>();
        args.add(CommandBuilderUtils.firstNonEmpty((String)this.conf.get("spark.r.shell.command"), System.getenv("SPARKR_DRIVER_R"), "R"));
        return args;
    }

    private void constructEnvVarArgs(Map<String, String> env, String submitArgsEnvVariable) throws IOException {
        CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), this.getEffectiveConfig().get("spark.driver.extraLibraryPath"));
        StringBuilder submitArgs = new StringBuilder();
        for (String arg : this.buildSparkSubmitArgs()) {
            if (submitArgs.length() > 0) {
                submitArgs.append(" ");
            }
            submitArgs.append(CommandBuilderUtils.quoteForCommandString(arg));
        }
        env.put(submitArgsEnvVariable, submitArgs.toString());
    }

    boolean isClientMode(Map<String, String> userProps) {
        String userMaster = CommandBuilderUtils.firstNonEmpty(this.master, userProps.get("spark.master"));
        String userDeployMode = CommandBuilderUtils.firstNonEmpty(this.deployMode, userProps.get("spark.submit.deployMode"));
        return userMaster == null || "client".equals(userDeployMode) || !userMaster.equals("yarn-cluster") && userDeployMode == null;
    }

    private boolean isThriftServer(String mainClass) {
        return mainClass != null && mainClass.equals("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2");
    }

    private List<String> findExamplesJars() {
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        ArrayList<String> examplesJars = new ArrayList<String>();
        String sparkHome = this.getSparkHome();
        File jarsDir = new File(sparkHome, "RELEASE").isFile() ? new File(sparkHome, "examples/jars") : new File(sparkHome, String.format("examples/target/scala-%s/jars", this.getScalaVersion()));
        boolean foundDir = jarsDir.isDirectory();
        CommandBuilderUtils.checkState(isTesting || foundDir, "Examples jars directory '%s' does not exist.", jarsDir.getAbsolutePath());
        if (foundDir) {
            for (File f : jarsDir.listFiles()) {
                examplesJars.add(f.getAbsolutePath());
            }
        }
        return examplesJars;
    }

    static {
        specialClasses.put("org.apache.spark.repl.Main", "spark-shell");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver", "spark-internal");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2", "spark-internal");
    }

    private class OptionParser
    extends SparkSubmitOptionParser {
        boolean isAppResourceReq = true;

        private OptionParser() {
        }

        @Override
        protected boolean handle(String opt, String value) {
            switch (opt) {
                case "--master": {
                    SparkSubmitCommandBuilder.this.master = value;
                    break;
                }
                case "--deploy-mode": {
                    SparkSubmitCommandBuilder.this.deployMode = value;
                    break;
                }
                case "--properties-file": {
                    SparkSubmitCommandBuilder.this.propertiesFile = value;
                    break;
                }
                case "--driver-memory": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.memory", value);
                    break;
                }
                case "--driver-java-options": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraJavaOptions", value);
                    break;
                }
                case "--driver-library-path": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraLibraryPath", value);
                    break;
                }
                case "--driver-class-path": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraClassPath", value);
                    break;
                }
                case "--conf": {
                    String[] setConf = value.split("=", 2);
                    CommandBuilderUtils.checkArgument(setConf.length == 2, "Invalid argument to %s: %s", "--conf", value);
                    SparkSubmitCommandBuilder.this.conf.put(setConf[0], setConf[1]);
                    break;
                }
                case "--class": {
                    SparkSubmitCommandBuilder.this.mainClass = value;
                    if (!specialClasses.containsKey(value)) break;
                    SparkSubmitCommandBuilder.this.allowsMixedArguments = true;
                    SparkSubmitCommandBuilder.this.appResource = (String)specialClasses.get(value);
                    break;
                }
                case "--kill": 
                case "--status": {
                    this.isAppResourceReq = false;
                    SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
                    SparkSubmitCommandBuilder.this.sparkArgs.add(value);
                    break;
                }
                case "--help": 
                case "--usage-error": {
                    this.isAppResourceReq = false;
                    SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
                    break;
                }
                case "--version": {
                    this.isAppResourceReq = false;
                    SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
                    break;
                }
                default: {
                    SparkSubmitCommandBuilder.this.sparkArgs.add(opt);
                    if (value == null) break;
                    SparkSubmitCommandBuilder.this.sparkArgs.add(value);
                }
            }
            return true;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            if (SparkSubmitCommandBuilder.this.allowsMixedArguments) {
                SparkSubmitCommandBuilder.this.appArgs.add(opt);
                return true;
            }
            if (SparkSubmitCommandBuilder.this.isExample) {
                String className = opt;
                if (!className.startsWith(SparkSubmitCommandBuilder.EXAMPLE_CLASS_PREFIX)) {
                    className = SparkSubmitCommandBuilder.EXAMPLE_CLASS_PREFIX + className;
                }
                SparkSubmitCommandBuilder.this.mainClass = className;
                SparkSubmitCommandBuilder.this.appResource = "spark-internal";
                return false;
            }
            CommandBuilderUtils.checkArgument(!opt.startsWith("-"), "Unrecognized option: %s", opt);
            CommandBuilderUtils.checkState(SparkSubmitCommandBuilder.this.appResource == null, "Found unrecognized argument but resource is already set.", new Object[0]);
            SparkSubmitCommandBuilder.this.appResource = opt;
            return false;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
            SparkSubmitCommandBuilder.this.appArgs.addAll(extra);
        }
    }
}

