/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}tAB\u0001\u0003\u0011\u0003!a\"A\tTa\u0006\u00148nU)M\u00072KEI]5wKJT!a\u0001\u0003\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h!\ty\u0001#D\u0001\u0003\r\u0019\t\"\u0001#\u0001\u0005%\t\t2\u000b]1sWN\u000bFj\u0011'J\tJLg/\u001a:\u0014\u0007A\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!!\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001b\u0002\u0013\u0011\u0005\u0004%I!J\u0001\u0007aJ|W\u000e\u001d;\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_A\u0001\u000b\u0011\u0002\u0014\u0002\u000fA\u0014x.\u001c9uA!9\u0011\u0007\u0005b\u0001\n\u0013\u0011\u0014aD2p]RLg.^3e!J|W\u000e\u001d;\u0016\u0003M\u0002\"\u0001N\u001c\u000f\u0005Q)\u0014B\u0001\u001c\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011Q\u0006\u000f\u0006\u0003mUAaA\u000f\t!\u0002\u0013\u0019\u0014\u0001E2p]RLg.^3e!J|W\u000e\u001d;!\u0011%a\u0004\u00031AA\u0002\u0013%Q(A\u0005ue\u0006t7\u000f]8siV\ta\b\u0005\u0002@\u00076\t\u0001I\u0003\u0002=\u0003*\u0011!IC\u0001\u0007i\"\u0014\u0018N\u001a;\n\u0005\u0011\u0003%a\u0002+T_\u000e\\W\r\u001e\u0005\n\rB\u0001\r\u00111A\u0005\n\u001d\u000bQ\u0002\u001e:b]N\u0004xN\u001d;`I\u0015\fHC\u0001%L!\t!\u0012*\u0003\u0002K+\t!QK\\5u\u0011\u001daU)!AA\u0002y\n1\u0001\u001f\u00132\u0011\u0019q\u0005\u0003)Q\u0005}\u0005QAO]1ogB|'\u000f\u001e\u0011\t\u000fA\u0003\"\u0019!C\u0007#\u0006A2\u000bU!S\u0017~C\u0015\tR(P!~\u0003&k\u0014)`!J+e)\u0013-\u0016\u0003I{\u0011aU\u0011\u0002)\u0006i1\u000f]1sW:B\u0017\rZ8pa:BaA\u0016\t!\u0002\u001b\u0011\u0016!G*Q\u0003J[u\fS!E\u001f>\u0003v\f\u0015*P!~\u0003&+\u0012$J1\u0002BQ\u0001\u0017\t\u0005\u0002e\u000bA#\u001b8ti\u0006dGnU5h]\u0006d\u0007*\u00198eY\u0016\u0014H#\u0001%\t\u000bm\u0003B\u0011\u0001/\u0002\t5\f\u0017N\u001c\u000b\u0003\u0011vCQA\u0018.A\u0002}\u000bA!\u0019:hgB\u0019A\u0003Y\u001a\n\u0005\u0005,\"!B!se\u0006L\b\"B2\u0011\t\u0003!\u0017\u0001D5t%\u0016lw\u000e^3N_\u0012,GCA3i!\t!b-\u0003\u0002h+\t9!i\\8mK\u0006t\u0007\"B5c\u0001\u0004Q\u0017!B:uCR,\u0007CA6r\u001b\u0005a'BA7o\u0003\r\u0019G.\u001b\u0006\u0003\u000b=T!\u0001\u001d\u0006\u0002\r!\fGm\\8q\u0013\t\u0011HNA\bDY&\u001cVm]:j_:\u001cF/\u0019;f\r\u0015\t\"\u0001\u0001\u0003u'\r\u0019X/\u0007\t\u0003WZL!a\u001e7\u0003\u0013\rc\u0017\u000e\u0012:jm\u0016\u0014\b\"\u0002\u0011t\t\u0003IH#\u0001>\u0011\u0005=\u0019\bb\u0002?t\u0005\u0004%I!`\u0001\rg\u0016\u001c8/[8o'R\fG/Z\u000b\u0002U\"1qp\u001dQ\u0001\n)\fQb]3tg&|gn\u0015;bi\u0016\u0004\u0003\"CA\u0002g\n\u0007I\u0011BA\u0003\u0003\raujR\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0004m_\u001e<\u0017N\\4\u000b\u0007\u0005E!\"A\u0004d_6lwN\\:\n\t\u0005U\u00111\u0002\u0002\u0004\u0019><\u0007\u0002CA\rg\u0002\u0006I!a\u0002\u0002\t1{u\t\t\u0005\n\u0003;\u0019(\u0019!C\u0005\u0003?\tqaY8og>dW-\u0006\u0002\u0002\"A!\u00111EA\u001a\u001d\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tqa]3tg&|gNC\u0002\u0002.9\f!!\u001d7\n\t\u0005E\u0012qE\u0001\r'\u0016\u001c8/[8o'R\fG/Z\u0005\u0005\u0003k\t9DA\u0005M_\u001eDU\r\u001c9fe*!\u0011\u0011GA\u0014\u0011!\tYd\u001dQ\u0001\n\u0005\u0005\u0012\u0001C2p]N|G.\u001a\u0011\t\u0011\r\u001c(\u0019!C\u0005\u0003\u007f)\u0012!\u001a\u0005\b\u0003\u0007\u001a\b\u0015!\u0003f\u00035I7OU3n_R,Wj\u001c3fA!I\u0011qI:C\u0002\u0013%\u0011\u0011J\u0001\u0005G>tg-\u0006\u0002\u0002LA!\u0011QJA)\u001b\t\tyEC\u0002\u0002H=LA!a\u0015\u0002P\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"a\u0016tA\u0003%\u00111J\u0001\u0006G>tg\r\t\u0005\b\u00037\u001aH\u0011IA/\u0003A\u0019X\r\u001e%jm\u00164\u0016M]5bE2,7\u000fF\u0002I\u0003?B\u0001\"!\u0019\u0002Z\u0001\u0007\u00111M\u0001\u000eQ&4XMV1sS\u0006\u0014G.Z:\u0011\r\u0005\u0015\u00141N\u001a4\u001b\t\t9GC\u0002\u0002j)\nA!\u001e;jY&!\u0011QNA4\u0005\ri\u0015\r\u001d\u0005\b\u0003c\u001aH\u0011IA:\u0003)\u0001(o\\2fgN\u001cU\u000e\u001a\u000b\u0005\u0003k\nY\bE\u0002\u0015\u0003oJ1!!\u001f\u0016\u0005\rIe\u000e\u001e\u0005\b\u0003{\ny\u00071\u00014\u0003\r\u0019W\u000e\u001a")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Log LOG;
    private final SessionState.LogHelper console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Log LOG() {
        return this.LOG;
    }

    private SessionState.LogHelper console() {
        return this.console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> kv) {
                SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processCmd(String cmd) {
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long start = System.currentTimeMillis();
            super.processCmd(cmd);
            long end = System.currentTimeMillis();
            double timeTaken = (double)(end - start) / 1000.0;
            this.console().printInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)})));
            return 0;
        }
        int ret = 0;
        HiveConf hconf = (HiveConf)this.conf();
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
        if (proc != null) {
            if (!(proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor)) {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            } else {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long start = System.currentTimeMillis();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long end = System.currentTimeMillis();
                double timeTaken = (double)(end - start) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    Throwable throwable = rc.getException();
                    if (throwable instanceof AnalysisException) {
                        AnalysisException analysisException = (AnalysisException)throwable;
                        err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisException.getMessage()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        err.println(rc.getErrorMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1)new Serializable(this, out){
                        public static final long serialVersionUID = 0L;
                        private final PrintStream out$1;

                        public final void apply(List<FieldSchema> fields) {
                            this.out$1.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(FieldSchema x$1) {
                                    return x$1.getName();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        }
                        {
                            this.out$1 = out$1;
                        }
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1)new Serializable(this, out, counter){
                            public static final long serialVersionUID = 0L;
                            private final PrintStream out$1;
                            private final IntRef counter$1;

                            public final void apply(String l) {
                                ++this.counter$1.elem;
                                this.out$1.println(l);
                            }
                            {
                                this.out$1 = out$1;
                                this.counter$1 = counter$1;
                            }
                        });
                        res.clear();
                    }
                }
                catch (IOException iOException) {
                    this.console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with exception ", ": ", "\n                   |", "\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getClass().getName(), iOException.getMessage(), StringUtils.stringifyException((Throwable)iOException)})))).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)}));
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder().append((Object)responseMsg).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", Fetched ", " row(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter.elem)}))).toString();
                }
                this.console().printInfo(responseMsg, null);
                driver.destroy();
            }
        }
        int n = ret;
        return n;
    }

    public SparkSQLCLIDriver() {
        Logging.class.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LogFactory.getLog(SparkSQLCLIDriver.class);
        this.console = new SessionState.LogHelper(this.LOG());
        if (this.sessionState().getIsSilent()) {
            org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        }
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() == null ? new Configuration() : this.sessionState().getConf();
        if (this.isRemoteMode()) {
            throw new RuntimeException("Remote operations not supported");
        }
        SparkSQLEnv$.MODULE$.init();
    }
}

