/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.io.api.Binary;

public class LeafFilterFactory {
    private static final Log LOG = LogFactory.getLog(LeafFilterFactory.class);

    public FilterPredicateLeafBuilder getLeafFilterBuilderByType(PredicateLeaf.Type type) {
        switch (type) {
            case INTEGER: {
                return new IntFilterPredicateLeafBuilder();
            }
            case LONG: {
                return new LongFilterPredicateLeafBuilder();
            }
            case FLOAT: {
                return new DoubleFilterPredicateLeafBuilder();
            }
            case STRING: {
                return new BinaryFilterPredicateLeafBuilder();
            }
            case BOOLEAN: {
                return new BooleanFilterPredicateLeafBuilder();
            }
        }
        LOG.debug((Object)("Conversion to Parquet FilterPredicate not supported for " + (Object)((Object)type)));
        return null;
    }

    class BinaryFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BinaryFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.binaryColumn((String)columnName), (Comparable)Binary.fromString((String)((String)constant)));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)columnName), constant == null ? null : Binary.fromString((String)((String)constant)));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.binaryColumn((String)columnName), (Comparable)Binary.fromString((String)((String)constant)));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class BooleanFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BooleanFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) throws Exception {
            switch (op) {
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.booleanColumn((String)columnName), constant == null ? null : Boolean.valueOf((Boolean)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class DoubleFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        DoubleFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)columnName), (Comparable)Double.valueOf(((Number)constant).doubleValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)columnName), constant == null ? null : Double.valueOf(((Number)constant).doubleValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)columnName), (Comparable)Double.valueOf(((Number)constant).doubleValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class LongFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        LongFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.longColumn((String)columnName), (Comparable)Long.valueOf(((Number)constant).longValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.longColumn((String)columnName), constant == null ? null : Long.valueOf(((Number)constant).longValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.longColumn((String)columnName), (Comparable)Long.valueOf(((Number)constant).longValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }

    class IntFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        IntFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object literal, String columnName) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.intColumn((String)columnName), (Comparable)Integer.valueOf(((Number)literal).intValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.intColumn((String)columnName), literal == null ? null : Integer.valueOf(((Number)literal).intValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.intColumn((String)columnName), (Comparable)Integer.valueOf(((Number)literal).intValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + (Object)((Object)op));
        }
    }
}

