/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.util.concurrent.CountDownLatch;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;
import org.apache.mesos.protobuf.GeneratedMessageV3;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.scheduler.cluster.mesos.MesosSchedulerUtils;
import org.apache.spark.scheduler.cluster.mesos.MesosSchedulerUtils$;
import org.apache.spark.util.Utils$;
import org.spark_project.guava.base.Splitter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.VolatileObjectRef;
import scala.util.control.NonFatal$;

public abstract class MesosSchedulerUtils$class {
    public static SchedulerDriver createSchedulerDriver(MesosSchedulerUtils $this, String masterUrl, Scheduler scheduler, String sparkUser, String appName, SparkConf conf, Option webuiUrl, Option checkpoint, Option failoverTimeout, Option frameworkId) {
        Protos.FrameworkInfo.Builder fwInfoBuilder = Protos.FrameworkInfo.newBuilder().setUser(sparkUser).setName(appName);
        Protos.Credential.Builder credBuilder = Protos.Credential.newBuilder();
        webuiUrl.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String url) {
                return this.fwInfoBuilder$1.setWebuiUrl(url);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        checkpoint.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(boolean checkpoint) {
                return this.fwInfoBuilder$1.setCheckpoint(checkpoint);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        failoverTimeout.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(double timeout) {
                return this.fwInfoBuilder$1.setFailoverTimeout(timeout);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        frameworkId.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String id) {
                return this.fwInfoBuilder$1.setId(Protos.FrameworkID.newBuilder().setValue(id).build());
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        fwInfoBuilder.setHostname((String)Option$.MODULE$.apply((Object)conf.getenv("SPARK_PUBLIC_DNS")).getOrElse((Function0)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$1;

            public final String apply() {
                return (String)this.conf$1.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS());
            }
            {
                this.conf$1 = conf$1;
            }
        }));
        conf.getOption("spark.mesos.principal").foreach((Function1)new Serializable($this, fwInfoBuilder, credBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;
            private final Protos.Credential.Builder credBuilder$1;

            public final Protos.Credential.Builder apply(String principal) {
                this.fwInfoBuilder$1.setPrincipal(principal);
                return this.credBuilder$1.setPrincipal(principal);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
                this.credBuilder$1 = credBuilder$1;
            }
        });
        conf.getOption("spark.mesos.secret").foreach((Function1)new Serializable($this, credBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.Credential.Builder credBuilder$1;

            public final Protos.Credential.Builder apply(String secret) {
                return this.credBuilder$1.setSecret(secret);
            }
            {
                this.credBuilder$1 = credBuilder$1;
            }
        });
        if (credBuilder.hasSecret() && !fwInfoBuilder.hasPrincipal()) {
            throw new SparkException("spark.mesos.principal must be configured when spark.mesos.secret is set");
        }
        conf.getOption("spark.mesos.role").foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String role) {
                return this.fwInfoBuilder$1.setRole(role);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        int maxGpus = conf.getInt("spark.mesos.gpus.max", 0);
        Object object = maxGpus > 0 ? fwInfoBuilder.addCapabilities(Protos.FrameworkInfo.Capability.newBuilder().setType(Protos.FrameworkInfo.Capability.Type.GPU_RESOURCES)) : BoxedUnit.UNIT;
        return credBuilder.hasPrincipal() ? new MesosSchedulerDriver(scheduler, fwInfoBuilder.build(), masterUrl, credBuilder.build()) : new MesosSchedulerDriver(scheduler, fwInfoBuilder.build(), masterUrl);
    }

    public static Option createSchedulerDriver$default$6(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$7(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$8(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$9(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static void startScheduler(MesosSchedulerUtils $this, SchedulerDriver newDriver) {
        MesosSchedulerUtils mesosSchedulerUtils = $this;
        synchronized (mesosSchedulerUtils) {
            VolatileObjectRef error2 = VolatileObjectRef.create((Object)None$.MODULE$);
            new Thread($this, error2, newDriver){
                private final /* synthetic */ MesosSchedulerUtils $outer;
                private final VolatileObjectRef error$1;
                private final SchedulerDriver newDriver$1;

                public void run() {
                    try {
                        Protos.Status ret = this.newDriver$1.run();
                        this.$outer.logInfo((Function0)new Serializable(this, ret){
                            public static final long serialVersionUID = 0L;
                            private final Protos.Status ret$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"driver.run() returned with code ").append((Object)this.ret$1).toString();
                            }
                            {
                                this.ret$1 = ret$1;
                            }
                        });
                        if (ret != null && ret.equals((Object)Protos.Status.DRIVER_ABORTED)) {
                            this.error$1.elem = new Some((Object)((Object)new SparkException("Error starting driver, DRIVER_ABORTED")));
                            this.$outer.markErr();
                        }
                    }
                    catch (Exception exception) {
                        this.$outer.logError((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "driver.run() failed";
                            }
                        }, exception);
                        this.error$1.elem = new Some((Object)exception);
                        this.$outer.markErr();
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.error$1 = error$1;
                    this.newDriver$1 = newDriver$1;
                    super(new StringBuilder().append((Object)Utils$.MODULE$.getFormattedClassName((Object)$outer)).append((Object)"-mesos-driver").toString());
                    this.setDaemon(true);
                }
            }.start();
            $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().await();
            ((Option)error2.elem).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Exception x$1) {
                    throw x$1;
                }
            });
            return;
        }
    }

    public static double getResource(MesosSchedulerUtils $this, java.util.List res, String name) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).filter((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Protos.Resource x$2) {
                String string = x$2.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Protos.Resource x$3) {
                return x$3.getScalar().getValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static List getRangeResource(MesosSchedulerUtils $this, java.util.List res, String name) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).filter((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final boolean apply(Protos.Resource x$4) {
                String string = x$4.getName();
                String string2 = this.name$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$2 = name$2;
            }
        })).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<Object, Object>> apply(Protos.Resource x$5) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getRanges().getRangeList()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Protos.Value.Range r) {
                        return new Tuple2.mcJJ.sp(r.getBegin(), r.getEnd());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toList();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public static void markRegistered(MesosSchedulerUtils $this) {
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().countDown();
    }

    public static void markErr(MesosSchedulerUtils $this) {
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().countDown();
    }

    public static void org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$setReservationInfo(MesosSchedulerUtils $this, Option reservationInfo, Option role, Protos.Resource.Builder builder) {
        if (!role.contains((Object)"*")) {
            reservationInfo.foreach((Function1)new Serializable($this, builder){
                public static final long serialVersionUID = 0L;
                private final Protos.Resource.Builder builder$1;

                public final Protos.Resource.Builder apply(Protos.Resource.ReservationInfo res) {
                    return this.builder$1.setReservation(res);
                }
                {
                    this.builder$1 = builder$1;
                }
            });
        }
    }

    public static Protos.Resource createResource(MesosSchedulerUtils $this, String name, double amount, Option role, Option reservationInfo) {
        Protos.Resource.Builder builder = Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(amount).build());
        role.foreach((Function1)new Serializable($this, builder){
            public static final long serialVersionUID = 0L;
            private final Protos.Resource.Builder builder$2;

            public final Protos.Resource.Builder apply(String r) {
                return this.builder$2.setRole(r);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$setReservationInfo($this, reservationInfo, role, builder);
        return builder.build();
    }

    public static Option createResource$default$3(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createResource$default$4(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$getReservation(MesosSchedulerUtils $this, Protos.Resource resource) {
        return resource.hasReservation() ? new Some((Object)resource.getReservation()) : None$.MODULE$;
    }

    public static Tuple2 partitionResources(MesosSchedulerUtils $this, java.util.List resources, String resourceName, double amountToUse) {
        DoubleRef remain = DoubleRef.create((double)amountToUse);
        ObjectRef requestedResources = ObjectRef.create((Object)new ArrayBuffer());
        Buffer remainingResources = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(resources).asScala()).map((Function1)new Serializable($this, remain, requestedResources, resourceName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;
            private final DoubleRef remain$1;
            private final ObjectRef requestedResources$1;
            private final String resourceName$1;

            /*
             * Unable to fully structure code
             */
            public final Protos.Resource apply(Protos.Resource x0$1) {
                var2_2 = x0$1;
                reservation = MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$getReservation(this.$outer, var2_2);
                if (!(this.remain$1.elem > (double)false)) ** GOTO lbl-1000
                v0 = var2_2.getType();
                var5_4 = Protos.Value.Type.SCALAR;
                if ((v0 != null ? v0.equals(var5_4) == false : var5_4 != null) || !(var2_2.getScalar().getValue() > 0.0)) ** GOTO lbl-1000
                v1 = var2_2.getName();
                var6_5 = this.resourceName$1;
                if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) {
                    usage = Math.min(this.remain$1.elem, var2_2.getScalar().getValue());
                    ((ArrayBuffer)this.requestedResources$1.elem).$plus$eq((Object)this.$outer.createResource(this.resourceName$1, usage, (Option<String>)Option$.MODULE$.apply((Object)var2_2.getRole()), (Option<Protos.Resource.ReservationInfo>)reservation));
                    this.remain$1.elem -= usage;
                    v2 = this.$outer.createResource(this.resourceName$1, var2_2.getScalar().getValue() - usage, (Option<String>)Option$.MODULE$.apply((Object)var2_2.getRole()), (Option<Protos.Resource.ReservationInfo>)reservation);
                } else lbl-1000:
                // 3 sources

                {
                    v2 = var2_2;
                }
                var3_7 = v2;
                return var3_7;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remain$1 = remain$1;
                this.requestedResources$1 = requestedResources$1;
                this.resourceName$1 = resourceName$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer filteredResources = (Buffer)remainingResources.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Protos.Resource r) {
                Protos.Value.Type type = r.getType();
                Protos.Value.Type type2 = Protos.Value.Type.SCALAR;
                return (type != null ? !type.equals(type2) : type2 != null) || r.getScalar().getValue() > 0.0;
            }
        });
        return new Tuple2((Object)filteredResources.toList(), (Object)((ArrayBuffer)requestedResources.elem).toList());
    }

    public static Tuple2 getAttribute(MesosSchedulerUtils $this, Protos.Attribute attr) {
        return new Tuple2((Object)attr.getName(), (Object)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(attr.getText().getValue())).split(',')).toSet());
    }

    public static Map toAttributeMap(MesosSchedulerUtils $this, java.util.List offerAttributes) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offerAttributes).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, GeneratedMessageV3> apply(Protos.Attribute attr) {
                Protos.Value.Type type;
                block6: {
                    Protos.Value.Scalar scalar;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    type = attr.getType();
                                    if (!Protos.Value.Type.SCALAR.equals(type)) break block2;
                                    scalar = attr.getScalar();
                                    break block3;
                                }
                                if (!Protos.Value.Type.RANGES.equals(type)) break block4;
                                scalar = attr.getRanges();
                                break block3;
                            }
                            if (!Protos.Value.Type.SET.equals(type)) break block5;
                            scalar = attr.getSet();
                            break block3;
                        }
                        if (!Protos.Value.Type.TEXT.equals(type)) break block6;
                        scalar = attr.getText();
                    }
                    Protos.Value.Scalar attrValue = scalar;
                    return new Tuple2((Object)attr.getName(), (Object)attrValue);
                }
                throw new MatchError((Object)type);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static boolean matchesAttributeRequirements(MesosSchedulerUtils $this, Map slaveOfferConstraints, Map offerAttributes) {
        return slaveOfferConstraints.forall((Function1)new Serializable($this, offerAttributes){
            public static final long serialVersionUID = 0L;
            private final Map offerAttributes$2;

            public final boolean apply(Tuple2<String, Set<String>> x0$2) {
                Tuple2<String, Set<String>> tuple2;
                block2: {
                    Option option;
                    block9: {
                        boolean bl;
                        block4: {
                            GeneratedMessageV3 textValue;
                            Some some;
                            boolean bl2;
                            Set requiredValues;
                            block8: {
                                GeneratedMessageV3 offeredValue;
                                block7: {
                                    GeneratedMessageV3 rangeValue;
                                    block6: {
                                        GeneratedMessageV3 scalarValue;
                                        block5: {
                                            block3: {
                                                tuple2 = x0$2;
                                                if (tuple2 == null) break block2;
                                                String name = (String)tuple2._1();
                                                requiredValues = (Set)tuple2._2();
                                                bl2 = false;
                                                some = null;
                                                option = this.offerAttributes$2.get((Object)name);
                                                if (!None$.MODULE$.equals(option)) break block3;
                                                bl = false;
                                                break block4;
                                            }
                                            if (!(option instanceof Some)) break block5;
                                            bl2 = true;
                                            some = (Some)option;
                                            if (!requiredValues.isEmpty()) break block5;
                                            bl = true;
                                            break block4;
                                        }
                                        if (!bl2 || !((scalarValue = (GeneratedMessageV3)some.x()) instanceof Protos.Value.Scalar)) break block6;
                                        Protos.Value.Scalar scalar = (Protos.Value.Scalar)scalarValue;
                                        bl = ((IterableLike)requiredValues.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final double apply(String x$6) {
                                                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toDouble();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, scalar){
                                            public static final long serialVersionUID = 0L;
                                            private final Protos.Value.Scalar x9$1;

                                            public final boolean apply(double x$7) {
                                                return this.apply$mcZD$sp(x$7);
                                            }

                                            public boolean apply$mcZD$sp(double x$7) {
                                                return x$7 <= this.x9$1.getValue();
                                            }
                                            {
                                                this.x9$1 = x9$1;
                                            }
                                        });
                                        break block4;
                                    }
                                    if (!bl2 || !((rangeValue = (GeneratedMessageV3)some.x()) instanceof Protos.Value.Range)) break block7;
                                    Protos.Value.Range range = (Protos.Value.Range)rangeValue;
                                    NumericRange.Inclusive offerRange = new RichLong(Predef$.MODULE$.longWrapper(range.getBegin())).to((Object)BoxesRunTime.boxToLong((long)range.getEnd()));
                                    bl = ((IterableLike)requiredValues.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(String x$8) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, offerRange){
                                        public static final long serialVersionUID = 0L;
                                        private final NumericRange.Inclusive offerRange$1;

                                        public final boolean apply(long x$9) {
                                            return this.apply$mcZJ$sp(x$9);
                                        }

                                        public boolean apply$mcZJ$sp(long x$9) {
                                            return this.offerRange$1.contains((Object)BoxesRunTime.boxToLong((long)x$9));
                                        }
                                        {
                                            this.offerRange$1 = offerRange$1;
                                        }
                                    });
                                    break block4;
                                }
                                if (!bl2 || !((offeredValue = (GeneratedMessageV3)some.x()) instanceof Protos.Value.Set)) break block8;
                                Protos.Value.Set set = (Protos.Value.Set)offeredValue;
                                bl = requiredValues.subsetOf((GenSet)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)set.getItemList()).asScala()).toSet());
                                break block4;
                            }
                            if (!bl2 || !((textValue = (GeneratedMessageV3)some.x()) instanceof Protos.Value.Text)) break block9;
                            Protos.Value.Text text = (Protos.Value.Text)textValue;
                            bl = requiredValues.contains((Object)text.getValue());
                        }
                        boolean bl3 = bl;
                        return bl3;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.offerAttributes$2 = offerAttributes$2;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map parseConstraintString(MesosSchedulerUtils $this, String constraintsVal) {
        Map map;
        Splitter.MapSplitter splitter = Splitter.on((char)';').trimResults().withKeyValueSeparator(':');
        if (constraintsVal.isEmpty()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            return map;
        }
        try {
            map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(splitter.split((CharSequence)constraintsVal)).asScala()).toMap(Predef$.MODULE$.$conforms()).mapValues((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(String v) {
                    return v == null || v.isEmpty() ? Predef$.MODULE$.Set().empty() : Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(v)).split(',')).toSet();
                }
            });
            return map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad constraint string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{constraintsVal})), e);
        }
    }

    public static int executorMemory(MesosSchedulerUtils $this, SparkContext sc) {
        return sc.conf().getInt("spark.mesos.executor.memoryOverhead", (int)package$.MODULE$.max($this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_FRACTION() * (double)sc.executorMemory(), (double)$this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_MINIMUM())) + sc.executorMemory();
    }

    public static void setupUris(MesosSchedulerUtils $this, String uris, Protos.CommandInfo.Builder builder, boolean useFetcherCache) {
        Predef$.MODULE$.refArrayOps((Object[])uris.split(",")).foreach((Function1)new Serializable($this, builder, useFetcherCache){
            public static final long serialVersionUID = 0L;
            private final Protos.CommandInfo.Builder builder$4;
            private final boolean useFetcherCache$1;

            public final Protos.CommandInfo.Builder apply(String uri) {
                return this.builder$4.addUris(Protos.CommandInfo.URI.newBuilder().setValue(uri.trim()).setCache(this.useFetcherCache$1));
            }
            {
                this.builder$4 = builder$4;
                this.useFetcherCache$1 = useFetcherCache$1;
            }
        });
    }

    public static boolean setupUris$default$3(MesosSchedulerUtils $this) {
        return false;
    }

    private static String getRejectOfferDurationStr(MesosSchedulerUtils $this, SparkConf conf) {
        return conf.get("spark.mesos.rejectOfferDuration", "120s");
    }

    public static long getRejectOfferDuration(MesosSchedulerUtils $this, SparkConf conf) {
        return Utils$.MODULE$.timeStringAsSeconds(MesosSchedulerUtils$class.getRejectOfferDurationStr($this, conf));
    }

    public static long getRejectOfferDurationForUnmetConstraints(MesosSchedulerUtils $this, SparkConf conf) {
        return conf.getTimeAsSeconds("spark.mesos.rejectOfferDurationForUnmetConstraints", MesosSchedulerUtils$class.getRejectOfferDurationStr($this, conf));
    }

    public static long getRejectOfferDurationForReachedMaxCores(MesosSchedulerUtils $this, SparkConf conf) {
        return conf.getTimeAsSeconds("spark.mesos.rejectOfferDurationForReachedMaxCores", MesosSchedulerUtils$class.getRejectOfferDurationStr($this, conf));
    }

    public static boolean checkPorts(MesosSchedulerUtils $this, SparkConf conf, List ports) {
        List<Object> portsToCheck = $this.nonZeroPortValuesFromConfig(conf);
        boolean withinRange = portsToCheck.forall((Function1)new Serializable($this, ports){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;
            private final List ports$2;

            public final boolean apply(long p) {
                return this.apply$mcZJ$sp(p);
            }

            public boolean apply$mcZJ$sp(long p) {
                return MesosSchedulerUtils$class.checkIfInRange$1(this.$outer, p, this.ports$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ports$2 = ports$2;
            }
        });
        boolean enoughPorts = BoxesRunTime.unboxToLong((Object)((TraversableOnce)ports.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    long rangeStart = tuple2._1$mcJ$sp();
                    long rangeEnd = tuple2._2$mcJ$sp();
                    long l = rangeEnd - rangeStart + 1L;
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) >= (long)portsToCheck.size();
        return enoughPorts && withinRange;
    }

    public static Tuple2 partitionPortResources(MesosSchedulerUtils $this, List requestedPorts, List offeredResources) {
        Tuple2 tuple2;
        block4: {
            Tuple2 tuple22;
            block3: {
                Tuple2 tuple23;
                block2: {
                    if (!requestedPorts.isEmpty()) break block2;
                    tuple22 = new Tuple2((Object)offeredResources, (Object)Nil$.MODULE$);
                    break block3;
                }
                tuple2 = MesosSchedulerUtils$class.filterPortResources($this, offeredResources);
                if (tuple2 == null) break block4;
                List resourcesWithoutPorts = (List)tuple2._1();
                List portResources = (List)tuple2._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)resourcesWithoutPorts, (Object)portResources);
                List resourcesWithoutPorts2 = (List)tuple24._1();
                List portResources2 = (List)tuple24._2();
                List portsAndResourceInfo = (List)requestedPorts.map((Function1)new Serializable($this, portResources2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MesosSchedulerUtils $outer;
                    private final List portResources$1;

                    public final Tuple2<Object, MesosSchedulerUtils.RoleResourceInfo> apply(long x) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)x), (Object)MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$findPortAndGetAssignedResourceInfo(this.$outer, x, this.portResources$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.portResources$1 = portResources$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                List assignedPortResources = MesosSchedulerUtils$class.createResourcesFromPorts($this, portsAndResourceInfo);
                tuple22 = new Tuple2((Object)resourcesWithoutPorts2, (Object)assignedPortResources);
            }
            return tuple22;
        }
        throw new MatchError((Object)tuple2);
    }

    public static List nonZeroPortValuesFromConfig(MesosSchedulerUtils $this, SparkConf conf) {
        return (List)((TraversableLike)$this.managedPortNames().map((Function1)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$2;

            public final long apply(String x$11) {
                return this.conf$2.getLong(x$11, 0L);
            }
            {
                this.conf$2 = conf$2;
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$12) {
                return this.apply$mcZJ$sp(x$12);
            }

            public boolean apply$mcZJ$sp(long x$12) {
                return x$12 != 0L;
            }
        });
    }

    private static List createResourcesFromPorts(MesosSchedulerUtils $this, List portsAndResourcesInfo) {
        return (List)portsAndResourcesInfo.flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;

            public final List<Protos.Resource> apply(Tuple2<Object, MesosSchedulerUtils.RoleResourceInfo> x0$5) {
                Tuple2<Object, MesosSchedulerUtils.RoleResourceInfo> tuple2 = x0$5;
                if (tuple2 != null) {
                    long port = tuple2._1$mcJ$sp();
                    MesosSchedulerUtils.RoleResourceInfo rInfo = (MesosSchedulerUtils.RoleResourceInfo)tuple2._2();
                    List list = MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$createMesosPortResource(this.$outer, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(port, port)})), Option$.MODULE$.apply((Object)rInfo.role()), rInfo.resInfo());
                    return list;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static List org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$createMesosPortResource(MesosSchedulerUtils $this, List ranges, Option role, Option reservationInfo) {
        return (List)ranges.map((Function1)new Serializable($this, role, reservationInfo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;
            private final Option role$1;
            private final Option reservationInfo$1;

            public final Protos.Resource apply(Tuple2<Object, Object> x0$6) {
                Tuple2<Object, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    long rangeStart = tuple2._1$mcJ$sp();
                    long rangeEnd = tuple2._2$mcJ$sp();
                    Protos.Value.Range.Builder rangeValue = Protos.Value.Range.newBuilder().setBegin(rangeStart).setEnd(rangeEnd);
                    Protos.Resource.Builder builder = Protos.Resource.newBuilder().setName("ports").setType(Protos.Value.Type.RANGES).setRanges(Protos.Value.Ranges.newBuilder().addRange(rangeValue));
                    this.role$1.foreach((Function1)new Serializable(this, builder){
                        public static final long serialVersionUID = 0L;
                        private final Protos.Resource.Builder builder$3;

                        public final Protos.Resource.Builder apply(String r) {
                            return this.builder$3.setRole(r);
                        }
                        {
                            this.builder$3 = builder$3;
                        }
                    });
                    MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$setReservationInfo(this.$outer, this.reservationInfo$1, this.role$1, builder);
                    Protos.Resource resource = builder.build();
                    return resource;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.role$1 = role$1;
                this.reservationInfo$1 = reservationInfo$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private static Option createMesosPortResource$default$2(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    private static Option createMesosPortResource$default$3(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static MesosSchedulerUtils.RoleResourceInfo org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$findPortAndGetAssignedResourceInfo(MesosSchedulerUtils $this, long port, List portResources) {
        List ranges = (List)portResources.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;

            public final Tuple2<MesosSchedulerUtils.RoleResourceInfo, List<Tuple2<Object, Object>>> apply(Protos.Resource resource) {
                Option reservation = MesosSchedulerUtils$class.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$getReservation(this.$outer, resource);
                return new Tuple2((Object)this.$outer.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$RoleResourceInfo().apply(resource.getRole(), (Option<Protos.Resource.ReservationInfo>)reservation), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(resource.getRanges().getRangeList()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Protos.Value.Range r) {
                        return new Tuple2.mcJJ.sp(r.getBegin(), r.getEnd());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toList());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Option rangePortResourceInfo = ranges.find((Function1)new Serializable($this, port){
            public static final long serialVersionUID = 0L;
            public final long port$2;

            public final boolean apply(Tuple2<MesosSchedulerUtils.RoleResourceInfo, List<Tuple2<Object, Object>>> x0$7) {
                Tuple2<MesosSchedulerUtils.RoleResourceInfo, List<Tuple2<Object, Object>>> tuple2 = x0$7;
                if (tuple2 != null) {
                    List rangeList = (List)tuple2._2();
                    boolean bl = rangeList.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MesosSchedulerUtils$.anonfun.7 $outer;

                        public final boolean apply(Tuple2<Object, Object> x0$8) {
                            Tuple2<Object, Object> tuple2 = x0$8;
                            if (tuple2 != null) {
                                long rangeStart = tuple2._1$mcJ$sp();
                                long rangeEnd = tuple2._2$mcJ$sp();
                                boolean bl = rangeStart <= this.$outer.port$2 & rangeEnd >= this.$outer.port$2;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.port$2 = port$2;
            }
        });
        return (MesosSchedulerUtils.RoleResourceInfo)rangePortResourceInfo.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final MesosSchedulerUtils.RoleResourceInfo apply(Tuple2<MesosSchedulerUtils.RoleResourceInfo, List<Tuple2<Object, Object>>> x0$9) {
                Tuple2<MesosSchedulerUtils.RoleResourceInfo, List<Tuple2<Object, Object>>> tuple2 = x0$9;
                if (tuple2 != null) {
                    MesosSchedulerUtils.RoleResourceInfo resourceInfo;
                    MesosSchedulerUtils.RoleResourceInfo roleResourceInfo = resourceInfo = (MesosSchedulerUtils.RoleResourceInfo)tuple2._1();
                    return roleResourceInfo;
                }
                throw new MatchError(tuple2);
            }
        }).get();
    }

    private static Tuple2 filterPortResources(MesosSchedulerUtils $this, List resources) {
        return resources.partition((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Protos.Resource r) {
                Protos.Value.Type type = r.getType();
                Protos.Value.Type type2 = Protos.Value.Type.RANGES;
                if (type == null) {
                    if (type2 != null) {
                        return true;
                    }
                } else if (!type.equals(type2)) return true;
                String string = r.getName();
                String string2 = "ports";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else {
                    if (!string.equals(string2)) return true;
                    return false;
                }
            }
        });
    }

    public static void unsetFrameworkID(MesosSchedulerUtils $this, SparkContext sc) {
        sc.conf().remove("spark.mesos.driver.frameworkId");
        System.clearProperty("spark.mesos.driver.frameworkId");
    }

    public static Enumeration.Value mesosToTaskState(MesosSchedulerUtils $this, Protos.TaskState state) {
        Protos.TaskState taskState;
        block8: {
            Enumeration.Value value;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    taskState = state;
                                    boolean bl = Protos.TaskState.TASK_STAGING.equals(taskState) ? true : Protos.TaskState.TASK_STARTING.equals(taskState);
                                    if (!bl) break block2;
                                    value = TaskState$.MODULE$.LAUNCHING();
                                    break block3;
                                }
                                boolean bl = Protos.TaskState.TASK_RUNNING.equals(taskState) ? true : Protos.TaskState.TASK_KILLING.equals(taskState);
                                if (!bl) break block4;
                                value = TaskState$.MODULE$.RUNNING();
                                break block3;
                            }
                            if (!Protos.TaskState.TASK_FINISHED.equals(taskState)) break block5;
                            value = TaskState$.MODULE$.FINISHED();
                            break block3;
                        }
                        boolean bl = Protos.TaskState.TASK_FAILED.equals(taskState) ? true : (Protos.TaskState.TASK_GONE.equals(taskState) ? true : Protos.TaskState.TASK_GONE_BY_OPERATOR.equals(taskState));
                        if (!bl) break block6;
                        value = TaskState$.MODULE$.FAILED();
                        break block3;
                    }
                    if (!Protos.TaskState.TASK_KILLED.equals(taskState)) break block7;
                    value = TaskState$.MODULE$.KILLED();
                    break block3;
                }
                boolean bl = Protos.TaskState.TASK_LOST.equals(taskState) ? true : (Protos.TaskState.TASK_ERROR.equals(taskState) ? true : (Protos.TaskState.TASK_DROPPED.equals(taskState) ? true : (Protos.TaskState.TASK_UNKNOWN.equals(taskState) ? true : Protos.TaskState.TASK_UNREACHABLE.equals(taskState))));
                if (!bl) break block8;
                value = TaskState$.MODULE$.LOST();
            }
            return value;
        }
        throw new MatchError((Object)taskState);
    }

    public static Protos.TaskState taskStateToMesos(MesosSchedulerUtils $this, Enumeration.Value state) {
        Enumeration.Value value;
        block8: {
            Protos.TaskState taskState;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    value = state;
                                    Enumeration.Value value2 = TaskState$.MODULE$.LAUNCHING();
                                    Enumeration.Value value3 = value;
                                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                    taskState = Protos.TaskState.TASK_STARTING;
                                    break block3;
                                }
                                Enumeration.Value value4 = TaskState$.MODULE$.RUNNING();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                                taskState = Protos.TaskState.TASK_RUNNING;
                                break block3;
                            }
                            Enumeration.Value value6 = TaskState$.MODULE$.FINISHED();
                            Enumeration.Value value7 = value;
                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                            taskState = Protos.TaskState.TASK_FINISHED;
                            break block3;
                        }
                        Enumeration.Value value8 = TaskState$.MODULE$.FAILED();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                        taskState = Protos.TaskState.TASK_FAILED;
                        break block3;
                    }
                    Enumeration.Value value10 = TaskState$.MODULE$.KILLED();
                    Enumeration.Value value11 = value;
                    if (value10 != null ? !value10.equals(value11) : value11 != null) break block7;
                    taskState = Protos.TaskState.TASK_KILLED;
                    break block3;
                }
                Enumeration.Value value12 = TaskState$.MODULE$.LOST();
                Enumeration.Value value13 = value;
                if (value12 != null ? !value12.equals(value13) : value13 != null) break block8;
                taskState = Protos.TaskState.TASK_LOST;
            }
            return taskState;
        }
        throw new MatchError((Object)value);
    }

    public static void declineOffer(MesosSchedulerUtils $this, SchedulerDriver driver, Protos.Offer offer, Option reason, Option refuseSeconds) {
        String id = offer.getId().getValue();
        Map<String, GeneratedMessageV3> offerAttributes = $this.toAttributeMap(offer.getAttributesList());
        double mem = $this.getResource(offer.getResourcesList(), "mem");
        double cpus = $this.getResource(offer.getResourcesList(), "cpus");
        List<Tuple2<Object, Object>> ports = $this.getRangeResource(offer.getResourcesList(), "ports");
        $this.logDebug((Function0)new Serializable($this, id, offerAttributes, mem, cpus, ports, reason, refuseSeconds){
            public static final long serialVersionUID = 0L;
            private final String id$1;
            private final Map offerAttributes$1;
            private final double mem$1;
            private final double cpus$1;
            private final List ports$1;
            private final Option reason$1;
            private final Option refuseSeconds$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Declining offer: ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attributes: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offerAttributes$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mem: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mem$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cpu: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.cpus$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"port: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ports$1}))).append(this.refuseSeconds$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long s) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for ", " seconds "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)s)}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).append(this.reason$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String r) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (reason: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).toString();
            }
            {
                this.id$1 = id$1;
                this.offerAttributes$1 = offerAttributes$1;
                this.mem$1 = mem$1;
                this.cpus$1 = cpus$1;
                this.ports$1 = ports$1;
                this.reason$1 = reason$1;
                this.refuseSeconds$1 = refuseSeconds$1;
            }
        });
        Option option = refuseSeconds;
        if (option instanceof Some) {
            Some some = (Some)option;
            long seconds = BoxesRunTime.unboxToLong((Object)some.x());
            Protos.Filters filters = Protos.Filters.newBuilder().setRefuseSeconds((double)seconds).build();
            driver.declineOffer(offer.getId(), filters);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            driver.declineOffer(offer.getId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static Option declineOffer$default$3(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option declineOffer$default$4(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static final boolean checkIfInRange$1(MesosSchedulerUtils $this, long port, List ps) {
        return ps.exists((Function1)new Serializable($this, port){
            public static final long serialVersionUID = 0L;
            private final long port$1;

            public final boolean apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    long rangeStart = tuple2._1$mcJ$sp();
                    long rangeEnd = tuple2._2$mcJ$sp();
                    boolean bl = rangeStart <= this.port$1 & rangeEnd >= this.port$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.port$1 = port$1;
            }
        });
    }

    public static void $init$(MesosSchedulerUtils $this) {
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch_$eq(new CountDownLatch(1));
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_FRACTION_$eq(0.1);
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_MINIMUM_$eq(384);
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$managedPortNames_$eq(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{org.apache.spark.internal.config.package$.MODULE$.BLOCK_MANAGER_PORT().key()})));
    }
}

