/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.InitContainerBootstrap;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.MountSecretsBootstrap;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodFactory;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterManager$;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001M3Q!\u0001\u0002\u0001\u00119\u0011\u0001dS;cKJtW\r^3t\u00072,8\u000f^3s\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002lqMT!!\u0002\u0004\u0002\u000f\rdWo\u001d;fe*\u0011q\u0001C\u0001\ng\u000eDW\rZ;mKJT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)\u0012\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011AB\u0005\u00031\u0019\u0011a#\u0012=uKJt\u0017\r\\\"mkN$XM]'b]\u0006<WM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!\u0001\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\u0014\u0001\t\u0003:\u0013!C2b]\u000e\u0013X-\u0019;f)\tA3\u0006\u0005\u0002\u0011S%\u0011!&\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015aS\u00051\u0001.\u0003%i\u0017m\u001d;feV\u0013F\n\u0005\u0002/c9\u0011\u0001cL\u0005\u0003aE\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\u0005\u0005\u0006k\u0001!\tEN\u0001\u0014GJ,\u0017\r^3UCN\\7k\u00195fIVdWM\u001d\u000b\u0004oi\u0002\u0005C\u0001\f9\u0013\tIdAA\u0007UCN\\7k\u00195fIVdWM\u001d\u0005\u0006wQ\u0002\r\u0001P\u0001\u0003g\u000e\u0004\"!\u0010 \u000e\u0003!I!a\u0010\u0005\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000b1\"\u0004\u0019A\u0017\t\u000b\t\u0003A\u0011I\"\u0002-\r\u0014X-\u0019;f'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012$B\u0001R$I\u0013B\u0011a#R\u0005\u0003\r\u001a\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\t\u000bm\n\u0005\u0019\u0001\u001f\t\u000b1\n\u0005\u0019A\u0017\t\u000b\u001d\t\u0005\u0019A\u001c\t\u000b-\u0003A\u0011\t'\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002N!F\u0003\"\u0001\u0005(\n\u0005=\u000b\"\u0001B+oSRDQa\u0002&A\u0002]BQA\u0015&A\u0002\u0011\u000bqAY1dW\u0016tG\r")
public class KubernetesClusterManager
implements ExternalClusterManager,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("k8s");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        if (masterURL.startsWith("k8s")) {
            String string = sc.deployMode();
            String string2 = "client";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new SparkException("Client mode is currently not supported for Kubernetes.");
            }
        }
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        SparkConf sparkConf = sc.getConf();
        Option initContainerConfigMap = (Option)sparkConf.get(Config$.MODULE$.INIT_CONTAINER_CONFIG_MAP_NAME());
        Option initContainerConfigMapKey = (Option)sparkConf.get(Config$.MODULE$.INIT_CONTAINER_CONFIG_MAP_KEY_CONF());
        if (initContainerConfigMap.isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The executor's init-container config map is not specified. Executors will therefore not attempt to fetch remote or submitted dependencies.";
                }
            });
        }
        if (initContainerConfigMapKey.isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The executor's init-container config map key is not specified. Executors will therefore not attempt to fetch remote or submitted dependencies.";
                }
            });
        }
        Option initContainerBootstrap = initContainerConfigMap.flatMap((Function1)new Serializable(this, sparkConf, initContainerConfigMapKey){
            public static final long serialVersionUID = 0L;
            public final SparkConf sparkConf$1;
            private final Option initContainerConfigMapKey$1;

            public final Option<InitContainerBootstrap> apply(String configMap) {
                return this.initContainerConfigMapKey$1.map((Function1)new Serializable(this, configMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final String configMap$1;

                    public final InitContainerBootstrap apply(String configMapKey) {
                        String initContainerImage = (String)((Option)this.$outer.sparkConf$1.get(Config$.MODULE$.INIT_CONTAINER_IMAGE())).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Nothing$ apply() {
                                throw new SparkException("Must specify the init-container image when there are remote dependencies");
                            }
                        });
                        return new InitContainerBootstrap(initContainerImage, (String)this.$outer.sparkConf$1.get(Config$.MODULE$.CONTAINER_IMAGE_PULL_POLICY()), (String)this.$outer.sparkConf$1.get(Config$.MODULE$.JARS_DOWNLOAD_LOCATION()), (String)this.$outer.sparkConf$1.get(Config$.MODULE$.FILES_DOWNLOAD_LOCATION()), this.configMap$1, configMapKey, Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE(), this.$outer.sparkConf$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.configMap$1 = configMap$1;
                    }
                });
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.initContainerConfigMapKey$1 = initContainerConfigMapKey$1;
            }
        });
        Map<String, String> executorSecretNamesToMountPaths = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
        None$ mountSecretBootstrap = executorSecretNamesToMountPaths.nonEmpty() ? new Some((Object)new MountSecretsBootstrap(executorSecretNamesToMountPaths)) : None$.MODULE$;
        None$ initContainerMountSecretsBootstrap = initContainerBootstrap.nonEmpty() && executorSecretNamesToMountPaths.nonEmpty() ? new Some((Object)new MountSecretsBootstrap(executorSecretNamesToMountPaths)) : None$.MODULE$;
        KubernetesClient kubernetesClient = SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(Constants$.MODULE$.KUBERNETES_MASTER_INTERNAL_URL(), (Option<String>)new Some(sparkConf.get(Config$.MODULE$.KUBERNETES_NAMESPACE())), Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), sparkConf, (Option<File>)new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/token")), (Option<File>)new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")));
        ExecutorPodFactory executorPodFactory = new ExecutorPodFactory(sparkConf, (Option<MountSecretsBootstrap>)mountSecretBootstrap, (Option<InitContainerBootstrap>)initContainerBootstrap, (Option<MountSecretsBootstrap>)initContainerMountSecretsBootstrap);
        ScheduledExecutorService allocatorExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-pod-allocator");
        ThreadPoolExecutor requestExecutorsService = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-executor-requests");
        return new KubernetesClusterSchedulerBackend((TaskSchedulerImpl)scheduler, sc.env().rpcEnv(), executorPodFactory, kubernetesClient, allocatorExecutor, requestExecutorsService);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }

    public KubernetesClusterManager() {
        Logging.class.$init$((Logging)this);
    }
}

