/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.util.Collection;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.InitContainerBootstrap;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.MountSecretsBootstrap;
import org.apache.spark.deploy.k8s.PodWithDetachedInitContainer;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0001!q!AE#yK\u000e,Ho\u001c:Q_\u00124\u0015m\u0019;pefT!a\u0001\u0003\u0002\u0007-D4O\u0003\u0002\u0006\r\u000591\r\\;ti\u0016\u0014(BA\u0004\t\u0003%\u00198\r[3ek2,'O\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\t\u0001q\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\t-\u0001\u0011\t\u0011)A\u00051\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\tI\"$D\u0001\t\u0013\tY\u0002BA\u0005Ta\u0006\u00148nQ8oM\"AQ\u0004\u0001B\u0001B\u0003%a$A\u000bn_VtGoU3de\u0016$8OQ8piN$(/\u00199\u0011\u0007Ay\u0012%\u0003\u0002!#\t1q\n\u001d;j_:\u0004\"A\t\u0014\u000e\u0003\rR!a\u0001\u0013\u000b\u0005\u0015B\u0011A\u00023fa2|\u00170\u0003\u0002(G\t)Rj\\;oiN+7M]3ug\n{w\u000e^:ue\u0006\u0004\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002-%t\u0017\u000e^\"p]R\f\u0017N\\3s\u0005>|Go\u001d;sCB\u00042\u0001E\u0010,!\t\u0011C&\u0003\u0002.G\t1\u0012J\\5u\u0007>tG/Y5oKJ\u0014un\u001c;tiJ\f\u0007\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\tJg.\u001b;D_:$\u0018-\u001b8fe6{WO\u001c;TK\u000e\u0014X\r^:C_>$8\u000f\u001e:ba\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"RaM\u001b7oa\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQA\u0006\u0019A\u0002aAQ!\b\u0019A\u0002yAQ!\u000b\u0019A\u0002)BQa\f\u0019A\u0002yAqA\u000f\u0001C\u0002\u0013%1(\u0001\ffq\u0016\u001cW\u000f^8s\u000bb$(/Y\"mCN\u001c\b/\u0019;i+\u0005a\u0004c\u0001\t {A\u0011a(\u0011\b\u0003!}J!\u0001Q\t\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001FAa!\u0012\u0001!\u0002\u0013a\u0014aF3yK\u000e,Ho\u001c:FqR\u0014\u0018m\u00117bgN\u0004\u0018\r\u001e5!\u0011\u001d9\u0005A1A\u0005\n!\u000ba\"\u001a=fGV$xN\u001d'bE\u0016d7/F\u0001J!\u0011q$*P\u001f\n\u0005-\u001b%aA'ba\"1Q\n\u0001Q\u0001\n%\u000bq\"\u001a=fGV$xN\u001d'bE\u0016d7\u000f\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003I\u0003M)\u00070Z2vi>\u0014\u0018I\u001c8pi\u0006$\u0018n\u001c8t\u0011\u0019\t\u0006\u0001)A\u0005\u0013\u0006!R\r_3dkR|'/\u00118o_R\fG/[8og\u0002Bqa\u0015\u0001C\u0002\u0013%\u0001*\u0001\u0007o_\u0012,7+\u001a7fGR|'\u000f\u0003\u0004V\u0001\u0001\u0006I!S\u0001\u000e]>$WmU3mK\u000e$xN\u001d\u0011\t\u000f]\u0003!\u0019!C\u00051\u00061R\r_3dkR|'oQ8oi\u0006Lg.\u001a:J[\u0006<W-F\u0001>\u0011\u0019Q\u0006\u0001)A\u0005{\u00059R\r_3dkR|'oQ8oi\u0006Lg.\u001a:J[\u0006<W\r\t\u0005\b9\u0002\u0011\r\u0011\"\u0003Y\u0003=IW.Y4f!VdG\u000eU8mS\u000eL\bB\u00020\u0001A\u0003%Q(\u0001\tj[\u0006<W\rU;mYB{G.[2zA!9\u0001\r\u0001b\u0001\n\u0013\t\u0017\u0001\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:u+\u0005\u0011\u0007C\u0001\td\u0013\t!\u0017CA\u0002J]RDaA\u001a\u0001!\u0002\u0013\u0011\u0017!\u00052m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:uA!9\u0001\u000e\u0001b\u0001\n\u0013A\u0016!F3yK\u000e,Ho\u001c:Q_\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0005\u0007U\u0002\u0001\u000b\u0011B\u001f\u0002-\u0015DXmY;u_J\u0004v\u000e\u001a(b[\u0016\u0004&/\u001a4jq\u0002Bq\u0001\u001c\u0001C\u0002\u0013%Q.A\tfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=NS\n+\u0012A\u001c\t\u0003!=L!\u0001]\t\u0003\t1{gn\u001a\u0005\u0007e\u0002\u0001\u000b\u0011\u00028\u0002%\u0015DXmY;u_JlU-\\8ss6K'\t\t\u0005\bi\u0002\u0011\r\u0011\"\u0003Y\u0003Q)\u00070Z2vi>\u0014X*Z7pef\u001cFO]5oO\"1a\u000f\u0001Q\u0001\nu\nQ#\u001a=fGV$xN]'f[>\u0014\u0018p\u0015;sS:<\u0007\u0005C\u0004y\u0001\t\u0007I\u0011B7\u0002#5,Wn\u001c:z\u001fZ,'\u000f[3bI6K'\t\u0003\u0004{\u0001\u0001\u0006IA\\\u0001\u0013[\u0016lwN]=Pm\u0016\u0014\b.Z1e\u001b&\u0014\u0005\u0005C\u0004}\u0001\t\u0007I\u0011B7\u00025\u0015DXmY;u_JlU-\\8ss^KG\u000f[(wKJDW-\u00193\t\ry\u0004\u0001\u0015!\u0003o\u0003m)\u00070Z2vi>\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1eA!I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111A\u0001\u000eKb,7-\u001e;pe\u000e{'/Z:\u0016\u0005\u0005\u0015\u0001c\u0001\t\u0002\b%\u0019\u0011\u0011B\t\u0003\r\u0011{WO\u00197f\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0015\u0011AD3yK\u000e,Ho\u001c:D_J,7\u000f\t\u0005\t\u0003#\u0001!\u0019!C\u0005w\u0005\u0011R\r_3dkR|'\u000fT5nSR\u001cuN]3t\u0011\u001d\t)\u0002\u0001Q\u0001\nq\n1#\u001a=fGV$xN\u001d'j[&$8i\u001c:fg\u0002B\u0001\"!\u0007\u0001\u0005\u0004%I\u0001W\u0001\u0018Kb,7-\u001e;pe*\u000b'o\u001d#po:dw.\u00193ESJDq!!\b\u0001A\u0003%Q(\u0001\rfq\u0016\u001cW\u000f^8s\u0015\u0006\u00148\u000fR8x]2|\u0017\r\u001a#je\u0002Bq!!\t\u0001\t\u0003\t\u0019#A\tde\u0016\fG/Z#yK\u000e,Ho\u001c:Q_\u0012$b\"!\n\u0002B\u0005\u0015\u0013\u0011JA'\u0003_\n\u0019\b\u0005\u0003\u0002(\u0005uRBAA\u0015\u0015\u0011\tY#!\f\u0002\u000b5|G-\u001a7\u000b\t\u0005=\u0012\u0011G\u0001\u0004CBL'\u0002BA\u001a\u0003k\t!b[;cKJtW\r^3t\u0015\u0011\t9$!\u000f\u0002\u000f\u0019\f'M]5dq)\u0011\u00111H\u0001\u0003S>LA!a\u0010\u0002*\t\u0019\u0001k\u001c3\t\u000f\u0005\r\u0013q\u0004a\u0001{\u0005QQ\r_3dkR|'/\u00133\t\u000f\u0005\u001d\u0013q\u0004a\u0001{\u0005i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012Dq!a\u0013\u0002 \u0001\u0007Q(A\u0005ee&4XM]+sY\"A\u0011qJA\u0010\u0001\u0004\t\t&\u0001\u0007fq\u0016\u001cW\u000f^8s\u000b:48\u000f\u0005\u0004\u0002T\u0005\r\u0014\u0011\u000e\b\u0005\u0003+\nyF\u0004\u0003\u0002X\u0005uSBAA-\u0015\r\tYfF\u0001\u0007yI|w\u000e\u001e \n\u0003II1!!\u0019\u0012\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\t\u00191+Z9\u000b\u0007\u0005\u0005\u0014\u0003E\u0003\u0011\u0003WjT(C\u0002\u0002nE\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CA9\u0003?\u0001\r!!\n\u0002\u0013\u0011\u0014\u0018N^3s!>$\u0007\u0002CA;\u0003?\u0001\r!a\u001e\u0002)9|G-\u001a+p\u0019>\u001c\u0017\r\u001c+bg.\u001cu.\u001e8u!\u0011q$*\u00102")
public class ExecutorPodFactory {
    private final SparkConf sparkConf;
    private final Option<MountSecretsBootstrap> mountSecretsBootstrap;
    private final Option<InitContainerBootstrap> initContainerBootstrap;
    public final Option<MountSecretsBootstrap> org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$initContainerMountSecretsBootstrap;
    private final Option<String> executorExtraClasspath;
    private final scala.collection.immutable.Map<String, String> executorLabels;
    private final scala.collection.immutable.Map<String, String> executorAnnotations;
    private final scala.collection.immutable.Map<String, String> nodeSelector;
    private final String executorContainerImage;
    private final String imagePullPolicy;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final long org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB;
    private final String executorMemoryString;
    private final long memoryOverheadMiB;
    private final long executorMemoryWithOverhead;
    private final double executorCores;
    private final Option<String> executorLimitCores;
    private final String executorJarsDownloadDir;

    private Option<String> executorExtraClasspath() {
        return this.executorExtraClasspath;
    }

    private scala.collection.immutable.Map<String, String> executorLabels() {
        return this.executorLabels;
    }

    private scala.collection.immutable.Map<String, String> executorAnnotations() {
        return this.executorAnnotations;
    }

    private scala.collection.immutable.Map<String, String> nodeSelector() {
        return this.nodeSelector;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private String imagePullPolicy() {
        return this.imagePullPolicy;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    public long org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB() {
        return this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    private long executorMemoryWithOverhead() {
        return this.executorMemoryWithOverhead;
    }

    private double executorCores() {
        return this.executorCores;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    private String executorJarsDownloadDir() {
        return this.executorJarsDownloadDir;
    }

    public Pod createExecutorPod(String executorId, String applicationId, String driverUrl, Seq<Tuple2<String, String>> executorEnvs, Pod driverPod, scala.collection.immutable.Map<String, Object> nodeToLocalTaskCount) {
        Container containerWithLimitCores;
        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-exec-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorPodNamePrefix(), executorId}));
        String hostname = name.substring(Math.max(0, name.length() - 63));
        scala.collection.immutable.Map resolvedExecutorLabels = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)executorId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)applicationId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}))).$plus$plus(this.executorLabels());
        Quantity executorMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Mi"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB())})))).build();
        Quantity executorMemoryLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Mi"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.executorMemoryWithOverhead())})))).build();
        Quantity executorCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(((Object)BoxesRunTime.boxToDouble((double)this.executorCores())).toString())).build();
        Option executorExtraClasspathEnv = this.executorExtraClasspath().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(String cp) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build();
            }
        });
        Seq executorExtraJavaOptionsEnv = (Seq)((Option)this.sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<EnvVar> apply(String opts) {
                Seq delimitedOpts = Utils$.MODULE$.splitCommandString(opts);
                return (Seq)((TraversableLike)delimitedOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final EnvVar apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String opt = (String)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.ENV_JAVA_OPT_PREFIX(), BoxesRunTime.boxToInteger((int)index)})))).withValue(opt)).build();
                            return envVar;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<EnvVar> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        Seq executorEnv = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)driverUrl), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)((Object)BoxesRunTime.boxToInteger((int)((int)package$.MODULE$.ceil(this.executorCores())))).toString()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)applicationId), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)executorId), new Tuple2((Object)Constants$.MODULE$.ENV_MOUNTED_CLASSPATH(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorJarsDownloadDir()})))}))).$plus$plus(executorEnvs, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(Tuple2<String, String> env) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build();
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)executorExtraJavaOptionsEnv, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(executorExtraClasspathEnv).toSeq(), Seq$.MODULE$.canBuildFrom());
        Seq requiredPorts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ContainerPort apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
                    return containerPort;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder().withName("executor")).withImage(this.executorContainerImage())).withImagePullPolicy(this.imagePullPolicy())).withNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryLimitQuantity).addToRequests("cpu", executorCpuQuantity)).endResources()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter(requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Pod executorPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new PodBuilder().withNewMetadata().withName(name).withLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)resolvedExecutorLabels).asJava()).withAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.executorAnnotations()).asJava()).withOwnerReferences(new OwnerReference[0]).addNewOwnerReference().withController(Predef$.MODULE$.boolean2Boolean(true)).withApiVersion(driverPod.getApiVersion()).withKind(driverPod.getKind()).withName(driverPod.getMetadata().getName()).withUid(driverPod.getMetadata().getUid())).endOwnerReference()).endMetadata()).withNewSpec().withHostname(hostname).withRestartPolicy("Never").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.nodeSelector()).asJava())).endSpec()).build();
        Tuple2 tuple2 = (Tuple2)this.mountSecretsBootstrap.map((Function1)new Serializable(this, executorPod, containerWithLimitCores = (Container)this.executorLimitCores().map((Function1)new Serializable(this, executorContainer){
            public static final long serialVersionUID = 0L;
            private final Container executorContainer$1;

            public final Container apply(String limitCores) {
                Quantity executorCpuLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build();
                return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(this.executorContainer$1).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
            }
            {
                this.executorContainer$1 = executorContainer$1;
            }
        }).getOrElse((Function0)new Serializable(this, executorContainer){
            public static final long serialVersionUID = 0L;
            private final Container executorContainer$1;

            public final Container apply() {
                return this.executorContainer$1;
            }
            {
                this.executorContainer$1 = executorContainer$1;
            }
        })){
            public static final long serialVersionUID = 0L;
            private final Pod executorPod$1;
            private final Container containerWithLimitCores$1;

            public final Tuple2<Pod, Container> apply(MountSecretsBootstrap bootstrap) {
                return new Tuple2((Object)bootstrap.addSecretVolumes(this.executorPod$1), (Object)bootstrap.mountSecrets(this.containerWithLimitCores$1));
            }
            {
                this.executorPod$1 = executorPod$1;
                this.containerWithLimitCores$1 = containerWithLimitCores$1;
            }
        }).getOrElse((Function0)new Serializable(this, executorPod, containerWithLimitCores){
            public static final long serialVersionUID = 0L;
            private final Pod executorPod$1;
            private final Container containerWithLimitCores$1;

            public final Tuple2<Pod, Container> apply() {
                return new Tuple2((Object)this.executorPod$1, (Object)this.containerWithLimitCores$1);
            }
            {
                this.executorPod$1 = executorPod$1;
                this.containerWithLimitCores$1 = containerWithLimitCores$1;
            }
        });
        if (tuple2 != null) {
            Container maybeSecretsMountedContainer;
            Container maybeSecretsMountedContainer2;
            Pod maybeSecretsMountedPod = (Pod)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)maybeSecretsMountedPod, (Object)(maybeSecretsMountedContainer2 = (Container)tuple2._2()));
            Tuple2 tuple23 = tuple22;
            Pod maybeSecretsMountedPod2 = (Pod)tuple23._1();
            Tuple2 tuple24 = (Tuple2)this.initContainerBootstrap.map((Function1)new Serializable(this, maybeSecretsMountedPod2, maybeSecretsMountedContainer = (Container)tuple23._2()){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorPodFactory $outer;
                private final Pod maybeSecretsMountedPod$1;
                private final Container maybeSecretsMountedContainer$1;

                public final Tuple2<Pod, Container> apply(InitContainerBootstrap bootstrap) {
                    PodWithDetachedInitContainer podWithInitContainer = bootstrap.bootstrapInitContainer(new PodWithDetachedInitContainer(this.maybeSecretsMountedPod$1, new ContainerBuilder().build(), this.maybeSecretsMountedContainer$1));
                    Tuple2 tuple2 = (Tuple2)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$initContainerMountSecretsBootstrap.map((Function1)new Serializable(this, podWithInitContainer){
                        public static final long serialVersionUID = 0L;
                        private final PodWithDetachedInitContainer podWithInitContainer$1;

                        public final Tuple2<Pod, Container> apply(MountSecretsBootstrap bootstrap) {
                            return new Tuple2((Object)this.podWithInitContainer$1.pod(), (Object)bootstrap.mountSecrets(this.podWithInitContainer$1.initContainer()));
                        }
                        {
                            this.podWithInitContainer$1 = podWithInitContainer$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, podWithInitContainer){
                        public static final long serialVersionUID = 0L;
                        private final PodWithDetachedInitContainer podWithInitContainer$1;

                        public final Tuple2<Pod, Container> apply() {
                            return new Tuple2((Object)this.podWithInitContainer$1.pod(), (Object)this.podWithInitContainer$1.initContainer());
                        }
                        {
                            this.podWithInitContainer$1 = podWithInitContainer$1;
                        }
                    });
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Pod pod = (Pod)tuple2._1();
                        Container mayBeSecretsMountedInitContainer = (Container)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)pod, (Object)mayBeSecretsMountedInitContainer);
                        Pod pod2 = (Pod)tuple23._1();
                        Container mayBeSecretsMountedInitContainer2 = (Container)tuple23._2();
                        Pod bootstrappedPod = KubernetesUtils$.MODULE$.appendInitContainer(pod2, mayBeSecretsMountedInitContainer2);
                        return new Tuple2((Object)bootstrappedPod, (Object)podWithInitContainer.mainContainer());
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.maybeSecretsMountedPod$1 = maybeSecretsMountedPod$1;
                    this.maybeSecretsMountedContainer$1 = maybeSecretsMountedContainer$1;
                }
            }).getOrElse((Function0)new Serializable(this, maybeSecretsMountedPod2, maybeSecretsMountedContainer){
                public static final long serialVersionUID = 0L;
                private final Pod maybeSecretsMountedPod$1;
                private final Container maybeSecretsMountedContainer$1;

                public final Tuple2<Pod, Container> apply() {
                    return new Tuple2((Object)this.maybeSecretsMountedPod$1, (Object)this.maybeSecretsMountedContainer$1);
                }
                {
                    this.maybeSecretsMountedPod$1 = maybeSecretsMountedPod$1;
                    this.maybeSecretsMountedContainer$1 = maybeSecretsMountedContainer$1;
                }
            });
            if (tuple24 != null) {
                Tuple2 tuple25;
                Pod bootstrappedPod = (Pod)tuple24._1();
                Container bootstrappedContainer = (Container)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)bootstrappedPod, (Object)bootstrappedContainer);
                Pod bootstrappedPod2 = (Pod)tuple26._1();
                Container bootstrappedContainer2 = (Container)tuple26._2();
                return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(bootstrappedPod2).editSpec().addToContainers(new Container[]{bootstrappedContainer2})).endSpec()).build();
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public ExecutorPodFactory(SparkConf sparkConf, Option<MountSecretsBootstrap> mountSecretsBootstrap, Option<InitContainerBootstrap> initContainerBootstrap, Option<MountSecretsBootstrap> initContainerMountSecretsBootstrap) {
        this.sparkConf = sparkConf;
        this.mountSecretsBootstrap = mountSecretsBootstrap;
        this.initContainerBootstrap = initContainerBootstrap;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$initContainerMountSecretsBootstrap = initContainerMountSecretsBootstrap;
        this.executorExtraClasspath = (Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH());
        this.executorLabels = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX());
        Predef$.MODULE$.require(!this.executorLabels().contains((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom executor labels cannot contain ", " as it is reserved for Spark."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SPARK_APP_ID_LABEL()}));
            }
        });
        Predef$.MODULE$.require(!this.executorLabels().contains((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom executor labels cannot contain ", " as it is reserved for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()}))).append((Object)" Spark.").toString();
            }
        });
        Predef$.MODULE$.require(!this.executorLabels().contains((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom executor labels cannot contain ", " as it is reserved for Spark."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SPARK_ROLE_LABEL()}));
            }
        });
        this.executorAnnotations = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX());
        this.nodeSelector = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_NODE_SELECTOR_PREFIX());
        this.executorContainerImage = (String)((Option)sparkConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("Must specify the executor container image");
            }
        });
        this.imagePullPolicy = (String)sparkConf.get(Config$.MODULE$.CONTAINER_IMAGE_PULL_POLICY());
        this.blockManagerPort = sparkConf.getInt("spark.blockmanager.port", Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.executorPodNamePrefix = (String)sparkConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB = BoxesRunTime.unboxToLong((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorMemoryString = sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodFactory $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return package$.MODULE$.max((long)((int)(Constants$.MODULE$.MEMORY_OVERHEAD_FACTOR() * (double)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.executorMemoryWithOverhead = this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodFactory$$executorMemoryMiB() + this.memoryOverheadMiB();
        this.executorCores = sparkConf.getDouble("spark.executor.cores", 1.0);
        this.executorLimitCores = (Option)sparkConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
        this.executorJarsDownloadDir = (String)sparkConf.get(Config$.MODULE$.JARS_DOWNLOAD_LOCATION());
    }
}

