/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.util.Collection;
import java.util.Collections;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.Client$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001!q!AB\"mS\u0016tGO\u0003\u0002\u0004\t\u000511/\u001e2nSRT!!\u0002\u0004\u0002\u0007-D4O\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001fM,(-\\5tg&|gn\u0015;faN\u001c\u0001\u0001E\u0002 O)r!\u0001I\u0013\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rj\u0012A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t1\u0013#A\u0004qC\u000e\\\u0017mZ3\n\u0005!J#aA*fc*\u0011a%\u0005\t\u0003W9j\u0011\u0001\f\u0006\u0003[\t\tQa\u001d;faNL!a\f\u0017\u0003/\u0011\u0013\u0018N^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8Ti\u0016\u0004\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA\u001a5\u001b\u0005A\u0011BA\u001b\t\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0005\u0002:\u00056\t!H\u0003\u0002<y\u000511\r\\5f]RT!!\u0010 \u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002@\u0001\u00069a-\u00192sS\u000eD$\"A!\u0002\u0005%|\u0017BA\";\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003Q9\u0018-\u001b;G_J\f\u0005\u000f]\"p[BdW\r^5p]B\u0011\u0001cR\u0005\u0003\u0011F\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0003\u001d\t\u0007\u000f\u001d(b[\u0016\u0004\"\u0001T(\u000f\u0005Ai\u0015B\u0001(\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u000b\u0002\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\u0002\u000f]\fGo\u00195feB\u0011QKV\u0007\u0002\u0005%\u0011qK\u0001\u0002\u0018\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJDQ!\u0017\u0001\u0005\u0002i\u000ba\u0001P5oSRtDcB.];z{\u0006-\u0019\t\u0003+\u0002AQ\u0001\b-A\u0002yAQ!\r-A\u0002IBQa\u000e-A\u0002aBQ!\u0012-A\u0002\u0019CQA\u0013-A\u0002-CQa\u0015-A\u0002QCqa\u0019\u0001C\u0002\u0013%A-A\tee&4XM\u001d&bm\u0006|\u0005\u000f^5p]N,\u0012!\u001a\t\u0004!\u0019\\\u0015BA4\u0012\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u000e\u0001Q\u0001\n\u0015\f!\u0003\u001a:jm\u0016\u0014(*\u0019<b\u001fB$\u0018n\u001c8tA!)1\u000e\u0001C\u0001Y\u0006\u0019!/\u001e8\u0015\u00035\u0004\"\u0001\u00058\n\u0005=\f\"\u0001B+oSRDQ!\u001d\u0001\u0005\nI\fq#\u00193e\tJLg/\u001a:Po:,'OU3gKJ,gnY3\u0015\u00075\u001cX\u0010C\u0003ua\u0002\u0007Q/A\u0005ee&4XM\u001d)pIB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0006[>$W\r\u001c\u0006\u0003ur\n1!\u00199j\u0013\taxOA\u0002Q_\u0012DQA 9A\u0002}\f\u0011B]3t_V\u00148-Z:\u0011\t}9\u0013\u0011\u0001\t\u0004m\u0006\r\u0011bAA\u0003o\nY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class Client
implements Logging {
    private final Seq<DriverConfigurationStep> submissionSteps;
    private final SparkConf sparkConf;
    public final KubernetesClient org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient;
    public final boolean org$apache$spark$deploy$k8s$submit$Client$$waitForAppCompletion;
    public final String org$apache$spark$deploy$k8s$submit$Client$$appName;
    public final LoggingPodStatusWatcher org$apache$spark$deploy$k8s$submit$Client$$watcher;
    private final Option<String> driverJavaOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private Option<String> driverJavaOptions() {
        return this.driverJavaOptions;
    }

    public void run() {
        ObjectRef currentDriverSpec = ObjectRef.create((Object)KubernetesDriverSpec$.MODULE$.initialSpec(this.sparkConf));
        this.submissionSteps.foreach((Function1)new Serializable(this, currentDriverSpec){
            public static final long serialVersionUID = 0L;
            private final ObjectRef currentDriverSpec$1;

            public final void apply(DriverConfigurationStep nextStep) {
                this.currentDriverSpec$1.elem = nextStep.configureDriver((KubernetesDriverSpec)this.currentDriverSpec$1.elem);
            }
            {
                this.currentDriverSpec$1 = currentDriverSpec$1;
            }
        });
        String[] resolvedDriverJavaOpts = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KubernetesDriverSpec)currentDriverSpec.elem).driverSparkConf().remove((ConfigEntry)package$.MODULE$.DRIVER_JAVA_OPTIONS()).getAll()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String confKey = (String)tuple2._1();
                    String confValue = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{confKey, confValue}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)this.driverJavaOptions().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String s) {
                return Utils$.MODULE$.splitCommandString(s);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Seq driverJavaOptsEnvs = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])resolvedDriverJavaOpts).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String option = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.ENV_JAVA_OPT_PREFIX(), BoxesRunTime.boxToInteger((int)index)})))).withValue(option)).build();
                    return envVar;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Container resolvedDriverContainer = ((ContainerBuilder)new ContainerBuilder(((KubernetesDriverSpec)currentDriverSpec.elem).driverContainer()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(driverJavaOptsEnvs).asJava())).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(((KubernetesDriverSpec)currentDriverSpec.elem).driverPod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer})).endSpec()).build();
        Utils$.MODULE$.tryWithResource((Function0)new Serializable(this, resolvedDriverPod){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Client $outer;
            private final Pod resolvedDriverPod$1;

            public final Watch apply() {
                return (Watch)((Watchable)this.$outer.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().withName(this.resolvedDriverPod$1.getMetadata().getName())).watch((Object)this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolvedDriverPod$1 = resolvedDriverPod$1;
            }
        }, (Function1)new Serializable(this, currentDriverSpec, resolvedDriverPod){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Client $outer;
            private final ObjectRef currentDriverSpec$1;
            private final Pod resolvedDriverPod$1;

            public final void apply(Watch x$1) {
                block6: {
                    Pod createdDriverPod = (Pod)this.$outer.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().create((Object[])new Pod[]{this.resolvedDriverPod$1});
                    try {
                        Object object;
                        if (((KubernetesDriverSpec)this.currentDriverSpec$1.elem).otherKubernetesResources().nonEmpty()) {
                            Seq<HasMetadata> otherKubernetesResources = ((KubernetesDriverSpec)this.currentDriverSpec$1.elem).otherKubernetesResources();
                            this.$outer.org$apache$spark$deploy$k8s$submit$Client$$addDriverOwnerReference(createdDriverPod, otherKubernetesResources);
                            object = this.$outer.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
                            break block6;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        this.$outer.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().delete((Object[])new Pod[]{createdDriverPod});
                        throw e;
                    }
                }
                if (this.$outer.org$apache$spark$deploy$k8s$submit$Client$$waitForAppCompletion) {
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$run$3 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for application ", " to finish..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$Client$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$Client$$appName}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher.awaitCompletion();
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$run$3 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application ", " finished."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$Client$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$Client$$appName}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                } else {
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$run$3 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deployed Spark application ", " into Kubernetes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$k8s$submit$Client$$anonfun$$$outer().org$apache$spark$deploy$k8s$submit$Client$$appName}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ Client org$apache$spark$deploy$k8s$submit$Client$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentDriverSpec$1 = currentDriverSpec$1;
                this.resolvedDriverPod$1 = resolvedDriverPod$1;
            }
        });
    }

    public void org$apache$spark$deploy$k8s$submit$Client$$addDriverOwnerReference(Pod driverPod, Seq<HasMetadata> resources) {
        OwnerReference driverPodOwnerReference = ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withName(driverPod.getMetadata().getName())).withApiVersion(driverPod.getApiVersion())).withUid(driverPod.getMetadata().getUid())).withKind(driverPod.getKind())).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
        resources.foreach((Function1)new Serializable(this, driverPodOwnerReference){
            public static final long serialVersionUID = 0L;
            private final OwnerReference driverPodOwnerReference$1;

            public final void apply(HasMetadata resource) {
                ObjectMeta originalMetadata = resource.getMetadata();
                originalMetadata.setOwnerReferences(Collections.singletonList(this.driverPodOwnerReference$1));
            }
            {
                this.driverPodOwnerReference$1 = driverPodOwnerReference$1;
            }
        });
    }

    public Client(Seq<DriverConfigurationStep> submissionSteps, SparkConf sparkConf, KubernetesClient kubernetesClient, boolean waitForAppCompletion, String appName, LoggingPodStatusWatcher watcher) {
        this.submissionSteps = submissionSteps;
        this.sparkConf = sparkConf;
        this.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$deploy$k8s$submit$Client$$waitForAppCompletion = waitForAppCompletion;
        this.org$apache$spark$deploy$k8s$submit$Client$$appName = appName;
        this.org$apache$spark$deploy$k8s$submit$Client$$watcher = watcher;
        Logging.class.$init$((Logging)this);
        this.driverJavaOptions = (Option)sparkConf.get((ConfigEntry)package$.MODULE$.DRIVER_JAVA_OPTIONS());
    }
}

