/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class Config$
implements Logging {
    public static final Config$ MODULE$;
    private final ConfigEntry<String> KUBERNETES_NAMESPACE;
    private final OptionalConfigEntry<String> CONTAINER_IMAGE;
    private final ConfigEntry<Option<String>> DRIVER_CONTAINER_IMAGE;
    private final ConfigEntry<Option<String>> EXECUTOR_CONTAINER_IMAGE;
    private final ConfigEntry<String> CONTAINER_IMAGE_PULL_POLICY;
    private final String KUBERNETES_AUTH_DRIVER_CONF_PREFIX;
    private final String KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX;
    private final String OAUTH_TOKEN_CONF_SUFFIX;
    private final String OAUTH_TOKEN_FILE_CONF_SUFFIX;
    private final String CLIENT_KEY_FILE_CONF_SUFFIX;
    private final String CLIENT_CERT_FILE_CONF_SUFFIX;
    private final String CA_CERT_FILE_CONF_SUFFIX;
    private final OptionalConfigEntry<String> KUBERNETES_SERVICE_ACCOUNT_NAME;
    private final OptionalConfigEntry<String> KUBERNETES_DRIVER_LIMIT_CORES;
    private final OptionalConfigEntry<String> KUBERNETES_EXECUTOR_LIMIT_CORES;
    private final OptionalConfigEntry<String> KUBERNETES_DRIVER_POD_NAME;
    private final ConfigEntry<String> KUBERNETES_EXECUTOR_POD_NAME_PREFIX;
    private final ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_SIZE;
    private final ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_DELAY;
    private final ConfigEntry<Object> KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS;
    private final ConfigEntry<Object> WAIT_FOR_APP_COMPLETION;
    private final ConfigEntry<Object> REPORT_INTERVAL;
    private final ConfigEntry<String> JARS_DOWNLOAD_LOCATION;
    private final ConfigEntry<String> FILES_DOWNLOAD_LOCATION;
    private final ConfigEntry<Option<String>> INIT_CONTAINER_IMAGE;
    private final ConfigEntry<Object> INIT_CONTAINER_MOUNT_TIMEOUT;
    private final ConfigEntry<Object> INIT_CONTAINER_MAX_THREAD_POOL_SIZE;
    private final OptionalConfigEntry<String> INIT_CONTAINER_REMOTE_JARS;
    private final OptionalConfigEntry<String> INIT_CONTAINER_REMOTE_FILES;
    private final OptionalConfigEntry<String> INIT_CONTAINER_CONFIG_MAP_NAME;
    private final OptionalConfigEntry<String> INIT_CONTAINER_CONFIG_MAP_KEY_CONF;
    private final String KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX;
    private final String KUBERNETES_NODE_SELECTOR_PREFIX;
    private final String KUBERNETES_DRIVER_LABEL_PREFIX;
    private final String KUBERNETES_DRIVER_ANNOTATION_PREFIX;
    private final String KUBERNETES_DRIVER_SECRETS_PREFIX;
    private final String KUBERNETES_EXECUTOR_LABEL_PREFIX;
    private final String KUBERNETES_EXECUTOR_ANNOTATION_PREFIX;
    private final String KUBERNETES_EXECUTOR_SECRETS_PREFIX;
    private final String KUBERNETES_DRIVER_ENV_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Config$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ConfigEntry<String> KUBERNETES_NAMESPACE() {
        return this.KUBERNETES_NAMESPACE;
    }

    public OptionalConfigEntry<String> CONTAINER_IMAGE() {
        return this.CONTAINER_IMAGE;
    }

    public ConfigEntry<Option<String>> DRIVER_CONTAINER_IMAGE() {
        return this.DRIVER_CONTAINER_IMAGE;
    }

    public ConfigEntry<Option<String>> EXECUTOR_CONTAINER_IMAGE() {
        return this.EXECUTOR_CONTAINER_IMAGE;
    }

    public ConfigEntry<String> CONTAINER_IMAGE_PULL_POLICY() {
        return this.CONTAINER_IMAGE_PULL_POLICY;
    }

    public String KUBERNETES_AUTH_DRIVER_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX;
    }

    public String KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX;
    }

    public String OAUTH_TOKEN_CONF_SUFFIX() {
        return this.OAUTH_TOKEN_CONF_SUFFIX;
    }

    public String OAUTH_TOKEN_FILE_CONF_SUFFIX() {
        return this.OAUTH_TOKEN_FILE_CONF_SUFFIX;
    }

    public String CLIENT_KEY_FILE_CONF_SUFFIX() {
        return this.CLIENT_KEY_FILE_CONF_SUFFIX;
    }

    public String CLIENT_CERT_FILE_CONF_SUFFIX() {
        return this.CLIENT_CERT_FILE_CONF_SUFFIX;
    }

    public String CA_CERT_FILE_CONF_SUFFIX() {
        return this.CA_CERT_FILE_CONF_SUFFIX;
    }

    public OptionalConfigEntry<String> KUBERNETES_SERVICE_ACCOUNT_NAME() {
        return this.KUBERNETES_SERVICE_ACCOUNT_NAME;
    }

    public OptionalConfigEntry<String> KUBERNETES_DRIVER_LIMIT_CORES() {
        return this.KUBERNETES_DRIVER_LIMIT_CORES;
    }

    public OptionalConfigEntry<String> KUBERNETES_EXECUTOR_LIMIT_CORES() {
        return this.KUBERNETES_EXECUTOR_LIMIT_CORES;
    }

    public OptionalConfigEntry<String> KUBERNETES_DRIVER_POD_NAME() {
        return this.KUBERNETES_DRIVER_POD_NAME;
    }

    public ConfigEntry<String> KUBERNETES_EXECUTOR_POD_NAME_PREFIX() {
        return this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX;
    }

    public ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_SIZE() {
        return this.KUBERNETES_ALLOCATION_BATCH_SIZE;
    }

    public ConfigEntry<Object> KUBERNETES_ALLOCATION_BATCH_DELAY() {
        return this.KUBERNETES_ALLOCATION_BATCH_DELAY;
    }

    public ConfigEntry<Object> KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS() {
        return this.KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS;
    }

    public ConfigEntry<Object> WAIT_FOR_APP_COMPLETION() {
        return this.WAIT_FOR_APP_COMPLETION;
    }

    public ConfigEntry<Object> REPORT_INTERVAL() {
        return this.REPORT_INTERVAL;
    }

    public ConfigEntry<String> JARS_DOWNLOAD_LOCATION() {
        return this.JARS_DOWNLOAD_LOCATION;
    }

    public ConfigEntry<String> FILES_DOWNLOAD_LOCATION() {
        return this.FILES_DOWNLOAD_LOCATION;
    }

    public ConfigEntry<Option<String>> INIT_CONTAINER_IMAGE() {
        return this.INIT_CONTAINER_IMAGE;
    }

    public ConfigEntry<Object> INIT_CONTAINER_MOUNT_TIMEOUT() {
        return this.INIT_CONTAINER_MOUNT_TIMEOUT;
    }

    public ConfigEntry<Object> INIT_CONTAINER_MAX_THREAD_POOL_SIZE() {
        return this.INIT_CONTAINER_MAX_THREAD_POOL_SIZE;
    }

    public OptionalConfigEntry<String> INIT_CONTAINER_REMOTE_JARS() {
        return this.INIT_CONTAINER_REMOTE_JARS;
    }

    public OptionalConfigEntry<String> INIT_CONTAINER_REMOTE_FILES() {
        return this.INIT_CONTAINER_REMOTE_FILES;
    }

    public OptionalConfigEntry<String> INIT_CONTAINER_CONFIG_MAP_NAME() {
        return this.INIT_CONTAINER_CONFIG_MAP_NAME;
    }

    public OptionalConfigEntry<String> INIT_CONTAINER_CONFIG_MAP_KEY_CONF() {
        return this.INIT_CONTAINER_CONFIG_MAP_KEY_CONF;
    }

    public String KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX() {
        return this.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX;
    }

    public String KUBERNETES_NODE_SELECTOR_PREFIX() {
        return this.KUBERNETES_NODE_SELECTOR_PREFIX;
    }

    public String KUBERNETES_DRIVER_LABEL_PREFIX() {
        return this.KUBERNETES_DRIVER_LABEL_PREFIX;
    }

    public String KUBERNETES_DRIVER_ANNOTATION_PREFIX() {
        return this.KUBERNETES_DRIVER_ANNOTATION_PREFIX;
    }

    public String KUBERNETES_DRIVER_SECRETS_PREFIX() {
        return this.KUBERNETES_DRIVER_SECRETS_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_LABEL_PREFIX() {
        return this.KUBERNETES_EXECUTOR_LABEL_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_ANNOTATION_PREFIX() {
        return this.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX;
    }

    public String KUBERNETES_EXECUTOR_SECRETS_PREFIX() {
        return this.KUBERNETES_EXECUTOR_SECRETS_PREFIX;
    }

    public String KUBERNETES_DRIVER_ENV_KEY() {
        return this.KUBERNETES_DRIVER_ENV_KEY;
    }

    private Config$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.KUBERNETES_NAMESPACE = new ConfigBuilder("spark.kubernetes.namespace").doc("The namespace that will be used for running the driver and executor pods.").stringConf().createWithDefault((Object)"default");
        this.CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.container.image").doc("Container image to use for Spark containers. Individual container types (e.g. driver or executor) can also be configured to use different images if desired, by setting the container type-specific image name.").stringConf().createOptional();
        this.DRIVER_CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.driver.container.image").doc("Container image to use for the driver.").fallbackConf(this.CONTAINER_IMAGE());
        this.EXECUTOR_CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.executor.container.image").doc("Container image to use for the executors.").fallbackConf(this.CONTAINER_IMAGE());
        this.CONTAINER_IMAGE_PULL_POLICY = new ConfigBuilder("spark.kubernetes.container.image.pullPolicy").doc("Kubernetes image pull policy. Valid values are Always, Never, and IfNotPresent.").stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Always", "Never", "IfNotPresent"}))).createWithDefault((Object)"IfNotPresent");
        this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX = "spark.kubernetes.authenticate.driver";
        this.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX = "spark.kubernetes.authenticate.driver.mounted";
        this.OAUTH_TOKEN_CONF_SUFFIX = "oauthToken";
        this.OAUTH_TOKEN_FILE_CONF_SUFFIX = "oauthTokenFile";
        this.CLIENT_KEY_FILE_CONF_SUFFIX = "clientKeyFile";
        this.CLIENT_CERT_FILE_CONF_SUFFIX = "clientCertFile";
        this.CA_CERT_FILE_CONF_SUFFIX = "caCertFile";
        this.KUBERNETES_SERVICE_ACCOUNT_NAME = new ConfigBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".serviceAccountName"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.KUBERNETES_AUTH_DRIVER_CONF_PREFIX()}))).doc("Service account that is used when running the driver pod. The driver pod uses this service account when requesting executor pods from the API server. If specific credentials are given for the driver pod to use, the driver will favor using those credentials instead.").stringConf().createOptional();
        this.KUBERNETES_DRIVER_LIMIT_CORES = new ConfigBuilder("spark.kubernetes.driver.limit.cores").doc("Specify the hard cpu limit for the driver pod").stringConf().createOptional();
        this.KUBERNETES_EXECUTOR_LIMIT_CORES = new ConfigBuilder("spark.kubernetes.executor.limit.cores").doc("Specify the hard cpu limit for each executor pod").stringConf().createOptional();
        this.KUBERNETES_DRIVER_POD_NAME = new ConfigBuilder("spark.kubernetes.driver.pod.name").doc("Name of the driver pod.").stringConf().createOptional();
        this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX = new ConfigBuilder("spark.kubernetes.executor.podNamePrefix").doc("Prefix to use in front of the executor pod names.").internal().stringConf().createWithDefault((Object)"spark");
        this.KUBERNETES_ALLOCATION_BATCH_SIZE = new ConfigBuilder("spark.kubernetes.allocation.batch.size").doc("Number of pods to launch at once in each round of executor allocation.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int value) {
                return this.apply$mcZI$sp(value);
            }

            public boolean apply$mcZI$sp(int value) {
                return value > 0;
            }
        }, "Allocation batch size should be a positive integer").createWithDefault((Object)BoxesRunTime.boxToInteger((int)5));
        this.KUBERNETES_ALLOCATION_BATCH_DELAY = new ConfigBuilder("spark.kubernetes.allocation.batch.delay").doc("Time to wait between each round of executor allocation.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long value) {
                return this.apply$mcZJ$sp(value);
            }

            public boolean apply$mcZJ$sp(long value) {
                return value > 0L;
            }
        }, "Allocation batch delay must be a positive time value.").createWithDefaultString("1s");
        this.KUBERNETES_EXECUTOR_LOST_REASON_CHECK_MAX_ATTEMPTS = new ConfigBuilder("spark.kubernetes.executor.lostCheck.maxAttempts").doc("Maximum number of attempts allowed for checking the reason of an executor loss before it is assumed that the executor failed.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int value) {
                return this.apply$mcZI$sp(value);
            }

            public boolean apply$mcZI$sp(int value) {
                return value > 0;
            }
        }, "Maximum attempts of checks of executor lost reason must be a positive integer").createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.WAIT_FOR_APP_COMPLETION = new ConfigBuilder("spark.kubernetes.submission.waitAppCompletion").doc("In cluster mode, whether to wait for the application to finish before exiting the launcher process.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.REPORT_INTERVAL = new ConfigBuilder("spark.kubernetes.report.interval").doc("Interval between reports of the current app status in cluster mode.").timeConf(TimeUnit.MILLISECONDS).checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long interval) {
                return this.apply$mcZJ$sp(interval);
            }

            public boolean apply$mcZJ$sp(long interval) {
                return interval > 0L;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logging interval must be a positive time value."})).s((Seq)Nil$.MODULE$)).createWithDefaultString("1s");
        this.JARS_DOWNLOAD_LOCATION = new ConfigBuilder("spark.kubernetes.mountDependencies.jarsDownloadDir").doc("Location to download jars to in the driver and executors. When using spark-submit, this directory must be empty and will be mounted as an empty directory volume on the driver and executor pod.").stringConf().createWithDefault((Object)"/var/spark-data/spark-jars");
        this.FILES_DOWNLOAD_LOCATION = new ConfigBuilder("spark.kubernetes.mountDependencies.filesDownloadDir").doc("Location to download files to in the driver and executors. When using spark-submit, this directory must be empty and will be mounted as an empty directory volume on the driver and executor pods.").stringConf().createWithDefault((Object)"/var/spark-data/spark-files");
        this.INIT_CONTAINER_IMAGE = new ConfigBuilder("spark.kubernetes.initContainer.image").doc("Image for the driver and executor's init-container for downloading dependencies.").fallbackConf(this.CONTAINER_IMAGE());
        this.INIT_CONTAINER_MOUNT_TIMEOUT = new ConfigBuilder("spark.kubernetes.mountDependencies.timeout").doc("Timeout before aborting the attempt to download and unpack dependencies from remote locations into the driver and executor pods.").timeConf(TimeUnit.SECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)300L));
        this.INIT_CONTAINER_MAX_THREAD_POOL_SIZE = new ConfigBuilder("spark.kubernetes.mountDependencies.maxSimultaneousDownloads").doc("Maximum number of remote dependencies to download simultaneously in a driver or executor pod.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)5));
        this.INIT_CONTAINER_REMOTE_JARS = new ConfigBuilder("spark.kubernetes.initContainer.remoteJars").doc("Comma-separated list of jar URIs to download in the init-container. This is calculated from spark.jars.").internal().stringConf().createOptional();
        this.INIT_CONTAINER_REMOTE_FILES = new ConfigBuilder("spark.kubernetes.initContainer.remoteFiles").doc("Comma-separated list of file URIs to download in the init-container. This is calculated from spark.files.").internal().stringConf().createOptional();
        this.INIT_CONTAINER_CONFIG_MAP_NAME = new ConfigBuilder("spark.kubernetes.initContainer.configMapName").doc("Name of the config map to use in the init-container that retrieves submitted files for the executor.").internal().stringConf().createOptional();
        this.INIT_CONTAINER_CONFIG_MAP_KEY_CONF = new ConfigBuilder("spark.kubernetes.initContainer.configMapKey").doc("Key for the entry in the init container config map for submitted files that corresponds to the properties for this init-container.").internal().stringConf().createOptional();
        this.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX = "spark.kubernetes.authenticate.submission";
        this.KUBERNETES_NODE_SELECTOR_PREFIX = "spark.kubernetes.node.selector.";
        this.KUBERNETES_DRIVER_LABEL_PREFIX = "spark.kubernetes.driver.label.";
        this.KUBERNETES_DRIVER_ANNOTATION_PREFIX = "spark.kubernetes.driver.annotation.";
        this.KUBERNETES_DRIVER_SECRETS_PREFIX = "spark.kubernetes.driver.secrets.";
        this.KUBERNETES_EXECUTOR_LABEL_PREFIX = "spark.kubernetes.executor.label.";
        this.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX = "spark.kubernetes.executor.annotation.";
        this.KUBERNETES_EXECUTOR_SECRETS_PREFIX = "spark.kubernetes.executor.secrets.";
        this.KUBERNETES_DRIVER_ENV_KEY = "spark.kubernetes.driverEnv.";
    }
}

