/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.util.Date;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class AppStatusUtils$ {
    public static final AppStatusUtils$ MODULE$;
    private final Set<String> TASK_FINISHED_STATES;

    static {
        new AppStatusUtils$();
    }

    private Set<String> TASK_FINISHED_STATES() {
        return this.TASK_FINISHED_STATES;
    }

    private boolean isTaskFinished(TaskData task) {
        return this.TASK_FINISHED_STATES().contains((Object)task.status());
    }

    public long schedulerDelay(TaskData task) {
        long l;
        if (this.isTaskFinished(task) && task.taskMetrics().isDefined() && task.duration().isDefined()) {
            TaskMetrics m = (TaskMetrics)task.taskMetrics().get();
            l = this.schedulerDelay(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().get()), m.executorDeserializeTime(), m.resultSerializationTime(), m.executorRunTime());
        } else {
            l = 0L;
        }
        return l;
    }

    public long gettingResultTime(TaskData task) {
        return this.gettingResultTime(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        })));
    }

    public long schedulerDelay(long launchTime, long fetchStart, long duration, long deserializeTime, long serializeTime, long runTime) {
        return package$.MODULE$.max(0L, duration - runTime - deserializeTime - serializeTime - this.gettingResultTime(launchTime, fetchStart, duration));
    }

    public long gettingResultTime(long launchTime, long fetchStart, long duration) {
        return fetchStart > 0L ? (duration > 0L ? launchTime + duration - fetchStart : System.currentTimeMillis() - fetchStart) : 0L;
    }

    private long fetchStart(TaskData task) {
        return task.resultFetchStart().isDefined() ? ((Date)task.resultFetchStart().get()).getTime() : -1L;
    }

    private AppStatusUtils$() {
        MODULE$ = this;
        this.TASK_FINISHED_STATES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED", "KILLED", "SUCCESS"}));
    }
}

