/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.Cursor;

public class AvaticaParameter {
    public final boolean signed;
    public final int precision;
    public final int scale;
    public final int parameterType;
    public final String typeName;
    public final String className;
    public final String name;
    public static final Object DUMMY_VALUE = Dummy.INSTANCE;

    @JsonCreator
    public AvaticaParameter(@JsonProperty(value="signed") boolean signed, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="parameterType") int parameterType, @JsonProperty(value="typeName") String typeName, @JsonProperty(value="className") String className, @JsonProperty(value="name") String name) {
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.parameterType = parameterType;
        this.typeName = typeName;
        this.className = className;
        this.name = name;
    }

    public void setByte(Object[] slots, int index, byte o) {
        slots[index] = o;
    }

    public void setChar(Object[] slots, int index, char o) {
        slots[index] = Character.valueOf(o);
    }

    public void setShort(Object[] slots, int index, short o) {
        slots[index] = o;
    }

    public void setInt(Object[] slots, int index, int o) {
        slots[index] = o;
    }

    public void setLong(Object[] slots, int index, long o) {
        slots[index] = o;
    }

    public void setBoolean(Object[] slots, int index, boolean o) {
        slots[index] = o;
    }

    private static Object wrap(Object o) {
        if (o == null) {
            return DUMMY_VALUE;
        }
        return o;
    }

    public boolean isSet(Object[] slots, int index) {
        return slots[index] != null;
    }

    public void setRowId(Object[] slots, int index, RowId x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setNString(Object[] slots, int index, String o) {
        slots[index] = AvaticaParameter.wrap(o);
    }

    public void setNCharacterStream(Object[] slots, int index, Reader value, long length) {
    }

    public void setNClob(Object[] slots, int index, NClob value) {
        slots[index] = AvaticaParameter.wrap(value);
    }

    public void setClob(Object[] slots, int index, Reader reader, long length) {
    }

    public void setBlob(Object[] slots, int index, InputStream inputStream, long length) {
    }

    public void setNClob(Object[] slots, int index, Reader reader, long length) {
    }

    public void setSQLXML(Object[] slots, int index, SQLXML xmlObject) {
        slots[index] = AvaticaParameter.wrap(xmlObject);
    }

    public void setAsciiStream(Object[] slots, int index, InputStream x, long length) {
    }

    public void setBinaryStream(Object[] slots, int index, InputStream x, long length) {
    }

    public void setCharacterStream(Object[] slots, int index, Reader reader, long length) {
    }

    public void setAsciiStream(Object[] slots, int index, InputStream x) {
    }

    public void setBinaryStream(Object[] slots, int index, InputStream x) {
    }

    public void setCharacterStream(Object[] slots, int index, Reader reader) {
    }

    public void setNCharacterStream(Object[] slots, int index, Reader value) {
    }

    public void setClob(Object[] slots, int index, Reader reader) {
    }

    public void setBlob(Object[] slots, int index, InputStream inputStream) {
    }

    public void setNClob(Object[] slots, int index, Reader reader) {
    }

    public void setUnicodeStream(Object[] slots, int index, InputStream x, int length) {
    }

    public void setTimestamp(Object[] slots, int index, Timestamp x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setTime(Object[] slots, int index, Time x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setFloat(Object[] slots, int index, float x) {
        slots[index] = AvaticaParameter.wrap(Float.valueOf(x));
    }

    public void setDouble(Object[] slots, int index, double x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setBigDecimal(Object[] slots, int index, BigDecimal x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setString(Object[] slots, int index, String x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setBytes(Object[] slots, int index, byte[] x) {
        slots[index] = x == null ? DUMMY_VALUE : new ByteString(x);
    }

    public void setDate(Object[] slots, int index, Date x, Calendar cal) {
    }

    public void setDate(Object[] slots, int index, Date x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setObject(Object[] slots, int index, Object x, int targetSqlType) {
        if (x == null || 0 == targetSqlType) {
            this.setNull(slots, index, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 70: 
            case 1111: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw AvaticaParameter.notImplemented();
            }
            case 2003: {
                this.setArray(slots, index, AvaticaParameter.toArray(x));
                break;
            }
            case -5: {
                this.setLong(slots, index, AvaticaParameter.toLong(x));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(slots, index, AvaticaParameter.toBytes(x));
                break;
            }
            case -7: 
            case 16: {
                this.setBoolean(slots, index, AvaticaParameter.toBoolean(x));
                break;
            }
            case 2004: {
                if (x instanceof Blob) {
                    this.setBlob(slots, index, (Blob)x);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBlob(slots, index, (InputStream)x);
                }
                throw AvaticaParameter.unsupportedCast(x.getClass(), Blob.class);
            }
            case 91: {
                this.setDate(slots, index, AvaticaParameter.toDate(x));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(slots, index, AvaticaParameter.toBigDecimal(x));
                break;
            }
            case 2001: {
                throw AvaticaParameter.notImplemented();
            }
            case 6: 
            case 8: {
                this.setDouble(slots, index, AvaticaParameter.toDouble(x));
                break;
            }
            case 4: {
                this.setInt(slots, index, AvaticaParameter.toInt(x));
                break;
            }
            case 2000: {
                this.setObject(slots, index, x);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(slots, index, AvaticaParameter.toString(x));
                break;
            }
            case 7: {
                this.setFloat(slots, index, AvaticaParameter.toFloat(x));
                break;
            }
            case -8: {
                if (x instanceof RowId) {
                    this.setRowId(slots, index, (RowId)x);
                    break;
                }
                throw AvaticaParameter.unsupportedCast(x.getClass(), RowId.class);
            }
            case 5: {
                this.setShort(slots, index, AvaticaParameter.toShort(x));
                break;
            }
            case 92: {
                this.setTime(slots, index, AvaticaParameter.toTime(x));
                break;
            }
            case 93: {
                this.setTimestamp(slots, index, AvaticaParameter.toTimestamp(x));
                break;
            }
            case -6: {
                this.setByte(slots, index, AvaticaParameter.toByte(x));
                break;
            }
            default: {
                throw AvaticaParameter.notImplemented();
            }
        }
    }

    public static Object get(Cursor.Accessor accessor, int targetSqlType, Calendar localCalendar) throws SQLException {
        switch (targetSqlType) {
            case 70: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw AvaticaParameter.notImplemented();
            }
            case 2003: {
                return accessor.getArray();
            }
            case -5: {
                long aLong = accessor.getLong();
                if (aLong == 0L && accessor.wasNull()) {
                    return null;
                }
                return aLong;
            }
            case -4: 
            case -3: 
            case -2: {
                return accessor.getBytes();
            }
            case -7: 
            case 16: {
                boolean aBoolean = accessor.getBoolean();
                if (!aBoolean && accessor.wasNull()) {
                    return null;
                }
                return aBoolean;
            }
            case 2004: {
                return accessor.getBlob();
            }
            case 91: {
                return accessor.getDate(localCalendar);
            }
            case 2: 
            case 3: {
                return accessor.getBigDecimal();
            }
            case 2001: {
                throw AvaticaParameter.notImplemented();
            }
            case 6: 
            case 8: {
                double aDouble = accessor.getDouble();
                if (aDouble == 0.0 && accessor.wasNull()) {
                    return null;
                }
                return aDouble;
            }
            case 4: {
                int anInt = accessor.getInt();
                if (anInt == 0 && accessor.wasNull()) {
                    return null;
                }
                return anInt;
            }
            case 1111: 
            case 2000: {
                return accessor.getObject();
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return accessor.getString();
            }
            case 7: {
                float aFloat = accessor.getFloat();
                if (aFloat == 0.0f && accessor.wasNull()) {
                    return null;
                }
                return Float.valueOf(aFloat);
            }
            case -8: {
                throw AvaticaParameter.notImplemented();
            }
            case 5: {
                short aShort = accessor.getShort();
                if (aShort == 0 && accessor.wasNull()) {
                    return null;
                }
                return aShort;
            }
            case 92: {
                return accessor.getTime(localCalendar);
            }
            case 93: {
                return accessor.getTimestamp(localCalendar);
            }
            case -6: {
                byte aByte = accessor.getByte();
                if (aByte == 0 && accessor.wasNull()) {
                    return null;
                }
                return aByte;
            }
        }
        throw AvaticaParameter.notImplemented();
    }

    public void setObject(Object[] slots, int index, Object x) {
        slots[index] = AvaticaParameter.wrap(x);
    }

    public void setNull(Object[] slots, int index, int sqlType) {
        slots[index] = DUMMY_VALUE;
    }

    public void setTime(Object[] slots, int index, Time x, Calendar cal) {
    }

    public void setRef(Object[] slots, int index, Ref x) {
    }

    public void setBlob(Object[] slots, int index, Blob x) {
    }

    public void setClob(Object[] slots, int index, Clob x) {
    }

    public void setArray(Object[] slots, int index, Array x) {
    }

    public void setTimestamp(Object[] slots, int index, Timestamp x, Calendar cal) {
    }

    public void setNull(Object[] slots, int index, int sqlType, String typeName) {
    }

    public void setURL(Object[] slots, int index, URL x) {
    }

    public void setObject(Object[] slots, int index, Object x, int targetSqlType, int scaleOrLength) {
    }

    private static RuntimeException unsupportedCast(Class<?> from, Class<?> to) {
        return new UnsupportedOperationException("Cannot convert from " + from.getCanonicalName() + " to " + to.getCanonicalName());
    }

    private static RuntimeException notImplemented() {
        return new RuntimeException("not implemented");
    }

    private static Array toArray(Object x) {
        if (x instanceof Array) {
            return (Array)x;
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Array.class);
    }

    public static BigDecimal toBigDecimal(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        if (x instanceof Number) {
            if (x instanceof Double || x instanceof Float) {
                return new BigDecimal(((Number)x).doubleValue());
            }
            return new BigDecimal(((Number)x).longValue());
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (x instanceof String) {
            return new BigDecimal((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), BigDecimal.class);
    }

    private static boolean toBoolean(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            return ((Number)x).intValue() != 0;
        }
        if (x instanceof String) {
            String s = (String)x;
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
                return true;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
                return false;
            }
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Boolean.TYPE);
    }

    private static byte toByte(Object x) {
        if (x instanceof Number) {
            return ((Number)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? (byte)1 : 0;
        }
        if (x instanceof String) {
            return Byte.parseByte((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Byte.TYPE);
    }

    private static byte[] toBytes(Object x) {
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), byte[].class);
    }

    private static Date toDate(Object x) {
        if (x instanceof String) {
            return Date.valueOf((String)x);
        }
        return new Date(AvaticaParameter.toLong(x));
    }

    private static Time toTime(Object x) {
        if (x instanceof String) {
            return Time.valueOf((String)x);
        }
        return new Time(AvaticaParameter.toLong(x));
    }

    private static Timestamp toTimestamp(Object x) {
        if (x instanceof String) {
            return Timestamp.valueOf((String)x);
        }
        return new Timestamp(AvaticaParameter.toLong(x));
    }

    private static double toDouble(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        if (x instanceof String) {
            return Double.parseDouble((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Double.TYPE);
    }

    private static float toFloat(Object x) {
        if (x instanceof Number) {
            return ((Number)x).floatValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0f : 0.0f;
        }
        if (x instanceof String) {
            return Float.parseFloat((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Float.TYPE);
    }

    private static int toInt(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof String) {
            return Integer.parseInt((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Integer.TYPE);
    }

    private static long toLong(Object x) {
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1L : 0L;
        }
        if (x instanceof String) {
            return Long.parseLong((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Long.TYPE);
    }

    private static short toShort(Object x) {
        if (x instanceof Number) {
            return ((Number)x).shortValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? (short)1 : 0;
        }
        if (x instanceof String) {
            return Short.parseShort((String)x);
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), Short.TYPE);
    }

    private static String toString(Object x) {
        if (x instanceof String) {
            return (String)x;
        }
        if (x instanceof Character || x instanceof Boolean) {
            return x.toString();
        }
        throw AvaticaParameter.unsupportedCast(x.getClass(), String.class);
    }

    private static enum Dummy {
        INSTANCE;

    }
}

