/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptQuery;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.MetadataFactoryImpl;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;

public class RelOptCluster {
    private final RelDataTypeFactory typeFactory;
    private final RelOptQuery query;
    private final RelOptPlanner planner;
    private RexNode originalExpression;
    private final RexBuilder rexBuilder;
    private RelMetadataProvider metadataProvider;
    private MetadataFactory metadataFactory;
    private final RelTraitSet emptyTraitSet;

    RelOptCluster(RelOptQuery query, RelOptPlanner planner, RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        assert (planner != null);
        assert (typeFactory != null);
        this.query = query;
        this.planner = planner;
        this.typeFactory = typeFactory;
        this.rexBuilder = rexBuilder;
        this.originalExpression = rexBuilder.makeLiteral("?");
        this.setMetadataProvider(new DefaultRelMetadataProvider());
        this.emptyTraitSet = planner.emptyTraitSet();
        assert (this.emptyTraitSet.size() == planner.getRelTraitDefs().size());
    }

    public RelOptQuery getQuery() {
        return this.query;
    }

    public RexNode getOriginalExpression() {
        return this.originalExpression;
    }

    public void setOriginalExpression(RexNode originalExpression) {
        this.originalExpression = originalExpression;
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RexBuilder getRexBuilder() {
        return this.rexBuilder;
    }

    public RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(RelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        this.metadataFactory = new MetadataFactoryImpl(metadataProvider);
    }

    public MetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    public RelTraitSet traitSet() {
        return this.emptyTraitSet;
    }

    @Deprecated
    public RelTraitSet traitSetOf(RelTrait ... traits) {
        RelTraitSet traitSet = this.emptyTraitSet;
        for (RelTrait trait : traits) {
            traitSet = traitSet.replace(trait);
        }
        return traitSet;
    }

    public RelTraitSet traitSetOf(RelTrait trait) {
        return this.emptyTraitSet.replace(trait);
    }
}

