/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.JobCondition;
import io.fabric8.kubernetes.api.model.JobConditionFluent;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;

public class JobConditionFluentImpl<A extends JobConditionFluent<A>>
extends BaseFluent<A>
implements JobConditionFluent<A> {
    private TimeBuilder lastProbeTime;
    private TimeBuilder lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public JobConditionFluentImpl() {
    }

    public JobConditionFluentImpl(JobCondition instance) {
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
    }

    @Override
    @Deprecated
    public Time getLastProbeTime() {
        return this.lastProbeTime != null ? this.lastProbeTime.build() : null;
    }

    @Override
    public Time buildLastProbeTime() {
        return this.lastProbeTime != null ? this.lastProbeTime.build() : null;
    }

    @Override
    public A withLastProbeTime(Time lastProbeTime) {
        this._visitables.remove(this.lastProbeTime);
        if (lastProbeTime != null) {
            this.lastProbeTime = new TimeBuilder(lastProbeTime);
            this._visitables.add(this.lastProbeTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastProbeTime() {
        return this.lastProbeTime != null;
    }

    @Override
    public JobConditionFluent.LastProbeTimeNested<A> withNewLastProbeTime() {
        return new LastProbeTimeNestedImpl();
    }

    @Override
    public JobConditionFluent.LastProbeTimeNested<A> withNewLastProbeTimeLike(Time item) {
        return new LastProbeTimeNestedImpl(item);
    }

    @Override
    public JobConditionFluent.LastProbeTimeNested<A> editLastProbeTime() {
        return this.withNewLastProbeTimeLike(this.getLastProbeTime());
    }

    @Override
    public JobConditionFluent.LastProbeTimeNested<A> editOrNewLastProbeTime() {
        return this.withNewLastProbeTimeLike(this.getLastProbeTime() != null ? this.getLastProbeTime() : new TimeBuilder().build());
    }

    @Override
    public JobConditionFluent.LastProbeTimeNested<A> editOrNewLastProbeTimeLike(Time item) {
        return this.withNewLastProbeTimeLike(this.getLastProbeTime() != null ? this.getLastProbeTime() : item);
    }

    @Override
    public A withNewLastProbeTime(String time) {
        return this.withLastProbeTime(new Time(time));
    }

    @Override
    @Deprecated
    public Time getLastTransitionTime() {
        return this.lastTransitionTime != null ? this.lastTransitionTime.build() : null;
    }

    @Override
    public Time buildLastTransitionTime() {
        return this.lastTransitionTime != null ? this.lastTransitionTime.build() : null;
    }

    @Override
    public A withLastTransitionTime(Time lastTransitionTime) {
        this._visitables.remove(this.lastTransitionTime);
        if (lastTransitionTime != null) {
            this.lastTransitionTime = new TimeBuilder(lastTransitionTime);
            this._visitables.add(this.lastTransitionTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastTransitionTime() {
        return this.lastTransitionTime != null;
    }

    @Override
    public JobConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime() {
        return new LastTransitionTimeNestedImpl();
    }

    @Override
    public JobConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item) {
        return new LastTransitionTimeNestedImpl(item);
    }

    @Override
    public JobConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime() {
        return this.withNewLastTransitionTimeLike(this.getLastTransitionTime());
    }

    @Override
    public JobConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime() {
        return this.withNewLastTransitionTimeLike(this.getLastTransitionTime() != null ? this.getLastTransitionTime() : new TimeBuilder().build());
    }

    @Override
    public JobConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item) {
        return this.withNewLastTransitionTimeLike(this.getLastTransitionTime() != null ? this.getLastTransitionTime() : item);
    }

    @Override
    public A withNewLastTransitionTime(String time) {
        return this.withLastTransitionTime(new Time(time));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobConditionFluentImpl that = (JobConditionFluentImpl)o;
        if (this.lastProbeTime != null ? !this.lastProbeTime.equals(that.lastProbeTime) : that.lastProbeTime != null) {
            return false;
        }
        if (this.lastTransitionTime != null ? !this.lastTransitionTime.equals(that.lastTransitionTime) : that.lastTransitionTime != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class LastTransitionTimeNestedImpl<N>
    extends TimeFluentImpl<JobConditionFluent.LastTransitionTimeNested<N>>
    implements JobConditionFluent.LastTransitionTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        LastTransitionTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        LastTransitionTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobConditionFluentImpl.this.withLastTransitionTime(this.builder.build());
        }

        @Override
        public N endLastTransitionTime() {
            return this.and();
        }
    }

    public class LastProbeTimeNestedImpl<N>
    extends TimeFluentImpl<JobConditionFluent.LastProbeTimeNested<N>>
    implements JobConditionFluent.LastProbeTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        LastProbeTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        LastProbeTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobConditionFluentImpl.this.withLastProbeTime(this.builder.build());
        }

        @Override
        public N endLastProbeTime() {
            return this.and();
        }
    }
}

