/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.security.KerberosInfo;

@KerberosInfo(serverPrincipal="dfs.namenode.kerberos.principal", clientPrincipal="dfs.datanode.kerberos.principal")
@InterfaceAudience.Private
public interface DatanodeProtocol {
    public static final long versionID = 28L;
    public static final int NOTIFY = 0;
    public static final int DISK_ERROR = 1;
    public static final int INVALID_BLOCK = 2;
    public static final int FATAL_DISK_ERROR = 3;
    public static final int DNA_UNKNOWN = 0;
    public static final int DNA_TRANSFER = 1;
    public static final int DNA_INVALIDATE = 2;
    public static final int DNA_SHUTDOWN = 3;
    public static final int DNA_REGISTER = 4;
    public static final int DNA_FINALIZE = 5;
    public static final int DNA_RECOVERBLOCK = 6;
    public static final int DNA_ACCESSKEYUPDATE = 7;
    public static final int DNA_BALANCERBANDWIDTHUPDATE = 8;
    public static final int DNA_CACHE = 9;
    public static final int DNA_UNCACHE = 10;

    @Idempotent
    public DatanodeRegistration registerDatanode(DatanodeRegistration var1) throws IOException;

    @Idempotent
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration var1, StorageReport[] var2, long var3, long var5, int var7, int var8, int var9, VolumeFailureSummary var10) throws IOException;

    @Idempotent
    public DatanodeCommand blockReport(DatanodeRegistration var1, String var2, StorageBlockReport[] var3, BlockReportContext var4) throws IOException;

    @Idempotent
    public DatanodeCommand cacheReport(DatanodeRegistration var1, String var2, List<Long> var3) throws IOException;

    @Idempotent
    public void blockReceivedAndDeleted(DatanodeRegistration var1, String var2, StorageReceivedDeletedBlocks[] var3) throws IOException;

    @Idempotent
    public void errorReport(DatanodeRegistration var1, int var2, String var3) throws IOException;

    @Idempotent
    public NamespaceInfo versionRequest() throws IOException;

    @Idempotent
    public void reportBadBlocks(LocatedBlock[] var1) throws IOException;

    @Idempotent
    public void commitBlockSynchronization(ExtendedBlock var1, long var2, long var4, boolean var6, boolean var7, DatanodeID[] var8, String[] var9) throws IOException;
}

