/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.Kernel;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
public class SigmoidKernel
extends Kernel
implements HasExtensions {
    @XmlAttribute(name="description")
    private String description;
    @XmlAttribute(name="gamma")
    private Double gamma;
    @XmlAttribute(name="coef0")
    private Double coef0;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    private static final Double DEFAULT_GAMMA = 1.0;
    private static final Double DEFAULT_COEF0 = 1.0;

    public String getDescription() {
        return this.description;
    }

    public SigmoidKernel setDescription(String description) {
        this.description = description;
        return this;
    }

    public Double getGamma() {
        if (this.gamma == null) {
            return DEFAULT_GAMMA;
        }
        return this.gamma;
    }

    public SigmoidKernel setGamma(Double gamma) {
        this.gamma = gamma;
        return this;
    }

    public Double getCoef0() {
        if (this.coef0 == null) {
            return DEFAULT_COEF0;
        }
        return this.coef0;
    }

    public SigmoidKernel setCoef0(Double coef0) {
        this.coef0 = coef0;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SigmoidKernel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

