/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV2_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEf\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qA\u0003G\u000e\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u00103%\u0011!\u0004\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00039}i\u0011!\b\u0006\u0003=\u0011\tA!\u001e;jY&\u0011\u0001%\b\u0002\t'\u00064X-\u00192mK\"A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0004mC\n,Gn]\u000b\u0002IA\u0019q\"J\u0014\n\u0005\u0019\u0002\"!B!se\u0006L\bCA\b)\u0013\tI\u0003C\u0001\u0004E_V\u0014G.\u001a\u0015\u0004C-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003a5\u0012QaU5oG\u0016\f\u0013AM\u0001\u0006c9\u0002d\u0006\r\u0005\ti\u0001\u0011\t\u0011)A\u0005I\u00059A.\u00192fYN\u0004\u0003fA\u001a,c!Aq\u0007\u0001BC\u0002\u0013\u00051%\u0001\u0002qS\"\u001aagK\u001d\"\u0003i\nQ\u0001\r\u0018:]AB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0004a&\u0004\u0003fA\u001e,s!Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\u0003uQ\u0016$\u0018-F\u0001B!\ryQ\u0005\n\u0015\u0004}-J\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\rQDW\r^1!Q\r\u00195&\u000f\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u0006IQn\u001c3fYRK\b/Z\u000b\u0002\u0013B\u0011!*\u0014\b\u0003\u001f-K!\u0001\u0014\t\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019BA3AR\u0016RC\u0005\u0011\u0016!B\u0019/i9\u0002\u0004\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002\u00155|G-\u001a7UsB,\u0007\u0005K\u0002TWECaa\u0016\u0001\u0005\u0002\u0019A\u0016A\u0002\u001fj]&$h\bF\u0003Z5rs\u0006\r\u0005\u0002\u0016\u0001!)!E\u0016a\u0001I!\u001a!lK\u0019\t\u000b]2\u0006\u0019\u0001\u0013)\u0007q[\u0013\bC\u0003@-\u0002\u0007\u0011\tK\u0002_WeBQa\u0012,A\u0002%C3\u0001Y\u0016R\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\f\u0001\u0002]5WK\u000e$xN]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eB\u0001\u0007Y&t\u0017\r\\4\n\u0005)<'a\u0003#f]N,g+Z2u_JDa\u0001\u001c\u0001!\u0002\u0013)\u0017!\u00039j-\u0016\u001cGo\u001c:!\u0011\u001dq\u0007A1A\u0005\n=\f1\u0002\u001e5fi\u0006l\u0015\r\u001e:jqV\t\u0001\u000f\u0005\u0002gc&\u0011!o\u001a\u0002\f\t\u0016t7/Z'biJL\u0007\u0010\u0003\u0004u\u0001\u0001\u0006I\u0001]\u0001\ri\",G/Y'biJL\u0007\u0010\t\u0005\u0007/\u0002!\t\u0001\u0002<\u0015\te;\b0\u001f\u0005\u0006EU\u0004\r\u0001\n\u0005\u0006oU\u0004\r\u0001\n\u0005\u0006\u007fU\u0004\r!\u0011\u0005\u0007/\u0002!\t\u0001B>\u0015\rec\u00181BA\u0007\u0011\u0015\u0011#\u00101\u0001~!\u0011q\u0018qA\u0014\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\nA\u0011\n^3sC\ndW\rC\u00038u\u0002\u0007Q\u0010\u0003\u0004@u\u0002\u0007\u0011q\u0002\t\u0005}\u0006\u001dQ\u0010\u0003\u0007\u0002\u0014\u0001\u0001\n\u0011aA!\u0002\u0013\t)\"A\u0002yII\u0002raDA\f\u00037\t\t#C\u0002\u0002\u001aA\u0011a\u0001V;qY\u0016\u0014\u0004\u0003B\b\u0002\u001eAL1!a\b\u0011\u0005\u0019y\u0005\u000f^5p]B!q\"!\bf\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9#\u0001\nuQ\u0016$\u0018-T5okNtUm\u001a+iKR\fWCAA\u000e\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0011a\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006\u0004\u0003\"CA\u0018\u0001\t\u0007I\u0011BA\u0019\u0003-qWm\u001a+iKR\f7+^7\u0016\u0005\u0005\u0005\u0002\u0002CA\u001b\u0001\u0001\u0006I!!\t\u0002\u00199,w\r\u00165fi\u0006\u001cV/\u001c\u0011\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u00059\u0001O]3eS\u000e$H\u0003BA\u001f\u0003\u0013\u0002R!a\u0010\u0002F\u001dj!!!\u0011\u000b\u0007\u0005\rc!A\u0002sI\u0012LA!a\u0012\u0002B\t\u0019!\u000b\u0012#\t\u0011\u0005-\u0013q\u0007a\u0001\u0003\u001b\n\u0001\u0002^3ti\u0012\u000bG/\u0019\t\u0007\u0003\u007f\t)%a\u0014\u0011\u0007\u0019\f\t&C\u0002\u0002T\u001d\u0014aAV3di>\u0014\b\u0006BA\u001cWEBq!!\u000f\u0001\t\u0003\nI\u0006F\u0002(\u00037B\u0001\"a\u0013\u0002X\u0001\u0007\u0011q\n\u0015\u0005\u0003/Z\u0013\u0007C\u0004\u0002b\u0001!\t!a\u0019\u0002)A\u0014X\rZ5diB\u0013xNY1cS2LG/[3t)\u0011\ti%!\u001a\t\u0011\u0005-\u0013q\fa\u0001\u0003\u001bBS!a\u0018,\u0003S\n#!a\u001b\u0002\u000bErSG\f\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002pQ!\u0011qJA9\u0011!\tY%!\u001cA\u0002\u0005=\u0003&BA7W\u0005%\u0004bBA<\u0001\u0011%\u0011\u0011P\u0001\u0017[VdG/\u001b8p[&\fGnQ1mGVd\u0017\r^5p]R\u0019Q-a\u001f\t\u0011\u0005-\u0013Q\u000fa\u0001\u0003\u001fBq!a \u0001\t\u0013\t\t)\u0001\u000bcKJtw.\u001e7mS\u000e\u000bGnY;mCRLwN\u001c\u000b\u0004K\u0006\r\u0005\u0002CA&\u0003{\u0002\r!a\u0014\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\u00061\u0002o\\:uKJLwN\u001d)s_\n\f'-\u001b7ji&,7\u000fF\u0002f\u0003\u0017Cq!!$\u0002\u0006\u0002\u0007Q-A\u0004m_\u001e\u0004&o\u001c2\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\u0006!1/\u0019<f)\u0019\t)*a'\u0002(B\u0019q\"a&\n\u0007\u0005e\u0005C\u0001\u0003V]&$\b\u0002CAO\u0003\u001f\u0003\r!a(\u0002\u0005M\u001c\u0007\u0003BAQ\u0003Gk\u0011AB\u0005\u0004\u0003K3!\u0001D*qCJ\\7i\u001c8uKb$\bbBAU\u0003\u001f\u0003\r!S\u0001\u0005a\u0006$\b\u000eK\u0003\u0002\u0010.\ni+\t\u0002\u00020\u0006)\u0011GL\u001a/a!1\u00111\u0017\u0001\u0005R!\u000bQBZ8s[\u0006$h+\u001a:tS>t\u0007f\u0001\u0001,s\u001d9\u0011\u0011\u0018\u0002\t\u0002\u0005m\u0016a\u0004(bSZ,')Y=fg6{G-\u001a7\u0011\u0007U\tiL\u0002\u0004\u0002\u0005!\u0005\u0011qX\n\u0007\u0003{s\u0011\u0011\u0019\r\u0011\tq\t\u0019-W\u0005\u0004\u0003\u000bl\"A\u0002'pC\u0012,'\u000fC\u0004X\u0003{#\t!!3\u0015\u0005\u0005mv!CAg\u0003{C\t\u0001BAh\u00031\u0019\u0016M^3M_\u0006$gKM01!\u0011\t\t.a5\u000e\u0005\u0005uf!CAk\u0003{C\t\u0001BAl\u00051\u0019\u0016M^3M_\u0006$gKM01'\r\t\u0019N\u0004\u0005\b/\u0006MG\u0011AAn)\t\ty\rC\u0004\u0002`\u0006MG\u0011\u0001%\u0002#QD\u0017n\u001d$pe6\fGOV3sg&|g\u000eC\u0004\u0002d\u0006MG\u0011\u0001%\u0002\u001bQD\u0017n]\"mCN\u001ch*Y7f\r\u001d\t9/a5A\u0003S\u0014A\u0001R1uCN1\u0011Q\u001d\b\u0002lb\u00012aDAw\u0013\r\ty\u000f\u0005\u0002\b!J|G-^2u\u0011%\u0011\u0013Q\u001dBK\u0002\u0013\u00051\u0005C\u00055\u0003K\u0014\t\u0012)A\u0005I!Iq'!:\u0003\u0016\u0004%\ta\t\u0005\ny\u0005\u0015(\u0011#Q\u0001\n\u0011B\u0011bPAs\u0005+\u0007I\u0011\u0001!\t\u0013\u0011\u000b)O!E!\u0002\u0013\t\u0005\"C$\u0002f\nU\r\u0011\"\u0001I\u0011%!\u0016Q\u001dB\tB\u0003%\u0011\nC\u0004X\u0003K$\tAa\u0001\u0015\u0015\t\u0015!\u0011\u0002B\u0006\u0005\u001b\u0011y\u0001\u0005\u0003\u0003\b\u0005\u0015XBAAj\u0011\u0019\u0011#\u0011\u0001a\u0001I!1qG!\u0001A\u0002\u0011Baa\u0010B\u0001\u0001\u0004\t\u0005BB$\u0003\u0002\u0001\u0007\u0011\n\u0003\u0006\u0003\u0014\u0005\u0015\u0018\u0011!C\u0001\u0005+\tAaY8qsRQ!Q\u0001B\f\u00053\u0011YB!\b\t\u0011\t\u0012\t\u0002%AA\u0002\u0011B\u0001b\u000eB\t!\u0003\u0005\r\u0001\n\u0005\t\u007f\tE\u0001\u0013!a\u0001\u0003\"AqI!\u0005\u0011\u0002\u0003\u0007\u0011\n\u0003\u0006\u0003\"\u0005\u0015\u0018\u0013!C\u0001\u0005G\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003&)\u001aAEa\n,\u0005\t%\u0002\u0003\u0002B\u0016\u0005gi!A!\f\u000b\t\t=\"\u0011G\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\f\t\n\t\tU\"Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B\u001d\u0003K\f\n\u0011\"\u0001\u0003$\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B\u001f\u0003K\f\n\u0011\"\u0001\u0003@\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B!U\r\t%q\u0005\u0005\u000b\u0005\u000b\n)/%A\u0005\u0002\t\u001d\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0013R3!\u0013B\u0014\u0011)\u0011i%!:\u0002\u0002\u0013\u0005#qJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0003c\u0001@\u0003T%\u0011aj \u0005\u000b\u0005/\n)/!A\u0005\u0002\te\u0013\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B.!\ry!QL\u0005\u0004\u0005?\u0002\"aA%oi\"Q!1MAs\u0003\u0003%\tA!\u001a\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\rB7!\ry!\u0011N\u0005\u0004\u0005W\u0002\"aA!os\"Q!q\u000eB1\u0003\u0003\u0005\rAa\u0017\u0002\u0007a$\u0013\u0007\u0003\u0006\u0003t\u0005\u0015\u0018\u0011!C!\u0005k\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005o\u0002bA!\u001f\u0003\u0000\t\u001dTB\u0001B>\u0015\r\u0011i\bE\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BA\u0005w\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005\u000b\u000b)/!A\u0005\u0002\t\u001d\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t%%q\u0012\t\u0004\u001f\t-\u0015b\u0001BG!\t9!i\\8mK\u0006t\u0007B\u0003B8\u0005\u0007\u000b\t\u00111\u0001\u0003h!Q!1SAs\u0003\u0003%\tE!&\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u0017\t\u0015\te\u0015Q]A\u0001\n\u0003\u0012Y*\u0001\u0005u_N#(/\u001b8h)\t\u0011\t\u0006\u0003\u0006\u0003 \u0006\u0015\u0018\u0011!C!\u0005C\u000ba!Z9vC2\u001cH\u0003\u0002BE\u0005GC!Ba\u001c\u0003\u001e\u0006\u0005\t\u0019\u0001B4\u000f)\u00119+a5\u0002\u0002#\u0005!\u0011V\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0003\b\t-fACAt\u0003'\f\t\u0011#\u0001\u0003.N)!1\u0016BX1AQ!\u0011\u0017B\\I\u0011\n\u0015J!\u0002\u000e\u0005\tM&b\u0001B[!\u00059!/\u001e8uS6,\u0017\u0002\u0002B]\u0005g\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85\u0011\u001d9&1\u0016C\u0001\u0005{#\"A!+\t\u0015\te%1VA\u0001\n\u000b\u0012Y\n\u0003\u0006\u0003D\n-\u0016\u0011!CA\u0005\u000b\fQ!\u00199qYf$\"B!\u0002\u0003H\n%'1\u001aBg\u0011\u0019\u0011#\u0011\u0019a\u0001I!1qG!1A\u0002\u0011Baa\u0010Ba\u0001\u0004\t\u0005BB$\u0003B\u0002\u0007\u0011\n\u0003\u0006\u0003R\n-\u0016\u0011!CA\u0005'\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003V\nu\u0007#B\b\u0002\u001e\t]\u0007cB\b\u0003Z\u0012\"\u0013)S\u0005\u0004\u00057\u0004\"A\u0002+va2,G\u0007\u0003\u0006\u0003`\n=\u0017\u0011!a\u0001\u0005\u000b\t1\u0001\u001f\u00131\u0011)\u0011\u0019Oa+\u0002\u0002\u0013%!Q]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003hB\u0019aP!;\n\u0007\t-xP\u0001\u0004PE*,7\r\u001e\u0005\t\u0003#\u000b\u0019\u000e\"\u0001\u0003pRA\u0011Q\u0013By\u0005g\u0014)\u0010\u0003\u0005\u0002\u001e\n5\b\u0019AAP\u0011\u001d\tIK!<A\u0002%C\u0001Ba>\u0003n\u0002\u0007!QA\u0001\u0005I\u0006$\u0018\r\u0003\u0005\u0003|\u0006MG\u0011\u0001B\u007f\u0003\u0011aw.\u00193\u0015\u000be\u0013yp!\u0001\t\u0011\u0005u%\u0011 a\u0001\u0003?Cq!!+\u0003z\u0002\u0007\u0011\nK\u0003\u0003z.\nikB\u0005\u0004\b\u0005u\u0006\u0012\u0001\u0003\u0004\n\u0005a1+\u0019<f\u0019>\fGMV\u0019`aA!\u0011\u0011[B\u0006\r%\u0019i!!0\t\u0002\u0011\u0019yA\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0004\f9AqaVB\u0006\t\u0003\u0019\u0019\u0002\u0006\u0002\u0004\n!9\u0011q\\B\u0006\t\u0003A\u0005bBAr\u0007\u0017!\t\u0001\u0013\u0004\b\u0003O\u001cY\u0001QB\u000e'\u0019\u0019IBDAv1!I!e!\u0007\u0003\u0016\u0004%\ta\t\u0005\ni\re!\u0011#Q\u0001\n\u0011B\u0011bNB\r\u0005+\u0007I\u0011A\u0012\t\u0013q\u001aIB!E!\u0002\u0013!\u0003\"C \u0004\u001a\tU\r\u0011\"\u0001A\u0011%!5\u0011\u0004B\tB\u0003%\u0011\tC\u0004X\u00073!\taa\u000b\u0015\u0011\r52\u0011GB\u001a\u0007k\u0001Baa\f\u0004\u001a5\u001111\u0002\u0005\u0007E\r%\u0002\u0019\u0001\u0013\t\r]\u001aI\u00031\u0001%\u0011\u0019y4\u0011\u0006a\u0001\u0003\"Q!1CB\r\u0003\u0003%\ta!\u000f\u0015\u0011\r521HB\u001f\u0007\u007fA\u0001BIB\u001c!\u0003\u0005\r\u0001\n\u0005\to\r]\u0002\u0013!a\u0001I!Aqha\u000e\u0011\u0002\u0003\u0007\u0011\t\u0003\u0006\u0003\"\re\u0011\u0013!C\u0001\u0005GA!B!\u000f\u0004\u001aE\u0005I\u0011\u0001B\u0012\u0011)\u0011id!\u0007\u0012\u0002\u0013\u0005!q\b\u0005\u000b\u0005\u001b\u001aI\"!A\u0005B\t=\u0003B\u0003B,\u00073\t\t\u0011\"\u0001\u0003Z!Q!1MB\r\u0003\u0003%\ta!\u0014\u0015\t\t\u001d4q\n\u0005\u000b\u0005_\u001aY%!AA\u0002\tm\u0003B\u0003B:\u00073\t\t\u0011\"\u0011\u0003v!Q!QQB\r\u0003\u0003%\ta!\u0016\u0015\t\t%5q\u000b\u0005\u000b\u0005_\u001a\u0019&!AA\u0002\t\u001d\u0004B\u0003BJ\u00073\t\t\u0011\"\u0011\u0003\u0016\"Q!\u0011TB\r\u0003\u0003%\tEa'\t\u0015\t}5\u0011DA\u0001\n\u0003\u001ay\u0006\u0006\u0003\u0003\n\u000e\u0005\u0004B\u0003B8\u0007;\n\t\u00111\u0001\u0003h\u001dQ!qUB\u0006\u0003\u0003E\ta!\u001a\u0011\t\r=2q\r\u0004\u000b\u0003O\u001cY!!A\t\u0002\r%4#BB4\u0007WB\u0002#\u0003BY\u0007[\"C%QB\u0017\u0013\u0011\u0019yGa-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004X\u0007O\"\taa\u001d\u0015\u0005\r\u0015\u0004B\u0003BM\u0007O\n\t\u0011\"\u0012\u0003\u001c\"Q!1YB4\u0003\u0003%\ti!\u001f\u0015\u0011\r521PB?\u0007\u007fBaAIB<\u0001\u0004!\u0003BB\u001c\u0004x\u0001\u0007A\u0005\u0003\u0004@\u0007o\u0002\r!\u0011\u0005\u000b\u0005#\u001c9'!A\u0005\u0002\u000e\rE\u0003BBC\u0007\u001b\u0003RaDA\u000f\u0007\u000f\u0003baDBEI\u0011\n\u0015bABF!\t1A+\u001e9mKNB!Ba8\u0004\u0002\u0006\u0005\t\u0019AB\u0017\u0011)\u0011\u0019oa\u001a\u0002\u0002\u0013%!Q\u001d\u0005\t\u0003#\u001bY\u0001\"\u0001\u0004\u0014RA\u0011QSBK\u0007/\u001bI\n\u0003\u0005\u0002\u001e\u000eE\u0005\u0019AAP\u0011\u001d\tIk!%A\u0002%C\u0001Ba>\u0004\u0012\u0002\u00071Q\u0006\u0005\t\u0005w\u001cY\u0001\"\u0001\u0004\u001eR)\u0011la(\u0004\"\"A\u0011QTBN\u0001\u0004\ty\nC\u0004\u0002*\u000em\u0005\u0019A%\t\u0011\tm\u0018Q\u0018C!\u0007K#R!WBT\u0007SC\u0001\"!(\u0004$\u0002\u0007\u0011q\u0014\u0005\b\u0003S\u001b\u0019\u000b1\u0001J\u0011)\u0011\u0019/!0\u0002\u0002\u0013%!Q\u001d\u0015\u0006\u0003{[\u0013Q\u0016\u0015\u0006\u0003o[\u0013Q\u0016")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final String modelType;
    private final DenseVector piVector;
    private final DenseMatrix thetaMatrix;
    private final /* synthetic */ Tuple2 x$2;
    private final Option<DenseMatrix> thetaMinusNegTheta;
    private final Option<DenseVector> negThetaSum;

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    public String modelType() {
        return this.modelType;
    }

    private DenseVector piVector() {
        return this.piVector;
    }

    private DenseMatrix thetaMatrix() {
        return this.thetaMatrix;
    }

    private Option<DenseMatrix> thetaMinusNegTheta() {
        return this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return this.negThetaSum;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1)new Serializable(this, bcModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcModel$1;

            public final Iterator<Object> apply(Iterator<Vector> iter) {
                NaiveBayesModel model = (NaiveBayesModel)this.bcModel$1.value();
                return iter.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$1;

                    public final double apply(Vector testData) {
                        return this.model$1.predict(testData);
                    }
                    {
                        this.model$1 = model$1;
                    }
                });
            }
            {
                this.bcModel$1 = bcModel$1;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        String string;
        block4: {
            double d;
            block3: {
                block2: {
                    string = this.modelType();
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    d = this.labels()[this.multinomialCalculation(testData).argmax()];
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                d = this.labels()[this.bernoulliCalculation(testData).argmax()];
            }
            return d;
        }
        throw new MatchError((Object)string);
    }

    public RDD<Vector> predictProbabilities(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1)new Serializable(this, bcModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcModel$2;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                NaiveBayesModel model = (NaiveBayesModel)this.bcModel$2.value();
                return iter.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$2;

                    public final Vector apply(Vector testData) {
                        return this.model$2.predictProbabilities(testData);
                    }
                    {
                        this.model$2 = model$2;
                    }
                });
            }
            {
                this.bcModel$2 = bcModel$2;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector predictProbabilities(Vector testData) {
        String string;
        block4: {
            DenseVector denseVector;
            block3: {
                block2: {
                    string = this.modelType();
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    denseVector = this.posteriorProbabilities(this.multinomialCalculation(testData));
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                denseVector = this.posteriorProbabilities(this.bernoulliCalculation(testData));
            }
            return denseVector;
        }
        throw new MatchError((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector testData) {
        void var2_2;
        DenseVector prob2 = this.thetaMatrix().multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob2);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector testData) {
        void var2_2;
        testData.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, testData){
            public static final long serialVersionUID = 0L;
            private final Vector testData$1;

            public final void apply(int x$3, double value) {
                this.apply$mcVID$sp(x$3, value);
            }

            public void apply$mcVID$sp(int x$3, double value) {
                if (value != 0.0 && value != 1.0) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testData$1})));
                }
            }
            {
                this.testData$1 = testData$1;
            }
        });
        DenseVector prob2 = ((Matrix)this.thetaMinusNegTheta().get()).multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob2);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob2);
        return var2_2;
    }

    private DenseVector posteriorProbabilities(DenseVector logProb) {
        double[] logProbArray = logProb.toArray();
        double maxLog = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(logProbArray).max((Ordering)Ordering.Double$.MODULE$));
        double[] scaledProbs = (double[])Predef$.MODULE$.doubleArrayOps(logProbArray).map((Function1)new Serializable(this, maxLog){
            public static final long serialVersionUID = 0L;
            private final double maxLog$1;

            public final double apply(double lp) {
                return this.apply$mcDD$sp(lp);
            }

            public double apply$mcDD$sp(double lp) {
                return package$.MODULE$.exp(lp - this.maxLog$1);
            }
            {
                this.maxLog$1 = maxLog$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double probSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(scaledProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new DenseVector((double[])Predef$.MODULE$.doubleArrayOps(scaledProbs).map((Function1)new Serializable(this, probSum){
            public static final long serialVersionUID = 0L;
            private final double probSum$1;

            public final double apply(double x$4) {
                return this.apply$mcDD$sp(x$4);
            }

            public double apply$mcDD$sp(double x$4) {
                return x$4 / this.probSum$1;
            }
            {
                this.probSum$1 = probSum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV2_0.Data data = new SaveLoadV2_0.Data(this.labels(), this.pi(), this.theta(), this.modelType());
        NaiveBayesModel$SaveLoadV2_0$.MODULE$.save(sc, path, data);
    }

    @Override
    public String formatVersion() {
        return "2.0";
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta, String modelType) {
        block6: {
            Tuple2 tuple2;
            block5: {
                String string;
                block4: {
                    this.labels = labels;
                    this.pi = pi;
                    this.theta = theta;
                    this.modelType = modelType;
                    ClassificationModel$class.$init$(this);
                    this.piVector = new DenseVector(pi);
                    this.thetaMatrix = new DenseMatrix(labels.length, theta[0].length, (double[])Predef$.MODULE$.refArrayOps((Object[])theta).flatten((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final WrappedArray<Object> apply(double[] xs) {
                            return Predef$.MODULE$.wrapDoubleArray(xs);
                        }
                    }, ClassTag$.MODULE$.Double()), true);
                    Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ NaiveBayesModel $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType ", ". Supported modelTypes are ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.modelType(), NaiveBayes$.MODULE$.supportedModelTypes()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    string = modelType;
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block4;
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                    break block5;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block6;
                Matrix negTheta = this.thetaMatrix().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double value) {
                        return this.apply$mcDD$sp(value);
                    }

                    public double apply$mcDD$sp(double value) {
                        return package$.MODULE$.log(1.0 - package$.MODULE$.exp(value));
                    }
                });
                DenseVector ones2 = new DenseVector((double[])Array$.MODULE$.fill(this.thetaMatrix().numCols(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0;
                    }
                }, ClassTag$.MODULE$.Double()));
                Matrix thetaMinusNegTheta = this.thetaMatrix().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double value) {
                        return this.apply$mcDD$sp(value);
                    }

                    public double apply$mcDD$sp(double value) {
                        return value - package$.MODULE$.log(1.0 - package$.MODULE$.exp(value));
                    }
                });
                tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)((DenseMatrix)negTheta).multiply(ones2)));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Option thetaMinusNegTheta = (Option)tuple22._1();
                Option negThetaSum = (Option)tuple22._2();
                this.x$2 = tuple23 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
                this.thetaMinusNegTheta = (Option)this.x$2._1();
                this.negThetaSum = (Option)this.x$2._2();
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelType})));
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this(labels, pi, theta, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayesModel(Iterable<Object> labels, Iterable<Object> pi, Iterable<Iterable<Object>> theta) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(labels).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(pi).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[][])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(theta).asScala()).toArray(ClassTag$.MODULE$.apply(Iterable.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Iterable<Object> x$1) {
                return (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).toArray(ClassTag$.MODULE$.Double());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }
}

