/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.utils.RestUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    public static String HASH_SHA256 = "SHA-256";
    private static final Log log = LogFactory.getLog(ServiceUtils.class);
    protected static final SimpleDateFormat iso8601DateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected static final SimpleDateFormat iso8601DateParser_Walrus = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final SimpleDateFormat rfc822DateParser = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseIso8601Date(String dateString) throws ParseException {
        ParseException exception = null;
        SimpleDateFormat simpleDateFormat = iso8601DateParser;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser.parse(dateString);
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        simpleDateFormat = iso8601DateParser_Walrus;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser_Walrus.parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601DateParser;
        synchronized (simpleDateFormat) {
            return iso8601DateParser.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.format(date);
        }
    }

    public static String signWithHmacSha1(String awsSecretKey, String canonicalString) {
        if (awsSecretKey == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Canonical string will not be signed, as no AWS Secret Key was provided");
            }
            return null;
        }
        SecretKeySpec signingKey = null;
        signingKey = new SecretKeySpec(ServiceUtils.stringToBytes(awsSecretKey), "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        try {
            byte[] b64 = Base64.encodeBase64((byte[])mac.doFinal(ServiceUtils.stringToBytes(canonicalString)));
            return new String(b64, Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] stringToBytes(String str) {
        try {
            return str.getBytes(Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding \"" + Constants.DEFAULT_ENCODING + "\" for: " + str, e);
        }
    }

    public static byte[] hash(byte[] data, String cryptoHash) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(cryptoHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find hashing algorithm \"" + cryptoHash + "\"", e);
        }
        md.update(data);
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(InputStream dataIS, String cryptoHash, boolean resetInsteadOfClose) throws IOException {
        MessageDigest md;
        block11: {
            BufferedInputStream bis;
            block10: {
                md = null;
                try {
                    md = MessageDigest.getInstance(cryptoHash);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Could not find hashing algorithm \"" + cryptoHash + "\"", e);
                }
                bis = new BufferedInputStream(dataIS);
                try {
                    byte[] buffer = new byte[16384];
                    int bytesRead = -1;
                    while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                        md.update(buffer, 0, bytesRead);
                    }
                    Object var8_8 = null;
                    if (!resetInsteadOfClose) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (resetInsteadOfClose) {
                        dataIS.reset();
                    } else {
                        try {
                            bis.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                dataIS.reset();
                break block11;
            }
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
        return md.digest();
    }

    public static byte[] hash(String data, String cryptoHash) {
        return ServiceUtils.hash(ServiceUtils.stringToBytes(data), cryptoHash);
    }

    public static byte[] hashSHA256(byte[] data) {
        return ServiceUtils.hash(data, "SHA-256");
    }

    public static byte[] hashSHA256(InputStream dataIS, boolean resetInsteadOfClose) throws IOException {
        return ServiceUtils.hash(dataIS, "SHA-256", resetInsteadOfClose);
    }

    public static byte[] hashSHA256(InputStream dataIS) throws IOException {
        return ServiceUtils.hashSHA256(dataIS, false);
    }

    public static byte[] hmac(byte[] key, byte[] data, String cryptoAlgorithm) {
        String hmacDefinition = "Hmac" + cryptoAlgorithm;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, hmacDefinition);
            Mac mac = Mac.getInstance(hmacDefinition);
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find hashing algorithm \"" + hmacDefinition + "\"", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not init hashing algorithm \"" + hmacDefinition + "\"", e);
        }
    }

    public static byte[] hmacSHA256(String key, String data) {
        return ServiceUtils.hmac(ServiceUtils.stringToBytes(key), ServiceUtils.stringToBytes(data), "SHA256");
    }

    public static byte[] hmacSHA256(byte[] key, byte[] data) {
        return ServiceUtils.hmac(key, data, "SHA256");
    }

    public static String readInputStreamToString(InputStream is, String encoding) throws IOException {
        StringBuilder sb;
        block4: {
            sb = new StringBuilder();
            BufferedReader br = null;
            br = encoding != null ? new BufferedReader(new InputStreamReader(is, encoding)) : new BufferedReader(new InputStreamReader(is));
            String line = null;
            try {
                boolean firstLine = true;
                while ((line = br.readLine()) != null) {
                    if (!firstLine) {
                        sb.append("\n");
                    }
                    sb.append(line);
                    firstLine = false;
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"Unable to read String from Input Stream", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String readInputStreamLineToString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = -1;
        while ((b = is.read()) != -1 && '\n' != (char)b) {
            baos.write(b);
        }
        return new String(baos.toByteArray(), encoding);
    }

    public static byte[] readInputStreamToBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = -1;
        while ((b = is.read()) != -1) {
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static long countBytesInObjects(S3Object[] objects) {
        long byteTotal = 0L;
        for (int i = 0; objects != null && i < objects.length; ++i) {
            byteTotal += objects[i].getContentLength();
        }
        return byteTotal;
    }

    public static Map<String, Object> cleanRestMetadataMap(Map<String, Object> metadata, String serviceMetadataPrefix, String userMetadataPrefix) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing REST metadata items");
        }
        HashMap<String, Object> combinedMap = new HashMap<String, Object>();
        HashMap<String, Object> serviceMetadataMap = new HashMap<String, Object>();
        HashMap<String, Object> userMetadataMap = new HashMap<String, Object>();
        HashMap<String, Object> httpMetadataMap = new HashMap<String, Object>();
        HashMap<String, Object> completeMetadataMap = new HashMap<String, Object>();
        if (metadata != null) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                Object value;
                String key;
                block29: {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value instanceof Collection) {
                        Collection coll = (Collection)value;
                        if (coll.size() == 1) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Converted metadata single-item Collection " + coll.getClass() + " " + coll + " for key: " + key));
                            }
                            value = coll.iterator().next();
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Collection " + coll + " has too many items to convert to a single string"));
                        }
                    }
                    if (("Date".equals(key) || "Last-Modified".equals(key)) && !(value instanceof Date)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Parsing date string '" + value + "' into Date object for key: " + key));
                        }
                        try {
                            value = ServiceUtils.parseRfc822Date(value.toString());
                        }
                        catch (ParseException pe) {
                            try {
                                value = ServiceUtils.parseIso8601Date(value.toString());
                            }
                            catch (ParseException pe2) {
                                if (!log.isWarnEnabled()) break block29;
                                log.warn((Object)("Date string is not RFC 822 compliant for metadata field " + key), (Throwable)pe);
                            }
                        }
                    }
                }
                String keyStr = key != null ? key.toString() : "";
                completeMetadataMap.put(keyStr, value);
                if (keyStr.toLowerCase().startsWith(userMetadataPrefix)) {
                    key = keyStr.substring(userMetadataPrefix.length(), keyStr.length());
                    userMetadataMap.put(key, value);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removed user metadata header prefix " + userMetadataPrefix + " from key: " + keyStr + "=>" + key));
                    }
                } else if (keyStr.toLowerCase().startsWith(serviceMetadataPrefix)) {
                    key = keyStr.substring(serviceMetadataPrefix.length(), keyStr.length());
                    serviceMetadataMap.put(key, value);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removed header prefix " + serviceMetadataPrefix + " from key: " + keyStr + "=>" + key));
                    }
                } else if (RestUtils.HTTP_HEADER_METADATA_NAMES.contains(keyStr.toLowerCase(Locale.ENGLISH))) {
                    key = keyStr;
                    httpMetadataMap.put(key, value);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Leaving HTTP header item unchanged: " + key + "=" + value));
                    }
                } else if ("ETag".equalsIgnoreCase(keyStr) || "Date".equalsIgnoreCase(keyStr) || "Last-Modified".equalsIgnoreCase(keyStr) || "Content-Range".equalsIgnoreCase(keyStr)) {
                    key = keyStr;
                    httpMetadataMap.put(key, value);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Leaving header item unchanged: " + key + "=" + value));
                    }
                } else if (keyStr.toLowerCase().startsWith("x-jets3t-")) {
                    key = keyStr;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Leaving internal JetS3t header item unchanged: " + key + "=" + value));
                    }
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring metadata item: " + keyStr + "=" + value));
                    continue;
                }
                combinedMap.put(key, value);
            }
        }
        combinedMap.put("__service__", serviceMetadataMap);
        combinedMap.put("__user__", userMetadataMap);
        combinedMap.put("__http__", httpMetadataMap);
        combinedMap.put("__complete__", completeMetadataMap);
        return combinedMap;
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public static byte[] fromHex(String hexData) {
        if ((hexData.length() & 1) != 0 || hexData.replaceAll("[a-fA-F0-9]", "").length() > 0) {
            throw new IllegalArgumentException("'" + hexData + "' is not a hex string");
        }
        byte[] result = new byte[(hexData.length() + 1) / 2];
        String hexNumber = null;
        int byteOffset = 0;
        for (int stringOffset = 0; stringOffset < hexData.length(); stringOffset += 2) {
            hexNumber = hexData.substring(stringOffset, stringOffset + 2);
            result[byteOffset++] = (byte)Integer.parseInt(hexNumber, 16);
        }
        return result;
    }

    public static String toBase64(byte[] data) {
        byte[] b64 = Base64.encodeBase64((byte[])data);
        try {
            return new String(b64, Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String join(List<?> items, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            sb.append(items.get(i).toString());
            if (i >= items.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(Object[] items, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(int[] ints, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ints.length; ++i) {
            sb.append(ints[i]);
            if (i >= ints.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String[] splitIgnoreEmpty(String str, String regexp) {
        String[] splits = str.split(regexp);
        ArrayList<String> results = new ArrayList<String>();
        for (String candidate : splits) {
            if (candidate.length() <= 0) continue;
            results.add(candidate);
        }
        return results.toArray(new String[0]);
    }

    public static byte[] fromBase64(String b64Data) {
        byte[] decoded = Base64.decodeBase64((byte[])ServiceUtils.stringToBytes(b64Data));
        return decoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        byte[] byArray;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byArray = messageDigest.digest();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
            throw throwable;
        }
        try {
            bis.close();
        }
        catch (Exception e) {
            System.err.println("Unable to close input stream of hash candidate: " + e);
        }
        return byArray;
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static boolean isEtagAlsoAnMD5Hash(String etag) {
        if (etag == null || etag.length() != 32) {
            return false;
        }
        String nonHexChars = etag.toLowerCase().replaceAll("[a-f0-9]", "");
        return nonHexChars.length() <= 0;
    }

    public static String findBucketNameInHostname(String host, String s3Endpoint) {
        String bucketName = null;
        bucketName = host.endsWith(s3Endpoint) ? host.substring(0, host.length() - s3Endpoint.length() - 1) : host;
        return bucketName;
    }

    public static String findBucketNameInHostOrPath(URI uri, String s3Endpoint) {
        String host = uri.getHost();
        String path = uri.getPath();
        String[] pathSplit = ServiceUtils.splitIgnoreEmpty(path, "/");
        if (host.equalsIgnoreCase(s3Endpoint)) {
            if (pathSplit.length > 0) {
                return pathSplit[0];
            }
            return null;
        }
        if (host.endsWith("." + s3Endpoint)) {
            return host.substring(0, host.length() - s3Endpoint.length() - 1);
        }
        String[] hostSplit = ServiceUtils.splitIgnoreEmpty(host, "\\.");
        String[] s3EndpointSplit = ServiceUtils.splitIgnoreEmpty(s3Endpoint, "\\.");
        String s3EndpointSuffix = null;
        if (s3EndpointSplit.length >= 3) {
            s3EndpointSuffix = ServiceUtils.join(Arrays.copyOfRange(s3EndpointSplit, 1, s3EndpointSplit.length), ".");
        }
        if (s3EndpointSuffix != null && host.endsWith("." + s3EndpointSuffix) && hostSplit.length > s3EndpointSplit.length) {
            int firstNonEndpointHostComponentOffset = -1;
            String regionVariation = hostSplit[hostSplit.length - s3EndpointSplit.length];
            String firstS3EndpointComponent = s3EndpointSplit[0];
            if (regionVariation.equals(firstS3EndpointComponent) || regionVariation.startsWith(firstS3EndpointComponent + "-")) {
                firstNonEndpointHostComponentOffset = hostSplit.length - s3EndpointSplit.length;
            }
            if (firstNonEndpointHostComponentOffset < 0 && hostSplit.length > s3EndpointSplit.length + 1 && ((regionVariation = hostSplit[hostSplit.length - s3EndpointSplit.length - 1]).equals(firstS3EndpointComponent) || regionVariation.startsWith(firstS3EndpointComponent + "-"))) {
                firstNonEndpointHostComponentOffset = hostSplit.length - s3EndpointSplit.length - 1;
            }
            if (firstNonEndpointHostComponentOffset > 0) {
                String bucketName = ServiceUtils.join(Arrays.copyOfRange(hostSplit, 0, firstNonEndpointHostComponentOffset), ".");
                return bucketName;
            }
        }
        if (s3EndpointSuffix != null && !host.endsWith("." + s3EndpointSuffix)) {
            String bucketName = host;
            return bucketName;
        }
        if (pathSplit.length > 0) {
            return pathSplit[0];
        }
        return null;
    }

    public static S3Object buildObjectFromUrl(String host, String urlPath, String s3Endpoint) throws UnsupportedEncodingException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        String bucketName = null;
        String objectKey = null;
        if (!s3Endpoint.equals(host)) {
            bucketName = ServiceUtils.findBucketNameInHostname(host, s3Endpoint);
        } else {
            int slashIndex = urlPath.indexOf("/");
            bucketName = URLDecoder.decode(urlPath.substring(0, slashIndex), Constants.DEFAULT_ENCODING);
            urlPath = urlPath.substring(bucketName.length() + 1);
        }
        objectKey = URLDecoder.decode(urlPath, Constants.DEFAULT_ENCODING);
        S3Object object = new S3Object(objectKey);
        object.setBucketName(bucketName);
        return object;
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (Pattern.matches("([0-9]{1,3}\\.){3}[0-9]{1,3}", bucketName)) {
            return false;
        }
        String[] fragments = bucketName.split("\\.");
        for (int i = 0; i < fragments.length; ++i) {
            if (!Pattern.matches("^-.*", fragments[i]) && !Pattern.matches(".*-$", fragments[i]) && !Pattern.matches("^$", fragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String generateS3HostnameForBucket(String bucketName, boolean isDnsBucketNamingDisabled, String s3Endpoint) {
        if (ServiceUtils.isBucketNameValidDNSName(bucketName) && !isDnsBucketNamingDisabled) {
            return bucketName + "." + s3Endpoint;
        }
        return s3Endpoint;
    }

    public static String getUserAgentDescription(String applicationDescription) {
        return "JetS3t/0.9.4 (" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + ";" + " " + System.getProperty("os.arch") + (System.getProperty("user.region") != null ? "; " + System.getProperty("user.region") : "") + (System.getProperty("user.language") != null ? "; " + System.getProperty("user.language") : "") + (System.getProperty("java.version") != null ? "; JVM " + System.getProperty("java.version") : "") + ")" + (applicationDescription != null ? " " + applicationDescription : "");
    }

    public static XMLReader loadXMLReader() throws ServiceException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            String[] altXmlReaderClasspaths = new String[]{"org.apache.crimson.parser.XMLReaderImpl", "org.xmlpull.v1.sax2.Driver"};
            for (int i = 0; i < altXmlReaderClasspaths.length; ++i) {
                String xmlReaderClasspath = altXmlReaderClasspaths[i];
                try {
                    return XMLReaderFactory.createXMLReader(xmlReaderClasspath);
                }
                catch (SAXException sAXException) {
                    continue;
                }
            }
            throw new ServiceException("Failed to initialize a SAX XMLReader");
        }
    }

    public static String wrapString(String p_Input, String p_Prefix, int p_Len) {
        if (p_Input == null) {
            return "";
        }
        String in = p_Input.replace('\\', '/');
        boolean replaced = !in.equals(p_Input);
        String output = ServiceUtils.wrapString(p_Input, p_Prefix, p_Len, " /_");
        return replaced ? output.replace('/', '\\') : output;
    }

    public static String wrapString(String p_Input, String p_Prefix, int p_Len, String p_Delims) {
        if (p_Input == null) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        StringBuffer workBuf = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(p_Input, p_Delims, true);
        while (strTok.hasMoreTokens()) {
            String temp = strTok.nextToken();
            if (workBuf.length() + temp.length() >= p_Len) {
                if (p_Prefix != null) {
                    output.append(p_Prefix);
                }
                output.append(workBuf.toString());
                output.append("\n");
                workBuf = new StringBuffer();
                if (temp.startsWith(" ")) {
                    int tempLen = temp.length();
                    temp = tempLen > 1 ? temp.substring(1, temp.length() - 1) : "";
                }
            }
            workBuf.append(temp);
        }
        if (p_Prefix != null) {
            output.append(p_Prefix);
        }
        output.append(workBuf.toString());
        return output.toString();
    }

    static {
        iso8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
        rfc822DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

