/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluentImpl;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$;
import org.apache.spark.util.ThreadUtils$;
import org.spark_project.guava.base.Charsets;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class SparkKubernetesClientFactory$ {
    public static final SparkKubernetesClientFactory$ MODULE$;

    static {
        new SparkKubernetesClientFactory$();
    }

    public KubernetesClient createKubernetesClient(String master, Option<String> namespace, String kubernetesAuthConfPrefix, SparkConf sparkConf, Option<File> defaultServiceAccountToken, Option<File> defaultServiceAccountCaCert) {
        String oauthTokenFileConf = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesAuthConfPrefix, Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()}));
        String oauthTokenConf = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesAuthConfPrefix, Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()}));
        Option oauthTokenFile = sparkConf.getOption(oauthTokenFileConf).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }).orElse((Function0)new Serializable(defaultServiceAccountToken){
            public static final long serialVersionUID = 0L;
            private final Option defaultServiceAccountToken$1;

            public final Option<File> apply() {
                return this.defaultServiceAccountToken$1;
            }
            {
                this.defaultServiceAccountToken$1 = defaultServiceAccountToken$1;
            }
        });
        Option oauthTokenValue = sparkConf.getOption(oauthTokenConf);
        KubernetesUtils$.MODULE$.requireNandDefined(oauthTokenFile, oauthTokenValue, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot specify OAuth token through both a file ", " and a "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oauthTokenFileConf}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oauthTokenConf}))).toString());
        Option caCertFile = sparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesAuthConfPrefix, Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()}))).orElse((Function0)new Serializable(defaultServiceAccountCaCert){
            public static final long serialVersionUID = 0L;
            private final Option defaultServiceAccountCaCert$1;

            public final Option<String> apply() {
                return this.defaultServiceAccountCaCert$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$2) {
                        return x$2.getAbsolutePath();
                    }
                });
            }
            {
                this.defaultServiceAccountCaCert$1 = defaultServiceAccountCaCert$1;
            }
        });
        Option clientKeyFile = sparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesAuthConfPrefix, Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})));
        Option clientCertFile = sparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kubernetesAuthConfPrefix, Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})));
        Dispatcher dispatcher = new Dispatcher((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-dispatcher"));
        Config config = SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)((ConfigFluentImpl)((ConfigFluentImpl)new ConfigBuilder().withApiVersion("v1")).withMasterUrl(master)).withWebsocketPingInterval(0L)), oauthTokenValue, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(String token, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withOauthToken(token);
            }
        })), oauthTokenFile, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(File file, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withOauthToken(Files.toString((File)file, (Charset)Charsets.UTF_8));
            }
        })), caCertFile, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(String file, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withCaCertFile(file);
            }
        })), clientKeyFile, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(String file, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withClientKeyFile(file);
            }
        })), clientCertFile, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(String file, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withClientCertFile(file);
            }
        })), namespace, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigBuilder apply(String ns, ConfigBuilder configBuilder) {
                return (ConfigBuilder)configBuilder.withNamespace(ns);
            }
        }).build();
        OkHttpClient baseHttpClient = HttpClientUtils.createHttpClient((Config)config);
        OkHttpClient httpClientWithCustomDispatcher = baseHttpClient.newBuilder().dispatcher(dispatcher).build();
        return new DefaultKubernetesClient(httpClientWithCustomDispatcher, config);
    }

    private ConfigBuilder OptionConfigurableConfigBuilder(ConfigBuilder configBuilder) {
        return configBuilder;
    }

    private SparkKubernetesClientFactory$() {
        MODULE$ = this;
    }
}

