/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;

public class ContainerStateTerminatedFluentImpl<A extends ContainerStateTerminatedFluent<A>>
extends BaseFluent<A>
implements ContainerStateTerminatedFluent<A> {
    private String containerID;
    private Integer exitCode;
    private TimeBuilder finishedAt;
    private String message;
    private String reason;
    private Integer signal;
    private TimeBuilder startedAt;

    public ContainerStateTerminatedFluentImpl() {
    }

    public ContainerStateTerminatedFluentImpl(ContainerStateTerminated instance) {
        this.withContainerID(instance.getContainerID());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withSignal(instance.getSignal());
        this.withStartedAt(instance.getStartedAt());
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public Boolean hasContainerID() {
        return this.containerID != null;
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public A withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return (A)this;
    }

    @Override
    public Boolean hasExitCode() {
        return this.exitCode != null;
    }

    @Override
    @Deprecated
    public Time getFinishedAt() {
        return this.finishedAt != null ? this.finishedAt.build() : null;
    }

    @Override
    public Time buildFinishedAt() {
        return this.finishedAt != null ? this.finishedAt.build() : null;
    }

    @Override
    public A withFinishedAt(Time finishedAt) {
        this._visitables.remove(this.finishedAt);
        if (finishedAt != null) {
            this.finishedAt = new TimeBuilder(finishedAt);
            this._visitables.add(this.finishedAt);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinishedAt() {
        return this.finishedAt != null;
    }

    @Override
    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAt() {
        return new FinishedAtNestedImpl();
    }

    @Override
    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAtLike(Time item) {
        return new FinishedAtNestedImpl(item);
    }

    @Override
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editFinishedAt() {
        return this.withNewFinishedAtLike(this.getFinishedAt());
    }

    @Override
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAt() {
        return this.withNewFinishedAtLike(this.getFinishedAt() != null ? this.getFinishedAt() : new TimeBuilder().build());
    }

    @Override
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAtLike(Time item) {
        return this.withNewFinishedAtLike(this.getFinishedAt() != null ? this.getFinishedAt() : item);
    }

    @Override
    public A withNewFinishedAt(String time) {
        return this.withFinishedAt(new Time(time));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public Integer getSignal() {
        return this.signal;
    }

    @Override
    public A withSignal(Integer signal) {
        this.signal = signal;
        return (A)this;
    }

    @Override
    public Boolean hasSignal() {
        return this.signal != null;
    }

    @Override
    @Deprecated
    public Time getStartedAt() {
        return this.startedAt != null ? this.startedAt.build() : null;
    }

    @Override
    public Time buildStartedAt() {
        return this.startedAt != null ? this.startedAt.build() : null;
    }

    @Override
    public A withStartedAt(Time startedAt) {
        this._visitables.remove(this.startedAt);
        if (startedAt != null) {
            this.startedAt = new TimeBuilder(startedAt);
            this._visitables.add(this.startedAt);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStartedAt() {
        return this.startedAt != null;
    }

    @Override
    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAt() {
        return new StartedAtNestedImpl();
    }

    @Override
    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAtLike(Time item) {
        return new StartedAtNestedImpl(item);
    }

    @Override
    public ContainerStateTerminatedFluent.StartedAtNested<A> editStartedAt() {
        return this.withNewStartedAtLike(this.getStartedAt());
    }

    @Override
    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAt() {
        return this.withNewStartedAtLike(this.getStartedAt() != null ? this.getStartedAt() : new TimeBuilder().build());
    }

    @Override
    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAtLike(Time item) {
        return this.withNewStartedAtLike(this.getStartedAt() != null ? this.getStartedAt() : item);
    }

    @Override
    public A withNewStartedAt(String time) {
        return this.withStartedAt(new Time(time));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateTerminatedFluentImpl that = (ContainerStateTerminatedFluentImpl)o;
        if (this.containerID != null ? !this.containerID.equals(that.containerID) : that.containerID != null) {
            return false;
        }
        if (this.exitCode != null ? !this.exitCode.equals(that.exitCode) : that.exitCode != null) {
            return false;
        }
        if (this.finishedAt != null ? !this.finishedAt.equals(that.finishedAt) : that.finishedAt != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.signal != null ? !this.signal.equals(that.signal) : that.signal != null) {
            return false;
        }
        return !(this.startedAt != null ? !this.startedAt.equals(that.startedAt) : that.startedAt != null);
    }

    public class StartedAtNestedImpl<N>
    extends TimeFluentImpl<ContainerStateTerminatedFluent.StartedAtNested<N>>
    implements ContainerStateTerminatedFluent.StartedAtNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        StartedAtNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        StartedAtNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateTerminatedFluentImpl.this.withStartedAt(this.builder.build());
        }

        @Override
        public N endStartedAt() {
            return this.and();
        }
    }

    public class FinishedAtNestedImpl<N>
    extends TimeFluentImpl<ContainerStateTerminatedFluent.FinishedAtNested<N>>
    implements ContainerStateTerminatedFluent.FinishedAtNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        FinishedAtNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        FinishedAtNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateTerminatedFluentImpl.this.withFinishedAt(this.builder.build());
        }

        @Override
        public N endFinishedAt() {
            return this.and();
        }
    }
}

