/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.Worker;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNioWorker
extends AbstractNioSelector
implements Worker {
    protected final SocketSendBufferPool sendBufferPool = new SocketSendBufferPool();

    AbstractNioWorker(Executor executor) {
        super(executor);
    }

    AbstractNioWorker(Executor executor, ThreadNameDeterminer determiner) {
        super(executor, determiner);
    }

    @Override
    public void executeInIoThread(Runnable task) {
        this.executeInIoThread(task, false);
    }

    public void executeInIoThread(Runnable task, boolean alwaysAsync) {
        if (!alwaysAsync && this.isIoThread()) {
            task.run();
        } else {
            this.registerTask(task);
        }
    }

    @Override
    protected void close(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    @Override
    protected ThreadRenamingRunnable newThreadRenamingRunnable(int id, ThreadNameDeterminer determiner) {
        return new ThreadRenamingRunnable(this, "New I/O worker #" + id, determiner);
    }

    @Override
    public void run() {
        super.run();
        this.sendBufferPool.releaseExternalResources();
    }

    @Override
    protected void process(Selector selector) throws IOException {
        Set<SelectionKey> selectedKeys = selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.writeFromSelectorLoop(k);
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    void writeFromUserCode(AbstractNioChannel<?> channel) {
        if (!channel.isConnected()) {
            AbstractNioWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    void writeFromTaskLoop(AbstractNioChannel<?> ch) {
        if (!ch.writeSuspended) {
            this.write0(ch);
        }
    }

    void writeFromSelectorLoop(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    protected abstract boolean scheduleWriteIfNecessary(AbstractNioChannel<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write0(AbstractNioChannel<?> channel) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        WritableByteChannel ch = (WritableByteChannel)channel.channel;
        Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        ArrayList<Throwable> causes = null;
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                MessageEvent evt = channel.currentWriteEvent;
                SocketSendBufferPool.SendBuffer buf = null;
                ChannelFuture future = null;
                try {
                    if (evt == null) {
                        channel.currentWriteEvent = evt = writeBuffer.poll();
                        if (evt == null) {
                            removeOpWrite = true;
                            channel.writeSuspended = false;
                            break;
                        }
                        future = evt.getFuture();
                        channel.currentWriteBuffer = buf = sendBufferPool.acquire(evt.getMessage());
                    } else {
                        future = evt.getFuture();
                        buf = channel.currentWriteBuffer;
                    }
                    long localWrittenBytes = 0L;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = buf.transferTo(ch);
                        if (localWrittenBytes != 0L) {
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (buf.finished()) break;
                    }
                    if (buf.finished()) {
                        buf.release();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                    if (writtenBytes <= 0L) break;
                    future.setProgress(localWrittenBytes, buf.writtenBytes(), buf.totalBytes());
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    if (buf != null) {
                        buf.release();
                    }
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    if (future != null) {
                        future.setFailure(t);
                    }
                    if (iothread) {
                        if (causes == null) {
                            causes = new ArrayList<Throwable>(1);
                        }
                        causes.add(t);
                    } else {
                        Channels.fireExceptionCaughtLater(channel, t);
                    }
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (open) {
                if (addOpWrite) {
                    this.setOpWrite(channel);
                } else if (removeOpWrite) {
                    this.clearOpWrite(channel);
                }
            }
        }
        if (causes != null) {
            for (Throwable cause : causes) {
                Channels.fireExceptionCaught(channel, cause);
            }
        }
        if (!open) {
            this.close(channel, Channels.succeededFuture(channel));
        }
        if (iothread) {
            Channels.fireWriteComplete(channel, writtenBytes);
        } else {
            Channels.fireWriteCompleteLater(channel, writtenBytes);
        }
    }

    static boolean isIoThread(AbstractNioChannel<?> channel) {
        return Thread.currentThread() == channel.worker.thread;
    }

    protected void setOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        int interestOps = channel.getRawInterestOps();
        if ((interestOps & 4) == 0) {
            key.interestOps(interestOps |= 4);
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    protected void clearOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        int interestOps = channel.getRawInterestOps();
        if ((interestOps & 4) != 0) {
            key.interestOps(interestOps &= 0xFFFFFFFB);
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    protected void close(AbstractNioChannel<?> channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        try {
            ((AbstractInterruptibleChannel)channel.channel).close();
            this.increaseCancelledKeys();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    if (iothread) {
                        Channels.fireChannelDisconnected(channel);
                    } else {
                        Channels.fireChannelDisconnectedLater(channel);
                    }
                }
                if (bound) {
                    if (iothread) {
                        Channels.fireChannelUnbound(channel);
                    } else {
                        Channels.fireChannelUnboundLater(channel);
                    }
                }
                AbstractNioWorker.cleanUpWriteBuffer(channel);
                if (iothread) {
                    Channels.fireChannelClosed(channel);
                } else {
                    Channels.fireChannelClosedLater(channel);
                }
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanUpWriteBuffer(AbstractNioChannel<?> channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                ChannelFuture future = evt.getFuture();
                if (channel.currentWriteBuffer != null) {
                    channel.currentWriteBuffer.release();
                    channel.currentWriteBuffer = null;
                }
                channel.currentWriteEvent = null;
                evt = null;
                future.setFailure(cause);
                fireExceptionCaught = true;
            }
            Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
            while ((evt = writeBuffer.poll()) != null) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                    fireExceptionCaught = true;
                }
                evt.getFuture().setFailure(cause);
            }
        }
        if (fireExceptionCaught) {
            if (AbstractNioWorker.isIoThread(channel)) {
                Channels.fireExceptionCaught(channel, (Throwable)cause);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)cause);
            }
        }
    }

    void setInterestOps(final AbstractNioChannel<?> channel, final ChannelFuture future, final int interestOps) {
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        if (!iothread) {
            channel.getPipeline().execute(new Runnable(){

                public void run() {
                    AbstractNioWorker.this.setInterestOps(channel, future, interestOps);
                }
            });
            return;
        }
        boolean changed = false;
        try {
            Selector selector = this.selector;
            SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
            int newInterestOps = interestOps & 0xFFFFFFFB | channel.getRawInterestOps() & 4;
            if (key == null || selector == null) {
                if (channel.getRawInterestOps() != newInterestOps) {
                    changed = true;
                }
                channel.setRawInterestOpsNow(newInterestOps);
                future.setSuccess();
                if (changed) {
                    if (iothread) {
                        Channels.fireChannelInterestChanged(channel);
                    } else {
                        Channels.fireChannelInterestChangedLater(channel);
                    }
                }
                return;
            }
            if (channel.getRawInterestOps() != newInterestOps) {
                changed = true;
                key.interestOps(newInterestOps);
                if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                    selector.wakeup();
                }
                channel.setRawInterestOpsNow(newInterestOps);
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    protected abstract boolean read(SelectionKey var1);
}

