/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcInputFormat;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVector;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class OrcColumnarBatchReader
extends org.apache.hadoop.mapreduce.RecordReader<Void, ColumnarBatch> {
    private static final int CAPACITY = 4096;
    private VectorizedRowBatch batch;
    private int[] requestedColIds;
    private RecordReader recordReader;
    private StructField[] requiredFields;
    private ColumnarBatch columnarBatch;
    private WritableColumnVector[] columnVectors;
    private ColumnVector[] orcVectorWrappers;
    private final MemoryMode MEMORY_MODE;
    private final boolean copyToSpark;

    public OrcColumnarBatchReader(boolean useOffHeap, boolean copyToSpark) {
        this.MEMORY_MODE = useOffHeap ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        this.copyToSpark = copyToSpark;
    }

    public Void getCurrentKey() {
        return null;
    }

    public ColumnarBatch getCurrentValue() {
        return this.columnarBatch;
    }

    public float getProgress() throws IOException {
        return this.recordReader.getProgress();
    }

    public boolean nextKeyValue() throws IOException {
        return this.nextBatch();
    }

    public void close() throws IOException {
        if (this.columnarBatch != null) {
            this.columnarBatch.close();
            this.columnarBatch = null;
        }
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader reader = OrcFile.createReader((Path)fileSplit.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)).filesystem(fileSplit.getPath().getFileSystem(conf)));
        Reader.Options options = OrcInputFormat.buildOptions((Configuration)conf, (Reader)reader, (long)fileSplit.getStart(), (long)fileSplit.getLength());
        this.recordReader = reader.rows(options);
    }

    public void initBatch(TypeDescription orcSchema, int[] requestedColIds, StructField[] requiredFields, StructType partitionSchema, InternalRow partitionValues) {
        int i;
        this.batch = orcSchema.createRowBatch(4096);
        assert (!this.batch.selectedInUse);
        this.requiredFields = requiredFields;
        this.requestedColIds = requestedColIds;
        assert (requiredFields.length == requestedColIds.length);
        StructType resultSchema = new StructType(requiredFields);
        for (StructField f : partitionSchema.fields()) {
            resultSchema = resultSchema.add(f);
        }
        if (this.copyToSpark) {
            this.columnVectors = this.MEMORY_MODE == MemoryMode.OFF_HEAP ? OffHeapColumnVector.allocateColumns(4096, resultSchema) : OnHeapColumnVector.allocateColumns(4096, resultSchema);
            for (int i2 = 0; i2 < requiredFields.length; ++i2) {
                if (requestedColIds[i2] != -1) continue;
                this.columnVectors[i2].putNulls(0, 4096);
                this.columnVectors[i2].setIsConstant();
            }
            if (partitionValues.numFields() > 0) {
                int partitionIdx = requiredFields.length;
                for (i = 0; i < partitionValues.numFields(); ++i) {
                    ColumnVectorUtils.populate(this.columnVectors[i + partitionIdx], partitionValues, i);
                    this.columnVectors[i + partitionIdx].setIsConstant();
                }
            }
            this.columnarBatch = new ColumnarBatch(this.columnVectors);
        } else {
            this.orcVectorWrappers = new ColumnVector[resultSchema.length()];
            for (int i3 = 0; i3 < requiredFields.length; ++i3) {
                DataType dt = requiredFields[i3].dataType();
                int colId = requestedColIds[i3];
                if (colId == -1) {
                    OnHeapColumnVector missingCol = new OnHeapColumnVector(4096, dt);
                    missingCol.putNulls(0, 4096);
                    missingCol.setIsConstant();
                    this.orcVectorWrappers[i3] = missingCol;
                    continue;
                }
                this.orcVectorWrappers[i3] = new OrcColumnVector(dt, this.batch.cols[colId]);
            }
            if (partitionValues.numFields() > 0) {
                int partitionIdx = requiredFields.length;
                for (i = 0; i < partitionValues.numFields(); ++i) {
                    DataType dt = partitionSchema.fields()[i].dataType();
                    OnHeapColumnVector partitionCol = new OnHeapColumnVector(4096, dt);
                    ColumnVectorUtils.populate(partitionCol, partitionValues, i);
                    partitionCol.setIsConstant();
                    this.orcVectorWrappers[partitionIdx + i] = partitionCol;
                }
            }
            this.columnarBatch = new ColumnarBatch(this.orcVectorWrappers);
        }
    }

    private boolean nextBatch() throws IOException {
        this.recordReader.nextBatch(this.batch);
        int batchSize = this.batch.size;
        if (batchSize == 0) {
            return false;
        }
        this.columnarBatch.setNumRows(batchSize);
        if (!this.copyToSpark) {
            for (int i = 0; i < this.requiredFields.length; ++i) {
                if (this.requestedColIds[i] == -1) continue;
                ((OrcColumnVector)this.orcVectorWrappers[i]).setBatchSize(batchSize);
            }
            return true;
        }
        for (WritableColumnVector vector : this.columnVectors) {
            vector.reset();
        }
        for (int i = 0; i < this.requiredFields.length; ++i) {
            StructField field = this.requiredFields[i];
            WritableColumnVector toColumn = this.columnVectors[i];
            if (this.requestedColIds[i] < 0) continue;
            org.apache.orc.storage.ql.exec.vector.ColumnVector fromColumn = this.batch.cols[this.requestedColIds[i]];
            if (fromColumn.isRepeating) {
                this.putRepeatingValues(batchSize, field, fromColumn, toColumn);
                continue;
            }
            if (fromColumn.noNulls) {
                this.putNonNullValues(batchSize, field, fromColumn, toColumn);
                continue;
            }
            this.putValues(batchSize, field, fromColumn, toColumn);
        }
        return true;
    }

    private void putRepeatingValues(int batchSize, StructField field, org.apache.orc.storage.ql.exec.vector.ColumnVector fromColumn, WritableColumnVector toColumn) {
        if (fromColumn.isNull[0]) {
            toColumn.putNulls(0, batchSize);
        } else {
            DataType type = field.dataType();
            if (type instanceof BooleanType) {
                toColumn.putBooleans(0, batchSize, ((LongColumnVector)fromColumn).vector[0] == 1L);
            } else if (type instanceof ByteType) {
                toColumn.putBytes(0, batchSize, (byte)((LongColumnVector)fromColumn).vector[0]);
            } else if (type instanceof ShortType) {
                toColumn.putShorts(0, batchSize, (short)((LongColumnVector)fromColumn).vector[0]);
            } else if (type instanceof IntegerType || type instanceof DateType) {
                toColumn.putInts(0, batchSize, (int)((LongColumnVector)fromColumn).vector[0]);
            } else if (type instanceof LongType) {
                toColumn.putLongs(0, batchSize, ((LongColumnVector)fromColumn).vector[0]);
            } else if (type instanceof TimestampType) {
                toColumn.putLongs(0, batchSize, OrcColumnarBatchReader.fromTimestampColumnVector((TimestampColumnVector)fromColumn, 0));
            } else if (type instanceof FloatType) {
                toColumn.putFloats(0, batchSize, (float)((DoubleColumnVector)fromColumn).vector[0]);
            } else if (type instanceof DoubleType) {
                toColumn.putDoubles(0, batchSize, ((DoubleColumnVector)fromColumn).vector[0]);
            } else if (type instanceof StringType || type instanceof BinaryType) {
                BytesColumnVector data = (BytesColumnVector)fromColumn;
                int size = data.vector[0].length;
                toColumn.arrayData().reserve(size);
                toColumn.arrayData().putBytes(0, size, data.vector[0], 0);
                for (int index = 0; index < batchSize; ++index) {
                    toColumn.putArray(index, 0, size);
                }
            } else if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                OrcColumnarBatchReader.putDecimalWritables(toColumn, batchSize, decimalType.precision(), decimalType.scale(), ((DecimalColumnVector)fromColumn).vector[0]);
            } else {
                throw new UnsupportedOperationException("Unsupported Data Type: " + type);
            }
        }
    }

    private void putNonNullValues(int batchSize, StructField field, org.apache.orc.storage.ql.exec.vector.ColumnVector fromColumn, WritableColumnVector toColumn) {
        DataType type = field.dataType();
        if (type instanceof BooleanType) {
            long[] data = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putBoolean(index, data[index] == 1L);
            }
        } else if (type instanceof ByteType) {
            long[] data = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putByte(index, (byte)data[index]);
            }
        } else if (type instanceof ShortType) {
            long[] data = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putShort(index, (short)data[index]);
            }
        } else if (type instanceof IntegerType || type instanceof DateType) {
            long[] data = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putInt(index, (int)data[index]);
            }
        } else if (type instanceof LongType) {
            toColumn.putLongs(0, batchSize, ((LongColumnVector)fromColumn).vector, 0);
        } else if (type instanceof TimestampType) {
            TimestampColumnVector data = (TimestampColumnVector)fromColumn;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putLong(index, OrcColumnarBatchReader.fromTimestampColumnVector(data, index));
            }
        } else if (type instanceof FloatType) {
            double[] data = ((DoubleColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                toColumn.putFloat(index, (float)data[index]);
            }
        } else if (type instanceof DoubleType) {
            toColumn.putDoubles(0, batchSize, ((DoubleColumnVector)fromColumn).vector, 0);
        } else if (type instanceof StringType || type instanceof BinaryType) {
            BytesColumnVector data = (BytesColumnVector)fromColumn;
            WritableColumnVector arrayData = toColumn.arrayData();
            int totalNumBytes = IntStream.of(data.length).sum();
            arrayData.reserve(totalNumBytes);
            int pos = 0;
            for (int index = 0; index < batchSize; ++index) {
                arrayData.putBytes(pos, data.length[index], data.vector[index], data.start[index]);
                toColumn.putArray(index, pos, data.length[index]);
                pos += data.length[index];
            }
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            DecimalColumnVector data = (DecimalColumnVector)fromColumn;
            if (decimalType.precision() > Decimal.MAX_LONG_DIGITS()) {
                toColumn.arrayData().reserve(batchSize * 16);
            }
            for (int index = 0; index < batchSize; ++index) {
                OrcColumnarBatchReader.putDecimalWritable(toColumn, index, decimalType.precision(), decimalType.scale(), data.vector[index]);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Data Type: " + type);
        }
    }

    private void putValues(int batchSize, StructField field, org.apache.orc.storage.ql.exec.vector.ColumnVector fromColumn, WritableColumnVector toColumn) {
        DataType type = field.dataType();
        if (type instanceof BooleanType) {
            long[] vector = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putBoolean(index, vector[index] == 1L);
            }
        } else if (type instanceof ByteType) {
            long[] vector = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putByte(index, (byte)vector[index]);
            }
        } else if (type instanceof ShortType) {
            long[] vector = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putShort(index, (short)vector[index]);
            }
        } else if (type instanceof IntegerType || type instanceof DateType) {
            long[] vector = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putInt(index, (int)vector[index]);
            }
        } else if (type instanceof LongType) {
            long[] vector = ((LongColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putLong(index, vector[index]);
            }
        } else if (type instanceof TimestampType) {
            TimestampColumnVector vector = (TimestampColumnVector)fromColumn;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putLong(index, OrcColumnarBatchReader.fromTimestampColumnVector(vector, index));
            }
        } else if (type instanceof FloatType) {
            double[] vector = ((DoubleColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putFloat(index, (float)vector[index]);
            }
        } else if (type instanceof DoubleType) {
            double[] vector = ((DoubleColumnVector)fromColumn).vector;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                toColumn.putDouble(index, vector[index]);
            }
        } else if (type instanceof StringType || type instanceof BinaryType) {
            BytesColumnVector vector = (BytesColumnVector)fromColumn;
            WritableColumnVector arrayData = toColumn.arrayData();
            int totalNumBytes = IntStream.of(vector.length).sum();
            arrayData.reserve(totalNumBytes);
            int pos = 0;
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                } else {
                    arrayData.putBytes(pos, vector.length[index], vector.vector[index], vector.start[index]);
                    toColumn.putArray(index, pos, vector.length[index]);
                }
                pos += vector.length[index];
            }
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            HiveDecimalWritable[] vector = ((DecimalColumnVector)fromColumn).vector;
            if (decimalType.precision() > Decimal.MAX_LONG_DIGITS()) {
                toColumn.arrayData().reserve(batchSize * 16);
            }
            for (int index = 0; index < batchSize; ++index) {
                if (fromColumn.isNull[index]) {
                    toColumn.putNull(index);
                    continue;
                }
                OrcColumnarBatchReader.putDecimalWritable(toColumn, index, decimalType.precision(), decimalType.scale(), vector[index]);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Data Type: " + type);
        }
    }

    private static long fromTimestampColumnVector(TimestampColumnVector vector, int index) {
        return vector.time[index] * 1000L + (long)(vector.nanos[index] / 1000 % 1000);
    }

    private static void putDecimalWritable(WritableColumnVector toColumn, int index, int precision, int scale, HiveDecimalWritable decimalWritable) {
        HiveDecimal decimal = decimalWritable.getHiveDecimal();
        Decimal value = Decimal.apply((BigDecimal)decimal.bigDecimalValue(), (int)decimal.precision(), (int)decimal.scale());
        value.changePrecision(precision, scale);
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            toColumn.putInt(index, (int)value.toUnscaledLong());
        } else if (precision <= Decimal.MAX_LONG_DIGITS()) {
            toColumn.putLong(index, value.toUnscaledLong());
        } else {
            byte[] bytes = value.toJavaBigDecimal().unscaledValue().toByteArray();
            toColumn.arrayData().putBytes(index * 16, bytes.length, bytes, 0);
            toColumn.putArray(index, index * 16, bytes.length);
        }
    }

    private static void putDecimalWritables(WritableColumnVector toColumn, int size, int precision, int scale, HiveDecimalWritable decimalWritable) {
        HiveDecimal decimal = decimalWritable.getHiveDecimal();
        Decimal value = Decimal.apply((BigDecimal)decimal.bigDecimalValue(), (int)decimal.precision(), (int)decimal.scale());
        value.changePrecision(precision, scale);
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            toColumn.putInts(0, size, (int)value.toUnscaledLong());
        } else if (precision <= Decimal.MAX_LONG_DIGITS()) {
            toColumn.putLongs(0, size, value.toUnscaledLong());
        } else {
            byte[] bytes = value.toJavaBigDecimal().unscaledValue().toByteArray();
            toColumn.arrayData().reserve(bytes.length);
            toColumn.arrayData().putBytes(0, bytes.length, bytes, 0);
            for (int index = 0; index < size; ++index) {
                toColumn.putArray(index, 0, bytes.length);
            }
        }
    }
}

