/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasValue;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Predicate;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_2")
public class SimplePredicate
extends Predicate
implements HasExtensions,
HasValue {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="operator", required=true)
    private Operator operator;
    @XmlAttribute(name="value")
    private String value;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public SimplePredicate() {
    }

    public SimplePredicate(FieldName field, Operator operator) {
        this.field = field;
        this.operator = operator;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    public SimplePredicate setField(FieldName field) {
        this.field = field;
        return this;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public SimplePredicate setOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public SimplePredicate setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SimplePredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Operator {
        EQUAL("equal"),
        NOT_EQUAL("notEqual"),
        LESS_THAN("lessThan"),
        LESS_OR_EQUAL("lessOrEqual"),
        GREATER_THAN("greaterThan"),
        GREATER_OR_EQUAL("greaterOrEqual"),
        IS_MISSING("isMissing"),
        IS_NOT_MISSING("isNotMissing");

        private final String value;

        private Operator(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Operator fromValue(String v) {
            for (Operator c : Operator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

