/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LSHParams;
import org.apache.spark.ml.feature.LSHParams$class;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t5baB\u0001\u0003\u0003\u0003!AB\u0005\u0002\t\u0019NCUj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-\u0006\u0002\u000e)M!\u0001A\u0004\u0011$!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'Qa\u0001\u0001B\u0003\u0016\u0001\t\u0007qCA\u0001U\u0007\u0001\t\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0019q\u0004\u0001\n\u000e\u0003\t\u0001\"aH\u0011\n\u0005\t\u0012!!\u0003'T\u0011B\u000b'/Y7t!\t!s%D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003yA\u0001\"\f\u0001C\u0002\u001bEAAL\u0001\rQ\u0006\u001c\bNR;oGRLwN\\\u000b\u0002_A!\u0011\u0004\r\u001a9\u0013\t\t$DA\u0005Gk:\u001cG/[8ocA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0007Y&t\u0017\r\\4\n\u0005]\"$A\u0002,fGR|'\u000fE\u0002\u001asIJ!A\u000f\u000e\u0003\u000b\u0005\u0013(/Y=\t\rq\u0002a\u0011\u0003\u0003>\u0003-YW-\u001f#jgR\fgnY3\u0015\u0007y\n5\t\u0005\u0002\u001a\u007f%\u0011\u0001I\u0007\u0002\u0007\t>,(\r\\3\t\u000b\t[\u0004\u0019\u0001\u001a\u0002\u0003aDQ\u0001R\u001eA\u0002I\n\u0011!\u001f\u0005\u0007\r\u00021\t\u0002B$\u0002\u0019!\f7\u000f\u001b#jgR\fgnY3\u0015\u0007yBU\u000bC\u0003C\u000b\u0002\u0007\u0011\nE\u0002K%Jr!a\u0013)\u000f\u00051{U\"A'\u000b\u000593\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t\t&$A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011K\u0007\u0005\u0006\t\u0016\u0003\r!\u0013\u0005\u0006/\u0002!\t\u0005W\u0001\niJ\fgn\u001d4pe6$\"!W5\u0011\u0005i3gBA.e\u001d\ta&M\u0004\u0002^C:\u0011a\f\u0019\b\u0003\u0019~K\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\r4\u0011aA:rY&\u0011\u0011+\u001a\u0006\u0003G\u001aI!a\u001a5\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA)f\u0011\u0015Qg\u000b1\u0001l\u0003\u001d!\u0017\r^1tKR\u0004$\u0001\\9\u0011\u00075t\u0007/D\u0001f\u0013\tyWMA\u0004ECR\f7/\u001a;\u0011\u0005M\tH!\u0003:j\u0003\u0003\u0005\tQ!\u0001t\u0005\ryF%M\t\u00031Q\u0004\"!G;\n\u0005YT\"aA!os\")\u0001\u0010\u0001C!s\u0006yAO]1og\u001a|'/\\*dQ\u0016l\u0017\rF\u0002{\u0003\u0003\u0001\"a\u001f@\u000e\u0003qT!!`3\u0002\u000bQL\b/Z:\n\u0005}d(AC*ueV\u001cG\u000fV=qK\"1\u00111A<A\u0002i\faa]2iK6\f\u0007\u0002CA\u0004\u0001\u0011\u0005!!!\u0003\u0002-\u0005\u0004\bO]8y\u001d\u0016\f'/Z:u\u001d\u0016Lw\r\u001b2peN$B\"a\u0003\u0002\u0016\u0005\u0005\u0012QEA\u0018\u0003s\u0001D!!\u0004\u0002\u0012A!QN\\A\b!\r\u0019\u0012\u0011\u0003\u0003\f\u0003'\t)!!A\u0001\u0002\u000b\u00051OA\u0002`IMBqA[A\u0003\u0001\u0004\t9\u0002\r\u0003\u0002\u001a\u0005u\u0001\u0003B7o\u00037\u00012aEA\u000f\t-\ty\"!\u0006\u0002\u0002\u0003\u0005)\u0011A:\u0003\u0007}##\u0007C\u0004\u0002$\u0005\u0015\u0001\u0019\u0001\u001a\u0002\u0007-,\u0017\u0010\u0003\u0005\u0002(\u0005\u0015\u0001\u0019AA\u0015\u0003MqW/\u001c(fCJ,7\u000f\u001e(fS\u001eD'm\u001c:t!\rI\u00121F\u0005\u0004\u0003[Q\"aA%oi\"A\u0011\u0011GA\u0003\u0001\u0004\t\u0019$A\u0006tS:<G.\u001a)s_\n,\u0007cA\r\u00026%\u0019\u0011q\u0007\u000e\u0003\u000f\t{w\u000e\\3b]\"A\u00111HA\u0003\u0001\u0004\ti$A\u0004eSN$8i\u001c7\u0011\t\u0005}\u0012Q\t\b\u00043\u0005\u0005\u0013bAA\"5\u00051\u0001K]3eK\u001aLA!a\u0012\u0002J\t11\u000b\u001e:j]\u001eT1!a\u0011\u001b\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u001b\"\"\"a\u0014\u0002Z\u0005\u0015\u0014qMA5a\u0011\t\t&!\u0016\u0011\t5t\u00171\u000b\t\u0004'\u0005UCaCA,\u0003\u0017\n\t\u0011!A\u0003\u0002M\u00141a\u0018\u00136\u0011\u001dQ\u00171\na\u0001\u00037\u0002D!!\u0018\u0002bA!QN\\A0!\r\u0019\u0012\u0011\r\u0003\f\u0003G\nI&!A\u0001\u0002\u000b\u00051OA\u0002`IQBq!a\t\u0002L\u0001\u0007!\u0007\u0003\u0005\u0002(\u0005-\u0003\u0019AA\u0015\u0011!\tY$a\u0013A\u0002\u0005u\u0002bBA\u0004\u0001\u0011\u0005\u0011Q\u000e\u000b\t\u0003_\nI(!\"\u0002\bB\"\u0011\u0011OA;!\u0011ig.a\u001d\u0011\u0007M\t)\bB\u0006\u0002x\u0005-\u0014\u0011!A\u0001\u0006\u0003\u0019(aA0%o!9!.a\u001bA\u0002\u0005m\u0004\u0007BA?\u0003\u0003\u0003B!\u001c8\u0002\u0000A\u00191#!!\u0005\u0017\u0005\r\u0015\u0011PA\u0001\u0002\u0003\u0015\ta\u001d\u0002\u0004?\u00122\u0004bBA\u0012\u0003W\u0002\rA\r\u0005\t\u0003O\tY\u00071\u0001\u0002*!A\u00111\u0012\u0001!\n\u0013\ti)\u0001\bqe>\u001cWm]:ECR\f7/\u001a;\u0015\u0011\u0005=\u0015\u0011TAS\u0003S\u0003D!!%\u0002\u0016B!QN\\AJ!\r\u0019\u0012Q\u0013\u0003\f\u0003/\u000bI)!A\u0001\u0002\u000b\u00051OA\u0002`IeBqA[AE\u0001\u0004\tY\n\r\u0003\u0002\u001e\u0006\u0005\u0006\u0003B7o\u0003?\u00032aEAQ\t-\t\u0019+!'\u0002\u0002\u0003\u0005)\u0011A:\u0003\u0007}#\u0003\b\u0003\u0005\u0002(\u0006%\u0005\u0019AA\u001f\u0003%Ig\u000e];u\u001d\u0006lW\r\u0003\u0005\u0002,\u0006%\u0005\u0019AAW\u0003-)\u0007\u0010\u001d7pI\u0016\u001cu\u000e\\:\u0011\t)\u0013\u0016Q\b\u0005\t\u0003c\u0003\u0001\u0015\"\u0003\u00024\u0006Y!/Z2sK\u0006$XmQ8m)!\t),a0\u0002L\u0006=\u0007\u0007BA\\\u0003w\u0003B!\u001c8\u0002:B\u00191#a/\u0005\u0017\u0005u\u0016qVA\u0001\u0002\u0003\u0015\ta\u001d\u0002\u0005?\u0012\n\u0014\u0007C\u0004k\u0003_\u0003\r!!11\t\u0005\r\u0017q\u0019\t\u0005[:\f)\rE\u0002\u0014\u0003\u000f$1\"!3\u0002@\u0006\u0005\t\u0011!B\u0001g\n!q\fJ\u00191\u0011!\ti-a,A\u0002\u0005u\u0012aB2pY:\u000bW.\u001a\u0005\t\u0003#\fy\u000b1\u0001\u0002>\u0005QA/\u001c9D_2t\u0015-\\3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u0006!\u0012\r\u001d9s_b\u001c\u0016.\\5mCJLG/\u001f&pS:$\"\"!7\u0002d\u0006E\u0018q B\u0002a\u0011\tY.a8\u0011\t5t\u0017Q\u001c\t\u0004'\u0005}GaCAq\u0003'\f\t\u0011!A\u0003\u0002M\u0014Aa\u0018\u00132i!A\u0011Q]Aj\u0001\u0004\t9/\u0001\u0005eCR\f7/\u001a;Ba\u0011\tI/!<\u0011\t5t\u00171\u001e\t\u0004'\u00055HaCAx\u0003G\f\t\u0011!A\u0003\u0002M\u0014Aa\u0018\u00132e!A\u00111_Aj\u0001\u0004\t)0\u0001\u0005eCR\f7/\u001a;Ca\u0011\t90a?\u0011\t5t\u0017\u0011 \t\u0004'\u0005mHaCA\u007f\u0003c\f\t\u0011!A\u0003\u0002M\u0014Aa\u0018\u00132g!9!\u0011AAj\u0001\u0004q\u0014!\u0003;ie\u0016\u001c\bn\u001c7e\u0011!\tY$a5A\u0002\u0005u\u0002bBAk\u0001\u0011\u0005!q\u0001\u000b\t\u0005\u0013\u0011\u0019Ba\b\u0003,A\"!1\u0002B\b!\u0011igN!\u0004\u0011\u0007M\u0011y\u0001B\u0006\u0003\u0012\t\u0015\u0011\u0011!A\u0001\u0006\u0003\u0019(\u0001B0%c]B\u0001\"!:\u0003\u0006\u0001\u0007!Q\u0003\u0019\u0005\u0005/\u0011Y\u0002\u0005\u0003n]\ne\u0001cA\n\u0003\u001c\u0011Y!Q\u0004B\n\u0003\u0003\u0005\tQ!\u0001t\u0005\u0011yF%M\u001b\t\u0011\u0005M(Q\u0001a\u0001\u0005C\u0001DAa\t\u0003(A!QN\u001cB\u0013!\r\u0019\"q\u0005\u0003\f\u0005S\u0011y\"!A\u0001\u0002\u000b\u00051O\u0001\u0003`IE2\u0004b\u0002B\u0001\u0005\u000b\u0001\rA\u0010")
public abstract class LSHModel<T extends LSHModel<T>>
extends Model<T>
implements LSHParams,
MLWritable {
    private final IntParam numHashTables;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam numHashTables() {
        return this.numHashTables;
    }

    @Override
    public final void org$apache$spark$ml$feature$LSHParams$_setter_$numHashTables_$eq(IntParam x$1) {
        this.numHashTables = x$1;
    }

    @Override
    public final int getNumHashTables() {
        return LSHParams$class.getNumHashTables(this);
    }

    @Override
    public final StructType validateAndTransformSchema(StructType schema) {
        return LSHParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    public abstract Function1<Vector, Vector[]> hashFunction();

    public abstract double keyDistance(Vector var1, Vector var2);

    public abstract double hashDistance(Seq<Vector> var1, Seq<Vector> var2);

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        UserDefinedFunction transformUDF = functions$.MODULE$.udf(this.hashFunction(), (DataType)DataTypes.createArrayType((DataType)new VectorUDT()));
        return dataset.withColumn(this.$(this.outputCol()), transformUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, boolean singleProbe, String distCol) {
        Dataset dataset2;
        Dataset<Row> modelDataset;
        Predef$.MODULE$.require(numNearestNeighbors > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The number of nearest neighbors cannot be less than 1";
            }
        });
        Vector[] keyHash = (Vector[])this.hashFunction().apply((Object)key);
        Dataset<Row> dataset3 = modelDataset = Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).contains((Object)this.$(this.outputCol())) ? dataset.toDF() : this.transform(dataset);
        if (singleProbe) {
            UserDefinedFunction sameBucketWithKeyUDF = functions$.MODULE$.udf((Object)new Serializable(this, keyHash){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LSHModel $outer;
                private final Vector[] keyHash$1;

                public final boolean apply(Seq<Vector> x) {
                    return this.$outer.org$apache$spark$ml$feature$LSHModel$$sameBucket$1(x, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.keyHash$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.keyHash$1 = keyHash$1;
                }
            }, DataTypes.BooleanType);
            dataset2 = modelDataset.filter(sameBucketWithKeyUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))})));
        } else {
            UserDefinedFunction hashDistUDF = functions$.MODULE$.udf((Object)new Serializable(this, keyHash){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LSHModel $outer;
                private final Vector[] keyHash$1;

                public final double apply(Seq<Vector> x) {
                    return this.$outer.hashDistance(x, (Seq<Vector>)Predef$.MODULE$.wrapRefArray((Object[])this.keyHash$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.keyHash$1 = keyHash$1;
                }
            }, DataTypes.DoubleType);
            Column hashDistCol = hashDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))}));
            Dataset modelDatasetSortedByHash = modelDataset.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{hashDistCol})).limit(numNearestNeighbors);
            Dataset thresholdDataset = modelDatasetSortedByHash.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(hashDistCol)}));
            double hashThreshold = ((Row)Predef$.MODULE$.refArrayOps((Object[])thresholdDataset.take(1)).head()).getDouble(0);
            dataset2 = modelDataset.filter(hashDistCol.$less$eq((Object)BoxesRunTime.boxToDouble((double)hashThreshold)));
        }
        Dataset modelSubset = dataset2;
        UserDefinedFunction keyDistUDF = functions$.MODULE$.udf((Object)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LSHModel $outer;
            private final Vector key$1;

            public final double apply(Vector x) {
                return this.$outer.keyDistance(x, this.key$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, DataTypes.DoubleType);
        Dataset modelSubsetWithDistCol = modelSubset.withColumn(distCol, keyDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
        return modelSubsetWithDistCol.sort(distCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).limit(numNearestNeighbors);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, String distCol) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, distCol);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, "distCol");
    }

    private Dataset<?> processDataset(Dataset<?> dataset, String inputName, Seq<String> explodeCols) {
        Predef$.MODULE$.require(explodeCols.size() == 2, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "explodeCols must be two strings.";
            }
        });
        Dataset<Row> modelDataset = Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).contains((Object)this.$(this.outputCol())) ? dataset.toDF() : this.transform(dataset);
        return modelDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*")})).as(inputName), functions$.MODULE$.posexplode(functions$.MODULE$.col(this.$(this.outputCol()))).as(explodeCols)}));
    }

    private Dataset<?> recreateCol(Dataset<?> dataset, String colName, String tmpColName) {
        return dataset.withColumnRenamed(colName, tmpColName).withColumn(colName, functions$.MODULE$.col(tmpColName)).drop(tmpColName);
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold, String distCol) {
        Dataset<?> dataset;
        String leftColName = "datasetA";
        String rightColName = "datasetB";
        Seq explodeCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entry", "hashValue"}));
        Dataset<?> explodedA = this.processDataset(datasetA, leftColName, (Seq<String>)explodeCols);
        Dataset<?> dataset2 = datasetA;
        Dataset<?> dataset3 = datasetB;
        if (!(dataset2 != null ? !dataset2.equals(dataset3) : dataset3 != null)) {
            Dataset<?> recreatedB = this.recreateCol(datasetB, this.$(this.inputCol()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "#", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.inputCol()), Random$.MODULE$.nextString(5)})));
            dataset = this.processDataset(recreatedB, rightColName, (Seq<String>)explodeCols);
        } else {
            dataset = this.processDataset(datasetB, rightColName, (Seq<String>)explodeCols);
        }
        Dataset<?> explodedB = dataset;
        Dataset joinedDataset = explodedA.join(explodedB, explodeCols).drop(explodeCols).distinct();
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LSHModel $outer;

            public final double apply(Vector x, Vector y) {
                return this.$outer.keyDistance(x, y);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, DataTypes.DoubleType);
        Dataset joinedDatasetWithDist = joinedDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftColName, this.$(this.inputCol())}))), functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightColName, this.$(this.inputCol())})))})).as(distCol)}));
        return joinedDatasetWithDist.filter(functions$.MODULE$.col(distCol).$less((Object)BoxesRunTime.boxToDouble((double)threshold)));
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold) {
        return this.approxSimilarityJoin(datasetA, datasetB, threshold, "distCol");
    }

    public final boolean org$apache$spark$ml$feature$LSHModel$$sameBucket$1(Seq x, Seq y) {
        return ((IterableLike)x.zip((GenIterable)y, Seq$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Vector, Vector> tuple) {
                return BoxesRunTime.equals((Object)tuple._1(), (Object)tuple._2());
            }
        });
    }

    public LSHModel() {
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        LSHParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

