/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTClassifierParams$class;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeClassifierParams$class;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleModel$class;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B\u0001\u0003\u00015\u0011ac\u0012\"U\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0002\u0001\u000f3}Ac\u0006\u0005\u0003\u0010!IAR\"\u0001\u0002\n\u0005E\u0011!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\r1Lg.\u00197h\u0013\t9BC\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001f\u0001\u0001\"AG\u000f\u000e\u0003mQ!\u0001\b\u0003\u0002\tQ\u0014X-Z\u0005\u0003=m\u00111c\u0012\"U\u00072\f7o]5gS\u0016\u0014\b+\u0019:b[N\u00042A\u0007\u0011#\u0013\t\t3DA\tUe\u0016,WI\\:f[\ndW-T8eK2\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002(I\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003[)\u0012!\"\u0014'Xe&$\u0018M\u00197f!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!)\u0004A!b\u0001\n\u00032\u0014aA;jIV\tq\u0007\u0005\u00029w9\u0011q&O\u0005\u0003uA\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!\b\r\u0015\u0004i}*\u0005C\u0001!D\u001b\u0005\t%B\u0001\"\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003\t\u0006\u0013QaU5oG\u0016\f\u0013AR\u0001\u0006c92d\u0006\r\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005o\u0005!Q/\u001b3!Q\r9u(\u0012\u0005\t\u0017\u0002\u0011)\u0019!C\u0005\u0019\u00061q\f\u001e:fKN,\u0012!\u0014\t\u0004_9\u0013\u0013BA(1\u0005\u0015\t%O]1z\u0011!\t\u0006A!A!\u0002\u0013i\u0015aB0ue\u0016,7\u000f\t\u0005\t'\u0002\u0011)\u0019!C\u0005)\u0006aq\f\u001e:fK^+\u0017n\u001a5ugV\tQ\u000bE\u00020\u001dZ\u0003\"aL,\n\u0005a\u0003$A\u0002#pk\ndW\r\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003V\u00035yFO]3f/\u0016Lw\r\u001b;tA!AA\f\u0001BC\u0002\u0013\u0005S,A\u0006ok64U-\u0019;ve\u0016\u001cX#\u00010\u0011\u0005=z\u0016B\u000111\u0005\rIe\u000e\u001e\u0015\u00047~*\u0005\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011)\u0007\t|T\t\u0003\u0005g\u0001\t\u0015\r\u0011\"\u0011^\u0003)qW/\\\"mCN\u001cXm\u001d\u0015\u0004K~B\u0017%A5\u0002\u000bIr#G\f\u0019\t\u0011-\u0004!\u0011!Q\u0001\ny\u000b1B\\;n\u00072\f7o]3tA!\u001a!n\u00105\t\r9\u0004A\u0011\u0001\u0003p\u0003\u0019a\u0014N\\5u}Q1\u0001\u0004\u001d:tiZDQ!N7A\u0002]B3\u0001] F\u0011\u0015YU\u000e1\u0001N\u0011\u0015\u0019V\u000e1\u0001V\u0011\u0015aV\u000e1\u0001_Q\r!x(\u0012\u0005\u0006M6\u0004\rA\u0018\u0015\u0004m~B\u0007B\u00028\u0001\t\u0003!\u0011\u0010F\u0003\u0019undX\u0010C\u00036q\u0002\u0007q\u0007C\u0003Lq\u0002\u0007Q\nC\u0003Tq\u0002\u0007Q\u000bC\u0003]q\u0002\u0007a\fC\u0003o\u0001\u0011\u0005q\u0010F\u0004\u0019\u0003\u0003\t\u0019!!\u0002\t\u000bUr\b\u0019A\u001c\t\u000b-s\b\u0019A'\t\u000bMs\b\u0019A+)\u0007y|T\t\u0003\u0004\u0002\f\u0001!\t\u0005T\u0001\u0006iJ,Wm\u001d\u0015\u0006\u0003\u0013y\u0014qB\u0011\u0003\u0003#\tQ!\r\u00185]AB\u0001\"!\u0006\u0001\u0005\u0004%\t!X\u0001\fO\u0016$h*^7Ue\u0016,7\u000fK\u0003\u0002\u0014}\nI\"\t\u0002\u0002\u001c\u0005)!G\f\u0019/a!9\u0011q\u0004\u0001!\u0002\u0013q\u0016\u0001D4fi:+X\u000e\u0016:fKN\u0004\u0003&BA\u000f\u007f\u0005e\u0001BBA\u0013\u0001\u0011\u0005C+A\u0006ue\u0016,w+Z5hQR\u001c\b&BA\u0012\u007f\u0005=\u0001bBA\u0016\u0001\u0011E\u0013QF\u0001\u000eiJ\fgn\u001d4pe6LU\u000e\u001d7\u0015\t\u0005=\u0012q\u000b\t\u0005\u0003c\t\tF\u0004\u0003\u00024\u0005-c\u0002BA\u001b\u0003\u000frA!a\u000e\u0002F9!\u0011\u0011HA\"\u001d\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005%c!A\u0002tc2LA!!\u0014\u0002P\u00059\u0001/Y2lC\u001e,'bAA%\r%!\u00111KA+\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002N\u0005=\u0003\u0002CA-\u0003S\u0001\r!a\u0017\u0002\u000f\u0011\fG/Y:fiB\"\u0011QLA5!\u0019\ty&!\u0019\u0002f5\u0011\u0011qJ\u0005\u0005\u0003G\nyEA\u0004ECR\f7/\u001a;\u0011\t\u0005\u001d\u0014\u0011\u000e\u0007\u0001\t1\tY'a\u0016\u0002\u0002\u0003\u0005)\u0011AA7\u0005\ryFEM\t\u0005\u0003_\n)\bE\u00020\u0003cJ1!a\u001d1\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aLA<\u0013\r\tI\b\r\u0002\u0004\u0003:L\bbBA?\u0001\u0011E\u0013qP\u0001\baJ,G-[2u)\r1\u0016\u0011\u0011\u0005\b\u0003\u0007\u000bY\b1\u0001\u0013\u0003!1W-\u0019;ve\u0016\u001c\bbBAD\u0001\u0011E\u0013\u0011R\u0001\u000baJ,G-[2u%\u0006<Hc\u0001\n\u0002\f\"9\u00111QAC\u0001\u0004\u0011\u0002bBAH\u0001\u0011E\u0013\u0011S\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0019!#a%\t\u000f\u0005U\u0015Q\u0012a\u0001%\u0005i!/Y<Qe\u0016$\u0017n\u0019;j_:D\u0001\"!'\u0001\u0005\u0004%\t!X\u0001\t]VlGK]3fg\"9\u0011Q\u0014\u0001!\u0002\u0013q\u0016!\u00038v[R\u0013X-Z:!\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000bAaY8qsR\u0019\u0001$!*\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003S\u000bQ!\u001a=ue\u0006\u0004B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_#\u0011!\u00029be\u0006l\u0017\u0002BAZ\u0003[\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006\u0003?{\u0014q\u0002\u0005\b\u0003s\u0003A\u0011IA^\u0003!!xn\u0015;sS:<G#A\u001c)\u000b\u0005]v(a\u0004\t\u0015\u0005\u0005\u0007\u0001#b\u0001\n\u0003\t\u0019-\u0001\ngK\u0006$XO]3J[B|'\u000f^1oG\u0016\u001cX#\u0001\n)\u000b\u0005}v(!\u0007\t\u0013\u0005%\u0007\u0001#A!B\u0013\u0011\u0012a\u00054fCR,(/Z%na>\u0014H/\u00198dKN\u0004\u0003&BAd\u007f\u0005e\u0001bBAh\u0001\u0011%\u0011\u0011[\u0001\u0007[\u0006\u0014x-\u001b8\u0015\u0007Y\u000b\u0019\u000eC\u0004\u0002\u0004\u00065\u0007\u0019\u0001\n\t\u0011\u0005]\u0007\u0001\"\u0001\u0005\u00033\fQ\u0001^8PY\u0012,\"!a7\u0011\t\u0005u\u0017\u0011^\u0007\u0003\u0003?TA!!9\u0002d\u0006)Qn\u001c3fY*\u0019A$!:\u000b\u0007\u0005\u001dh!A\u0003nY2L'-\u0003\u0003\u0002l\u0006}'!G$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7/T8eK2D\u0011\"a<\u0001\u0005\u0004%I!!=\u0002\t1|7o]\u000b\u0003\u0003g\u0004B!!>\u0002z6\u0011\u0011q\u001f\u0006\u0005\u0003_\f\u0019/\u0003\u0003\u0002|\u0006](AE\"mCN\u001c\u0018NZ5dCRLwN\u001c'pgND\u0001\"a@\u0001A\u0003%\u00111_\u0001\u0006Y>\u001c8\u000f\t\u0005\b\u0005\u0007\u0001A\u0011\tB\u0003\u0003\u00159(/\u001b;f+\t\u00119\u0001E\u0002*\u0005\u0013I1Aa\u0003+\u0005!iEj\u0016:ji\u0016\u0014\b&\u0002B\u0001\u007f\u0005e\u0001f\u0001\u0001@\u000b\u001e9!1\u0003\u0002\t\u0002\tU\u0011AF$C)\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0007=\u00119B\u0002\u0004\u0002\u0005!\u0005!\u0011D\n\b\u0005/\u0011YB!\t/!\ry#QD\u0005\u0004\u0005?\u0001$AB!osJ+g\r\u0005\u0003*\u0005GA\u0012b\u0001B\u0013U\tQQ\n\u0014*fC\u0012\f'\r\\3\t\u000f9\u00149\u0002\"\u0001\u0003*Q\u0011!Q\u0003\u0005\n\u0005[\u00119B1A\u0005\nY\naB\\;n\r\u0016\fG/\u001e:fg.+\u0017\u0010\u0003\u0005\u00032\t]\u0001\u0015!\u00038\u0003=qW/\u001c$fCR,(/Z:LKf\u0004\u0003\"\u0003B\u001b\u0005/\u0011\r\u0011\"\u00037\u0003-qW/\u001c+sK\u0016\u001c8*Z=\t\u0011\te\"q\u0003Q\u0001\n]\nAB\\;n)J,Wm]&fs\u0002B\u0001B!\u0010\u0003\u0018\u0011\u0005#qH\u0001\u0005e\u0016\fG-\u0006\u0002\u0003BA!\u0011Fa\u0011\u0019\u0013\r\u0011)E\u000b\u0002\t\u001b2\u0013V-\u00193fe\"*!1H \u0002\u001a!A!1\nB\f\t\u0003\u0012i%\u0001\u0003m_\u0006$Gc\u0001\r\u0003P!9!\u0011\u000bB%\u0001\u00049\u0014\u0001\u00029bi\"DSA!\u0013@\u000331\u0011Ba\u0016\u0003\u0018\u0001\u00119B!\u0017\u00039\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2<&/\u001b;feN!!Q\u000bB\u0004\u0011)\u0011iF!\u0016\u0003\u0002\u0003\u0006I\u0001G\u0001\tS:\u001cH/\u00198dK\"9aN!\u0016\u0005\u0002\t\u0005D\u0003\u0002B2\u0005O\u0002BA!\u001a\u0003V5\u0011!q\u0003\u0005\b\u0005;\u0012y\u00061\u0001\u0019\u0011!\u0011YG!\u0016\u0005R\t5\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\t=$Q\u000f\t\u0004_\tE\u0014b\u0001B:a\t!QK\\5u\u0011\u001d\u0011\tF!\u001bA\u0002]2qA!\u001f\u0003\u0018\u0011\u0011YH\u0001\u000fH\u0005R\u001bE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\t\t]$\u0011\t\u0005\b]\n]D\u0011\u0001B@)\t\u0011\t\t\u0005\u0003\u0003f\t]\u0004B\u0003BC\u0005o\u0012\r\u0011\"\u0003\u0003\b\u0006I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005\u0013\u0003BAa#\u0003\u00166\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0003mC:<'B\u0001BJ\u0003\u0011Q\u0017M^1\n\u0007q\u0012i\tC\u0005\u0003\u001a\n]\u0004\u0015!\u0003\u0003\n\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\t\u0015\tu%q\u000fb\u0001\n\u0013\u00119)A\u0007ue\u0016,7\t\\1tg:\u000bW.\u001a\u0005\n\u0005C\u00139\b)A\u0005\u0005\u0013\u000ba\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0003L\t]D\u0011\tBS)\rA\"q\u0015\u0005\b\u0005#\u0012\u0019\u000b1\u00018\u0011%\u0011YKa\u0006\u0005\u0002\u0011\u0011i+A\u0004ge>lw\n\u001c3\u0015\u0017a\u0011yKa-\u0003>\n\u001d'\u0011\u001a\u0005\t\u0005c\u0013I\u000b1\u0001\u0002\\\u0006Aq\u000e\u001c3N_\u0012,G\u000e\u0003\u0005\u00036\n%\u0006\u0019\u0001B\\\u0003\u0019\u0001\u0018M]3oiB\u0019qB!/\n\u0007\tm&AA\u0007H\u0005R\u001bE.Y:tS\u001aLWM\u001d\u0005\t\u0005\u007f\u0013I\u000b1\u0001\u0003B\u0006\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB)\u0001Ha1_=&\u0019!QY\u001f\u0003\u00075\u000b\u0007\u000f\u0003\u0005]\u0005S\u0003\n\u00111\u0001_\u0011!1'\u0011\u0016I\u0001\u0002\u0004q\u0006B\u0003Bg\u0005/\t\n\u0011\"\u0001\u0003P\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tE'f\u00010\u0003T.\u0012!Q\u001b\t\u0005\u0005/\u0014y.\u0004\u0002\u0003Z*!!1\u001cBo\u0003%)hn\u00195fG.,GM\u0003\u0002Ca%!!\u0011\u001dBm\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005K\u00149\"%A\u0005\u0002\t=\u0017!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%k!Q!\u0011\u001eB\f\u0003\u0003%IAa;\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005[\u0004BAa#\u0003p&!!\u0011\u001fBG\u0005\u0019y%M[3di\"*!qC \u0002\u001a!*!\u0011C \u0002\u001a\u0001")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private final String uid;
    private final DecisionTreeRegressionModel[] org$apache$spark$ml$classification$GBTClassificationModel$$_trees;
    private final double[] org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final int numTrees;
    private Vector featureImportances;
    private final ClassificationLoss loss;
    private final int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static int fromOld$default$5() {
        return GBTClassificationModel$.MODULE$.fromOld$default$5();
    }

    public static int fromOld$default$4() {
        return GBTClassificationModel$.MODULE$.fromOld$default$4();
    }

    public static GBTClassificationModel load(String string) {
        return GBTClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.featureImportances;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel$class.totalNumNodes(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.totalNumNodes;
        }
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel$class.javaTreeWeights(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel$class.toDebugString(this);
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param x$1) {
        this.lossType = x$1;
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams$class.getLossType(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams$class.getOldLossType(this);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams$class.setImpurity(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams$class.getOldImpurity(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams$class.setStepSize(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DecisionTreeRegressionModel[] org$apache$spark$ml$classification$GBTClassificationModel$$_trees() {
        return this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees;
    }

    public double[] org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights() {
        return this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this, bcastModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcastModel$1;

            public final double apply(Object features) {
                return ((GBTClassificationModel)this.bcastModel$1.value()).predict((Vector)features);
            }
            {
                this.bcastModel$1 = bcastModel$1;
            }
        }, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        return this.isDefined(this.thresholds()) ? super.predict(features) : (this.margin(features) > 0.0 ? 1.0 : 0.0);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
            denseVector.values()[1] = 1.0 - denseVector.values()[0];
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees(), this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassificationModel (uid=", ") with ", " trees"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid(), BoxesRunTime.boxToInteger((int)this.numTrees())}));
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees()).map((Function1)new Serializable(this, features){
            public static final long serialVersionUID = 0L;
            private final Vector features$1;

            public final double apply(DecisionTreeRegressionModel x$2) {
                return x$2.rootNode().predictImpl(this.features$1).prediction();
            }
            {
                this.features$1 = features$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeModel apply(DecisionTreeRegressionModel x$3) {
                return x$3.toOld();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights2, int numFeatures, int numClasses) {
        this.uid = uid;
        this.org$apache$spark$ml$classification$GBTClassificationModel$$_trees = _trees;
        this.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights = _treeWeights2;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeClassifierParams$class.$init$(this);
        GBTClassifierParams$class.$init$(this);
        TreeEnsembleModel$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])_trees).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTClassificationModel requires at least 1 tree.";
            }
        });
        Predef$.MODULE$.require(_trees.length == _treeWeights2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassificationModel $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"GBTClassificationModel given trees, treeWeights").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of non-matching lengths (", ", ", ", respectively)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$GBTClassificationModel$$_trees().length), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$classification$GBTClassificationModel$$_treeWeights().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
        this.loss = this.getOldLossType();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights2, int numFeatures) {
        this(uid, _trees, _treeWeights2, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights2) {
        this(uid, _trees, _treeWeights2, -1, 2);
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            });
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }

    public static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
            if (tuple3 != null) {
                DefaultParamsReader.Metadata metadata = (DefaultParamsReader.Metadata)tuple3._1();
                Tuple2[] treesData = (Tuple2[])tuple3._2();
                double[] treeWeights = (double[])tuple3._3();
                if (metadata != null) {
                    DefaultParamsReader.Metadata metadata2 = metadata;
                    if (treesData != null) {
                        Tuple2[] tuple2Array = treesData;
                        if (treeWeights != null) {
                            DecisionTreeRegressionModel[] trees;
                            Tuple3 tuple32;
                            double[] dArray = treeWeights;
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)metadata2, (Object)tuple2Array, (Object)dArray);
                            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple33._1();
                            Tuple2[] treesData2 = (Tuple2[])tuple33._2();
                            double[] treeWeights2 = (double[])tuple33._3();
                            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
                            Predef$.MODULE$.require(numTrees == (trees = (DecisionTreeRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])treesData2).map((Function1)new Serializable(this, numFeatures){
                                public static final long serialVersionUID = 0L;
                                private final int numFeatures$1;

                                public final DecisionTreeRegressionModel apply(Tuple2<DefaultParamsReader.Metadata, Node> x0$2) {
                                    Tuple2<DefaultParamsReader.Metadata, Node> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                                        Node root = (Node)tuple2._2();
                                        DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, this.numFeatures$1);
                                        DefaultParamsReader$.MODULE$.getAndSetParams(tree, treeMetadata, DefaultParamsReader$.MODULE$.getAndSetParams$default$3());
                                        DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                                        return decisionTreeRegressionModel;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.numFeatures$1 = numFeatures$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)))).length, (Function0)new Serializable(this, numTrees, trees){
                                public static final long serialVersionUID = 0L;
                                private final int numTrees$1;
                                private final DecisionTreeRegressionModel[] trees$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassificationModel.load expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" trees based on metadata but found ", " trees."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trees$1.length)}))).toString();
                                }
                                {
                                    this.numTrees$1 = numTrees$1;
                                    this.trees$1 = trees$1;
                                }
                            });
                            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
                            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata3, DefaultParamsReader$.MODULE$.getAndSetParams$default$3());
                            return model;
                        }
                    }
                }
            }
            throw new MatchError(tuple3);
        }
    }
}

