/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.clustering.LDAParams$class;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uh!B\u0001\u0003\u0003\u0003i!\u0001\u0003'E\u00036{G-\u001a7\u000b\u0005\r!\u0011AC2mkN$XM]5oO*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002F\f\u001e!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u00131#\u0015\tU1sC6\u001c\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001e\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003*\u0013aA;jIV\ta\u0005\u0005\u0002([9\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013\u0006K\u0002$c]\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00027g\t)1+\u001b8dK\u0006\n\u0001(A\u00032]Yr\u0003\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003'\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007e\nt\u0007\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001?\u0003%1xnY1c'&TX-F\u0001@!\tA\u0003)\u0003\u0002BS\t\u0019\u0011J\u001c;)\u0007q\nt\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003@\u0003)1xnY1c'&TX\r\t\u0015\u0004\u0007F:\u0004\"C$\u0001\u0005\u000b\u0007I\u0011\u0001\u0003I\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u001d.\u0013Ab\u00159be.\u001cVm]:j_:D3AR\u00198\u0011!\t\u0006A!A!\u0002\u0013I\u0015!D:qCJ\\7+Z:tS>t\u0007\u0005\u000b\u0002Q'B\u0011\u0001\u0006V\u0005\u0003+&\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u0007A\u000bt\u0007\u0003\u0004Y\u0001\u0011\u0005A!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\tIQFL\u0018\u0005\u0006I]\u0003\rA\n\u0015\u00045F:\u0004\"B\u001fX\u0001\u0004y\u0004f\u0001/2o!)qi\u0016a\u0001\u0013\"\u001aa,M\u001c\t\r\u0005\u0004a\u0011\u0001\u0002c\u00035yG\u000e\u001a'pG\u0006dWj\u001c3fYV\t1\r\u0005\u0002eQ6\tQM\u0003\u0002\u0004M*\u0011qMB\u0001\u0006[2d\u0017NY\u0005\u0003S\u0016\u0014Q\u0002T8dC2dE)Q'pI\u0016d\u0007f\u000112o!1A\u000e\u0001D\u0001\u00055\f\u0001bZ3u\u001b>$W\r\\\u000b\u0002]B\u0011Am\\\u0005\u0003\u0003\u0015D3a[\u00198\u0011\u0019\u0011\b\u0001\"\u0001\u0005g\u0006ar-\u001a;FM\u001a,7\r^5wK\u0012{7mQ8oG\u0016tGO]1uS>tW#\u0001;\u0011\u0007!*x/\u0003\u0002wS\t)\u0011I\u001d:bsB\u0011\u0001\u0006_\u0005\u0003s&\u0012a\u0001R8vE2,\u0007BB>\u0001\t\u0003!A0\u0001\u0010hKR,eMZ3di&4X\rV8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]V\tq\u000fC\u0003\u007f\u0001\u0011\u0005q0\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\t\u0005\u0005\u00111A\u0007\u0002\u0001!1\u0011QA?A\u0002\u0019\nQA^1mk\u0016D3!`\u00198\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tqc]3u)>\u0004\u0018n\u0019#jgR\u0014\u0018NY;uS>t7i\u001c7\u0015\t\u0005\u0005\u0011q\u0002\u0005\b\u0003\u000b\tI\u00011\u0001'Q\u0015\tI!MA\nC\t\t)\"A\u00033]Ir\u0003\u0007C\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u000fM,GoU3fIR!\u0011\u0011AA\u000f\u0011!\t)!a\u0006A\u0002\u0005}\u0001c\u0001\u0015\u0002\"%\u0019\u00111E\u0015\u0003\t1{gn\u001a\u0015\u0005\u0003/\tt\u0007C\u0004\u0002*\u0001!\t%a\u000b\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA\u0017\u0003#\u0002B!a\f\u0002L9!\u0011\u0011GA$\u001d\u0011\t\u0019$!\u0012\u000f\t\u0005U\u00121\t\b\u0005\u0003o\t\tE\u0004\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001'\u0007\u0013\r\tIeS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti%a\u0014\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA%\u0017\"A\u00111KA\u0014\u0001\u0004\t)&A\u0004eCR\f7/\u001a;1\t\u0005]\u0013\u0011\r\t\u0006\u0015\u0006e\u0013QL\u0005\u0004\u00037Z%a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003?\n\t\u0007\u0004\u0001\u0005\u0019\u0005\r\u0014\u0011KA\u0001\u0002\u0003\u0015\t!!\u001a\u0003\u0007}#\u0013'\u0005\u0003\u0002h\u00055\u0004c\u0001\u0015\u0002j%\u0019\u00111N\u0015\u0003\u000f9{G\u000f[5oOB\u0019\u0001&a\u001c\n\u0007\u0005E\u0014FA\u0002B]fDS!a\n2\u0003k\n#!a\u001e\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002\u0000\u0005-\u0005\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u00155*A\u0003usB,7/\u0003\u0003\u0002\n\u0006\r%AC*ueV\u001cG\u000fV=qK\"A\u0011QRA=\u0001\u0004\ty(\u0001\u0004tG\",W.\u0019\u0015\u0005\u0003s\nt\u0007C\u0004\u0002\u0014\u0002!\t!!&\u00023\u0015\u001cH/[7bi\u0016$Gi\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0003\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;#\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002\"\u0006m%A\u0002,fGR|'\u000fK\u0003\u0002\u0012F\n)\bC\u0004\u0002(\u0002!\t!!+\u0002\u0019Q|\u0007/[2t\u001b\u0006$(/\u001b=\u0016\u0005\u0005-\u0006\u0003BAM\u0003[KA!a,\u0002\u001c\n1Q*\u0019;sSbDS!!*2\u0003kBq!!.\u0001\r\u0003\t9,A\u0007jg\u0012K7\u000f\u001e:jEV$X\rZ\u000b\u0003\u0003s\u00032\u0001KA^\u0013\r\ti,\u000b\u0002\b\u0005>|G.Z1oQ\u0011\t\u0019,M\u001c\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006iAn\\4MS.,G.\u001b5p_\u0012$2a^Ad\u0011!\t\u0019&!1A\u0002\u0005%\u0007\u0007BAf\u0003\u001f\u0004RASA-\u0003\u001b\u0004B!a\u0018\u0002P\u0012a\u0011\u0011[Ad\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\f\n\u001a)\u000b\u0005\u0005\u0017'!\u001e\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\u0006iAn\\4QKJ\u0004H.\u001a=jif$2a^An\u0011!\t\u0019&!6A\u0002\u0005u\u0007\u0007BAp\u0003G\u0004RASA-\u0003C\u0004B!a\u0018\u0002d\u0012a\u0011Q]An\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\fJ\u001a)\u000b\u0005U\u0017'!\u001e\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006qA-Z:de&\u0014W\rV8qS\u000e\u001cH\u0003BA\u0017\u0003_Dq!!=\u0002j\u0002\u0007q(\u0001\tnCb$VM]7t!\u0016\u0014Hk\u001c9jG\"\"\u0011\u0011^\u00198\u0011\u001d\tY\u000f\u0001C\u0001\u0003o$\"!!\f)\t\u0005U\u0018g\u000e\u0015\u0004\u0001E:\u0004")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final BooleanParam keepLastCheckpoint;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public int getK() {
        return LDAParams$class.getK(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams$class.getDocConcentration(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams$class.getOldDocConcentration(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams$class.getTopicConcentration(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams$class.getOldTopicConcentration(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams$class.getOptimizer(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams$class.getTopicDistributionCol(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams$class.getLearningOffset(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams$class.getLearningDecay(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams$class.getSubsamplingRate(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams$class.getOptimizeDocConcentration(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams$class.getKeepLastCheckpoint(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams$class.getOldOptimizer(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public double[] getEffectiveDocConcentration() {
        return this.getModel().docConcentration().toArray();
    }

    public double getEffectiveTopicConcentration() {
        return this.getModel().topicConcentration();
    }

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setTopicDistributionCol(String value) {
        return (LDAModel)this.set(this.topicDistributionCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            Function1<Vector, Vector> transformer = this.oldLocalModel().getTopicDistributionMethod();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf((Function1)new Serializable(this, transformer){
                public static final long serialVersionUID = 0L;
                private final Function1 transformer$1;

                public final org.apache.spark.ml.linalg.Vector apply(org.apache.spark.ml.linalg.Vector v) {
                    return ((Vector)this.transformer$1.apply((Object)Vectors$.MODULE$.fromML(v))).asML();
                }
                {
                    this.transformer$1 = transformer$1;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(this)));
            dataset2 = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).toDF();
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.";
                }
            });
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Seq<Object>, Seq<Object>> apply(Tuple2<Tuple2<int[], double[]>, Object> x0$2) {
                Tuple2<Tuple2<int[], double[]>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int topic = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        int[] termIndices = (int[])tuple22._1();
                        double[] termWeights = (double[])tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)Predef$.MODULE$.intArrayOps(termIndices).toSeq(), (Object)Predef$.MODULE$.doubleArrayOps(termWeights).toSeq());
                        return tuple3;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor()}))), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})))})));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasSeed$class.$init$(this);
        HasCheckpointInterval$class.$init$(this);
        LDAParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

