/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.math.BigInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CpuTimeTracker {
    public static final int UNAVAILABLE = -1;
    final long MINIMUM_UPDATE_INTERVAL;
    BigInteger cumulativeCpuTime = BigInteger.ZERO;
    BigInteger lastCumulativeCpuTime = BigInteger.ZERO;
    long sampleTime;
    long lastSampleTime;
    float cpuUsage;
    BigInteger jiffyLengthInMillis;

    public CpuTimeTracker(long jiffyLengthInMillis) {
        this.jiffyLengthInMillis = BigInteger.valueOf(jiffyLengthInMillis);
        this.cpuUsage = -1.0f;
        this.sampleTime = -1L;
        this.lastSampleTime = -1L;
        this.MINIMUM_UPDATE_INTERVAL = 10L * jiffyLengthInMillis;
    }

    public float getCpuTrackerUsagePercent() {
        if (this.lastSampleTime == -1L || this.lastSampleTime > this.sampleTime) {
            this.lastSampleTime = this.sampleTime;
            this.lastCumulativeCpuTime = this.cumulativeCpuTime;
            return this.cpuUsage;
        }
        if (this.sampleTime > this.lastSampleTime + this.MINIMUM_UPDATE_INTERVAL) {
            this.cpuUsage = this.cumulativeCpuTime.subtract(this.lastCumulativeCpuTime).floatValue() * 100.0f / (float)(this.sampleTime - this.lastSampleTime);
            this.lastSampleTime = this.sampleTime;
            this.lastCumulativeCpuTime = this.cumulativeCpuTime;
        }
        return this.cpuUsage;
    }

    public void updateElapsedJiffies(BigInteger elapedJiffies, long sampleTime) {
        this.cumulativeCpuTime = elapedJiffies.multiply(this.jiffyLengthInMillis);
        this.sampleTime = sampleTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleTime " + this.sampleTime);
        sb.append(" CummulativeCpuTime " + this.cumulativeCpuTime);
        sb.append(" LastSampleTime " + this.lastSampleTime);
        sb.append(" LastCummulativeCpuTime " + this.lastCumulativeCpuTime);
        sb.append(" CpuUsage " + this.cpuUsage);
        sb.append(" JiffyLengthMillisec " + this.jiffyLengthInMillis);
        return sb.toString();
    }
}

