/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils.oauth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.security.OAuth2Tokens;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.oauth.OAuthScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthUtils {
    private static final Log log = LogFactory.getLog(OAuthUtils.class);
    protected static final String HTTP_USER_AGENT = "OAuthUtils/0.9.4";
    protected HttpClient httpClient = null;
    protected ObjectMapper jsonMapper = new ObjectMapper();
    protected OAuthImplementation implementation = null;
    protected String clientId = null;
    protected String clientSecret = null;

    public OAuthUtils(OAuthImplementation implementation, String clientId, String clientSecret, Jets3tProperties jets3tProperties) {
        this(RestUtils.initHttpConnection(null, jets3tProperties, HTTP_USER_AGENT, null), implementation, clientId, clientSecret);
    }

    public OAuthUtils(HttpClient httpClient, OAuthImplementation implementation, String clientId, String clientSecret) {
        this.implementation = implementation;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClient = httpClient;
        if (this.implementation == null || this.clientId == null || this.clientSecret == null || this.httpClient == null) {
            throw new IllegalArgumentException("Null arguments not permitted when constructing " + this.getClass().getName());
        }
    }

    public OAuthUtils(OAuthImplementation implementation, String clientId, String clientSecret) {
        this(implementation, clientId, clientSecret, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String generateBrowserUrlToAuthorizeNativeApplication(OAuthScope scope) {
        if (this.implementation == OAuthImplementation.GOOGLE_STORAGE_OAUTH2_10) {
            String url = "https://accounts.google.com/o/oauth2/auth?response_type=code&redirect_uri=urn:ietf:wg:oauth:2.0:oob&client_id=" + this.clientId + "&scope=" + scope;
            log.debug((Object)("Generated authorization URL for OAuth implementation " + (Object)((Object)this.implementation) + ": " + url));
            return url;
        }
        throw new IllegalStateException("Unsupported implementation: " + (Object)((Object)this.implementation));
    }

    public OAuth2Tokens retrieveOAuth2TokensFromAuthorization(final String authorizationCode) throws IOException {
        log.debug((Object)("Retrieving OAuth2 tokens using implementation " + (Object)((Object)this.implementation) + " with authorization code: " + authorizationCode));
        if (this.implementation == OAuthImplementation.GOOGLE_STORAGE_OAUTH2_10) {
            Map<String, Object> responseData = this.performPostRequestAndParseJSONResponse("https://accounts.google.com/o/oauth2/token", (List<NameValuePair>)new ArrayList<NameValuePair>(){
                {
                    this.add(new BasicNameValuePair("client_id", OAuthUtils.this.clientId));
                    this.add(new BasicNameValuePair("client_secret", OAuthUtils.this.clientSecret));
                    this.add(new BasicNameValuePair("code", authorizationCode));
                    this.add(new BasicNameValuePair("grant_type", "authorization_code"));
                    this.add(new BasicNameValuePair("redirect_uri", "urn:ietf:wg:oauth:2.0:oob"));
                }
            });
            log.debug((Object)("Retrieved authorization data from OAuth2 token endpoint https://accounts.google.com/o/oauth2/token: " + responseData));
            String error = (String)responseData.get("error");
            if (error != null) {
                throw new IOException("OAuth2 authentication-to-tokens error: " + error);
            }
            String accessToken = (String)responseData.get("access_token");
            String refreshToken = (String)responseData.get("refresh_token");
            Number expiresIn = (Number)responseData.get("expires_in");
            String tokenType = (String)responseData.get("token_type");
            if (!"Bearer".equals(tokenType)) {
                throw new IOException("OAuth2 authentication-to-tokens error, invalid token type in data: " + responseData);
            }
            if (accessToken == null || refreshToken == null) {
                throw new IOException("OAuth2 authentication-to-tokens error, missing token(s) in data: " + responseData);
            }
            return new OAuth2Tokens(accessToken, refreshToken, OAuth2Tokens.calculateExpiry(expiresIn));
        }
        throw new IllegalStateException("Unsupported implementation: " + (Object)((Object)this.implementation));
    }

    public OAuth2Tokens refreshOAuth2AccessToken(final OAuth2Tokens tokens) throws IOException {
        log.debug((Object)("Refreshing OAuth2 access token using implementation " + (Object)((Object)this.implementation) + " with refresh token: " + tokens.getRefreshToken()));
        Map<String, Object> responseData = null;
        if (this.implementation == OAuthImplementation.GOOGLE_STORAGE_OAUTH2_10) {
            responseData = this.performPostRequestAndParseJSONResponse("https://accounts.google.com/o/oauth2/token", (List<NameValuePair>)new ArrayList<NameValuePair>(){
                {
                    this.add(new BasicNameValuePair("client_id", OAuthUtils.this.clientId));
                    this.add(new BasicNameValuePair("client_secret", OAuthUtils.this.clientSecret));
                    this.add(new BasicNameValuePair("refresh_token", tokens.getRefreshToken()));
                    this.add(new BasicNameValuePair("grant_type", "refresh_token"));
                }
            });
            log.debug((Object)("Retrieved access token refresh data from OAuth2 token endpoint https://accounts.google.com/o/oauth2/token: " + responseData));
            String error = (String)responseData.get("error");
            if (error != null) {
                throw new IOException("OAuth2 error refreshing access token: " + error);
            }
            String accessToken = (String)responseData.get("access_token");
            Number expiresIn = (Number)responseData.get("expires_in");
            String tokenType = (String)responseData.get("token_type");
            if (!"Bearer".equals(tokenType)) {
                throw new IOException("OAuth2 error refreshing access token, invalid token type in data: " + responseData);
            }
            if (accessToken == null) {
                throw new IOException("OAuth2 error refreshing access token, missing token in data: " + responseData);
            }
            return new OAuth2Tokens(accessToken, tokens.getRefreshToken(), OAuth2Tokens.calculateExpiry(expiresIn));
        }
        throw new IllegalStateException("Unsupported implementation: " + (Object)((Object)this.implementation));
    }

    protected Map<String, Object> performPostRequestAndParseJSONResponse(String endpointUri, List<NameValuePair> postParams) throws IOException {
        log.debug((Object)("Performing POST request to " + endpointUri + " and expecting JSON response. POST parameters: " + postParams));
        HttpPost post = new HttpPost(endpointUri);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "UTF-8"));
        String responseDataString = (String)this.httpClient.execute((HttpUriRequest)post, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (statusCode == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return EntityUtils.toString((HttpEntity)entity);
                    }
                    return null;
                }
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        });
        return (Map)this.jsonMapper.readValue(responseDataString, Map.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OAuthImplementation {
        GOOGLE_STORAGE_OAUTH2_10;

    }
}

