/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.spark_project.guava.util.concurrent.MoreExecutors;
import org.spark_project.guava.util.concurrent.ThreadFactoryBuilder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Awaitable;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.VolatileObjectRef;
import scala.util.control.NonFatal$;

public final class ThreadUtils$ {
    public static final ThreadUtils$ MODULE$;
    private final ExecutionContextExecutorService sameThreadExecutionContext;

    static {
        new ThreadUtils$();
    }

    private ExecutionContextExecutorService sameThreadExecutionContext() {
        return this.sameThreadExecutionContext;
    }

    public ExecutionContextExecutor sameThread() {
        return this.sameThreadExecutionContext();
    }

    public ThreadFactory namedThreadFactory(String prefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(new StringBuilder().append((Object)prefix).append((Object)"-%d").toString()).build();
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix, int maxThreadNumber, int keepAliveSeconds) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(maxThreadNumber, maxThreadNumber, (long)keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public int newDaemonCachedThreadPool$default$3() {
        return 60;
    }

    public ThreadPoolExecutor newDaemonFixedThreadPool(int nThreads, String prefix) {
        ThreadFactory threadFactory = this.namedThreadFactory(prefix);
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public ExecutorService newDaemonSingleThreadExecutor(String threadName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        void var3_3;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        return var3_3;
    }

    public <T> T runInNewThread(String threadName, boolean isDaemon, Function0<T> body2) {
        VolatileObjectRef exception2 = VolatileObjectRef.create((Object)None$.MODULE$);
        VolatileObjectRef result2 = VolatileObjectRef.create(null);
        Thread thread = new Thread(threadName, body2, exception2, result2){
            private final Function0 body$1;
            private final VolatileObjectRef exception$1;
            private final VolatileObjectRef result$1;

            public void run() {
                try {
                    this.result$1.elem = this.body$1.apply();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.exception$1.elem = new Some((Object)e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.body$1 = body$1;
                this.exception$1 = exception$1;
                this.result$1 = result$1;
                super(threadName$1);
            }
        };
        thread.setDaemon(isDaemon);
        thread.start();
        thread.join();
        Option option = (Option)exception2.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable realException = (Throwable)some.x();
            StackTraceElement[] baseStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).dropWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StackTraceElement x$1) {
                    return !x$1.getClassName().contains(ThreadUtils$.MODULE$.getClass().getSimpleName());
                }
            })).drop(1);
            StackTraceElement[] extraStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])realException.getStackTrace()).takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StackTraceElement x$2) {
                    return !x$2.getClassName().contains(ThreadUtils$.MODULE$.getClass().getSimpleName());
                }
            });
            StackTraceElement placeHolderStackElem = new StackTraceElement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"... run in separate thread using ", " .."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$")})), " ", "", -1);
            StackTraceElement[] finalStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])extraStackTrace).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StackTraceElement[]{placeHolderStackElem})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])baseStackTrace), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)));
            realException.setStackTrace(finalStackTrace);
            throw realException;
        }
        if (None$.MODULE$.equals(option)) {
            Object object = result2.elem;
            return (T)object;
        }
        throw new MatchError((Object)option);
    }

    public <T> boolean runInNewThread$default$2() {
        return true;
    }

    public ForkJoinPool newForkJoinPool(String prefix, int maxThreadNumber) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(prefix){
            public final String prefix$1;

            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new ForkJoinWorkerThread(this, pool){
                    {
                        super(pool$1);
                        this.setName(new StringBuilder().append((Object)$outer.prefix$1).append((Object)"-").append((Object)super.getName()).toString());
                    }
                };
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        return new ForkJoinPool(maxThreadNumber, factory, null, false);
    }

    public <T> T awaitResult(Awaitable<T> awaitable, Duration atMost) throws SparkException {
        try {
            CanAwait awaitPermission = null;
            return (T)awaitable.result(atMost, awaitPermission);
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || (t = (Throwable)option.get()) instanceof TimeoutException) {
                throw throwable;
            }
            throw new SparkException("Exception thrown in awaitResult: ", t);
        }
    }

    public <T> Awaitable<T> awaitReady(Awaitable<T> awaitable, Duration atMost) throws SparkException {
        try {
            CanAwait awaitPermission = null;
            return awaitable.ready(atMost, awaitPermission);
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || (t = (Throwable)option.get()) instanceof TimeoutException) {
                throw throwable;
            }
            throw new SparkException("Exception thrown in awaitResult: ", t);
        }
    }

    private ThreadUtils$() {
        MODULE$ = this;
        this.sameThreadExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)MoreExecutors.sameThreadExecutor());
    }
}

